# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectionAdminCredentialsArgs',
    'ConnectionConnectDescriptorArgs',
    'ConnectionPrivateEndpointArgs',
    'ConnectionReplicationCredentialsArgs',
    'ConnectionSshDetailsArgs',
    'ConnectionVaultDetailsArgs',
    'JobProgressArgs',
    'JobProgressPhaseArgs',
    'JobProgressPhaseExtractArgs',
    'JobProgressPhaseLogLocationArgs',
    'JobUnsupportedObjectArgs',
    'MigrationAdvisorSettingsArgs',
    'MigrationDataTransferMediumDetailsArgs',
    'MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs',
    'MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs',
    'MigrationDataTransferMediumDetailsObjectStorageDetailsArgs',
    'MigrationDataTransferMediumDetailsV2Args',
    'MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs',
    'MigrationDatapumpSettingsArgs',
    'MigrationDatapumpSettingsDataPumpParametersArgs',
    'MigrationDatapumpSettingsExportDirectoryObjectArgs',
    'MigrationDatapumpSettingsImportDirectoryObjectArgs',
    'MigrationDatapumpSettingsMetadataRemapArgs',
    'MigrationDumpTransferDetailsArgs',
    'MigrationDumpTransferDetailsSourceArgs',
    'MigrationDumpTransferDetailsTargetArgs',
    'MigrationExcludeObjectArgs',
    'MigrationGoldenGateDetailsArgs',
    'MigrationGoldenGateDetailsHubArgs',
    'MigrationGoldenGateDetailsHubRestAdminCredentialsArgs',
    'MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs',
    'MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs',
    'MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs',
    'MigrationGoldenGateDetailsSettingsArgs',
    'MigrationGoldenGateDetailsSettingsExtractArgs',
    'MigrationGoldenGateDetailsSettingsReplicatArgs',
    'MigrationGoldenGateServiceDetailsArgs',
    'MigrationGoldenGateServiceDetailsGgsDeploymentArgs',
    'MigrationGoldenGateServiceDetailsSettingsArgs',
    'MigrationGoldenGateServiceDetailsSettingsExtractArgs',
    'MigrationGoldenGateServiceDetailsSettingsReplicatArgs',
    'MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs',
    'MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs',
    'MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs',
    'MigrationIncludeObjectArgs',
    'MigrationVaultDetailsArgs',
    'GetAgentImagesFilterArgs',
    'GetAgentsFilterArgs',
    'GetConnectionsFilterArgs',
    'GetMigrationObjectTypesFilterArgs',
    'GetMigrationsFilterArgs',
]

@pulumi.input_type
class ConnectionAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Administrator password
        :param pulumi.Input[str] username: (Updatable) Administrator username
        """
        ConnectionAdminCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConnectionConnectDescriptorArgs:
    def __init__(__self__, *,
                 connect_string: Optional[pulumi.Input[str]] = None,
                 database_service_name: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] connect_string: (Updatable) Connect String. Required if no host, port nor databaseServiceName were specified. If a Private Endpoint was specified in the Connection, the host entry should be a valid IP address. Supported formats: Easy connect: <host>:<port>/<db_service_name> Long format: (description= (address=(port=<port>)(host=<host>))(connect_data=(service_name=<db_service_name>)))
        :param pulumi.Input[str] database_service_name: (Updatable) Database service name. Required if no connectString was specified.
        :param pulumi.Input[str] host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[int] port: (Updatable) Port of the connect descriptor. Required if no connectString was specified.
        """
        ConnectionConnectDescriptorArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connect_string=connect_string,
            database_service_name=database_service_name,
            host=host,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connect_string: Optional[pulumi.Input[str]] = None,
             database_service_name: Optional[pulumi.Input[str]] = None,
             host: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if connect_string is not None:
            _setter("connect_string", connect_string)
        if database_service_name is not None:
            _setter("database_service_name", database_service_name)
        if host is not None:
            _setter("host", host)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Connect String. Required if no host, port nor databaseServiceName were specified. If a Private Endpoint was specified in the Connection, the host entry should be a valid IP address. Supported formats: Easy connect: <host>:<port>/<db_service_name> Long format: (description= (address=(port=<port>)(host=<host>))(connect_data=(service_name=<db_service_name>)))
        """
        return pulumi.get(self, "connect_string")

    @connect_string.setter
    def connect_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_string", value)

    @property
    @pulumi.getter(name="databaseServiceName")
    def database_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database service name. Required if no connectString was specified.
        """
        return pulumi.get(self, "database_service_name")

    @database_service_name.setter
    def database_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_service_name", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Port of the connect descriptor. Required if no connectString was specified.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ConnectionPrivateEndpointArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vcn_id: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        :param pulumi.Input[str] vcn_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        :param pulumi.Input[str] id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        ConnectionPrivateEndpointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
            id=id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             subnet_id: pulumi.Input[str],
             vcn_id: pulumi.Input[str],
             id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)
        if id is not None:
            _setter("id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vcn_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ConnectionReplicationCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Administrator password
        :param pulumi.Input[str] username: (Updatable) Administrator username
        """
        ConnectionReplicationCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ConnectionSshDetailsArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 sshkey: pulumi.Input[str],
                 user: pulumi.Input[str],
                 sudo_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[str] sshkey: (Updatable) Private SSH key string.
        :param pulumi.Input[str] user: (Updatable) SSH user
        :param pulumi.Input[str] sudo_location: (Updatable) Sudo location
        """
        ConnectionSshDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            sshkey=sshkey,
            user=user,
            sudo_location=sudo_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: pulumi.Input[str],
             sshkey: pulumi.Input[str],
             user: pulumi.Input[str],
             sudo_location: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("host", host)
        _setter("sshkey", sshkey)
        _setter("user", user)
        if sudo_location is not None:
            _setter("sudo_location", sudo_location)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def sshkey(self) -> pulumi.Input[str]:
        """
        (Updatable) Private SSH key string.
        """
        return pulumi.get(self, "sshkey")

    @sshkey.setter
    def sshkey(self, value: pulumi.Input[str]):
        pulumi.set(self, "sshkey", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        (Updatable) SSH user
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="sudoLocation")
    def sudo_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Sudo location
        """
        return pulumi.get(self, "sudo_location")

    @sudo_location.setter
    def sudo_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sudo_location", value)


@pulumi.input_type
class ConnectionVaultDetailsArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 key_id: pulumi.Input[str],
                 vault_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] key_id: (Updatable) OCID of the vault encryption key
        :param pulumi.Input[str] vault_id: (Updatable) OCID of the vault 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ConnectionVaultDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             key_id: pulumi.Input[str],
             vault_id: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the vault 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class JobProgressArgs:
    def __init__(__self__, *,
                 current_phase: Optional[pulumi.Input[str]] = None,
                 current_status: Optional[pulumi.Input[str]] = None,
                 phases: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]] = None):
        """
        :param pulumi.Input[str] current_phase: Current phase of the job.
        :param pulumi.Input[str] current_status: Current status of the job.
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]] phases: List of phase status for the job.
        """
        JobProgressArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            current_phase=current_phase,
            current_status=current_status,
            phases=phases,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             current_phase: Optional[pulumi.Input[str]] = None,
             current_status: Optional[pulumi.Input[str]] = None,
             phases: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if current_phase is not None:
            _setter("current_phase", current_phase)
        if current_status is not None:
            _setter("current_status", current_status)
        if phases is not None:
            _setter("phases", phases)

    @property
    @pulumi.getter(name="currentPhase")
    def current_phase(self) -> Optional[pulumi.Input[str]]:
        """
        Current phase of the job.
        """
        return pulumi.get(self, "current_phase")

    @current_phase.setter
    def current_phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_phase", value)

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the job.
        """
        return pulumi.get(self, "current_status")

    @current_status.setter
    def current_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_status", value)

    @property
    @pulumi.getter
    def phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]:
        """
        List of phase status for the job.
        """
        return pulumi.get(self, "phases")

    @phases.setter
    def phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]):
        pulumi.set(self, "phases", value)


@pulumi.input_type
class JobProgressPhaseArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 duration_in_ms: Optional[pulumi.Input[int]] = None,
                 extracts: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]] = None,
                 is_advisor_report_available: Optional[pulumi.Input[bool]] = None,
                 issue: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 progress: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The text describing the action required to fix the issue
        :param pulumi.Input[int] duration_in_ms: Duration of the phase in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]] extracts: Summary of phase status results.
        :param pulumi.Input[bool] is_advisor_report_available: True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        :param pulumi.Input[str] issue: The text describing the root cause of the reported issue
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]] log_locations: Details to access log file in the specified Object Storage bucket, if any.
        :param pulumi.Input[str] name: Phase name
        :param pulumi.Input[int] progress: Percent progress of job phase.
        :param pulumi.Input[str] status: Phase status
        """
        JobProgressPhaseArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            duration_in_ms=duration_in_ms,
            extracts=extracts,
            is_advisor_report_available=is_advisor_report_available,
            issue=issue,
            log_locations=log_locations,
            name=name,
            progress=progress,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: Optional[pulumi.Input[str]] = None,
             duration_in_ms: Optional[pulumi.Input[int]] = None,
             extracts: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]] = None,
             is_advisor_report_available: Optional[pulumi.Input[bool]] = None,
             issue: Optional[pulumi.Input[str]] = None,
             log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             progress: Optional[pulumi.Input[int]] = None,
             status: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if action is not None:
            _setter("action", action)
        if duration_in_ms is not None:
            _setter("duration_in_ms", duration_in_ms)
        if extracts is not None:
            _setter("extracts", extracts)
        if is_advisor_report_available is not None:
            _setter("is_advisor_report_available", is_advisor_report_available)
        if issue is not None:
            _setter("issue", issue)
        if log_locations is not None:
            _setter("log_locations", log_locations)
        if name is not None:
            _setter("name", name)
        if progress is not None:
            _setter("progress", progress)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the action required to fix the issue
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="durationInMs")
    def duration_in_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of the phase in milliseconds
        """
        return pulumi.get(self, "duration_in_ms")

    @duration_in_ms.setter
    def duration_in_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_in_ms", value)

    @property
    @pulumi.getter
    def extracts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]:
        """
        Summary of phase status results.
        """
        return pulumi.get(self, "extracts")

    @extracts.setter
    def extracts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]):
        pulumi.set(self, "extracts", value)

    @property
    @pulumi.getter(name="isAdvisorReportAvailable")
    def is_advisor_report_available(self) -> Optional[pulumi.Input[bool]]:
        """
        True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        """
        return pulumi.get(self, "is_advisor_report_available")

    @is_advisor_report_available.setter
    def is_advisor_report_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_advisor_report_available", value)

    @property
    @pulumi.getter
    def issue(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the root cause of the reported issue
        """
        return pulumi.get(self, "issue")

    @issue.setter
    def issue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]:
        """
        Details to access log file in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Phase name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[int]]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Phase status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class JobProgressPhaseExtractArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message: Message in entry.
        :param pulumi.Input[str] type: Type of unsupported object
        """
        JobProgressPhaseExtractArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if message is not None:
            _setter("message", message)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message in entry.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobProgressPhaseLogLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Name of the bucket containing the log file.
        :param pulumi.Input[str] namespace: Object Storage namespace.
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        """
        JobProgressPhaseLogLocationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket containing the log file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class JobUnsupportedObjectArgs:
    def __init__(__self__, *,
                 object: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        :param pulumi.Input[str] owner: Owner of the object (regular expression is allowed)
        :param pulumi.Input[str] type: Type of unsupported object
        """
        JobUnsupportedObjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: Optional[pulumi.Input[str]] = None,
             owner: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if object is not None:
            _setter("object", object)
        if owner is not None:
            _setter("owner", owner)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationAdvisorSettingsArgs:
    def __init__(__self__, *,
                 is_ignore_errors: Optional[pulumi.Input[bool]] = None,
                 is_skip_advisor: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_ignore_errors: (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        :param pulumi.Input[bool] is_skip_advisor: (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        MigrationAdvisorSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_ignore_errors=is_ignore_errors,
            is_skip_advisor=is_skip_advisor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_ignore_errors: Optional[pulumi.Input[bool]] = None,
             is_skip_advisor: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_ignore_errors is not None:
            _setter("is_ignore_errors", is_ignore_errors)
        if is_skip_advisor is not None:
            _setter("is_skip_advisor", is_skip_advisor)

    @property
    @pulumi.getter(name="isIgnoreErrors")
    def is_ignore_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        """
        return pulumi.get(self, "is_ignore_errors")

    @is_ignore_errors.setter
    def is_ignore_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ignore_errors", value)

    @property
    @pulumi.getter(name="isSkipAdvisor")
    def is_skip_advisor(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        return pulumi.get(self, "is_skip_advisor")

    @is_skip_advisor.setter
    def is_skip_advisor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_skip_advisor", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsArgs:
    def __init__(__self__, *,
                 database_link_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs']] = None,
                 object_storage_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageDetailsArgs']] = None):
        """
        :param pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs'] database_link_details: (Updatable) Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        :param pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageDetailsArgs'] object_storage_details: (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        MigrationDataTransferMediumDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            database_link_details=database_link_details,
            object_storage_details=object_storage_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             database_link_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs']] = None,
             object_storage_details: Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageDetailsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if database_link_details is not None:
            _setter("database_link_details", database_link_details)
        if object_storage_details is not None:
            _setter("object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="databaseLinkDetails")
    def database_link_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs']]:
        """
        (Updatable) Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        """
        return pulumi.get(self, "database_link_details")

    @database_link_details.setter
    def database_link_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs']]):
        pulumi.set(self, "database_link_details", value)

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageDetailsArgs']]:
        """
        (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "object_storage_details")

    @object_storage_details.setter
    def object_storage_details(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageDetailsArgs']]):
        pulumi.set(self, "object_storage_details", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 wallet_bucket: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs']] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        :param pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs'] wallet_bucket: (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            wallet_bucket=wallet_bucket,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             wallet_bucket: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if name is not None:
            _setter("name", name)
        if wallet_bucket is not None:
            _setter("wallet_bucket", wallet_bucket)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="walletBucket")
    def wallet_bucket(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs']]:
        """
        (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "wallet_bucket")

    @wallet_bucket.setter
    def wallet_bucket(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs']]):
        pulumi.set(self, "wallet_bucket", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: (Updatable) Bucket name.
        :param pulumi.Input[str] namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             namespace: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsObjectStorageDetailsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: (Updatable) Bucket name.
        :param pulumi.Input[str] namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsObjectStorageDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: pulumi.Input[str],
             namespace: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsV2Args:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage_bucket: Optional[pulumi.Input['MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Migration type.
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        """
        MigrationDataTransferMediumDetailsV2Args._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            access_key_id=access_key_id,
            name=name,
            object_storage_bucket=object_storage_bucket,
            region=region,
            secret_access_key=secret_access_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: pulumi.Input[str],
             access_key_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             object_storage_bucket: Optional[pulumi.Input['MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs']] = None,
             region: Optional[pulumi.Input[str]] = None,
             secret_access_key: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if access_key_id is not None:
            _setter("access_key_id", access_key_id)
        if name is not None:
            _setter("name", name)
        if object_storage_bucket is not None:
            _setter("object_storage_bucket", object_storage_bucket)
        if region is not None:
            _setter("region", region)
        if secret_access_key is not None:
            _setter("secret_access_key", secret_access_key)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStorageBucket")
    def object_storage_bucket(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs']]:
        return pulumi.get(self, "object_storage_bucket")

    @object_storage_bucket.setter
    def object_storage_bucket(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs']]):
        pulumi.set(self, "object_storage_bucket", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: (Updatable) Bucket name.
        :param pulumi.Input[str] namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsV2ObjectStorageBucketArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class MigrationDatapumpSettingsArgs:
    def __init__(__self__, *,
                 data_pump_parameters: Optional[pulumi.Input['MigrationDatapumpSettingsDataPumpParametersArgs']] = None,
                 export_directory_object: Optional[pulumi.Input['MigrationDatapumpSettingsExportDirectoryObjectArgs']] = None,
                 import_directory_object: Optional[pulumi.Input['MigrationDatapumpSettingsImportDirectoryObjectArgs']] = None,
                 job_mode: Optional[pulumi.Input[str]] = None,
                 metadata_remaps: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationDatapumpSettingsMetadataRemapArgs']]]] = None):
        """
        :param pulumi.Input['MigrationDatapumpSettingsDataPumpParametersArgs'] data_pump_parameters: (Updatable) Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        :param pulumi.Input['MigrationDatapumpSettingsExportDirectoryObjectArgs'] export_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param pulumi.Input['MigrationDatapumpSettingsImportDirectoryObjectArgs'] import_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param pulumi.Input[str] job_mode: (Updatable) Data Pump job mode. Refer to [link text](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        :param pulumi.Input[Sequence[pulumi.Input['MigrationDatapumpSettingsMetadataRemapArgs']]] metadata_remaps: (Updatable) Defines remapping to be applied to objects as they are processed. Refer to [DATA_REMAP](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-E75AAE6F-4EA6-4737-A752-6B62F5E9D460)
        """
        MigrationDatapumpSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_pump_parameters=data_pump_parameters,
            export_directory_object=export_directory_object,
            import_directory_object=import_directory_object,
            job_mode=job_mode,
            metadata_remaps=metadata_remaps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_pump_parameters: Optional[pulumi.Input['MigrationDatapumpSettingsDataPumpParametersArgs']] = None,
             export_directory_object: Optional[pulumi.Input['MigrationDatapumpSettingsExportDirectoryObjectArgs']] = None,
             import_directory_object: Optional[pulumi.Input['MigrationDatapumpSettingsImportDirectoryObjectArgs']] = None,
             job_mode: Optional[pulumi.Input[str]] = None,
             metadata_remaps: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationDatapumpSettingsMetadataRemapArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if data_pump_parameters is not None:
            _setter("data_pump_parameters", data_pump_parameters)
        if export_directory_object is not None:
            _setter("export_directory_object", export_directory_object)
        if import_directory_object is not None:
            _setter("import_directory_object", import_directory_object)
        if job_mode is not None:
            _setter("job_mode", job_mode)
        if metadata_remaps is not None:
            _setter("metadata_remaps", metadata_remaps)

    @property
    @pulumi.getter(name="dataPumpParameters")
    def data_pump_parameters(self) -> Optional[pulumi.Input['MigrationDatapumpSettingsDataPumpParametersArgs']]:
        """
        (Updatable) Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        """
        return pulumi.get(self, "data_pump_parameters")

    @data_pump_parameters.setter
    def data_pump_parameters(self, value: Optional[pulumi.Input['MigrationDatapumpSettingsDataPumpParametersArgs']]):
        pulumi.set(self, "data_pump_parameters", value)

    @property
    @pulumi.getter(name="exportDirectoryObject")
    def export_directory_object(self) -> Optional[pulumi.Input['MigrationDatapumpSettingsExportDirectoryObjectArgs']]:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "export_directory_object")

    @export_directory_object.setter
    def export_directory_object(self, value: Optional[pulumi.Input['MigrationDatapumpSettingsExportDirectoryObjectArgs']]):
        pulumi.set(self, "export_directory_object", value)

    @property
    @pulumi.getter(name="importDirectoryObject")
    def import_directory_object(self) -> Optional[pulumi.Input['MigrationDatapumpSettingsImportDirectoryObjectArgs']]:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "import_directory_object")

    @import_directory_object.setter
    def import_directory_object(self, value: Optional[pulumi.Input['MigrationDatapumpSettingsImportDirectoryObjectArgs']]):
        pulumi.set(self, "import_directory_object", value)

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Data Pump job mode. Refer to [link text](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        """
        return pulumi.get(self, "job_mode")

    @job_mode.setter
    def job_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_mode", value)

    @property
    @pulumi.getter(name="metadataRemaps")
    def metadata_remaps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationDatapumpSettingsMetadataRemapArgs']]]]:
        """
        (Updatable) Defines remapping to be applied to objects as they are processed. Refer to [DATA_REMAP](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-E75AAE6F-4EA6-4737-A752-6B62F5E9D460)
        """
        return pulumi.get(self, "metadata_remaps")

    @metadata_remaps.setter
    def metadata_remaps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationDatapumpSettingsMetadataRemapArgs']]]]):
        pulumi.set(self, "metadata_remaps", value)


@pulumi.input_type
class MigrationDatapumpSettingsDataPumpParametersArgs:
    def __init__(__self__, *,
                 estimate: Optional[pulumi.Input[str]] = None,
                 exclude_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 export_parallelism_degree: Optional[pulumi.Input[int]] = None,
                 import_parallelism_degree: Optional[pulumi.Input[int]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 table_exists_action: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] estimate: (Updatable) Estimate size of dumps that will be generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_parameters: (Updatable) Exclude paratemers for Export and Import.
        :param pulumi.Input[int] export_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        :param pulumi.Input[int] import_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        :param pulumi.Input[bool] is_cluster: (Updatable) Set to false to force Data Pump worker process to run on one instance.
        :param pulumi.Input[str] table_exists_action: (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        MigrationDatapumpSettingsDataPumpParametersArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            estimate=estimate,
            exclude_parameters=exclude_parameters,
            export_parallelism_degree=export_parallelism_degree,
            import_parallelism_degree=import_parallelism_degree,
            is_cluster=is_cluster,
            table_exists_action=table_exists_action,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             estimate: Optional[pulumi.Input[str]] = None,
             exclude_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             export_parallelism_degree: Optional[pulumi.Input[int]] = None,
             import_parallelism_degree: Optional[pulumi.Input[int]] = None,
             is_cluster: Optional[pulumi.Input[bool]] = None,
             table_exists_action: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if estimate is not None:
            _setter("estimate", estimate)
        if exclude_parameters is not None:
            _setter("exclude_parameters", exclude_parameters)
        if export_parallelism_degree is not None:
            _setter("export_parallelism_degree", export_parallelism_degree)
        if import_parallelism_degree is not None:
            _setter("import_parallelism_degree", import_parallelism_degree)
        if is_cluster is not None:
            _setter("is_cluster", is_cluster)
        if table_exists_action is not None:
            _setter("table_exists_action", table_exists_action)

    @property
    @pulumi.getter
    def estimate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Estimate size of dumps that will be generated.
        """
        return pulumi.get(self, "estimate")

    @estimate.setter
    def estimate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimate", value)

    @property
    @pulumi.getter(name="excludeParameters")
    def exclude_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Exclude paratemers for Export and Import.
        """
        return pulumi.get(self, "exclude_parameters")

    @exclude_parameters.setter
    def exclude_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_parameters", value)

    @property
    @pulumi.getter(name="exportParallelismDegree")
    def export_parallelism_degree(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        """
        return pulumi.get(self, "export_parallelism_degree")

    @export_parallelism_degree.setter
    def export_parallelism_degree(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "export_parallelism_degree", value)

    @property
    @pulumi.getter(name="importParallelismDegree")
    def import_parallelism_degree(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        """
        return pulumi.get(self, "import_parallelism_degree")

    @import_parallelism_degree.setter
    def import_parallelism_degree(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "import_parallelism_degree", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to false to force Data Pump worker process to run on one instance.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="tableExistsAction")
    def table_exists_action(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        return pulumi.get(self, "table_exists_action")

    @table_exists_action.setter
    def table_exists_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_exists_action", value)


@pulumi.input_type
class MigrationDatapumpSettingsExportDirectoryObjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        :param pulumi.Input[str] path: (Updatable) Absolute path of directory on database server
        """
        MigrationDatapumpSettingsExportDirectoryObjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: pulumi.Input[str],
             path: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        if path is not None:
            _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class MigrationDatapumpSettingsImportDirectoryObjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        :param pulumi.Input[str] path: (Updatable) Absolute path of directory on database server
        """
        MigrationDatapumpSettingsImportDirectoryObjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: pulumi.Input[str],
             path: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        if path is not None:
            _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class MigrationDatapumpSettingsMetadataRemapArgs:
    def __init__(__self__, *,
                 new_value: pulumi.Input[str],
                 old_value: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] new_value: (Updatable) Specifies the new value that oldValue should be translated into.
        :param pulumi.Input[str] old_value: (Updatable) Specifies the value which needs to be reset.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        """
        MigrationDatapumpSettingsMetadataRemapArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            new_value=new_value,
            old_value=old_value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             new_value: pulumi.Input[str],
             old_value: pulumi.Input[str],
             type: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("new_value", new_value)
        _setter("old_value", old_value)
        _setter("type", type)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> pulumi.Input[str]:
        """
        (Updatable) Specifies the new value that oldValue should be translated into.
        """
        return pulumi.get(self, "new_value")

    @new_value.setter
    def new_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "new_value", value)

    @property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> pulumi.Input[str]:
        """
        (Updatable) Specifies the value which needs to be reset.
        """
        return pulumi.get(self, "old_value")

    @old_value.setter
    def old_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "old_value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationDumpTransferDetailsArgs:
    def __init__(__self__, *,
                 shared_storage_mount_target_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['MigrationDumpTransferDetailsSourceArgs']] = None,
                 target: Optional[pulumi.Input['MigrationDumpTransferDetailsTargetArgs']] = None):
        """
        :param pulumi.Input['MigrationDumpTransferDetailsSourceArgs'] source: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        :param pulumi.Input['MigrationDumpTransferDetailsTargetArgs'] target: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        MigrationDumpTransferDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            shared_storage_mount_target_id=shared_storage_mount_target_id,
            source=source,
            target=target,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             shared_storage_mount_target_id: Optional[pulumi.Input[str]] = None,
             source: Optional[pulumi.Input['MigrationDumpTransferDetailsSourceArgs']] = None,
             target: Optional[pulumi.Input['MigrationDumpTransferDetailsTargetArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if shared_storage_mount_target_id is not None:
            _setter("shared_storage_mount_target_id", shared_storage_mount_target_id)
        if source is not None:
            _setter("source", source)
        if target is not None:
            _setter("target", target)

    @property
    @pulumi.getter(name="sharedStorageMountTargetId")
    def shared_storage_mount_target_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "shared_storage_mount_target_id")

    @shared_storage_mount_target_id.setter
    def shared_storage_mount_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_storage_mount_target_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MigrationDumpTransferDetailsSourceArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MigrationDumpTransferDetailsSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MigrationDumpTransferDetailsTargetArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MigrationDumpTransferDetailsTargetArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class MigrationDumpTransferDetailsSourceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 oci_home: Optional[pulumi.Input[str]] = None,
                 wallet_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param pulumi.Input[str] oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param pulumi.Input[str] wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        MigrationDumpTransferDetailsSourceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: pulumi.Input[str],
             oci_home: Optional[pulumi.Input[str]] = None,
             wallet_location: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        if oci_home is not None:
            _setter("oci_home", oci_home)
        if wallet_location is not None:
            _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @oci_home.setter
    def oci_home(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oci_home", value)

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")

    @wallet_location.setter
    def wallet_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_location", value)


@pulumi.input_type
class MigrationDumpTransferDetailsTargetArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 oci_home: Optional[pulumi.Input[str]] = None,
                 wallet_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param pulumi.Input[str] oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param pulumi.Input[str] wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        MigrationDumpTransferDetailsTargetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: pulumi.Input[str],
             oci_home: Optional[pulumi.Input[str]] = None,
             wallet_location: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        if oci_home is not None:
            _setter("oci_home", oci_home)
        if wallet_location is not None:
            _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @oci_home.setter
    def oci_home(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oci_home", value)

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")

    @wallet_location.setter
    def wallet_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_location", value)


@pulumi.input_type
class MigrationExcludeObjectArgs:
    def __init__(__self__, *,
                 object: pulumi.Input[str],
                 owner: pulumi.Input[str],
                 is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: (Updatable) Name of the object (regular expression is allowed)
        :param pulumi.Input[str] owner: (Updatable) Owner of the object (regular expression is allowed)
        :param pulumi.Input[bool] is_omit_excluded_table_from_replication: (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        """
        MigrationExcludeObjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: pulumi.Input[str],
             owner: pulumi.Input[str],
             is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("object", object)
        _setter("owner", owner)
        if is_omit_excluded_table_from_replication is not None:
            _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        (Updatable) Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @is_omit_excluded_table_from_replication.setter
    def is_omit_excluded_table_from_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_omit_excluded_table_from_replication", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationGoldenGateDetailsArgs:
    def __init__(__self__, *,
                 hub: pulumi.Input['MigrationGoldenGateDetailsHubArgs'],
                 settings: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsArgs']] = None):
        """
        :param pulumi.Input['MigrationGoldenGateDetailsHubArgs'] hub: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param pulumi.Input['MigrationGoldenGateDetailsSettingsArgs'] settings: (Updatable) Optional settings for GoldenGate Microservices processes
        """
        MigrationGoldenGateDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hub=hub,
            settings=settings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hub: pulumi.Input['MigrationGoldenGateDetailsHubArgs'],
             settings: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("hub", hub)
        if settings is not None:
            _setter("settings", settings)

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Input['MigrationGoldenGateDetailsHubArgs']:
        """
        (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: pulumi.Input['MigrationGoldenGateDetailsHubArgs']):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsArgs']]:
        """
        (Updatable) Optional settings for GoldenGate Microservices processes
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class MigrationGoldenGateDetailsHubArgs:
    def __init__(__self__, *,
                 rest_admin_credentials: pulumi.Input['MigrationGoldenGateDetailsHubRestAdminCredentialsArgs'],
                 url: pulumi.Input[str],
                 compute_id: Optional[pulumi.Input[str]] = None,
                 source_container_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs']] = None,
                 source_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs']] = None,
                 source_microservices_deployment_name: Optional[pulumi.Input[str]] = None,
                 target_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs']] = None,
                 target_microservices_deployment_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['MigrationGoldenGateDetailsHubRestAdminCredentialsArgs'] rest_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] url: (Updatable) Oracle GoldenGate Microservices hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        :param pulumi.Input[str] compute_id: (Updatable) OCID of GoldenGate Microservices compute instance.
        :param pulumi.Input['MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs'] source_container_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input['MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs'] source_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] source_microservices_deployment_name: (Updatable) Name of GoldenGate Microservices deployment to operate on source database
        :param pulumi.Input['MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs'] target_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] target_microservices_deployment_name: (Updatable) Name of GoldenGate Microservices deployment to operate on target database
        """
        MigrationGoldenGateDetailsHubArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            rest_admin_credentials=rest_admin_credentials,
            url=url,
            compute_id=compute_id,
            source_container_db_admin_credentials=source_container_db_admin_credentials,
            source_db_admin_credentials=source_db_admin_credentials,
            source_microservices_deployment_name=source_microservices_deployment_name,
            target_db_admin_credentials=target_db_admin_credentials,
            target_microservices_deployment_name=target_microservices_deployment_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             rest_admin_credentials: pulumi.Input['MigrationGoldenGateDetailsHubRestAdminCredentialsArgs'],
             url: pulumi.Input[str],
             compute_id: Optional[pulumi.Input[str]] = None,
             source_container_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs']] = None,
             source_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs']] = None,
             source_microservices_deployment_name: Optional[pulumi.Input[str]] = None,
             target_db_admin_credentials: Optional[pulumi.Input['MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs']] = None,
             target_microservices_deployment_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("rest_admin_credentials", rest_admin_credentials)
        _setter("url", url)
        if compute_id is not None:
            _setter("compute_id", compute_id)
        if source_container_db_admin_credentials is not None:
            _setter("source_container_db_admin_credentials", source_container_db_admin_credentials)
        if source_db_admin_credentials is not None:
            _setter("source_db_admin_credentials", source_db_admin_credentials)
        if source_microservices_deployment_name is not None:
            _setter("source_microservices_deployment_name", source_microservices_deployment_name)
        if target_db_admin_credentials is not None:
            _setter("target_db_admin_credentials", target_db_admin_credentials)
        if target_microservices_deployment_name is not None:
            _setter("target_microservices_deployment_name", target_microservices_deployment_name)

    @property
    @pulumi.getter(name="restAdminCredentials")
    def rest_admin_credentials(self) -> pulumi.Input['MigrationGoldenGateDetailsHubRestAdminCredentialsArgs']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "rest_admin_credentials")

    @rest_admin_credentials.setter
    def rest_admin_credentials(self, value: pulumi.Input['MigrationGoldenGateDetailsHubRestAdminCredentialsArgs']):
        pulumi.set(self, "rest_admin_credentials", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        (Updatable) Oracle GoldenGate Microservices hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of GoldenGate Microservices compute instance.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter(name="sourceContainerDbAdminCredentials")
    def source_container_db_admin_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_container_db_admin_credentials")

    @source_container_db_admin_credentials.setter
    def source_container_db_admin_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs']]):
        pulumi.set(self, "source_container_db_admin_credentials", value)

    @property
    @pulumi.getter(name="sourceDbAdminCredentials")
    def source_db_admin_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_db_admin_credentials")

    @source_db_admin_credentials.setter
    def source_db_admin_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs']]):
        pulumi.set(self, "source_db_admin_credentials", value)

    @property
    @pulumi.getter(name="sourceMicroservicesDeploymentName")
    def source_microservices_deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of GoldenGate Microservices deployment to operate on source database
        """
        return pulumi.get(self, "source_microservices_deployment_name")

    @source_microservices_deployment_name.setter
    def source_microservices_deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_microservices_deployment_name", value)

    @property
    @pulumi.getter(name="targetDbAdminCredentials")
    def target_db_admin_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "target_db_admin_credentials")

    @target_db_admin_credentials.setter
    def target_db_admin_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs']]):
        pulumi.set(self, "target_db_admin_credentials", value)

    @property
    @pulumi.getter(name="targetMicroservicesDeploymentName")
    def target_microservices_deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of GoldenGate Microservices deployment to operate on target database
        """
        return pulumi.get(self, "target_microservices_deployment_name")

    @target_microservices_deployment_name.setter
    def target_microservices_deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_microservices_deployment_name", value)


@pulumi.input_type
class MigrationGoldenGateDetailsHubRestAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubRestAdminCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateDetailsSettingsArgs:
    def __init__(__self__, *,
                 acceptable_lag: Optional[pulumi.Input[int]] = None,
                 extract: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsExtractArgs']] = None,
                 replicat: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsReplicatArgs']] = None):
        """
        :param pulumi.Input[int] acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param pulumi.Input['MigrationGoldenGateDetailsSettingsExtractArgs'] extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param pulumi.Input['MigrationGoldenGateDetailsSettingsReplicatArgs'] replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        MigrationGoldenGateDetailsSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extract=extract,
            replicat=replicat,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: Optional[pulumi.Input[int]] = None,
             extract: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsExtractArgs']] = None,
             replicat: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsReplicatArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if acceptable_lag is not None:
            _setter("acceptable_lag", acceptable_lag)
        if extract is not None:
            _setter("extract", extract)
        if replicat is not None:
            _setter("replicat", replicat)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @acceptable_lag.setter
    def acceptable_lag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptable_lag", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsExtractArgs']]:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter
    def replicat(self) -> Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsReplicatArgs']]:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")

    @replicat.setter
    def replicat(self, value: Optional[pulumi.Input['MigrationGoldenGateDetailsSettingsReplicatArgs']]):
        pulumi.set(self, "replicat", value)


@pulumi.input_type
class MigrationGoldenGateDetailsSettingsExtractArgs:
    def __init__(__self__, *,
                 long_trans_duration: Optional[pulumi.Input[int]] = None,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param pulumi.Input[str] performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateDetailsSettingsExtractArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: Optional[pulumi.Input[int]] = None,
             performance_profile: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if long_trans_duration is not None:
            _setter("long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @long_trans_duration.setter
    def long_trans_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "long_trans_duration", value)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationGoldenGateDetailsSettingsReplicatArgs:
    def __init__(__self__, *,
                 map_parallelism: Optional[pulumi.Input[int]] = None,
                 max_apply_parallelism: Optional[pulumi.Input[int]] = None,
                 min_apply_parallelism: Optional[pulumi.Input[int]] = None,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] map_parallelism: (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        :param pulumi.Input[int] max_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param pulumi.Input[int] min_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param pulumi.Input[str] performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateDetailsSettingsReplicatArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: Optional[pulumi.Input[int]] = None,
             max_apply_parallelism: Optional[pulumi.Input[int]] = None,
             min_apply_parallelism: Optional[pulumi.Input[int]] = None,
             performance_profile: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if map_parallelism is not None:
            _setter("map_parallelism", map_parallelism)
        if max_apply_parallelism is not None:
            _setter("max_apply_parallelism", max_apply_parallelism)
        if min_apply_parallelism is not None:
            _setter("min_apply_parallelism", min_apply_parallelism)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @map_parallelism.setter
    def map_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_parallelism", value)

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @max_apply_parallelism.setter
    def max_apply_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_apply_parallelism", value)

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")

    @min_apply_parallelism.setter
    def min_apply_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_apply_parallelism", value)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsArgs:
    def __init__(__self__, *,
                 ggs_deployments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGoldenGateServiceDetailsGgsDeploymentArgs']]]] = None,
                 settings: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsArgs']] = None,
                 source_container_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs']] = None,
                 source_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs']] = None,
                 target_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MigrationGoldenGateServiceDetailsGgsDeploymentArgs']]] ggs_deployments: Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsSettingsArgs'] settings: (Updatable) Optional settings for GoldenGate Microservices processes
        :param pulumi.Input['MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs'] source_container_db_credentials: (Updatable) Database Credentials details.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs'] source_db_credentials: (Updatable) Database Credentials details.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs'] target_db_credentials: (Updatable) Database Credentials details.
        """
        MigrationGoldenGateServiceDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ggs_deployments=ggs_deployments,
            settings=settings,
            source_container_db_credentials=source_container_db_credentials,
            source_db_credentials=source_db_credentials,
            target_db_credentials=target_db_credentials,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ggs_deployments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGoldenGateServiceDetailsGgsDeploymentArgs']]]] = None,
             settings: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsArgs']] = None,
             source_container_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs']] = None,
             source_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs']] = None,
             target_db_credentials: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if ggs_deployments is not None:
            _setter("ggs_deployments", ggs_deployments)
        if settings is not None:
            _setter("settings", settings)
        if source_container_db_credentials is not None:
            _setter("source_container_db_credentials", source_container_db_credentials)
        if source_db_credentials is not None:
            _setter("source_db_credentials", source_db_credentials)
        if target_db_credentials is not None:
            _setter("target_db_credentials", target_db_credentials)

    @property
    @pulumi.getter(name="ggsDeployments")
    def ggs_deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGoldenGateServiceDetailsGgsDeploymentArgs']]]]:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "ggs_deployments")

    @ggs_deployments.setter
    def ggs_deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGoldenGateServiceDetailsGgsDeploymentArgs']]]]):
        pulumi.set(self, "ggs_deployments", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsArgs']]:
        """
        (Updatable) Optional settings for GoldenGate Microservices processes
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="sourceContainerDbCredentials")
    def source_container_db_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs']]:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "source_container_db_credentials")

    @source_container_db_credentials.setter
    def source_container_db_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs']]):
        pulumi.set(self, "source_container_db_credentials", value)

    @property
    @pulumi.getter(name="sourceDbCredentials")
    def source_db_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs']]:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "source_db_credentials")

    @source_db_credentials.setter
    def source_db_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs']]):
        pulumi.set(self, "source_db_credentials", value)

    @property
    @pulumi.getter(name="targetDbCredentials")
    def target_db_credentials(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs']]:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "target_db_credentials")

    @target_db_credentials.setter
    def target_db_credentials(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs']]):
        pulumi.set(self, "target_db_credentials", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsGgsDeploymentArgs:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 ggs_admin_credentials_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deployment_id: OCID of a GoldenGate Deployment
        :param pulumi.Input[str] ggs_admin_credentials_secret_id: OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        MigrationGoldenGateServiceDetailsGgsDeploymentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_id=deployment_id,
            ggs_admin_credentials_secret_id=ggs_admin_credentials_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_id: Optional[pulumi.Input[str]] = None,
             ggs_admin_credentials_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if deployment_id is not None:
            _setter("deployment_id", deployment_id)
        if ggs_admin_credentials_secret_id is not None:
            _setter("ggs_admin_credentials_secret_id", ggs_admin_credentials_secret_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of a GoldenGate Deployment
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="ggsAdminCredentialsSecretId")
    def ggs_admin_credentials_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        return pulumi.get(self, "ggs_admin_credentials_secret_id")

    @ggs_admin_credentials_secret_id.setter
    def ggs_admin_credentials_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ggs_admin_credentials_secret_id", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsSettingsArgs:
    def __init__(__self__, *,
                 acceptable_lag: Optional[pulumi.Input[int]] = None,
                 extract: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsExtractArgs']] = None,
                 replicat: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsReplicatArgs']] = None):
        """
        :param pulumi.Input[int] acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsSettingsExtractArgs'] extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param pulumi.Input['MigrationGoldenGateServiceDetailsSettingsReplicatArgs'] replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        MigrationGoldenGateServiceDetailsSettingsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extract=extract,
            replicat=replicat,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: Optional[pulumi.Input[int]] = None,
             extract: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsExtractArgs']] = None,
             replicat: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsReplicatArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if acceptable_lag is not None:
            _setter("acceptable_lag", acceptable_lag)
        if extract is not None:
            _setter("extract", extract)
        if replicat is not None:
            _setter("replicat", replicat)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @acceptable_lag.setter
    def acceptable_lag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptable_lag", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsExtractArgs']]:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter
    def replicat(self) -> Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsReplicatArgs']]:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")

    @replicat.setter
    def replicat(self, value: Optional[pulumi.Input['MigrationGoldenGateServiceDetailsSettingsReplicatArgs']]):
        pulumi.set(self, "replicat", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsSettingsExtractArgs:
    def __init__(__self__, *,
                 long_trans_duration: Optional[pulumi.Input[int]] = None,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param pulumi.Input[str] performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateServiceDetailsSettingsExtractArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: Optional[pulumi.Input[int]] = None,
             performance_profile: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if long_trans_duration is not None:
            _setter("long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @long_trans_duration.setter
    def long_trans_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "long_trans_duration", value)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsSettingsReplicatArgs:
    def __init__(__self__, *,
                 map_parallelism: Optional[pulumi.Input[int]] = None,
                 max_apply_parallelism: Optional[pulumi.Input[int]] = None,
                 min_apply_parallelism: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] map_parallelism: (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        :param pulumi.Input[int] max_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param pulumi.Input[int] min_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        MigrationGoldenGateServiceDetailsSettingsReplicatArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: Optional[pulumi.Input[int]] = None,
             max_apply_parallelism: Optional[pulumi.Input[int]] = None,
             min_apply_parallelism: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if map_parallelism is not None:
            _setter("map_parallelism", map_parallelism)
        if max_apply_parallelism is not None:
            _setter("max_apply_parallelism", max_apply_parallelism)
        if min_apply_parallelism is not None:
            _setter("min_apply_parallelism", min_apply_parallelism)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @map_parallelism.setter
    def map_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_parallelism", value)

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @max_apply_parallelism.setter
    def max_apply_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_apply_parallelism", value)

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")

    @min_apply_parallelism.setter
    def min_apply_parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_apply_parallelism", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Database  password
        :param pulumi.Input[str] username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: pulumi.Input[str],
             username: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationIncludeObjectArgs:
    def __init__(__self__, *,
                 object: pulumi.Input[str],
                 owner: pulumi.Input[str],
                 is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: (Updatable) Name of the object (regular expression is allowed)
        :param pulumi.Input[str] owner: (Updatable) Owner of the object (regular expression is allowed)
        :param pulumi.Input[bool] is_omit_excluded_table_from_replication: (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param pulumi.Input[str] type: (Updatable) Migration type.
        """
        MigrationIncludeObjectArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: pulumi.Input[str],
             owner: pulumi.Input[str],
             is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("object", object)
        _setter("owner", owner)
        if is_omit_excluded_table_from_replication is not None:
            _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        (Updatable) Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @is_omit_excluded_table_from_replication.setter
    def is_omit_excluded_table_from_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_omit_excluded_table_from_replication", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationVaultDetailsArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 key_id: pulumi.Input[str],
                 vault_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] key_id: (Updatable) OCID of the vault encryption key
        :param pulumi.Input[str] vault_id: (Updatable) OCID of the vault 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MigrationVaultDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             key_id: pulumi.Input[str],
             vault_id: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the vault 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class GetAgentImagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAgentImagesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetAgentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAgentsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetConnectionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetConnectionsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMigrationObjectTypesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Object type name
        """
        GetMigrationObjectTypesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMigrationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of directory object in database
        """
        GetMigrationsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


