# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAuditArchiveRetrievalResult',
    'AwaitableGetAuditArchiveRetrievalResult',
    'get_audit_archive_retrieval',
    'get_audit_archive_retrieval_output',
]

@pulumi.output_type
class GetAuditArchiveRetrievalResult:
    """
    A collection of values returned by getAuditArchiveRetrieval.
    """
    def __init__(__self__, audit_archive_retrieval_id=None, audit_event_count=None, compartment_id=None, defined_tags=None, description=None, display_name=None, end_date=None, error_info=None, freeform_tags=None, id=None, lifecycle_details=None, start_date=None, state=None, system_tags=None, target_id=None, time_completed=None, time_of_expiry=None, time_requested=None):
        if audit_archive_retrieval_id and not isinstance(audit_archive_retrieval_id, str):
            raise TypeError("Expected argument 'audit_archive_retrieval_id' to be a str")
        pulumi.set(__self__, "audit_archive_retrieval_id", audit_archive_retrieval_id)
        if audit_event_count and not isinstance(audit_event_count, str):
            raise TypeError("Expected argument 'audit_event_count' to be a str")
        pulumi.set(__self__, "audit_event_count", audit_event_count)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if error_info and not isinstance(error_info, str):
            raise TypeError("Expected argument 'error_info' to be a str")
        pulumi.set(__self__, "error_info", error_info)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if start_date and not isinstance(start_date, str):
            raise TypeError("Expected argument 'start_date' to be a str")
        pulumi.set(__self__, "start_date", start_date)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_completed and not isinstance(time_completed, str):
            raise TypeError("Expected argument 'time_completed' to be a str")
        pulumi.set(__self__, "time_completed", time_completed)
        if time_of_expiry and not isinstance(time_of_expiry, str):
            raise TypeError("Expected argument 'time_of_expiry' to be a str")
        pulumi.set(__self__, "time_of_expiry", time_of_expiry)
        if time_requested and not isinstance(time_requested, str):
            raise TypeError("Expected argument 'time_requested' to be a str")
        pulumi.set(__self__, "time_requested", time_requested)

    @property
    @pulumi.getter(name="auditArchiveRetrievalId")
    def audit_archive_retrieval_id(self) -> str:
        return pulumi.get(self, "audit_archive_retrieval_id")

    @property
    @pulumi.getter(name="auditEventCount")
    def audit_event_count(self) -> str:
        """
        Total count of audit events to be retrieved from the archive for the specified date range.
        """
        return pulumi.get(self, "audit_event_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains archive retrieval.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the archive retrieval.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        End month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> str:
        """
        The Error details of a failed archive retrieval.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the archive retrieval.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the archive retrieval.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Start month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the archive retrieval.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target associated with the archive retrieval.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> str:
        """
        The date time when archive retrieval request was fulfilled, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeOfExpiry")
    def time_of_expiry(self) -> str:
        """
        The date time when retrieved archive data will be deleted from Data Safe and unloaded back into archival.
        """
        return pulumi.get(self, "time_of_expiry")

    @property
    @pulumi.getter(name="timeRequested")
    def time_requested(self) -> str:
        """
        The date time when archive retrieval was requested, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_requested")


class AwaitableGetAuditArchiveRetrievalResult(GetAuditArchiveRetrievalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditArchiveRetrievalResult(
            audit_archive_retrieval_id=self.audit_archive_retrieval_id,
            audit_event_count=self.audit_event_count,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            end_date=self.end_date,
            error_info=self.error_info,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            start_date=self.start_date,
            state=self.state,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_completed=self.time_completed,
            time_of_expiry=self.time_of_expiry,
            time_requested=self.time_requested)


def get_audit_archive_retrieval(audit_archive_retrieval_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditArchiveRetrievalResult:
    """
    This data source provides details about a specific Audit Archive Retrieval resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified archive retreival.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_archive_retrieval = oci.DataSafe.get_audit_archive_retrieval(audit_archive_retrieval_id=oci_data_safe_audit_archive_retrieval["test_audit_archive_retrieval"]["id"])
    ```


    :param str audit_archive_retrieval_id: OCID of the archive retrieval.
    """
    __args__ = dict()
    __args__['auditArchiveRetrievalId'] = audit_archive_retrieval_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditArchiveRetrieval:getAuditArchiveRetrieval', __args__, opts=opts, typ=GetAuditArchiveRetrievalResult).value

    return AwaitableGetAuditArchiveRetrievalResult(
        audit_archive_retrieval_id=pulumi.get(__ret__, 'audit_archive_retrieval_id'),
        audit_event_count=pulumi.get(__ret__, 'audit_event_count'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        end_date=pulumi.get(__ret__, 'end_date'),
        error_info=pulumi.get(__ret__, 'error_info'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        start_date=pulumi.get(__ret__, 'start_date'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_completed=pulumi.get(__ret__, 'time_completed'),
        time_of_expiry=pulumi.get(__ret__, 'time_of_expiry'),
        time_requested=pulumi.get(__ret__, 'time_requested'))


@_utilities.lift_output_func(get_audit_archive_retrieval)
def get_audit_archive_retrieval_output(audit_archive_retrieval_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuditArchiveRetrievalResult]:
    """
    This data source provides details about a specific Audit Archive Retrieval resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified archive retreival.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_archive_retrieval = oci.DataSafe.get_audit_archive_retrieval(audit_archive_retrieval_id=oci_data_safe_audit_archive_retrieval["test_audit_archive_retrieval"]["id"])
    ```


    :param str audit_archive_retrieval_id: OCID of the archive retrieval.
    """
    ...
