# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoveryAnalyticResult',
    'AwaitableGetDiscoveryAnalyticResult',
    'get_discovery_analytic',
    'get_discovery_analytic_output',
]

@pulumi.output_type
class GetDiscoveryAnalyticResult:
    """
    A collection of values returned by getDiscoveryAnalytic.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, group_by=None, id=None, items=None, sensitive_data_model_id=None, target_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[str]:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoveryAnalyticItemResult']:
        """
        An array of discovery analytics summary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetDiscoveryAnalyticResult(GetDiscoveryAnalyticResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryAnalyticResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            group_by=self.group_by,
            id=self.id,
            items=self.items,
            sensitive_data_model_id=self.sensitive_data_model_id,
            target_id=self.target_id)


def get_discovery_analytic(compartment_id: Optional[str] = None,
                           compartment_id_in_subtree: Optional[bool] = None,
                           group_by: Optional[str] = None,
                           sensitive_data_model_id: Optional[str] = None,
                           target_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryAnalyticResult:
    """
    This data source provides details about a specific Discovery Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated discovery analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_analytic = oci.DataSafe.get_discovery_analytic(compartment_id=var["compartment_id"],
        compartment_id_in_subtree=var["discovery_analytic_compartment_id_in_subtree"],
        group_by=var["discovery_analytic_group_by"],
        sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str group_by: Attribute by which the discovery analytics data should be grouped.
    :param str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBy'] = group_by
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDiscoveryAnalytic:getDiscoveryAnalytic', __args__, opts=opts, typ=GetDiscoveryAnalyticResult).value

    return AwaitableGetDiscoveryAnalyticResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'),
        target_id=pulumi.get(__ret__, 'target_id'))


@_utilities.lift_output_func(get_discovery_analytic)
def get_discovery_analytic_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                  compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                  group_by: Optional[pulumi.Input[Optional[str]]] = None,
                                  sensitive_data_model_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscoveryAnalyticResult]:
    """
    This data source provides details about a specific Discovery Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated discovery analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_analytic = oci.DataSafe.get_discovery_analytic(compartment_id=var["compartment_id"],
        compartment_id_in_subtree=var["discovery_analytic_compartment_id_in_subtree"],
        group_by=var["discovery_analytic_group_by"],
        sensitive_data_model_id=oci_data_safe_sensitive_data_model["test_sensitive_data_model"]["id"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str group_by: Attribute by which the discovery analytics data should be grouped.
    :param str sensitive_data_model_id: A filter to return only the resources that match the specified sensitive data model OCID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    ...
