# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetDatabasesResult',
    'AwaitableGetTargetDatabasesResult',
    'get_target_databases',
    'get_target_databases_output',
]

@pulumi.output_type
class GetTargetDatabasesResult:
    """
    A collection of values returned by getTargetDatabases.
    """
    def __init__(__self__, access_level=None, associated_resource_id=None, compartment_id=None, compartment_id_in_subtree=None, database_type=None, display_name=None, filters=None, id=None, infrastructure_type=None, state=None, target_database_id=None, target_databases=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if associated_resource_id and not isinstance(associated_resource_id, str):
            raise TypeError("Expected argument 'associated_resource_id' to be a str")
        pulumi.set(__self__, "associated_resource_id", associated_resource_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_database_id and not isinstance(target_database_id, str):
            raise TypeError("Expected argument 'target_database_id' to be a str")
        pulumi.set(__self__, "target_database_id", target_database_id)
        if target_databases and not isinstance(target_databases, list):
            raise TypeError("Expected argument 'target_databases' to be a list")
        pulumi.set(__self__, "target_databases", target_databases)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="associatedResourceId")
    def associated_resource_id(self) -> Optional[str]:
        return pulumi.get(self, "associated_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment which contains the Data Safe target database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the target database in Data Safe.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[str]:
        """
        The infrastructure type the database is running on.
        """
        return pulumi.get(self, "infrastructure_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> Optional[str]:
        return pulumi.get(self, "target_database_id")

    @property
    @pulumi.getter(name="targetDatabases")
    def target_databases(self) -> Sequence['outputs.GetTargetDatabasesTargetDatabaseResult']:
        """
        The list of target_databases.
        """
        return pulumi.get(self, "target_databases")


class AwaitableGetTargetDatabasesResult(GetTargetDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabasesResult(
            access_level=self.access_level,
            associated_resource_id=self.associated_resource_id,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            database_type=self.database_type,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            state=self.state,
            target_database_id=self.target_database_id,
            target_databases=self.target_databases)


def get_target_databases(access_level: Optional[str] = None,
                         associated_resource_id: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         compartment_id_in_subtree: Optional[bool] = None,
                         database_type: Optional[str] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetTargetDatabasesFilterArgs']]] = None,
                         infrastructure_type: Optional[str] = None,
                         state: Optional[str] = None,
                         target_database_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabasesResult:
    """
    This data source provides the list of Target Databases in Oracle Cloud Infrastructure Data Safe service.

    Returns the list of registered target databases in Data Safe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_databases = oci.DataSafe.get_target_databases(compartment_id=var["compartment_id"],
        access_level=var["target_database_access_level"],
        associated_resource_id=oci_data_safe_associated_resource["test_associated_resource"]["id"],
        compartment_id_in_subtree=var["target_database_compartment_id_in_subtree"],
        database_type=var["target_database_database_type"],
        display_name=var["target_database_display_name"],
        infrastructure_type=var["target_database_infrastructure_type"],
        state=var["target_database_state"],
        target_database_id=oci_data_safe_target_database["test_target_database"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str associated_resource_id: A filter to return the target databases that are associated to the resource id passed in as a parameter value.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str database_type: A filter to return only target databases that match the specified database type.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str infrastructure_type: A filter to return only target databases that match the specified infrastructure type.
    :param str state: A filter to return only target databases that match the specified lifecycle state.
    :param str target_database_id: A filter to return the target database that matches the specified OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['associatedResourceId'] = associated_resource_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['databaseType'] = database_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['state'] = state
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabases:getTargetDatabases', __args__, opts=opts, typ=GetTargetDatabasesResult).value

    return AwaitableGetTargetDatabasesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        associated_resource_id=pulumi.get(__ret__, 'associated_resource_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        database_type=pulumi.get(__ret__, 'database_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        state=pulumi.get(__ret__, 'state'),
        target_database_id=pulumi.get(__ret__, 'target_database_id'),
        target_databases=pulumi.get(__ret__, 'target_databases'))


@_utilities.lift_output_func(get_target_databases)
def get_target_databases_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                associated_resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                database_type: Optional[pulumi.Input[Optional[str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetTargetDatabasesFilterArgs']]]]] = None,
                                infrastructure_type: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                target_database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTargetDatabasesResult]:
    """
    This data source provides the list of Target Databases in Oracle Cloud Infrastructure Data Safe service.

    Returns the list of registered target databases in Data Safe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_databases = oci.DataSafe.get_target_databases(compartment_id=var["compartment_id"],
        access_level=var["target_database_access_level"],
        associated_resource_id=oci_data_safe_associated_resource["test_associated_resource"]["id"],
        compartment_id_in_subtree=var["target_database_compartment_id_in_subtree"],
        database_type=var["target_database_database_type"],
        display_name=var["target_database_display_name"],
        infrastructure_type=var["target_database_infrastructure_type"],
        state=var["target_database_state"],
        target_database_id=oci_data_safe_target_database["test_target_database"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str associated_resource_id: A filter to return the target databases that are associated to the resource id passed in as a parameter value.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str database_type: A filter to return only target databases that match the specified database type.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str infrastructure_type: A filter to return only target databases that match the specified infrastructure type.
    :param str state: A filter to return only target databases that match the specified lifecycle state.
    :param str target_database_id: A filter to return the target database that matches the specified OCID.
    """
    ...
