# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPipelineRunResult',
    'AwaitableGetPipelineRunResult',
    'get_pipeline_run',
    'get_pipeline_run_output',
]

@pulumi.output_type
class GetPipelineRunResult:
    """
    A collection of values returned by getPipelineRun.
    """
    def __init__(__self__, compartment_id=None, configuration_details=None, configuration_override_details=None, created_by=None, defined_tags=None, delete_related_job_runs=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, log_configuration_override_details=None, log_details=None, pipeline_id=None, pipeline_run_id=None, project_id=None, state=None, step_override_details=None, step_runs=None, system_tags=None, time_accepted=None, time_finished=None, time_started=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_details and not isinstance(configuration_details, list):
            raise TypeError("Expected argument 'configuration_details' to be a list")
        pulumi.set(__self__, "configuration_details", configuration_details)
        if configuration_override_details and not isinstance(configuration_override_details, list):
            raise TypeError("Expected argument 'configuration_override_details' to be a list")
        pulumi.set(__self__, "configuration_override_details", configuration_override_details)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if delete_related_job_runs and not isinstance(delete_related_job_runs, bool):
            raise TypeError("Expected argument 'delete_related_job_runs' to be a bool")
        pulumi.set(__self__, "delete_related_job_runs", delete_related_job_runs)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_configuration_override_details and not isinstance(log_configuration_override_details, list):
            raise TypeError("Expected argument 'log_configuration_override_details' to be a list")
        pulumi.set(__self__, "log_configuration_override_details", log_configuration_override_details)
        if log_details and not isinstance(log_details, list):
            raise TypeError("Expected argument 'log_details' to be a list")
        pulumi.set(__self__, "log_details", log_details)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_run_id and not isinstance(pipeline_run_id, str):
            raise TypeError("Expected argument 'pipeline_run_id' to be a str")
        pulumi.set(__self__, "pipeline_run_id", pipeline_run_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if step_override_details and not isinstance(step_override_details, list):
            raise TypeError("Expected argument 'step_override_details' to be a list")
        pulumi.set(__self__, "step_override_details", step_override_details)
        if step_runs and not isinstance(step_runs, list):
            raise TypeError("Expected argument 'step_runs' to be a list")
        pulumi.set(__self__, "step_runs", step_runs)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_accepted and not isinstance(time_accepted, str):
            raise TypeError("Expected argument 'time_accepted' to be a str")
        pulumi.set(__self__, "time_accepted", time_accepted)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetPipelineRunConfigurationDetailResult']:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="configurationOverrideDetails")
    def configuration_override_details(self) -> Sequence['outputs.GetPipelineRunConfigurationOverrideDetailResult']:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_override_details")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline run.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> bool:
        return pulumi.get(self, "delete_related_job_runs")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details of the state of the step run.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logConfigurationOverrideDetails")
    def log_configuration_override_details(self) -> Sequence['outputs.GetPipelineRunLogConfigurationOverrideDetailResult']:
        """
        The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_override_details")

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Sequence['outputs.GetPipelineRunLogDetailResult']:
        """
        Customer logging details for pipeline run.
        """
        return pulumi.get(self, "log_details")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineRunId")
    def pipeline_run_id(self) -> str:
        return pulumi.get(self, "pipeline_run_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the step run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepOverrideDetails")
    def step_override_details(self) -> Sequence['outputs.GetPipelineRunStepOverrideDetailResult']:
        """
        Array of step override details. Only Step Configuration is allowed to be overridden.
        """
        return pulumi.get(self, "step_override_details")

    @property
    @pulumi.getter(name="stepRuns")
    def step_runs(self) -> Sequence['outputs.GetPipelineRunStepRunResult']:
        """
        Array of StepRun object for each step.
        """
        return pulumi.get(self, "step_runs")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        """
        The date and time the pipeline run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The date and time the pipeline run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the pipeline run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the pipeline run was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetPipelineRunResult(GetPipelineRunResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineRunResult(
            compartment_id=self.compartment_id,
            configuration_details=self.configuration_details,
            configuration_override_details=self.configuration_override_details,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            delete_related_job_runs=self.delete_related_job_runs,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            log_configuration_override_details=self.log_configuration_override_details,
            log_details=self.log_details,
            pipeline_id=self.pipeline_id,
            pipeline_run_id=self.pipeline_run_id,
            project_id=self.project_id,
            state=self.state,
            step_override_details=self.step_override_details,
            step_runs=self.step_runs,
            system_tags=self.system_tags,
            time_accepted=self.time_accepted,
            time_finished=self.time_finished,
            time_started=self.time_started,
            time_updated=self.time_updated)


def get_pipeline_run(pipeline_run_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineRunResult:
    """
    This data source provides details about a specific Pipeline Run resource in Oracle Cloud Infrastructure Data Science service.

    Gets a PipelineRun by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_run = oci.DataScience.get_pipeline_run(pipeline_run_id=oci_datascience_pipeline_run["test_pipeline_run"]["id"])
    ```


    :param str pipeline_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline run.
    """
    __args__ = dict()
    __args__['pipelineRunId'] = pipeline_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getPipelineRun:getPipelineRun', __args__, opts=opts, typ=GetPipelineRunResult).value

    return AwaitableGetPipelineRunResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_details=pulumi.get(__ret__, 'configuration_details'),
        configuration_override_details=pulumi.get(__ret__, 'configuration_override_details'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        delete_related_job_runs=pulumi.get(__ret__, 'delete_related_job_runs'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        log_configuration_override_details=pulumi.get(__ret__, 'log_configuration_override_details'),
        log_details=pulumi.get(__ret__, 'log_details'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        pipeline_run_id=pulumi.get(__ret__, 'pipeline_run_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        step_override_details=pulumi.get(__ret__, 'step_override_details'),
        step_runs=pulumi.get(__ret__, 'step_runs'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_accepted=pulumi.get(__ret__, 'time_accepted'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_pipeline_run)
def get_pipeline_run_output(pipeline_run_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPipelineRunResult]:
    """
    This data source provides details about a specific Pipeline Run resource in Oracle Cloud Infrastructure Data Science service.

    Gets a PipelineRun by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pipeline_run = oci.DataScience.get_pipeline_run(pipeline_run_id=oci_datascience_pipeline_run["test_pipeline_run"]["id"])
    ```


    :param str pipeline_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline run.
    """
    ...
