# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHttpMonitorsFilterResult',
    'GetHttpMonitorsHttpMonitorResult',
    'GetHttpProbeResultsFilterResult',
    'GetHttpProbeResultsHttpProbeResultResult',
    'GetHttpProbeResultsHttpProbeResultConnectionResult',
    'GetHttpProbeResultsHttpProbeResultDnResult',
    'GetPingMonitorsFilterResult',
    'GetPingMonitorsPingMonitorResult',
    'GetPingProbeResultsFilterResult',
    'GetPingProbeResultsPingProbeResultResult',
    'GetPingProbeResultsPingProbeResultConnectionResult',
    'GetPingProbeResultsPingProbeResultDnResult',
    'GetVantagePointsFilterResult',
    'GetVantagePointsHealthChecksVantagePointResult',
    'GetVantagePointsHealthChecksVantagePointGeoResult',
    'GetVantagePointsHealthChecksVantagePointRoutingResult',
]

@pulumi.output_type
class GetHttpMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetHttpMonitorsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpMonitorsHttpMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 headers: Mapping[str, Any],
                 home_region: str,
                 id: str,
                 interval_in_seconds: int,
                 is_enabled: bool,
                 method: str,
                 path: str,
                 port: int,
                 protocol: str,
                 results_url: str,
                 targets: Sequence[str],
                 time_created: str,
                 timeout_in_seconds: int,
                 vantage_point_names: Sequence[str]):
        """
        :param str compartment_id: Filters results by compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param Mapping[str, Any] headers: A dictionary of HTTP request headers.
        :param str home_region: Filters results that match the `homeRegion`.
        :param str id: The OCID of the resource.
        :param int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param str method: The supported HTTP methods available for probes.
        :param str path: The optional URL path to probe, including query parameters.
        :param int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param str protocol: The supported protocols available for HTTP probes.
        :param str results_url: A URL for fetching the probe results.
        :param Sequence[str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        GetHttpMonitorsHttpMonitorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            headers=headers,
            home_region=home_region,
            id=id,
            interval_in_seconds=interval_in_seconds,
            is_enabled=is_enabled,
            method=method,
            path=path,
            port=port,
            protocol=protocol,
            results_url=results_url,
            targets=targets,
            time_created=time_created,
            timeout_in_seconds=timeout_in_seconds,
            vantage_point_names=vantage_point_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             headers: Mapping[str, Any],
             home_region: str,
             id: str,
             interval_in_seconds: int,
             is_enabled: bool,
             method: str,
             path: str,
             port: int,
             protocol: str,
             results_url: str,
             targets: Sequence[str],
             time_created: str,
             timeout_in_seconds: int,
             vantage_point_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("headers", headers)
        _setter("home_region", home_region)
        _setter("id", id)
        _setter("interval_in_seconds", interval_in_seconds)
        _setter("is_enabled", is_enabled)
        _setter("method", method)
        _setter("path", path)
        _setter("port", port)
        _setter("protocol", protocol)
        _setter("results_url", results_url)
        _setter("targets", targets)
        _setter("time_created", time_created)
        _setter("timeout_in_seconds", timeout_in_seconds)
        _setter("vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def headers(self) -> Mapping[str, Any]:
        """
        A dictionary of HTTP request headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The supported HTTP methods available for probes.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The optional URL path to probe, including query parameters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetHttpProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetHttpProbeResultsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultResult(dict):
    def __init__(__self__, *,
                 connect_end: float,
                 connect_start: float,
                 connections: Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult'],
                 domain_lookup_end: float,
                 domain_lookup_start: float,
                 duration: float,
                 encoded_body_size: int,
                 error_category: str,
                 error_message: str,
                 fetch_start: float,
                 is_healthy: bool,
                 is_timed_out: bool,
                 key: str,
                 probe_configuration_id: str,
                 protocol: str,
                 request_start: float,
                 response_end: float,
                 response_start: float,
                 secure_connection_start: float,
                 start_time: float,
                 status_code: int,
                 target: str,
                 vantage_point_name: str):
        """
        :param float connect_end: The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        :param float connect_start: The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        :param Sequence['GetHttpProbeResultsHttpProbeResultConnectionArgs'] connections: TCP connection results.  All durations are in milliseconds.
        :param Sequence['GetHttpProbeResultsHttpProbeResultDnArgs'] dns: The DNS resolution results.
        :param float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param float duration: The total duration from start of request until response is fully consumed or the connection is closed.
        :param int encoded_body_size: The size, in octets, of the payload body prior to removing any applied content-codings.
        :param str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param str error_message: The error information indicating why a probe execution failed.
        :param float fetch_start: The time immediately before the vantage point starts to fetch the resource.
        :param bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param str protocol: The supported protocols available for HTTP probes.
        :param float request_start: The time immediately before the vantage point starts requesting the resource from the server.
        :param float response_end: The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        :param float response_start: The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        :param float secure_connection_start: The time immediately before the vantage point starts the handshake process to secure the current connection.
        :param float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param int status_code: The HTTP response status code.
        :param str target: Filters results that match the `target`.
        :param str vantage_point_name: The name of the vantage point that executed the probe.
        """
        GetHttpProbeResultsHttpProbeResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connect_end=connect_end,
            connect_start=connect_start,
            connections=connections,
            dns=dns,
            domain_lookup_end=domain_lookup_end,
            domain_lookup_start=domain_lookup_start,
            duration=duration,
            encoded_body_size=encoded_body_size,
            error_category=error_category,
            error_message=error_message,
            fetch_start=fetch_start,
            is_healthy=is_healthy,
            is_timed_out=is_timed_out,
            key=key,
            probe_configuration_id=probe_configuration_id,
            protocol=protocol,
            request_start=request_start,
            response_end=response_end,
            response_start=response_start,
            secure_connection_start=secure_connection_start,
            start_time=start_time,
            status_code=status_code,
            target=target,
            vantage_point_name=vantage_point_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connect_end: float,
             connect_start: float,
             connections: Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult'],
             dns: Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult'],
             domain_lookup_end: float,
             domain_lookup_start: float,
             duration: float,
             encoded_body_size: int,
             error_category: str,
             error_message: str,
             fetch_start: float,
             is_healthy: bool,
             is_timed_out: bool,
             key: str,
             probe_configuration_id: str,
             protocol: str,
             request_start: float,
             response_end: float,
             response_start: float,
             secure_connection_start: float,
             start_time: float,
             status_code: int,
             target: str,
             vantage_point_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("connect_end", connect_end)
        _setter("connect_start", connect_start)
        _setter("connections", connections)
        _setter("dns", dns)
        _setter("domain_lookup_end", domain_lookup_end)
        _setter("domain_lookup_start", domain_lookup_start)
        _setter("duration", duration)
        _setter("encoded_body_size", encoded_body_size)
        _setter("error_category", error_category)
        _setter("error_message", error_message)
        _setter("fetch_start", fetch_start)
        _setter("is_healthy", is_healthy)
        _setter("is_timed_out", is_timed_out)
        _setter("key", key)
        _setter("probe_configuration_id", probe_configuration_id)
        _setter("protocol", protocol)
        _setter("request_start", request_start)
        _setter("response_end", response_end)
        _setter("response_start", response_start)
        _setter("secure_connection_start", secure_connection_start)
        _setter("start_time", start_time)
        _setter("status_code", status_code)
        _setter("target", target)
        _setter("vantage_point_name", vantage_point_name)

    @property
    @pulumi.getter(name="connectEnd")
    def connect_end(self) -> float:
        """
        The time immediately after the vantage point finishes establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_end")

    @property
    @pulumi.getter(name="connectStart")
    def connect_start(self) -> float:
        """
        The time immediately before the vantage point starts establishing the connection to the server to retrieve the resource.
        """
        return pulumi.get(self, "connect_start")

    @property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultConnectionResult']:
        """
        TCP connection results.  All durations are in milliseconds.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @property
    @pulumi.getter
    def duration(self) -> float:
        """
        The total duration from start of request until response is fully consumed or the connection is closed.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="encodedBodySize")
    def encoded_body_size(self) -> int:
        """
        The size, in octets, of the payload body prior to removing any applied content-codings.
        """
        return pulumi.get(self, "encoded_body_size")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="fetchStart")
    def fetch_start(self) -> float:
        """
        The time immediately before the vantage point starts to fetch the resource.
        """
        return pulumi.get(self, "fetch_start")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The supported protocols available for HTTP probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requestStart")
    def request_start(self) -> float:
        """
        The time immediately before the vantage point starts requesting the resource from the server.
        """
        return pulumi.get(self, "request_start")

    @property
    @pulumi.getter(name="responseEnd")
    def response_end(self) -> float:
        """
        The time immediately after the vantage point receives the last byte of the response or immediately before the transport connection is closed, whichever comes first.
        """
        return pulumi.get(self, "response_end")

    @property
    @pulumi.getter(name="responseStart")
    def response_start(self) -> float:
        """
        The time immediately after the vantage point's HTTP parser receives the first byte of the response.
        """
        return pulumi.get(self, "response_start")

    @property
    @pulumi.getter(name="secureConnectionStart")
    def secure_connection_start(self) -> float:
        """
        The time immediately before the vantage point starts the handshake process to secure the current connection.
        """
        return pulumi.get(self, "secure_connection_start")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        The HTTP response status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: str,
                 connect_duration: float,
                 port: int,
                 secure_connect_duration: float):
        """
        :param str address: The connection IP address.
        :param float connect_duration: Total connect duration, calculated using `connectEnd` minus `connectStart`.
        :param int port: The port.
        :param float secure_connect_duration: The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        GetHttpProbeResultsHttpProbeResultConnectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            connect_duration=connect_duration,
            port=port,
            secure_connect_duration=secure_connect_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             connect_duration: float,
             port: int,
             secure_connect_duration: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("connect_duration", connect_duration)
        _setter("port", port)
        _setter("secure_connect_duration", secure_connect_duration)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="connectDuration")
    def connect_duration(self) -> float:
        """
        Total connect duration, calculated using `connectEnd` minus `connectStart`.
        """
        return pulumi.get(self, "connect_duration")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="secureConnectDuration")
    def secure_connect_duration(self) -> float:
        """
        The duration to secure the connection.  This value will be zero for insecure connections.  Calculated using `connectEnd` minus `secureConnectionStart`.
        """
        return pulumi.get(self, "secure_connect_duration")


@pulumi.output_type
class GetHttpProbeResultsHttpProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[str],
                 domain_lookup_duration: float):
        """
        :param Sequence[str] addresses: The addresses returned by DNS resolution.
        :param float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        GetHttpProbeResultsHttpProbeResultDnResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            addresses=addresses,
            domain_lookup_duration=domain_lookup_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             addresses: Sequence[str],
             domain_lookup_duration: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("addresses", addresses)
        _setter("domain_lookup_duration", domain_lookup_duration)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetPingMonitorsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPingMonitorsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingMonitorsPingMonitorResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 home_region: str,
                 id: str,
                 interval_in_seconds: int,
                 is_enabled: bool,
                 port: int,
                 protocol: str,
                 results_url: str,
                 targets: Sequence[str],
                 time_created: str,
                 timeout_in_seconds: int,
                 vantage_point_names: Sequence[str]):
        """
        :param str compartment_id: Filters results by compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: Filters results that exactly match the `displayName` field.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str home_region: Filters results that match the `homeRegion`.
        :param str id: The OCID of the resource.
        :param int interval_in_seconds: The monitor interval in seconds. Valid values: 10, 30, and 60.
        :param bool is_enabled: Enables or disables the monitor. Set to 'true' to launch monitoring.
        :param int port: The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        :param str protocol: The protocols for ping probes.
        :param str results_url: A URL for fetching the probe results.
        :param Sequence[str] targets: A list of targets (hostnames or IP addresses) of the probe.
        :param str time_created: The RFC 3339-formatted creation date and time of the probe.
        :param int timeout_in_seconds: The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        :param Sequence[str] vantage_point_names: A list of names of vantage points from which to execute the probe.
        """
        GetPingMonitorsPingMonitorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            home_region=home_region,
            id=id,
            interval_in_seconds=interval_in_seconds,
            is_enabled=is_enabled,
            port=port,
            protocol=protocol,
            results_url=results_url,
            targets=targets,
            time_created=time_created,
            timeout_in_seconds=timeout_in_seconds,
            vantage_point_names=vantage_point_names,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             home_region: str,
             id: str,
             interval_in_seconds: int,
             is_enabled: bool,
             port: int,
             protocol: str,
             results_url: str,
             targets: Sequence[str],
             time_created: str,
             timeout_in_seconds: int,
             vantage_point_names: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("home_region", home_region)
        _setter("id", id)
        _setter("interval_in_seconds", interval_in_seconds)
        _setter("is_enabled", is_enabled)
        _setter("port", port)
        _setter("protocol", protocol)
        _setter("results_url", results_url)
        _setter("targets", targets)
        _setter("time_created", time_created)
        _setter("timeout_in_seconds", timeout_in_seconds)
        _setter("vantage_point_names", vantage_point_names)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Filters results by compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> str:
        """
        Filters results that match the `homeRegion`.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> int:
        """
        The monitor interval in seconds. Valid values: 10, 30, and 60.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Enables or disables the monitor. Set to 'true' to launch monitoring.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port on which to probe endpoints. If unspecified, probes will use the default port of their protocol.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> str:
        """
        A URL for fetching the probe results.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[str]:
        """
        A list of targets (hostnames or IP addresses) of the probe.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The RFC 3339-formatted creation date and time of the probe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The probe timeout in seconds. Valid values: 10, 20, 30, and 60. The probe timeout must be less than or equal to `intervalInSeconds` for monitors.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointNames")
    def vantage_point_names(self) -> Sequence[str]:
        """
        A list of names of vantage points from which to execute the probe.
        """
        return pulumi.get(self, "vantage_point_names")


@pulumi.output_type
class GetPingProbeResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPingProbeResultsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultResult(dict):
    def __init__(__self__, *,
                 connections: Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult'],
                 dns: Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult'],
                 domain_lookup_end: float,
                 domain_lookup_start: float,
                 error_category: str,
                 error_message: str,
                 icmp_code: int,
                 is_healthy: bool,
                 is_timed_out: bool,
                 key: str,
                 latency_in_ms: float,
                 probe_configuration_id: str,
                 protocol: str,
                 start_time: float,
                 target: str,
                 vantage_point_name: str):
        """
        :param Sequence['GetPingProbeResultsPingProbeResultConnectionArgs'] connections: The network connection results.
        :param Sequence['GetPingProbeResultsPingProbeResultDnArgs'] dns: The DNS resolution results.
        :param float domain_lookup_end: The time immediately before the vantage point finishes the domain name lookup for the resource.
        :param float domain_lookup_start: The time immediately before the vantage point starts the domain name lookup for the resource.
        :param str error_category: The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
               * NONE - No error
               * DNS - DNS errors
               * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
               * NETWORK - Network-related errors, for example a "network unreachable" error.
               * SYSTEM - Internal system errors.
        :param str error_message: The error information indicating why a probe execution failed.
        :param int icmp_code: The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        :param bool is_healthy: True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        :param bool is_timed_out: True if the probe did not complete before the configured `timeoutInSeconds` value.
        :param str key: A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        :param float latency_in_ms: The latency of the probe execution, in milliseconds.
        :param str probe_configuration_id: The OCID of a monitor or on-demand probe.
        :param str protocol: The protocols for ping probes.
        :param float start_time: The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        :param str target: Filters results that match the `target`.
        :param str vantage_point_name: The name of the vantage point that executed the probe.
        """
        GetPingProbeResultsPingProbeResultResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connections=connections,
            dns=dns,
            domain_lookup_end=domain_lookup_end,
            domain_lookup_start=domain_lookup_start,
            error_category=error_category,
            error_message=error_message,
            icmp_code=icmp_code,
            is_healthy=is_healthy,
            is_timed_out=is_timed_out,
            key=key,
            latency_in_ms=latency_in_ms,
            probe_configuration_id=probe_configuration_id,
            protocol=protocol,
            start_time=start_time,
            target=target,
            vantage_point_name=vantage_point_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connections: Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult'],
             dns: Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult'],
             domain_lookup_end: float,
             domain_lookup_start: float,
             error_category: str,
             error_message: str,
             icmp_code: int,
             is_healthy: bool,
             is_timed_out: bool,
             key: str,
             latency_in_ms: float,
             probe_configuration_id: str,
             protocol: str,
             start_time: float,
             target: str,
             vantage_point_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("connections", connections)
        _setter("dns", dns)
        _setter("domain_lookup_end", domain_lookup_end)
        _setter("domain_lookup_start", domain_lookup_start)
        _setter("error_category", error_category)
        _setter("error_message", error_message)
        _setter("icmp_code", icmp_code)
        _setter("is_healthy", is_healthy)
        _setter("is_timed_out", is_timed_out)
        _setter("key", key)
        _setter("latency_in_ms", latency_in_ms)
        _setter("probe_configuration_id", probe_configuration_id)
        _setter("protocol", protocol)
        _setter("start_time", start_time)
        _setter("target", target)
        _setter("vantage_point_name", vantage_point_name)

    @property
    @pulumi.getter
    def connections(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultConnectionResult']:
        """
        The network connection results.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def dns(self) -> Sequence['outputs.GetPingProbeResultsPingProbeResultDnResult']:
        """
        The DNS resolution results.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="domainLookupEnd")
    def domain_lookup_end(self) -> float:
        """
        The time immediately before the vantage point finishes the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_end")

    @property
    @pulumi.getter(name="domainLookupStart")
    def domain_lookup_start(self) -> float:
        """
        The time immediately before the vantage point starts the domain name lookup for the resource.
        """
        return pulumi.get(self, "domain_lookup_start")

    @property
    @pulumi.getter(name="errorCategory")
    def error_category(self) -> str:
        """
        The category of error if an error occurs executing the probe. The `errorMessage` field provides a message with the error details.
        * NONE - No error
        * DNS - DNS errors
        * TRANSPORT - Transport-related errors, for example a "TLS certificate expired" error.
        * NETWORK - Network-related errors, for example a "network unreachable" error.
        * SYSTEM - Internal system errors.
        """
        return pulumi.get(self, "error_category")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The error information indicating why a probe execution failed.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        """
        The ICMP code of the response message.  This field is not used when the protocol is set to TCP.  For more information on ICMP codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> bool:
        """
        True if the probe result is determined to be healthy based on probe type-specific criteria.  For HTTP probes, a probe result is considered healthy if the HTTP response code is greater than or equal to 200 and less than 300.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isTimedOut")
    def is_timed_out(self) -> bool:
        """
        True if the probe did not complete before the configured `timeoutInSeconds` value.
        """
        return pulumi.get(self, "is_timed_out")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A value identifying this specific probe result. The key is only unique within the results of its probe configuration. The key may be reused after 90 days.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="latencyInMs")
    def latency_in_ms(self) -> float:
        """
        The latency of the probe execution, in milliseconds.
        """
        return pulumi.get(self, "latency_in_ms")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> str:
        """
        The OCID of a monitor or on-demand probe.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocols for ping probes.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> float:
        """
        The date and time the probe was executed, expressed in milliseconds since the POSIX epoch. This field is defined by the PerformanceResourceTiming interface of the W3C Resource Timing specification. For more information, see [Resource Timing](https://w3c.github.io/resource-timing/#sec-resource-timing).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Filters results that match the `target`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="vantagePointName")
    def vantage_point_name(self) -> str:
        """
        The name of the vantage point that executed the probe.
        """
        return pulumi.get(self, "vantage_point_name")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultConnectionResult(dict):
    def __init__(__self__, *,
                 address: str,
                 port: int):
        """
        :param str address: The connection IP address.
        :param int port: The port.
        """
        GetPingProbeResultsPingProbeResultConnectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             port: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The connection IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPingProbeResultsPingProbeResultDnResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[str],
                 domain_lookup_duration: float):
        """
        :param Sequence[str] addresses: The addresses returned by DNS resolution.
        :param float domain_lookup_duration: Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        GetPingProbeResultsPingProbeResultDnResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            addresses=addresses,
            domain_lookup_duration=domain_lookup_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             addresses: Sequence[str],
             domain_lookup_duration: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("addresses", addresses)
        _setter("domain_lookup_duration", domain_lookup_duration)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence[str]:
        """
        The addresses returned by DNS resolution.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="domainLookupDuration")
    def domain_lookup_duration(self) -> float:
        """
        Total DNS resolution duration, in milliseconds. Calculated using `domainLookupEnd` minus `domainLookupStart`.
        """
        return pulumi.get(self, "domain_lookup_duration")


@pulumi.output_type
class GetVantagePointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Filters results that exactly match the `name` field.
        """
        GetVantagePointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 geos: Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult'],
                 name: str,
                 provider_name: str,
                 routings: Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']):
        """
        :param str display_name: Filters results that exactly match the `displayName` field.
        :param Sequence['GetVantagePointsHealthChecksVantagePointGeoArgs'] geos: Geographic information about a vantage point.
        :param str name: Filters results that exactly match the `name` field.
        :param str provider_name: The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        :param Sequence['GetVantagePointsHealthChecksVantagePointRoutingArgs'] routings: An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        GetVantagePointsHealthChecksVantagePointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            geos=geos,
            name=name,
            provider_name=provider_name,
            routings=routings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             geos: Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult'],
             name: str,
             provider_name: str,
             routings: Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("display_name", display_name)
        _setter("geos", geos)
        _setter("name", name)
        _setter("provider_name", provider_name)
        _setter("routings", routings)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Filters results that exactly match the `displayName` field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def geos(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointGeoResult']:
        """
        Geographic information about a vantage point.
        """
        return pulumi.get(self, "geos")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Filters results that exactly match the `name` field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> str:
        """
        The organization on whose infrastructure this vantage point resides. Provider names are not unique, as Oracle Cloud Infrastructure maintains many vantage points in each major provider.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter
    def routings(self) -> Sequence['outputs.GetVantagePointsHealthChecksVantagePointRoutingResult']:
        """
        An array of objects that describe how traffic to this vantage point is routed, including which prefixes and ASNs connect it to the internet.
        """
        return pulumi.get(self, "routings")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointGeoResult(dict):
    def __init__(__self__, *,
                 admin_div_code: str,
                 city_name: str,
                 country_code: str,
                 country_name: str,
                 geo_key: str,
                 latitude: float,
                 longitude: float):
        """
        :param str admin_div_code: The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param str city_name: Common English-language name for the city.
        :param str country_code: The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        :param str country_name: The common English-language name for the country.
        :param str geo_key: An opaque identifier for the geographic location of the vantage point.
        :param float latitude: Degrees north of the Equator.
        :param float longitude: Degrees east of the prime meridian.
        """
        GetVantagePointsHealthChecksVantagePointGeoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_div_code=admin_div_code,
            city_name=city_name,
            country_code=country_code,
            country_name=country_name,
            geo_key=geo_key,
            latitude=latitude,
            longitude=longitude,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_div_code: str,
             city_name: str,
             country_code: str,
             country_name: str,
             geo_key: str,
             latitude: float,
             longitude: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("admin_div_code", admin_div_code)
        _setter("city_name", city_name)
        _setter("country_code", country_code)
        _setter("country_name", country_name)
        _setter("geo_key", geo_key)
        _setter("latitude", latitude)
        _setter("longitude", longitude)

    @property
    @pulumi.getter(name="adminDivCode")
    def admin_div_code(self) -> str:
        """
        The ISO 3166-2 code for this location's first-level administrative division, either a US state or Canadian province. Only included for locations in the US or Canada. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "admin_div_code")

    @property
    @pulumi.getter(name="cityName")
    def city_name(self) -> str:
        """
        Common English-language name for the city.
        """
        return pulumi.get(self, "city_name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The ISO 3166-1 alpha-2 country code. For a list of codes, see [Country Codes](https://www.iso.org/obp/ui/#search).
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> str:
        """
        The common English-language name for the country.
        """
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="geoKey")
    def geo_key(self) -> str:
        """
        An opaque identifier for the geographic location of the vantage point.
        """
        return pulumi.get(self, "geo_key")

    @property
    @pulumi.getter
    def latitude(self) -> float:
        """
        Degrees north of the Equator.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> float:
        """
        Degrees east of the prime meridian.
        """
        return pulumi.get(self, "longitude")


@pulumi.output_type
class GetVantagePointsHealthChecksVantagePointRoutingResult(dict):
    def __init__(__self__, *,
                 as_label: str,
                 asn: int,
                 prefix: str,
                 weight: int):
        """
        :param str as_label: The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        :param int asn: The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        :param str prefix: An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        :param int weight: An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        GetVantagePointsHealthChecksVantagePointRoutingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            as_label=as_label,
            asn=asn,
            prefix=prefix,
            weight=weight,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             as_label: str,
             asn: int,
             prefix: str,
             weight: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("as_label", as_label)
        _setter("asn", asn)
        _setter("prefix", prefix)
        _setter("weight", weight)

    @property
    @pulumi.getter(name="asLabel")
    def as_label(self) -> str:
        """
        The registry label for `asn`, usually the name of the organization that owns the ASN. May be omitted or null.
        """
        return pulumi.get(self, "as_label")

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        The Autonomous System Number (ASN) identifying the organization responsible for routing packets to `prefix`.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        An IP prefix (CIDR syntax) that is less specific than `address`, through which `address` is routed.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        An integer between 0 and 100 used to select between multiple origin ASNs when routing to `prefix`. Most prefixes have exactly one origin ASN, in which case `weight` will be 100.
        """
        return pulumi.get(self, "weight")


