# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 description: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 home_region: pulumi.Input[str],
                 license_type: pulumi.Input[str],
                 admin_email: Optional[pulumi.Input[str]] = None,
                 admin_first_name: Optional[pulumi.Input[str]] = None,
                 admin_last_name: Optional[pulumi.Input[str]] = None,
                 admin_user_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
                 is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
                 is_primary_email_required: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the Compartment where domain is created
        :param pulumi.Input[str] description: (Updatable) Domain entity description
        :param pulumi.Input[str] display_name: (Updatable) The mutable display name of the domain.
        :param pulumi.Input[str] home_region: The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        :param pulumi.Input[str] license_type: The License type of Domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] admin_email: The admin email address
        :param pulumi.Input[str] admin_first_name: The admin first name
        :param pulumi.Input[str] admin_last_name: The admin last name
        :param pulumi.Input[str] admin_user_name: The admin user name
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_hidden_on_login: (Updatable) Indicates whether domain is hidden on login screen or not.
        :param pulumi.Input[bool] is_notification_bypassed: Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        :param pulumi.Input[bool] is_primary_email_required: Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        :param pulumi.Input[str] state: The current state.
        """
        DomainArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            description=description,
            display_name=display_name,
            home_region=home_region,
            license_type=license_type,
            admin_email=admin_email,
            admin_first_name=admin_first_name,
            admin_last_name=admin_last_name,
            admin_user_name=admin_user_name,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_hidden_on_login=is_hidden_on_login,
            is_notification_bypassed=is_notification_bypassed,
            is_primary_email_required=is_primary_email_required,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             description: pulumi.Input[str],
             display_name: pulumi.Input[str],
             home_region: pulumi.Input[str],
             license_type: pulumi.Input[str],
             admin_email: Optional[pulumi.Input[str]] = None,
             admin_first_name: Optional[pulumi.Input[str]] = None,
             admin_last_name: Optional[pulumi.Input[str]] = None,
             admin_user_name: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
             is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
             is_primary_email_required: Optional[pulumi.Input[bool]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("home_region", home_region)
        _setter("license_type", license_type)
        if admin_email is not None:
            _setter("admin_email", admin_email)
        if admin_first_name is not None:
            _setter("admin_first_name", admin_first_name)
        if admin_last_name is not None:
            _setter("admin_last_name", admin_last_name)
        if admin_user_name is not None:
            _setter("admin_user_name", admin_user_name)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_hidden_on_login is not None:
            _setter("is_hidden_on_login", is_hidden_on_login)
        if is_notification_bypassed is not None:
            _setter("is_notification_bypassed", is_notification_bypassed)
        if is_primary_email_required is not None:
            _setter("is_primary_email_required", is_primary_email_required)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the Compartment where domain is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        (Updatable) Domain entity description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The mutable display name of the domain.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> pulumi.Input[str]:
        """
        The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "home_region")

    @home_region.setter
    def home_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "home_region", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[str]:
        """
        The License type of Domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> Optional[pulumi.Input[str]]:
        """
        The admin email address
        """
        return pulumi.get(self, "admin_email")

    @admin_email.setter
    def admin_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_email", value)

    @property
    @pulumi.getter(name="adminFirstName")
    def admin_first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin first name
        """
        return pulumi.get(self, "admin_first_name")

    @admin_first_name.setter
    def admin_first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_first_name", value)

    @property
    @pulumi.getter(name="adminLastName")
    def admin_last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin last name
        """
        return pulumi.get(self, "admin_last_name")

    @admin_last_name.setter
    def admin_last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_last_name", value)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin user name
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isHiddenOnLogin")
    def is_hidden_on_login(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether domain is hidden on login screen or not.
        """
        return pulumi.get(self, "is_hidden_on_login")

    @is_hidden_on_login.setter
    def is_hidden_on_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hidden_on_login", value)

    @property
    @pulumi.getter(name="isNotificationBypassed")
    def is_notification_bypassed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        """
        return pulumi.get(self, "is_notification_bypassed")

    @is_notification_bypassed.setter
    def is_notification_bypassed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notification_bypassed", value)

    @property
    @pulumi.getter(name="isPrimaryEmailRequired")
    def is_primary_email_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        """
        return pulumi.get(self, "is_primary_email_required")

    @is_primary_email_required.setter
    def is_primary_email_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_primary_email_required", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 admin_email: Optional[pulumi.Input[str]] = None,
                 admin_first_name: Optional[pulumi.Input[str]] = None,
                 admin_last_name: Optional[pulumi.Input[str]] = None,
                 admin_user_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 home_region: Optional[pulumi.Input[str]] = None,
                 home_region_url: Optional[pulumi.Input[str]] = None,
                 is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
                 is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
                 is_primary_email_required: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input['DomainReplicaRegionArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[str] admin_email: The admin email address
        :param pulumi.Input[str] admin_first_name: The admin first name
        :param pulumi.Input[str] admin_last_name: The admin last name
        :param pulumi.Input[str] admin_user_name: The admin user name
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the Compartment where domain is created
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Domain entity description
        :param pulumi.Input[str] display_name: (Updatable) The mutable display name of the domain.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] home_region: The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        :param pulumi.Input[str] home_region_url: Region specific domain URL.
        :param pulumi.Input[bool] is_hidden_on_login: (Updatable) Indicates whether domain is hidden on login screen or not.
        :param pulumi.Input[bool] is_notification_bypassed: Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        :param pulumi.Input[bool] is_primary_email_required: Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        :param pulumi.Input[str] license_type: The License type of Domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Any additional details about the current state of the Domain.
        :param pulumi.Input[Sequence[pulumi.Input['DomainReplicaRegionArgs']]] replica_regions: The regions domain is replication to.
        :param pulumi.Input[str] state: The current state.
        :param pulumi.Input[str] time_created: Date and time the domain was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The type of the domain.
        :param pulumi.Input[str] url: Region agnostic domain URL.
        """
        _DomainState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_email=admin_email,
            admin_first_name=admin_first_name,
            admin_last_name=admin_last_name,
            admin_user_name=admin_user_name,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            home_region=home_region,
            home_region_url=home_region_url,
            is_hidden_on_login=is_hidden_on_login,
            is_notification_bypassed=is_notification_bypassed,
            is_primary_email_required=is_primary_email_required,
            license_type=license_type,
            lifecycle_details=lifecycle_details,
            replica_regions=replica_regions,
            state=state,
            time_created=time_created,
            type=type,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_email: Optional[pulumi.Input[str]] = None,
             admin_first_name: Optional[pulumi.Input[str]] = None,
             admin_last_name: Optional[pulumi.Input[str]] = None,
             admin_user_name: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             home_region: Optional[pulumi.Input[str]] = None,
             home_region_url: Optional[pulumi.Input[str]] = None,
             is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
             is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
             is_primary_email_required: Optional[pulumi.Input[bool]] = None,
             license_type: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input['DomainReplicaRegionArgs']]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             url: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if admin_email is not None:
            _setter("admin_email", admin_email)
        if admin_first_name is not None:
            _setter("admin_first_name", admin_first_name)
        if admin_last_name is not None:
            _setter("admin_last_name", admin_last_name)
        if admin_user_name is not None:
            _setter("admin_user_name", admin_user_name)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if home_region is not None:
            _setter("home_region", home_region)
        if home_region_url is not None:
            _setter("home_region_url", home_region_url)
        if is_hidden_on_login is not None:
            _setter("is_hidden_on_login", is_hidden_on_login)
        if is_notification_bypassed is not None:
            _setter("is_notification_bypassed", is_notification_bypassed)
        if is_primary_email_required is not None:
            _setter("is_primary_email_required", is_primary_email_required)
        if license_type is not None:
            _setter("license_type", license_type)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if replica_regions is not None:
            _setter("replica_regions", replica_regions)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if type is not None:
            _setter("type", type)
        if url is not None:
            _setter("url", url)

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> Optional[pulumi.Input[str]]:
        """
        The admin email address
        """
        return pulumi.get(self, "admin_email")

    @admin_email.setter
    def admin_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_email", value)

    @property
    @pulumi.getter(name="adminFirstName")
    def admin_first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin first name
        """
        return pulumi.get(self, "admin_first_name")

    @admin_first_name.setter
    def admin_first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_first_name", value)

    @property
    @pulumi.getter(name="adminLastName")
    def admin_last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin last name
        """
        return pulumi.get(self, "admin_last_name")

    @admin_last_name.setter
    def admin_last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_last_name", value)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The admin user name
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Compartment where domain is created
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Domain entity description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The mutable display name of the domain.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "home_region")

    @home_region.setter
    def home_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_region", value)

    @property
    @pulumi.getter(name="homeRegionUrl")
    def home_region_url(self) -> Optional[pulumi.Input[str]]:
        """
        Region specific domain URL.
        """
        return pulumi.get(self, "home_region_url")

    @home_region_url.setter
    def home_region_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_region_url", value)

    @property
    @pulumi.getter(name="isHiddenOnLogin")
    def is_hidden_on_login(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether domain is hidden on login screen or not.
        """
        return pulumi.get(self, "is_hidden_on_login")

    @is_hidden_on_login.setter
    def is_hidden_on_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hidden_on_login", value)

    @property
    @pulumi.getter(name="isNotificationBypassed")
    def is_notification_bypassed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        """
        return pulumi.get(self, "is_notification_bypassed")

    @is_notification_bypassed.setter
    def is_notification_bypassed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notification_bypassed", value)

    @property
    @pulumi.getter(name="isPrimaryEmailRequired")
    def is_primary_email_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        """
        return pulumi.get(self, "is_primary_email_required")

    @is_primary_email_required.setter
    def is_primary_email_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_primary_email_required", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        The License type of Domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Any additional details about the current state of the Domain.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainReplicaRegionArgs']]]]:
        """
        The regions domain is replication to.
        """
        return pulumi.get(self, "replica_regions")

    @replica_regions.setter
    def replica_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainReplicaRegionArgs']]]]):
        pulumi.set(self, "replica_regions", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the domain was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the domain.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Region agnostic domain URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_email: Optional[pulumi.Input[str]] = None,
                 admin_first_name: Optional[pulumi.Input[str]] = None,
                 admin_last_name: Optional[pulumi.Input[str]] = None,
                 admin_user_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 home_region: Optional[pulumi.Input[str]] = None,
                 is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
                 is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
                 is_primary_email_required: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Domain resource in Oracle Cloud Infrastructure Identity service.

        Creates a new domain in the tenancy with domain home in {@code homeRegion}. This is an asynchronous call - where, at start,
        {@code lifecycleState} of this domain is set to CREATING and {@code lifecycleDetails} to UPDATING. On domain creation completion
        this Domain's {@code lifecycleState} will be set to ACTIVE and {@code lifecycleDetails} to null.

        To track progress, HTTP GET on /iamWorkRequests/{iamWorkRequestsId} endpoint will provide
        the async operation's status.

        After creating a `Domain`, make sure its `lifecycleState` changes from CREATING to ACTIVE
        before using it.
        If the domain's {@code displayName} already exists, returns 400 BAD REQUEST.
        If any one of admin related fields are provided and one of the following 3 fields
        - {@code adminEmail}, {@code adminLastName} and {@code adminUserName} - is not provided,
          returns 400 BAD REQUEST.
        - If {@code isNotificationBypassed} is NOT provided when admin information is provided,
          returns 400 BAD REQUEST.
        - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_domain = oci.identity.Domain("testDomain",
            compartment_id=var["compartment_id"],
            description=var["domain_description"],
            display_name=var["domain_display_name"],
            home_region=var["domain_home_region"],
            license_type=var["domain_license_type"],
            admin_email=var["domain_admin_email"],
            admin_first_name=var["domain_admin_first_name"],
            admin_last_name=var["domain_admin_last_name"],
            admin_user_name=oci_identity_user["test_user"]["name"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_hidden_on_login=var["domain_is_hidden_on_login"],
            is_notification_bypassed=var["domain_is_notification_bypassed"],
            is_primary_email_required=var["domain_is_primary_email_required"])
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domain:Domain test_domain "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_email: The admin email address
        :param pulumi.Input[str] admin_first_name: The admin first name
        :param pulumi.Input[str] admin_last_name: The admin last name
        :param pulumi.Input[str] admin_user_name: The admin user name
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the Compartment where domain is created
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Domain entity description
        :param pulumi.Input[str] display_name: (Updatable) The mutable display name of the domain.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] home_region: The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        :param pulumi.Input[bool] is_hidden_on_login: (Updatable) Indicates whether domain is hidden on login screen or not.
        :param pulumi.Input[bool] is_notification_bypassed: Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        :param pulumi.Input[bool] is_primary_email_required: Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        :param pulumi.Input[str] license_type: The License type of Domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Domain resource in Oracle Cloud Infrastructure Identity service.

        Creates a new domain in the tenancy with domain home in {@code homeRegion}. This is an asynchronous call - where, at start,
        {@code lifecycleState} of this domain is set to CREATING and {@code lifecycleDetails} to UPDATING. On domain creation completion
        this Domain's {@code lifecycleState} will be set to ACTIVE and {@code lifecycleDetails} to null.

        To track progress, HTTP GET on /iamWorkRequests/{iamWorkRequestsId} endpoint will provide
        the async operation's status.

        After creating a `Domain`, make sure its `lifecycleState` changes from CREATING to ACTIVE
        before using it.
        If the domain's {@code displayName} already exists, returns 400 BAD REQUEST.
        If any one of admin related fields are provided and one of the following 3 fields
        - {@code adminEmail}, {@code adminLastName} and {@code adminUserName} - is not provided,
          returns 400 BAD REQUEST.
        - If {@code isNotificationBypassed} is NOT provided when admin information is provided,
          returns 400 BAD REQUEST.
        - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_domain = oci.identity.Domain("testDomain",
            compartment_id=var["compartment_id"],
            description=var["domain_description"],
            display_name=var["domain_display_name"],
            home_region=var["domain_home_region"],
            license_type=var["domain_license_type"],
            admin_email=var["domain_admin_email"],
            admin_first_name=var["domain_admin_first_name"],
            admin_last_name=var["domain_admin_last_name"],
            admin_user_name=oci_identity_user["test_user"]["name"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            is_hidden_on_login=var["domain_is_hidden_on_login"],
            is_notification_bypassed=var["domain_is_notification_bypassed"],
            is_primary_email_required=var["domain_is_primary_email_required"])
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domain:Domain test_domain "id"
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DomainArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_email: Optional[pulumi.Input[str]] = None,
                 admin_first_name: Optional[pulumi.Input[str]] = None,
                 admin_last_name: Optional[pulumi.Input[str]] = None,
                 admin_user_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 home_region: Optional[pulumi.Input[str]] = None,
                 is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
                 is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
                 is_primary_email_required: Optional[pulumi.Input[bool]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["admin_email"] = admin_email
            __props__.__dict__["admin_first_name"] = admin_first_name
            __props__.__dict__["admin_last_name"] = admin_last_name
            __props__.__dict__["admin_user_name"] = admin_user_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if home_region is None and not opts.urn:
                raise TypeError("Missing required property 'home_region'")
            __props__.__dict__["home_region"] = home_region
            __props__.__dict__["is_hidden_on_login"] = is_hidden_on_login
            __props__.__dict__["is_notification_bypassed"] = is_notification_bypassed
            __props__.__dict__["is_primary_email_required"] = is_primary_email_required
            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["state"] = state
            __props__.__dict__["home_region_url"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["replica_regions"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["url"] = None
        super(Domain, __self__).__init__(
            'oci:Identity/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_email: Optional[pulumi.Input[str]] = None,
            admin_first_name: Optional[pulumi.Input[str]] = None,
            admin_last_name: Optional[pulumi.Input[str]] = None,
            admin_user_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            home_region: Optional[pulumi.Input[str]] = None,
            home_region_url: Optional[pulumi.Input[str]] = None,
            is_hidden_on_login: Optional[pulumi.Input[bool]] = None,
            is_notification_bypassed: Optional[pulumi.Input[bool]] = None,
            is_primary_email_required: Optional[pulumi.Input[bool]] = None,
            license_type: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            replica_regions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainReplicaRegionArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_email: The admin email address
        :param pulumi.Input[str] admin_first_name: The admin first name
        :param pulumi.Input[str] admin_last_name: The admin last name
        :param pulumi.Input[str] admin_user_name: The admin user name
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the Compartment where domain is created
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Domain entity description
        :param pulumi.Input[str] display_name: (Updatable) The mutable display name of the domain.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] home_region: The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        :param pulumi.Input[str] home_region_url: Region specific domain URL.
        :param pulumi.Input[bool] is_hidden_on_login: (Updatable) Indicates whether domain is hidden on login screen or not.
        :param pulumi.Input[bool] is_notification_bypassed: Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        :param pulumi.Input[bool] is_primary_email_required: Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        :param pulumi.Input[str] license_type: The License type of Domain
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Any additional details about the current state of the Domain.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainReplicaRegionArgs']]]] replica_regions: The regions domain is replication to.
        :param pulumi.Input[str] state: The current state.
        :param pulumi.Input[str] time_created: Date and time the domain was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] type: The type of the domain.
        :param pulumi.Input[str] url: Region agnostic domain URL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["admin_email"] = admin_email
        __props__.__dict__["admin_first_name"] = admin_first_name
        __props__.__dict__["admin_last_name"] = admin_last_name
        __props__.__dict__["admin_user_name"] = admin_user_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["home_region"] = home_region
        __props__.__dict__["home_region_url"] = home_region_url
        __props__.__dict__["is_hidden_on_login"] = is_hidden_on_login
        __props__.__dict__["is_notification_bypassed"] = is_notification_bypassed
        __props__.__dict__["is_primary_email_required"] = is_primary_email_required
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["replica_regions"] = replica_regions
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["type"] = type
        __props__.__dict__["url"] = url
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEmail")
    def admin_email(self) -> pulumi.Output[str]:
        """
        The admin email address
        """
        return pulumi.get(self, "admin_email")

    @property
    @pulumi.getter(name="adminFirstName")
    def admin_first_name(self) -> pulumi.Output[str]:
        """
        The admin first name
        """
        return pulumi.get(self, "admin_first_name")

    @property
    @pulumi.getter(name="adminLastName")
    def admin_last_name(self) -> pulumi.Output[str]:
        """
        The admin last name
        """
        return pulumi.get(self, "admin_last_name")

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> pulumi.Output[str]:
        """
        The admin user name
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Compartment where domain is created
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Domain entity description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The mutable display name of the domain.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> pulumi.Output[str]:
        """
        The region's name. See [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm) for the full list of supported region names.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter(name="homeRegionUrl")
    def home_region_url(self) -> pulumi.Output[str]:
        """
        Region specific domain URL.
        """
        return pulumi.get(self, "home_region_url")

    @property
    @pulumi.getter(name="isHiddenOnLogin")
    def is_hidden_on_login(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether domain is hidden on login screen or not.
        """
        return pulumi.get(self, "is_hidden_on_login")

    @property
    @pulumi.getter(name="isNotificationBypassed")
    def is_notification_bypassed(self) -> pulumi.Output[bool]:
        """
        Indicates if admin user created in IDCS stripe would like to receive notification like welcome email or not. Required field only if admin information is provided, otherwise optional.
        """
        return pulumi.get(self, "is_notification_bypassed")

    @property
    @pulumi.getter(name="isPrimaryEmailRequired")
    def is_primary_email_required(self) -> pulumi.Output[bool]:
        """
        Optional field to indicate whether users in the domain are required to have a primary email address or not Defaults to true
        """
        return pulumi.get(self, "is_primary_email_required")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[str]:
        """
        The License type of Domain


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Any additional details about the current state of the Domain.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="replicaRegions")
    def replica_regions(self) -> pulumi.Output[Sequence['outputs.DomainReplicaRegion']]:
        """
        The regions domain is replication to.
        """
        return pulumi.get(self, "replica_regions")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the domain was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the domain.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Region agnostic domain URL.
        """
        return pulumi.get(self, "url")

