# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PublicationArgs', 'Publication']

@pulumi.input_type
class PublicationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 is_agreement_acknowledged: pulumi.Input[bool],
                 listing_type: pulumi.Input[str],
                 package_details: pulumi.Input['PublicationPackageDetailsArgs'],
                 short_description: pulumi.Input[str],
                 support_contacts: pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Publication resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        :param pulumi.Input[bool] is_agreement_acknowledged: Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        :param pulumi.Input[str] listing_type: The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        :param pulumi.Input['PublicationPackageDetailsArgs'] package_details: A base object for creating a publication package.
        :param pulumi.Input[str] short_description: (Updatable) A short description of the publication to use in the listing.
        :param pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]] support_contacts: (Updatable) Contact information for getting support from the publisher for the listing.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] long_description: (Updatable) A long description of the publication to use in the listing.
        :param pulumi.Input[str] name: (Updatable) The name of the contact.
        """
        PublicationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            is_agreement_acknowledged=is_agreement_acknowledged,
            listing_type=listing_type,
            package_details=package_details,
            short_description=short_description,
            support_contacts=support_contacts,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            long_description=long_description,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             is_agreement_acknowledged: pulumi.Input[bool],
             listing_type: pulumi.Input[str],
             package_details: pulumi.Input['PublicationPackageDetailsArgs'],
             short_description: pulumi.Input[str],
             support_contacts: pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             long_description: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("is_agreement_acknowledged", is_agreement_acknowledged)
        _setter("listing_type", listing_type)
        _setter("package_details", package_details)
        _setter("short_description", short_description)
        _setter("support_contacts", support_contacts)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if long_description is not None:
            _setter("long_description", long_description)
        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isAgreementAcknowledged")
    def is_agreement_acknowledged(self) -> pulumi.Input[bool]:
        """
        Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        """
        return pulumi.get(self, "is_agreement_acknowledged")

    @is_agreement_acknowledged.setter
    def is_agreement_acknowledged(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_agreement_acknowledged", value)

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> pulumi.Input[str]:
        """
        The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @listing_type.setter
    def listing_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "listing_type", value)

    @property
    @pulumi.getter(name="packageDetails")
    def package_details(self) -> pulumi.Input['PublicationPackageDetailsArgs']:
        """
        A base object for creating a publication package.
        """
        return pulumi.get(self, "package_details")

    @package_details.setter
    def package_details(self, value: pulumi.Input['PublicationPackageDetailsArgs']):
        pulumi.set(self, "package_details", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Input[str]:
        """
        (Updatable) A short description of the publication to use in the listing.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter(name="supportContacts")
    def support_contacts(self) -> pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]:
        """
        (Updatable) Contact information for getting support from the publisher for the listing.
        """
        return pulumi.get(self, "support_contacts")

    @support_contacts.setter
    def support_contacts(self, value: pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]):
        pulumi.set(self, "support_contacts", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A long description of the publication to use in the listing.
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the contact.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PublicationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 icons: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationIconArgs']]]] = None,
                 is_agreement_acknowledged: Optional[pulumi.Input[bool]] = None,
                 listing_type: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_details: Optional[pulumi.Input['PublicationPackageDetailsArgs']] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 support_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]] = None,
                 supported_operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportedOperatingSystemArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Publication resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['PublicationIconArgs']]] icons: The model for upload data for images and icons.
        :param pulumi.Input[bool] is_agreement_acknowledged: Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        :param pulumi.Input[str] listing_type: The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        :param pulumi.Input[str] long_description: (Updatable) A long description of the publication to use in the listing.
        :param pulumi.Input[str] name: (Updatable) The name of the contact.
        :param pulumi.Input['PublicationPackageDetailsArgs'] package_details: A base object for creating a publication package.
        :param pulumi.Input[str] package_type: The package's type.
        :param pulumi.Input[str] short_description: (Updatable) A short description of the publication to use in the listing.
        :param pulumi.Input[str] state: The lifecycle state of the publication.
        :param pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]] support_contacts: (Updatable) Contact information for getting support from the publisher for the listing.
        :param pulumi.Input[Sequence[pulumi.Input['PublicationSupportedOperatingSystemArgs']]] supported_operating_systems: The list of operating systems supported by the listing.
        :param pulumi.Input[str] time_created: The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        _PublicationState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            icons=icons,
            is_agreement_acknowledged=is_agreement_acknowledged,
            listing_type=listing_type,
            long_description=long_description,
            name=name,
            package_details=package_details,
            package_type=package_type,
            short_description=short_description,
            state=state,
            support_contacts=support_contacts,
            supported_operating_systems=supported_operating_systems,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             icons: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationIconArgs']]]] = None,
             is_agreement_acknowledged: Optional[pulumi.Input[bool]] = None,
             listing_type: Optional[pulumi.Input[str]] = None,
             long_description: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             package_details: Optional[pulumi.Input['PublicationPackageDetailsArgs']] = None,
             package_type: Optional[pulumi.Input[str]] = None,
             short_description: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             support_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]] = None,
             supported_operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportedOperatingSystemArgs']]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if icons is not None:
            _setter("icons", icons)
        if is_agreement_acknowledged is not None:
            _setter("is_agreement_acknowledged", is_agreement_acknowledged)
        if listing_type is not None:
            _setter("listing_type", listing_type)
        if long_description is not None:
            _setter("long_description", long_description)
        if name is not None:
            _setter("name", name)
        if package_details is not None:
            _setter("package_details", package_details)
        if package_type is not None:
            _setter("package_type", package_type)
        if short_description is not None:
            _setter("short_description", short_description)
        if state is not None:
            _setter("state", state)
        if support_contacts is not None:
            _setter("support_contacts", support_contacts)
        if supported_operating_systems is not None:
            _setter("supported_operating_systems", supported_operating_systems)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def icons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PublicationIconArgs']]]]:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "icons")

    @icons.setter
    def icons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationIconArgs']]]]):
        pulumi.set(self, "icons", value)

    @property
    @pulumi.getter(name="isAgreementAcknowledged")
    def is_agreement_acknowledged(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        """
        return pulumi.get(self, "is_agreement_acknowledged")

    @is_agreement_acknowledged.setter
    def is_agreement_acknowledged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_agreement_acknowledged", value)

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @listing_type.setter
    def listing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listing_type", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A long description of the publication to use in the listing.
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the contact.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageDetails")
    def package_details(self) -> Optional[pulumi.Input['PublicationPackageDetailsArgs']]:
        """
        A base object for creating a publication package.
        """
        return pulumi.get(self, "package_details")

    @package_details.setter
    def package_details(self, value: Optional[pulumi.Input['PublicationPackageDetailsArgs']]):
        pulumi.set(self, "package_details", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The package's type.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the publication to use in the listing.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle state of the publication.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="supportContacts")
    def support_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]]:
        """
        (Updatable) Contact information for getting support from the publisher for the listing.
        """
        return pulumi.get(self, "support_contacts")

    @support_contacts.setter
    def support_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportContactArgs']]]]):
        pulumi.set(self, "support_contacts", value)

    @property
    @pulumi.getter(name="supportedOperatingSystems")
    def supported_operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportedOperatingSystemArgs']]]]:
        """
        The list of operating systems supported by the listing.
        """
        return pulumi.get(self, "supported_operating_systems")

    @supported_operating_systems.setter
    def supported_operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PublicationSupportedOperatingSystemArgs']]]]):
        pulumi.set(self, "supported_operating_systems", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class Publication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_agreement_acknowledged: Optional[pulumi.Input[bool]] = None,
                 listing_type: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_details: Optional[pulumi.Input[pulumi.InputType['PublicationPackageDetailsArgs']]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 support_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportContactArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Publication resource in Oracle Cloud Infrastructure Marketplace service.

        Creates a publication of the specified listing type with an optional default package.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_publication = oci.marketplace.Publication("testPublication",
            compartment_id=var["compartment_id"],
            is_agreement_acknowledged=var["publication_is_agreement_acknowledged"],
            listing_type=var["publication_listing_type"],
            package_details=oci.marketplace.PublicationPackageDetailsArgs(
                eulas=[oci.marketplace.PublicationPackageDetailsEulaArgs(
                    eula_type=var["publication_package_details_eula_eula_type"],
                    license_text=var["publication_package_details_eula_license_text"],
                )],
                operating_system=oci.marketplace.PublicationPackageDetailsOperatingSystemArgs(
                    name=var["publication_package_details_operating_system_name"],
                ),
                package_type=var["publication_package_details_package_type"],
                package_version=var["publication_package_details_package_version"],
                image_id=oci_core_image["test_image"]["id"],
            ),
            short_description=var["publication_short_description"],
            support_contacts=[oci.marketplace.PublicationSupportContactArgs(
                email=var["publication_support_contacts_email"],
                name=var["publication_support_contacts_name"],
                phone=var["publication_support_contacts_phone"],
                subject=var["publication_support_contacts_subject"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            long_description=var["publication_long_description"])
        ```

        ## Import

        Publications can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Marketplace/publication:Publication test_publication "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_agreement_acknowledged: Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        :param pulumi.Input[str] listing_type: The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        :param pulumi.Input[str] long_description: (Updatable) A long description of the publication to use in the listing.
        :param pulumi.Input[str] name: (Updatable) The name of the contact.
        :param pulumi.Input[pulumi.InputType['PublicationPackageDetailsArgs']] package_details: A base object for creating a publication package.
        :param pulumi.Input[str] short_description: (Updatable) A short description of the publication to use in the listing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportContactArgs']]]] support_contacts: (Updatable) Contact information for getting support from the publisher for the listing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Publication resource in Oracle Cloud Infrastructure Marketplace service.

        Creates a publication of the specified listing type with an optional default package.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_publication = oci.marketplace.Publication("testPublication",
            compartment_id=var["compartment_id"],
            is_agreement_acknowledged=var["publication_is_agreement_acknowledged"],
            listing_type=var["publication_listing_type"],
            package_details=oci.marketplace.PublicationPackageDetailsArgs(
                eulas=[oci.marketplace.PublicationPackageDetailsEulaArgs(
                    eula_type=var["publication_package_details_eula_eula_type"],
                    license_text=var["publication_package_details_eula_license_text"],
                )],
                operating_system=oci.marketplace.PublicationPackageDetailsOperatingSystemArgs(
                    name=var["publication_package_details_operating_system_name"],
                ),
                package_type=var["publication_package_details_package_type"],
                package_version=var["publication_package_details_package_version"],
                image_id=oci_core_image["test_image"]["id"],
            ),
            short_description=var["publication_short_description"],
            support_contacts=[oci.marketplace.PublicationSupportContactArgs(
                email=var["publication_support_contacts_email"],
                name=var["publication_support_contacts_name"],
                phone=var["publication_support_contacts_phone"],
                subject=var["publication_support_contacts_subject"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            long_description=var["publication_long_description"])
        ```

        ## Import

        Publications can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Marketplace/publication:Publication test_publication "id"
        ```

        :param str resource_name: The name of the resource.
        :param PublicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            PublicationArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_agreement_acknowledged: Optional[pulumi.Input[bool]] = None,
                 listing_type: Optional[pulumi.Input[str]] = None,
                 long_description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_details: Optional[pulumi.Input[pulumi.InputType['PublicationPackageDetailsArgs']]] = None,
                 short_description: Optional[pulumi.Input[str]] = None,
                 support_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportContactArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicationArgs.__new__(PublicationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_agreement_acknowledged is None and not opts.urn:
                raise TypeError("Missing required property 'is_agreement_acknowledged'")
            __props__.__dict__["is_agreement_acknowledged"] = is_agreement_acknowledged
            if listing_type is None and not opts.urn:
                raise TypeError("Missing required property 'listing_type'")
            __props__.__dict__["listing_type"] = listing_type
            __props__.__dict__["long_description"] = long_description
            __props__.__dict__["name"] = name
            if package_details is not None and not isinstance(package_details, PublicationPackageDetailsArgs):
                package_details = package_details or {}
                def _setter(key, value):
                    package_details[key] = value
                PublicationPackageDetailsArgs._configure(_setter, **package_details)
            if package_details is None and not opts.urn:
                raise TypeError("Missing required property 'package_details'")
            __props__.__dict__["package_details"] = package_details
            if short_description is None and not opts.urn:
                raise TypeError("Missing required property 'short_description'")
            __props__.__dict__["short_description"] = short_description
            if support_contacts is None and not opts.urn:
                raise TypeError("Missing required property 'support_contacts'")
            __props__.__dict__["support_contacts"] = support_contacts
            __props__.__dict__["icons"] = None
            __props__.__dict__["package_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["supported_operating_systems"] = None
            __props__.__dict__["time_created"] = None
        super(Publication, __self__).__init__(
            'oci:Marketplace/publication:Publication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            icons: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationIconArgs']]]]] = None,
            is_agreement_acknowledged: Optional[pulumi.Input[bool]] = None,
            listing_type: Optional[pulumi.Input[str]] = None,
            long_description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package_details: Optional[pulumi.Input[pulumi.InputType['PublicationPackageDetailsArgs']]] = None,
            package_type: Optional[pulumi.Input[str]] = None,
            short_description: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            support_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportContactArgs']]]]] = None,
            supported_operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportedOperatingSystemArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'Publication':
        """
        Get an existing Publication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationIconArgs']]]] icons: The model for upload data for images and icons.
        :param pulumi.Input[bool] is_agreement_acknowledged: Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        :param pulumi.Input[str] listing_type: The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        :param pulumi.Input[str] long_description: (Updatable) A long description of the publication to use in the listing.
        :param pulumi.Input[str] name: (Updatable) The name of the contact.
        :param pulumi.Input[pulumi.InputType['PublicationPackageDetailsArgs']] package_details: A base object for creating a publication package.
        :param pulumi.Input[str] package_type: The package's type.
        :param pulumi.Input[str] short_description: (Updatable) A short description of the publication to use in the listing.
        :param pulumi.Input[str] state: The lifecycle state of the publication.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportContactArgs']]]] support_contacts: (Updatable) Contact information for getting support from the publisher for the listing.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PublicationSupportedOperatingSystemArgs']]]] supported_operating_systems: The list of operating systems supported by the listing.
        :param pulumi.Input[str] time_created: The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicationState.__new__(_PublicationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["icons"] = icons
        __props__.__dict__["is_agreement_acknowledged"] = is_agreement_acknowledged
        __props__.__dict__["listing_type"] = listing_type
        __props__.__dict__["long_description"] = long_description
        __props__.__dict__["name"] = name
        __props__.__dict__["package_details"] = package_details
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["short_description"] = short_description
        __props__.__dict__["state"] = state
        __props__.__dict__["support_contacts"] = support_contacts
        __props__.__dict__["supported_operating_systems"] = supported_operating_systems
        __props__.__dict__["time_created"] = time_created
        return Publication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the publication.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def icons(self) -> pulumi.Output[Sequence['outputs.PublicationIcon']]:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "icons")

    @property
    @pulumi.getter(name="isAgreementAcknowledged")
    def is_agreement_acknowledged(self) -> pulumi.Output[bool]:
        """
        Whether the publisher acknowledged that they have the right and authority to share the contents of the publication and that they accepted the Oracle terms of use agreements required to create a publication.
        """
        return pulumi.get(self, "is_agreement_acknowledged")

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> pulumi.Output[str]:
        """
        The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> pulumi.Output[str]:
        """
        (Updatable) A long description of the publication to use in the listing.
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the contact.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageDetails")
    def package_details(self) -> pulumi.Output['outputs.PublicationPackageDetails']:
        """
        A base object for creating a publication package.
        """
        return pulumi.get(self, "package_details")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[str]:
        """
        The package's type.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the publication to use in the listing.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The lifecycle state of the publication.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportContacts")
    def support_contacts(self) -> pulumi.Output[Sequence['outputs.PublicationSupportContact']]:
        """
        (Updatable) Contact information for getting support from the publisher for the listing.
        """
        return pulumi.get(self, "support_contacts")

    @property
    @pulumi.getter(name="supportedOperatingSystems")
    def supported_operating_systems(self) -> pulumi.Output[Sequence['outputs.PublicationSupportedOperatingSystem']]:
        """
        The list of operating systems supported by the listing.
        """
        return pulumi.get(self, "supported_operating_systems")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the publication was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

