# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyArgs', 'NetworkFirewallPolicy']

@pulumi.input_type
class NetworkFirewallPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 application_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]] = None,
                 decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]] = None,
                 decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]] = None,
                 mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]] = None,
                 url_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicy resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]] application_lists: (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]] decryption_profiles: (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]] decryption_rules: (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]] ip_address_lists: (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]] mapped_secrets: (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]] security_rules: (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]] url_lists: (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        NetworkFirewallPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            application_lists=application_lists,
            decryption_profiles=decryption_profiles,
            decryption_rules=decryption_rules,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            ip_address_lists=ip_address_lists,
            mapped_secrets=mapped_secrets,
            security_rules=security_rules,
            url_lists=url_lists,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             application_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]] = None,
             decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]] = None,
             decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]] = None,
             mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]] = None,
             security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]] = None,
             url_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        if application_lists is not None:
            _setter("application_lists", application_lists)
        if decryption_profiles is not None:
            _setter("decryption_profiles", decryption_profiles)
        if decryption_rules is not None:
            _setter("decryption_rules", decryption_rules)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if ip_address_lists is not None:
            _setter("ip_address_lists", ip_address_lists)
        if mapped_secrets is not None:
            _setter("mapped_secrets", mapped_secrets)
        if security_rules is not None:
            _setter("security_rules", security_rules)
        if url_lists is not None:
            _setter("url_lists", url_lists)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="applicationLists")
    def application_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]]:
        """
        (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        """
        return pulumi.get(self, "application_lists")

    @application_lists.setter
    def application_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]]):
        pulumi.set(self, "application_lists", value)

    @property
    @pulumi.getter(name="decryptionProfiles")
    def decryption_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]]:
        """
        (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        """
        return pulumi.get(self, "decryption_profiles")

    @decryption_profiles.setter
    def decryption_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]]):
        pulumi.set(self, "decryption_profiles", value)

    @property
    @pulumi.getter(name="decryptionRules")
    def decryption_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]]:
        """
        (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "decryption_rules")

    @decryption_rules.setter
    def decryption_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]]):
        pulumi.set(self, "decryption_rules", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipAddressLists")
    def ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]]:
        """
        (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        """
        return pulumi.get(self, "ip_address_lists")

    @ip_address_lists.setter
    def ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]]):
        pulumi.set(self, "ip_address_lists", value)

    @property
    @pulumi.getter(name="mappedSecrets")
    def mapped_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]]:
        """
        (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        """
        return pulumi.get(self, "mapped_secrets")

    @mapped_secrets.setter
    def mapped_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]]):
        pulumi.set(self, "mapped_secrets", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]]:
        """
        (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @property
    @pulumi.getter(name="urlLists")
    def url_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]]:
        """
        (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        return pulumi.get(self, "url_lists")

    @url_lists.setter
    def url_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]]):
        pulumi.set(self, "url_lists", value)


@pulumi.input_type
class _NetworkFirewallPolicyState:
    def __init__(__self__, *,
                 application_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]] = None,
                 decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]] = None,
                 is_firewall_attached: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 url_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]] application_lists: (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]] decryption_profiles: (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]] decryption_rules: (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]] ip_address_lists: (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        :param pulumi.Input[bool] is_firewall_attached: To determine if any Network Firewall is associated with this Network Firewall Policy.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]] mapped_secrets: (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]] security_rules: (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[str] state: The current state of the Network Firewall Policy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]] url_lists: (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        _NetworkFirewallPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            application_lists=application_lists,
            compartment_id=compartment_id,
            decryption_profiles=decryption_profiles,
            decryption_rules=decryption_rules,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            ip_address_lists=ip_address_lists,
            is_firewall_attached=is_firewall_attached,
            lifecycle_details=lifecycle_details,
            mapped_secrets=mapped_secrets,
            security_rules=security_rules,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            url_lists=url_lists,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             application_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]] = None,
             decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]] = None,
             is_firewall_attached: Optional[pulumi.Input[bool]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]] = None,
             security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             url_lists: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if application_lists is not None:
            _setter("application_lists", application_lists)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if decryption_profiles is not None:
            _setter("decryption_profiles", decryption_profiles)
        if decryption_rules is not None:
            _setter("decryption_rules", decryption_rules)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if ip_address_lists is not None:
            _setter("ip_address_lists", ip_address_lists)
        if is_firewall_attached is not None:
            _setter("is_firewall_attached", is_firewall_attached)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if mapped_secrets is not None:
            _setter("mapped_secrets", mapped_secrets)
        if security_rules is not None:
            _setter("security_rules", security_rules)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if url_lists is not None:
            _setter("url_lists", url_lists)

    @property
    @pulumi.getter(name="applicationLists")
    def application_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]]:
        """
        (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        """
        return pulumi.get(self, "application_lists")

    @application_lists.setter
    def application_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyApplicationListArgs']]]]):
        pulumi.set(self, "application_lists", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="decryptionProfiles")
    def decryption_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]]:
        """
        (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        """
        return pulumi.get(self, "decryption_profiles")

    @decryption_profiles.setter
    def decryption_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionProfileArgs']]]]):
        pulumi.set(self, "decryption_profiles", value)

    @property
    @pulumi.getter(name="decryptionRules")
    def decryption_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]]:
        """
        (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "decryption_rules")

    @decryption_rules.setter
    def decryption_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyDecryptionRuleArgs']]]]):
        pulumi.set(self, "decryption_rules", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipAddressLists")
    def ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]]:
        """
        (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        """
        return pulumi.get(self, "ip_address_lists")

    @ip_address_lists.setter
    def ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyIpAddressListArgs']]]]):
        pulumi.set(self, "ip_address_lists", value)

    @property
    @pulumi.getter(name="isFirewallAttached")
    def is_firewall_attached(self) -> Optional[pulumi.Input[bool]]:
        """
        To determine if any Network Firewall is associated with this Network Firewall Policy.
        """
        return pulumi.get(self, "is_firewall_attached")

    @is_firewall_attached.setter
    def is_firewall_attached(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_firewall_attached", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="mappedSecrets")
    def mapped_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]]:
        """
        (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        """
        return pulumi.get(self, "mapped_secrets")

    @mapped_secrets.setter
    def mapped_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyMappedSecretArgs']]]]):
        pulumi.set(self, "mapped_secrets", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]]:
        """
        (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicySecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Network Firewall Policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="urlLists")
    def url_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]]:
        """
        (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        return pulumi.get(self, "url_lists")

    @url_lists.setter
    def url_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFirewallPolicyUrlListArgs']]]]):
        pulumi.set(self, "url_lists", value)


class NetworkFirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyApplicationListArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionProfileArgs']]]]] = None,
                 decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionRuleArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyIpAddressListArgs']]]]] = None,
                 mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyMappedSecretArgs']]]]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicySecurityRuleArgs']]]]] = None,
                 url_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Network Firewall Policy.

        ## Import

        NetworkFirewallPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:NetworkFirewall/networkFirewallPolicy:NetworkFirewallPolicy test_network_firewall_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyApplicationListArgs']]]] application_lists: (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionProfileArgs']]]] decryption_profiles: (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionRuleArgs']]]] decryption_rules: (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyIpAddressListArgs']]]] ip_address_lists: (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyMappedSecretArgs']]]] mapped_secrets: (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicySecurityRuleArgs']]]] security_rules: (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListArgs']]]] url_lists: (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Network Firewall Policy.

        ## Import

        NetworkFirewallPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:NetworkFirewall/networkFirewallPolicy:NetworkFirewallPolicy test_network_firewall_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            NetworkFirewallPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyApplicationListArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionProfileArgs']]]]] = None,
                 decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionRuleArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyIpAddressListArgs']]]]] = None,
                 mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyMappedSecretArgs']]]]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicySecurityRuleArgs']]]]] = None,
                 url_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyArgs.__new__(NetworkFirewallPolicyArgs)

            __props__.__dict__["application_lists"] = application_lists
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["decryption_profiles"] = decryption_profiles
            __props__.__dict__["decryption_rules"] = decryption_rules
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ip_address_lists"] = ip_address_lists
            __props__.__dict__["mapped_secrets"] = mapped_secrets
            __props__.__dict__["security_rules"] = security_rules
            __props__.__dict__["url_lists"] = url_lists
            __props__.__dict__["is_firewall_attached"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NetworkFirewallPolicy, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicy:NetworkFirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyApplicationListArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            decryption_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionProfileArgs']]]]] = None,
            decryption_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionRuleArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyIpAddressListArgs']]]]] = None,
            is_firewall_attached: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            mapped_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyMappedSecretArgs']]]]] = None,
            security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicySecurityRuleArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            url_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListArgs']]]]] = None) -> 'NetworkFirewallPolicy':
        """
        Get an existing NetworkFirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyApplicationListArgs']]]] application_lists: (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionProfileArgs']]]] decryption_profiles: (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyDecryptionRuleArgs']]]] decryption_rules: (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyIpAddressListArgs']]]] ip_address_lists: (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        :param pulumi.Input[bool] is_firewall_attached: To determine if any Network Firewall is associated with this Network Firewall Policy.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyMappedSecretArgs']]]] mapped_secrets: (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicySecurityRuleArgs']]]] security_rules: (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        :param pulumi.Input[str] state: The current state of the Network Firewall Policy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkFirewallPolicyUrlListArgs']]]] url_lists: (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyState.__new__(_NetworkFirewallPolicyState)

        __props__.__dict__["application_lists"] = application_lists
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["decryption_profiles"] = decryption_profiles
        __props__.__dict__["decryption_rules"] = decryption_rules
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ip_address_lists"] = ip_address_lists
        __props__.__dict__["is_firewall_attached"] = is_firewall_attached
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["mapped_secrets"] = mapped_secrets
        __props__.__dict__["security_rules"] = security_rules
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["url_lists"] = url_lists
        return NetworkFirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationLists")
    def application_lists(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyApplicationList']]:
        """
        (Updatable) Lists of the application of the policy. The value of an entry is a list of "applications", each consisting of a protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range). The associated key is the identifier by which the application list is referenced.
        """
        return pulumi.get(self, "application_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the NetworkFirewall Policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="decryptionProfiles")
    def decryption_profiles(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyDecryptionProfile']]:
        """
        (Updatable) Map defining decryption profiles of the policy. The value of an entry is a decryption profile. The associated key is the identifier by which the decryption profile is referenced.
        """
        return pulumi.get(self, "decryption_profiles")

    @property
    @pulumi.getter(name="decryptionRules")
    def decryption_rules(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyDecryptionRule']]:
        """
        (Updatable) List of Decryption Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "decryption_rules")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly optional name for the firewall policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ipAddressLists")
    def ip_address_lists(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyIpAddressList']]:
        """
        (Updatable) List of IP address lists of the policy. The value of an entry is a list of IP addresses or prefixes in CIDR notation. The associated key is the identifier by which the IP address list is referenced.
        """
        return pulumi.get(self, "ip_address_lists")

    @property
    @pulumi.getter(name="isFirewallAttached")
    def is_firewall_attached(self) -> pulumi.Output[bool]:
        """
        To determine if any Network Firewall is associated with this Network Firewall Policy.
        """
        return pulumi.get(self, "is_firewall_attached")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="mappedSecrets")
    def mapped_secrets(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyMappedSecret']]:
        """
        (Updatable) Map defining secrets of the policy. The value of an entry is a "mapped secret" consisting of a purpose and source. The associated key is the identifier by which the mapped secret is referenced.
        """
        return pulumi.get(self, "mapped_secrets")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicySecurityRule']]:
        """
        (Updatable) List of Security Rules defining the behavior of the policy. The first rule with a matching condition determines the action taken upon network traffic.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Network Firewall Policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time instant at which the Network Firewall Policy was created in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time instant at which the Network Firewall Policy was updated in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="urlLists")
    def url_lists(self) -> pulumi.Output[Sequence['outputs.NetworkFirewallPolicyUrlList']]:
        """
        (Updatable) Map defining URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key is the identifier by which the URL pattern list is referenced.
        """
        return pulumi.get(self, "url_lists")

