# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SddcDatastore',
    'SddcHcxOnPremLicense',
    'SddcUpgradeLicense',
    'SddcVsphereUpgradeObject',
    'GetExsiHostsEsxiHostCollectionResult',
    'GetExsiHostsFilterResult',
    'GetSddcDatastoreResult',
    'GetSddcHcxOnPremLicenseResult',
    'GetSddcUpgradeLicenseResult',
    'GetSddcVsphereUpgradeObjectResult',
    'GetSddcsFilterResult',
    'GetSddcsSddcCollectionResult',
    'GetSddcsSddcCollectionDatastoreResult',
    'GetSddcsSddcCollectionHcxOnPremLicenseResult',
    'GetSddcsSddcCollectionUpgradeLicenseResult',
    'GetSddcsSddcCollectionVsphereUpgradeObjectResult',
    'GetSupportedHostShapesFilterResult',
    'GetSupportedHostShapesItemResult',
    'GetSupportedSkusFilterResult',
    'GetSupportedSkusItemResult',
    'GetSupportedVmwareSoftwareVersionsFilterResult',
    'GetSupportedVmwareSoftwareVersionsItemResult',
]

@pulumi.output_type
class SddcDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockVolumeIds":
            suggest = "block_volume_ids"
        elif key == "datastoreType":
            suggest = "datastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_volume_ids: Sequence[str],
                 datastore_type: str,
                 capacity: Optional[float] = None):
        """
        :param Sequence[str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param str datastore_type: Type of the datastore.
        :param float capacity: Size of the Block Storage Volume in GB.
        """
        SddcDatastore._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            block_volume_ids=block_volume_ids,
            datastore_type=datastore_type,
            capacity=capacity,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             block_volume_ids: Sequence[str],
             datastore_type: str,
             capacity: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("block_volume_ids", block_volume_ids)
        _setter("datastore_type", datastore_type)
        if capacity is not None:
            _setter("capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class SddcHcxOnPremLicense(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationKey":
            suggest = "activation_key"
        elif key == "systemName":
            suggest = "system_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcHcxOnPremLicense. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcHcxOnPremLicense.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcHcxOnPremLicense.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_key: Optional[str] = None,
                 status: Optional[str] = None,
                 system_name: Optional[str] = None):
        """
        :param str activation_key: HCX on-premise license key value.
        :param str status: status of HCX on-premise license.
        :param str system_name: Name of the system that consumed the HCX on-premise license
        """
        SddcHcxOnPremLicense._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            activation_key=activation_key,
            status=status,
            system_name=system_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             activation_key: Optional[str] = None,
             status: Optional[str] = None,
             system_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if activation_key is not None:
            _setter("activation_key", activation_key)
        if status is not None:
            _setter("status", status)
        if system_name is not None:
            _setter("system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[str]:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> Optional[str]:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class SddcUpgradeLicense(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "licenseKey":
            suggest = "license_key"
        elif key == "licenseType":
            suggest = "license_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcUpgradeLicense. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcUpgradeLicense.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcUpgradeLicense.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 license_key: Optional[str] = None,
                 license_type: Optional[str] = None):
        """
        :param str license_key: vSphere license key value.
        :param str license_type: vSphere license type.
        """
        SddcUpgradeLicense._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            license_key=license_key,
            license_type=license_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             license_key: Optional[str] = None,
             license_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if license_key is not None:
            _setter("license_key", license_key)
        if license_type is not None:
            _setter("license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[str]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class SddcVsphereUpgradeObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadLink":
            suggest = "download_link"
        elif key == "linkDescription":
            suggest = "link_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SddcVsphereUpgradeObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SddcVsphereUpgradeObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SddcVsphereUpgradeObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_link: Optional[str] = None,
                 link_description: Optional[str] = None):
        """
        :param str download_link: Binary object download link.
        :param str link_description: Binary object description.
        """
        SddcVsphereUpgradeObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            download_link=download_link,
            link_description=link_description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             download_link: Optional[str] = None,
             link_description: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if download_link is not None:
            _setter("download_link", download_link)
        if link_description is not None:
            _setter("link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[str]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[str]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetExsiHostsEsxiHostCollectionResult(dict):
    def __init__(__self__, *,
                 billing_contract_end_date: str,
                 billing_donor_host_id: str,
                 capacity_reservation_id: str,
                 compartment_id: str,
                 compute_availability_domain: str,
                 compute_instance_id: str,
                 current_sku: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 failed_esxi_host_id: str,
                 freeform_tags: Mapping[str, Any],
                 grace_period_end_date: str,
                 host_ocpu_count: float,
                 host_shape_name: str,
                 id: str,
                 is_billing_continuation_in_progress: bool,
                 is_billing_swapping_in_progress: bool,
                 next_sku: str,
                 non_upgraded_esxi_host_id: str,
                 replacement_esxi_host_id: str,
                 sddc_id: str,
                 state: str,
                 swap_billing_host_id: str,
                 time_created: str,
                 time_updated: str,
                 upgraded_replacement_esxi_host_id: str,
                 vmware_software_version: str):
        """
        :param str billing_contract_end_date: Current billing cycle end date. If the value in `currentSku` and `nextSku` are different, the value specified in `nextSku` becomes the new `currentSKU` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        :param str billing_donor_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        :param str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        :param str compute_availability_domain: The availability domain of the ESXi host.
        :param str compute_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute instance.
        :param str current_sku: The billing option currently used by the ESXi host. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param str failed_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that failed.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str grace_period_end_date: The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        :param float host_ocpu_count: The OCPU count of the ESXi host.
        :param str host_shape_name: The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
        :param bool is_billing_continuation_in_progress: Indicates whether this host is in the progress of billing continuation.
        :param bool is_billing_swapping_in_progress: Indicates whether this host is in the progress of swapping billing.
        :param str next_sku: The billing option to switch to after the current billing cycle ends. If `nextSku` is null or empty, `currentSku` continues to the next billing cycle. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param str non_upgraded_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded.
        :param str replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        :param str sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        :param str state: The lifecycle state of the resource.
        :param str swap_billing_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        :param str time_created: The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str upgraded_replacement_esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        :param str vmware_software_version: The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        GetExsiHostsEsxiHostCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            billing_contract_end_date=billing_contract_end_date,
            billing_donor_host_id=billing_donor_host_id,
            capacity_reservation_id=capacity_reservation_id,
            compartment_id=compartment_id,
            compute_availability_domain=compute_availability_domain,
            compute_instance_id=compute_instance_id,
            current_sku=current_sku,
            defined_tags=defined_tags,
            display_name=display_name,
            failed_esxi_host_id=failed_esxi_host_id,
            freeform_tags=freeform_tags,
            grace_period_end_date=grace_period_end_date,
            host_ocpu_count=host_ocpu_count,
            host_shape_name=host_shape_name,
            id=id,
            is_billing_continuation_in_progress=is_billing_continuation_in_progress,
            is_billing_swapping_in_progress=is_billing_swapping_in_progress,
            next_sku=next_sku,
            non_upgraded_esxi_host_id=non_upgraded_esxi_host_id,
            replacement_esxi_host_id=replacement_esxi_host_id,
            sddc_id=sddc_id,
            state=state,
            swap_billing_host_id=swap_billing_host_id,
            time_created=time_created,
            time_updated=time_updated,
            upgraded_replacement_esxi_host_id=upgraded_replacement_esxi_host_id,
            vmware_software_version=vmware_software_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             billing_contract_end_date: str,
             billing_donor_host_id: str,
             capacity_reservation_id: str,
             compartment_id: str,
             compute_availability_domain: str,
             compute_instance_id: str,
             current_sku: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             failed_esxi_host_id: str,
             freeform_tags: Mapping[str, Any],
             grace_period_end_date: str,
             host_ocpu_count: float,
             host_shape_name: str,
             id: str,
             is_billing_continuation_in_progress: bool,
             is_billing_swapping_in_progress: bool,
             next_sku: str,
             non_upgraded_esxi_host_id: str,
             replacement_esxi_host_id: str,
             sddc_id: str,
             state: str,
             swap_billing_host_id: str,
             time_created: str,
             time_updated: str,
             upgraded_replacement_esxi_host_id: str,
             vmware_software_version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("billing_contract_end_date", billing_contract_end_date)
        _setter("billing_donor_host_id", billing_donor_host_id)
        _setter("capacity_reservation_id", capacity_reservation_id)
        _setter("compartment_id", compartment_id)
        _setter("compute_availability_domain", compute_availability_domain)
        _setter("compute_instance_id", compute_instance_id)
        _setter("current_sku", current_sku)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("failed_esxi_host_id", failed_esxi_host_id)
        _setter("freeform_tags", freeform_tags)
        _setter("grace_period_end_date", grace_period_end_date)
        _setter("host_ocpu_count", host_ocpu_count)
        _setter("host_shape_name", host_shape_name)
        _setter("id", id)
        _setter("is_billing_continuation_in_progress", is_billing_continuation_in_progress)
        _setter("is_billing_swapping_in_progress", is_billing_swapping_in_progress)
        _setter("next_sku", next_sku)
        _setter("non_upgraded_esxi_host_id", non_upgraded_esxi_host_id)
        _setter("replacement_esxi_host_id", replacement_esxi_host_id)
        _setter("sddc_id", sddc_id)
        _setter("state", state)
        _setter("swap_billing_host_id", swap_billing_host_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("upgraded_replacement_esxi_host_id", upgraded_replacement_esxi_host_id)
        _setter("vmware_software_version", vmware_software_version)

    @property
    @pulumi.getter(name="billingContractEndDate")
    def billing_contract_end_date(self) -> str:
        """
        Current billing cycle end date. If the value in `currentSku` and `nextSku` are different, the value specified in `nextSku` becomes the new `currentSKU` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "billing_contract_end_date")

    @property
    @pulumi.getter(name="billingDonorHostId")
    def billing_donor_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        return pulumi.get(self, "billing_donor_host_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment as optional parameter.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> str:
        """
        The availability domain of the ESXi host.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute instance.
        """
        return pulumi.get(self, "compute_instance_id")

    @property
    @pulumi.getter(name="currentSku")
    def current_sku(self) -> str:
        """
        The billing option currently used by the ESXi host. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "current_sku")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="failedEsxiHostId")
    def failed_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that failed.
        """
        return pulumi.get(self, "failed_esxi_host_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracePeriodEndDate")
    def grace_period_end_date(self) -> str:
        """
        The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "grace_period_end_date")

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> float:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> str:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBillingContinuationInProgress")
    def is_billing_continuation_in_progress(self) -> bool:
        """
        Indicates whether this host is in the progress of billing continuation.
        """
        return pulumi.get(self, "is_billing_continuation_in_progress")

    @property
    @pulumi.getter(name="isBillingSwappingInProgress")
    def is_billing_swapping_in_progress(self) -> bool:
        """
        Indicates whether this host is in the progress of swapping billing.
        """
        return pulumi.get(self, "is_billing_swapping_in_progress")

    @property
    @pulumi.getter(name="nextSku")
    def next_sku(self) -> str:
        """
        The billing option to switch to after the current billing cycle ends. If `nextSku` is null or empty, `currentSku` continues to the next billing cycle. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "next_sku")

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    def non_upgraded_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded.
        """
        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @property
    @pulumi.getter(name="replacementEsxiHostId")
    def replacement_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        """
        return pulumi.get(self, "replacement_esxi_host_id")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swapBillingHostId")
    def swap_billing_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        """
        return pulumi.get(self, "swap_billing_host_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradedReplacementEsxiHostId")
    def upgraded_replacement_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        """
        return pulumi.get(self, "upgraded_replacement_esxi_host_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> str:
        """
        The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "vmware_software_version")


@pulumi.output_type
class GetExsiHostsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetExsiHostsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSddcDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[str],
                 capacity: float,
                 datastore_type: str):
        """
        :param Sequence[str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param float capacity: Size of the Block Storage Volume in GB.
        :param str datastore_type: Type of the datastore.
        """
        GetSddcDatastoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            block_volume_ids=block_volume_ids,
            capacity=capacity,
            datastore_type=datastore_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             block_volume_ids: Sequence[str],
             capacity: float,
             datastore_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("block_volume_ids", block_volume_ids)
        _setter("capacity", capacity)
        _setter("datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> float:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcHcxOnPremLicenseResult(dict):
    def __init__(__self__, *,
                 activation_key: str,
                 status: str,
                 system_name: str):
        """
        :param str activation_key: HCX on-premise license key value.
        :param str status: status of HCX on-premise license.
        :param str system_name: Name of the system that consumed the HCX on-premise license
        """
        GetSddcHcxOnPremLicenseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            activation_key=activation_key,
            status=status,
            system_name=system_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             activation_key: str,
             status: str,
             system_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("activation_key", activation_key)
        _setter("status", status)
        _setter("system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> str:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class GetSddcUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: str,
                 license_type: str):
        """
        :param str license_key: vSphere license key value.
        :param str license_type: vSphere license type.
        """
        GetSddcUpgradeLicenseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            license_key=license_key,
            license_type=license_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             license_key: str,
             license_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("license_key", license_key)
        _setter("license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> str:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetSddcVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: str,
                 link_description: str):
        """
        :param str download_link: Binary object download link.
        :param str link_description: Binary object description.
        """
        GetSddcVsphereUpgradeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            download_link=download_link,
            link_description=link_description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             download_link: str,
             link_description: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("download_link", download_link)
        _setter("link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> str:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> str:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetSddcsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSddcsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSddcsSddcCollectionResult(dict):
    def __init__(__self__, *,
                 actual_esxi_hosts_count: int,
                 capacity_reservation_id: str,
                 compartment_id: str,
                 compute_availability_domain: str,
                 datastores: Sequence['outputs.GetSddcsSddcCollectionDatastoreResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 esxi_hosts_count: int,
                 freeform_tags: Mapping[str, Any],
                 hcx_action: str,
                 hcx_fqdn: str,
                 hcx_initial_password: str,
                 hcx_on_prem_key: str,
                 hcx_on_prem_licenses: Sequence['outputs.GetSddcsSddcCollectionHcxOnPremLicenseResult'],
                 hcx_private_ip_id: str,
                 hcx_vlan_id: str,
                 id: str,
                 initial_host_ocpu_count: float,
                 initial_host_shape_name: str,
                 initial_sku: str,
                 instance_display_name_prefix: str,
                 is_hcx_enabled: bool,
                 is_hcx_enterprise_enabled: bool,
                 is_hcx_pending_downgrade: bool,
                 is_shielded_instance_enabled: bool,
                 is_single_host_sddc: bool,
                 nsx_edge_uplink1vlan_id: str,
                 nsx_edge_uplink2vlan_id: str,
                 nsx_edge_uplink_ip_id: str,
                 nsx_edge_vtep_vlan_id: str,
                 nsx_manager_fqdn: str,
                 nsx_manager_initial_password: str,
                 nsx_manager_private_ip_id: str,
                 nsx_manager_username: str,
                 nsx_overlay_segment_name: str,
                 nsx_vtep_vlan_id: str,
                 provisioning_subnet_id: str,
                 provisioning_vlan_id: str,
                 refresh_hcx_license_status: bool,
                 replication_vlan_id: str,
                 reserving_hcx_on_premise_license_keys: Sequence[str],
                 ssh_authorized_keys: str,
                 state: str,
                 time_created: str,
                 time_hcx_billing_cycle_end: str,
                 time_hcx_license_status_updated: str,
                 time_updated: str,
                 upgrade_licenses: Sequence['outputs.GetSddcsSddcCollectionUpgradeLicenseResult'],
                 vcenter_fqdn: str,
                 vcenter_initial_password: str,
                 vcenter_private_ip_id: str,
                 vcenter_username: str,
                 vmotion_vlan_id: str,
                 vmware_software_version: str,
                 vsan_vlan_id: str,
                 vsphere_upgrade_guide: str,
                 vsphere_upgrade_objects: Sequence['outputs.GetSddcsSddcCollectionVsphereUpgradeObjectResult'],
                 vsphere_vlan_id: str,
                 workload_network_cidr: str):
        """
        :param int actual_esxi_hosts_count: The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        :param str capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param str compute_availability_domain: The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        :param Sequence['GetSddcsSddcCollectionDatastoreArgs'] datastores: Datastores used for the Sddc.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param int esxi_hosts_count: The number of ESXi hosts in the SDDC.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str hcx_fqdn: The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param str hcx_initial_password: The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        :param str hcx_on_prem_key: The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        :param Sequence['GetSddcsSddcCollectionHcxOnPremLicenseArgs'] hcx_on_prem_licenses: The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        :param str hcx_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param str hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        :param float initial_host_ocpu_count: The initial OCPU count of the SDDC's ESXi hosts.
        :param str initial_host_shape_name: The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param str initial_sku: The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param str instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
        :param bool is_hcx_enabled: Indicates whether HCX is enabled for this SDDC.
        :param bool is_hcx_enterprise_enabled: Indicates whether HCX Enterprise is enabled for this SDDC.
        :param bool is_hcx_pending_downgrade: Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        :param bool is_shielded_instance_enabled: Indicates whether shielded instance is enabled at the SDDC level.
        :param bool is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param str nsx_edge_uplink1vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment.
        :param str nsx_edge_uplink2vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 2 component of the VMware environment.
        :param str nsx_edge_uplink_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        :param str nsx_edge_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge VTEP component of the VMware environment.
        :param str nsx_manager_fqdn: The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param str nsx_manager_initial_password: The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        :param str nsx_manager_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param str nsx_manager_username: The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        :param str nsx_overlay_segment_name: The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        :param str nsx_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX VTEP component of the VMware environment.
        :param str provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the SDDC.
        :param str provisioning_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        :param str replication_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        :param str ssh_authorized_keys: One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file.
        :param str state: The lifecycle state of the resource.
        :param str time_created: The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param str time_hcx_billing_cycle_end: The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param str time_hcx_license_status_updated: The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param Sequence['GetSddcsSddcCollectionUpgradeLicenseArgs'] upgrade_licenses: The vSphere licenses to use when upgrading the SDDC.
        :param str vcenter_fqdn: The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param str vcenter_initial_password: The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        :param str vcenter_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        :param str vcenter_username: The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        :param str vmotion_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vMotion component of the VMware environment.
        :param str vmware_software_version: In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        :param str vsan_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSAN component of the VMware environment.
        :param str vsphere_upgrade_guide: The link to guidance for upgrading vSphere.
        :param Sequence['GetSddcsSddcCollectionVsphereUpgradeObjectArgs'] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param str vsphere_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment.
        :param str workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads.
        """
        GetSddcsSddcCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actual_esxi_hosts_count=actual_esxi_hosts_count,
            capacity_reservation_id=capacity_reservation_id,
            compartment_id=compartment_id,
            compute_availability_domain=compute_availability_domain,
            datastores=datastores,
            defined_tags=defined_tags,
            display_name=display_name,
            esxi_hosts_count=esxi_hosts_count,
            freeform_tags=freeform_tags,
            hcx_action=hcx_action,
            hcx_fqdn=hcx_fqdn,
            hcx_initial_password=hcx_initial_password,
            hcx_on_prem_key=hcx_on_prem_key,
            hcx_on_prem_licenses=hcx_on_prem_licenses,
            hcx_private_ip_id=hcx_private_ip_id,
            hcx_vlan_id=hcx_vlan_id,
            id=id,
            initial_host_ocpu_count=initial_host_ocpu_count,
            initial_host_shape_name=initial_host_shape_name,
            initial_sku=initial_sku,
            instance_display_name_prefix=instance_display_name_prefix,
            is_hcx_enabled=is_hcx_enabled,
            is_hcx_enterprise_enabled=is_hcx_enterprise_enabled,
            is_hcx_pending_downgrade=is_hcx_pending_downgrade,
            is_shielded_instance_enabled=is_shielded_instance_enabled,
            is_single_host_sddc=is_single_host_sddc,
            nsx_edge_uplink1vlan_id=nsx_edge_uplink1vlan_id,
            nsx_edge_uplink2vlan_id=nsx_edge_uplink2vlan_id,
            nsx_edge_uplink_ip_id=nsx_edge_uplink_ip_id,
            nsx_edge_vtep_vlan_id=nsx_edge_vtep_vlan_id,
            nsx_manager_fqdn=nsx_manager_fqdn,
            nsx_manager_initial_password=nsx_manager_initial_password,
            nsx_manager_private_ip_id=nsx_manager_private_ip_id,
            nsx_manager_username=nsx_manager_username,
            nsx_overlay_segment_name=nsx_overlay_segment_name,
            nsx_vtep_vlan_id=nsx_vtep_vlan_id,
            provisioning_subnet_id=provisioning_subnet_id,
            provisioning_vlan_id=provisioning_vlan_id,
            refresh_hcx_license_status=refresh_hcx_license_status,
            replication_vlan_id=replication_vlan_id,
            reserving_hcx_on_premise_license_keys=reserving_hcx_on_premise_license_keys,
            ssh_authorized_keys=ssh_authorized_keys,
            state=state,
            time_created=time_created,
            time_hcx_billing_cycle_end=time_hcx_billing_cycle_end,
            time_hcx_license_status_updated=time_hcx_license_status_updated,
            time_updated=time_updated,
            upgrade_licenses=upgrade_licenses,
            vcenter_fqdn=vcenter_fqdn,
            vcenter_initial_password=vcenter_initial_password,
            vcenter_private_ip_id=vcenter_private_ip_id,
            vcenter_username=vcenter_username,
            vmotion_vlan_id=vmotion_vlan_id,
            vmware_software_version=vmware_software_version,
            vsan_vlan_id=vsan_vlan_id,
            vsphere_upgrade_guide=vsphere_upgrade_guide,
            vsphere_upgrade_objects=vsphere_upgrade_objects,
            vsphere_vlan_id=vsphere_vlan_id,
            workload_network_cidr=workload_network_cidr,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actual_esxi_hosts_count: int,
             capacity_reservation_id: str,
             compartment_id: str,
             compute_availability_domain: str,
             datastores: Sequence['outputs.GetSddcsSddcCollectionDatastoreResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             esxi_hosts_count: int,
             freeform_tags: Mapping[str, Any],
             hcx_action: str,
             hcx_fqdn: str,
             hcx_initial_password: str,
             hcx_on_prem_key: str,
             hcx_on_prem_licenses: Sequence['outputs.GetSddcsSddcCollectionHcxOnPremLicenseResult'],
             hcx_private_ip_id: str,
             hcx_vlan_id: str,
             id: str,
             initial_host_ocpu_count: float,
             initial_host_shape_name: str,
             initial_sku: str,
             instance_display_name_prefix: str,
             is_hcx_enabled: bool,
             is_hcx_enterprise_enabled: bool,
             is_hcx_pending_downgrade: bool,
             is_shielded_instance_enabled: bool,
             is_single_host_sddc: bool,
             nsx_edge_uplink1vlan_id: str,
             nsx_edge_uplink2vlan_id: str,
             nsx_edge_uplink_ip_id: str,
             nsx_edge_vtep_vlan_id: str,
             nsx_manager_fqdn: str,
             nsx_manager_initial_password: str,
             nsx_manager_private_ip_id: str,
             nsx_manager_username: str,
             nsx_overlay_segment_name: str,
             nsx_vtep_vlan_id: str,
             provisioning_subnet_id: str,
             provisioning_vlan_id: str,
             refresh_hcx_license_status: bool,
             replication_vlan_id: str,
             reserving_hcx_on_premise_license_keys: Sequence[str],
             ssh_authorized_keys: str,
             state: str,
             time_created: str,
             time_hcx_billing_cycle_end: str,
             time_hcx_license_status_updated: str,
             time_updated: str,
             upgrade_licenses: Sequence['outputs.GetSddcsSddcCollectionUpgradeLicenseResult'],
             vcenter_fqdn: str,
             vcenter_initial_password: str,
             vcenter_private_ip_id: str,
             vcenter_username: str,
             vmotion_vlan_id: str,
             vmware_software_version: str,
             vsan_vlan_id: str,
             vsphere_upgrade_guide: str,
             vsphere_upgrade_objects: Sequence['outputs.GetSddcsSddcCollectionVsphereUpgradeObjectResult'],
             vsphere_vlan_id: str,
             workload_network_cidr: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("actual_esxi_hosts_count", actual_esxi_hosts_count)
        _setter("capacity_reservation_id", capacity_reservation_id)
        _setter("compartment_id", compartment_id)
        _setter("compute_availability_domain", compute_availability_domain)
        _setter("datastores", datastores)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("esxi_hosts_count", esxi_hosts_count)
        _setter("freeform_tags", freeform_tags)
        _setter("hcx_action", hcx_action)
        _setter("hcx_fqdn", hcx_fqdn)
        _setter("hcx_initial_password", hcx_initial_password)
        _setter("hcx_on_prem_key", hcx_on_prem_key)
        _setter("hcx_on_prem_licenses", hcx_on_prem_licenses)
        _setter("hcx_private_ip_id", hcx_private_ip_id)
        _setter("hcx_vlan_id", hcx_vlan_id)
        _setter("id", id)
        _setter("initial_host_ocpu_count", initial_host_ocpu_count)
        _setter("initial_host_shape_name", initial_host_shape_name)
        _setter("initial_sku", initial_sku)
        _setter("instance_display_name_prefix", instance_display_name_prefix)
        _setter("is_hcx_enabled", is_hcx_enabled)
        _setter("is_hcx_enterprise_enabled", is_hcx_enterprise_enabled)
        _setter("is_hcx_pending_downgrade", is_hcx_pending_downgrade)
        _setter("is_shielded_instance_enabled", is_shielded_instance_enabled)
        _setter("is_single_host_sddc", is_single_host_sddc)
        _setter("nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        _setter("nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        _setter("nsx_edge_uplink_ip_id", nsx_edge_uplink_ip_id)
        _setter("nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        _setter("nsx_manager_fqdn", nsx_manager_fqdn)
        _setter("nsx_manager_initial_password", nsx_manager_initial_password)
        _setter("nsx_manager_private_ip_id", nsx_manager_private_ip_id)
        _setter("nsx_manager_username", nsx_manager_username)
        _setter("nsx_overlay_segment_name", nsx_overlay_segment_name)
        _setter("nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        _setter("provisioning_subnet_id", provisioning_subnet_id)
        _setter("provisioning_vlan_id", provisioning_vlan_id)
        _setter("refresh_hcx_license_status", refresh_hcx_license_status)
        _setter("replication_vlan_id", replication_vlan_id)
        _setter("reserving_hcx_on_premise_license_keys", reserving_hcx_on_premise_license_keys)
        _setter("ssh_authorized_keys", ssh_authorized_keys)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_hcx_billing_cycle_end", time_hcx_billing_cycle_end)
        _setter("time_hcx_license_status_updated", time_hcx_license_status_updated)
        _setter("time_updated", time_updated)
        _setter("upgrade_licenses", upgrade_licenses)
        _setter("vcenter_fqdn", vcenter_fqdn)
        _setter("vcenter_initial_password", vcenter_initial_password)
        _setter("vcenter_private_ip_id", vcenter_private_ip_id)
        _setter("vcenter_username", vcenter_username)
        _setter("vmotion_vlan_id", vmotion_vlan_id)
        _setter("vmware_software_version", vmware_software_version)
        _setter("vsan_vlan_id", vsan_vlan_id)
        _setter("vsphere_upgrade_guide", vsphere_upgrade_guide)
        _setter("vsphere_upgrade_objects", vsphere_upgrade_objects)
        _setter("vsphere_vlan_id", vsphere_vlan_id)
        _setter("workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> int:
        """
        The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> str:
        """
        The name of the availability domain that the Compute instances are running in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetSddcsSddcCollectionDatastoreResult']:
        """
        Datastores used for the Sddc.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> int:
        """
        The number of ESXi hosts in the SDDC.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hcxAction")
    def hcx_action(self) -> str:
        return pulumi.get(self, "hcx_action")

    @property
    @pulumi.getter(name="hcxFqdn")
    def hcx_fqdn(self) -> str:
        """
        The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "hcx_fqdn")

    @property
    @pulumi.getter(name="hcxInitialPassword")
    def hcx_initial_password(self) -> str:
        """
        The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        """
        return pulumi.get(self, "hcx_initial_password")

    @property
    @pulumi.getter(name="hcxOnPremKey")
    def hcx_on_prem_key(self) -> str:
        """
        The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        """
        return pulumi.get(self, "hcx_on_prem_key")

    @property
    @pulumi.getter(name="hcxOnPremLicenses")
    def hcx_on_prem_licenses(self) -> Sequence['outputs.GetSddcsSddcCollectionHcxOnPremLicenseResult']:
        """
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        """
        return pulumi.get(self, "hcx_on_prem_licenses")

    @property
    @pulumi.getter(name="hcxPrivateIpId")
    def hcx_private_ip_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "hcx_private_ip_id")

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> float:
        """
        The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> str:
        """
        The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="initialSku")
    def initial_sku(self) -> str:
        """
        The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "initial_sku")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> str:
        """
        A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isHcxEnabled")
    def is_hcx_enabled(self) -> bool:
        """
        Indicates whether HCX is enabled for this SDDC.
        """
        return pulumi.get(self, "is_hcx_enabled")

    @property
    @pulumi.getter(name="isHcxEnterpriseEnabled")
    def is_hcx_enterprise_enabled(self) -> bool:
        """
        Indicates whether HCX Enterprise is enabled for this SDDC.
        """
        return pulumi.get(self, "is_hcx_enterprise_enabled")

    @property
    @pulumi.getter(name="isHcxPendingDowngrade")
    def is_hcx_pending_downgrade(self) -> bool:
        """
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        """
        return pulumi.get(self, "is_hcx_pending_downgrade")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> bool:
        """
        Indicates whether shielded instance is enabled at the SDDC level.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="isSingleHostSddc")
    def is_single_host_sddc(self) -> bool:
        """
        Indicates whether this SDDC is designated for only single ESXi host.
        """
        return pulumi.get(self, "is_single_host_sddc")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 2 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplinkIpId")
    def nsx_edge_uplink_ip_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_edge_uplink_ip_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxManagerFqdn")
    def nsx_manager_fqdn(self) -> str:
        """
        The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "nsx_manager_fqdn")

    @property
    @pulumi.getter(name="nsxManagerInitialPassword")
    def nsx_manager_initial_password(self) -> str:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        """
        return pulumi.get(self, "nsx_manager_initial_password")

    @property
    @pulumi.getter(name="nsxManagerPrivateIpId")
    def nsx_manager_private_ip_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_manager_private_ip_id")

    @property
    @pulumi.getter(name="nsxManagerUsername")
    def nsx_manager_username(self) -> str:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        """
        return pulumi.get(self, "nsx_manager_username")

    @property
    @pulumi.getter(name="nsxOverlaySegmentName")
    def nsx_overlay_segment_name(self) -> str:
        """
        The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        """
        return pulumi.get(self, "nsx_overlay_segment_name")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the SDDC.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="refreshHcxLicenseStatus")
    def refresh_hcx_license_status(self) -> bool:
        return pulumi.get(self, "refresh_hcx_license_status")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="reservingHcxOnPremiseLicenseKeys")
    def reserving_hcx_on_premise_license_keys(self) -> Sequence[str]:
        return pulumi.get(self, "reserving_hcx_on_premise_license_keys")

    @property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> str:
        """
        One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file.
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeHcxBillingCycleEnd")
    def time_hcx_billing_cycle_end(self) -> str:
        """
        The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_billing_cycle_end")

    @property
    @pulumi.getter(name="timeHcxLicenseStatusUpdated")
    def time_hcx_license_status_updated(self) -> str:
        """
        The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_license_status_updated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> Sequence['outputs.GetSddcsSddcCollectionUpgradeLicenseResult']:
        """
        The vSphere licenses to use when upgrading the SDDC.
        """
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vcenterFqdn")
    def vcenter_fqdn(self) -> str:
        """
        The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "vcenter_fqdn")

    @property
    @pulumi.getter(name="vcenterInitialPassword")
    def vcenter_initial_password(self) -> str:
        """
        The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        """
        return pulumi.get(self, "vcenter_initial_password")

    @property
    @pulumi.getter(name="vcenterPrivateIpId")
    def vcenter_private_ip_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "vcenter_private_ip_id")

    @property
    @pulumi.getter(name="vcenterUsername")
    def vcenter_username(self) -> str:
        """
        The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        """
        return pulumi.get(self, "vcenter_username")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> str:
        """
        In general, this is a specific version of bundled VMware software supported by Oracle Cloud VMware Solution (see [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions)).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereUpgradeGuide")
    def vsphere_upgrade_guide(self) -> str:
        """
        The link to guidance for upgrading vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_guide")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> Sequence['outputs.GetSddcsSddcCollectionVsphereUpgradeObjectResult']:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> str:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads.
        """
        return pulumi.get(self, "workload_network_cidr")


@pulumi.output_type
class GetSddcsSddcCollectionDatastoreResult(dict):
    def __init__(__self__, *,
                 block_volume_ids: Sequence[str],
                 capacity: float,
                 datastore_type: str):
        """
        :param Sequence[str] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param float capacity: Size of the Block Storage Volume in GB.
        :param str datastore_type: Type of the datastore.
        """
        GetSddcsSddcCollectionDatastoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            block_volume_ids=block_volume_ids,
            capacity=capacity,
            datastore_type=datastore_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             block_volume_ids: Sequence[str],
             capacity: float,
             datastore_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("block_volume_ids", block_volume_ids)
        _setter("capacity", capacity)
        _setter("datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> Sequence[str]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @property
    @pulumi.getter
    def capacity(self) -> float:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> str:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")


@pulumi.output_type
class GetSddcsSddcCollectionHcxOnPremLicenseResult(dict):
    def __init__(__self__, *,
                 activation_key: str,
                 status: str,
                 system_name: str):
        """
        :param str activation_key: HCX on-premise license key value.
        :param str status: status of HCX on-premise license.
        :param str system_name: Name of the system that consumed the HCX on-premise license
        """
        GetSddcsSddcCollectionHcxOnPremLicenseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            activation_key=activation_key,
            status=status,
            system_name=system_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             activation_key: str,
             status: str,
             system_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("activation_key", activation_key)
        _setter("status", status)
        _setter("system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> str:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class GetSddcsSddcCollectionUpgradeLicenseResult(dict):
    def __init__(__self__, *,
                 license_key: str,
                 license_type: str):
        """
        :param str license_key: vSphere license key value.
        :param str license_type: vSphere license type.
        """
        GetSddcsSddcCollectionUpgradeLicenseResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            license_key=license_key,
            license_type=license_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             license_key: str,
             license_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("license_key", license_key)
        _setter("license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> str:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class GetSddcsSddcCollectionVsphereUpgradeObjectResult(dict):
    def __init__(__self__, *,
                 download_link: str,
                 link_description: str):
        """
        :param str download_link: Binary object download link.
        :param str link_description: Binary object description.
        """
        GetSddcsSddcCollectionVsphereUpgradeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            download_link=download_link,
            link_description=link_description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             download_link: str,
             link_description: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("download_link", download_link)
        _setter("link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> str:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> str:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")


@pulumi.output_type
class GetSupportedHostShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetSupportedHostShapesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedHostShapesItemResult(dict):
    def __init__(__self__, *,
                 default_ocpu_count: float,
                 description: str,
                 is_support_monthly_sku: bool,
                 is_support_shielded_instances: bool,
                 name: str,
                 shape_family: str,
                 supported_ocpu_counts: Sequence[float],
                 supported_operations: Sequence[str],
                 supported_sddc_types: Sequence[str],
                 supported_vmware_software_versions: Sequence[str]):
        """
        :param float default_ocpu_count: The default OCPU count of the shape.
        :param str description: Description of the shape.
        :param bool is_support_monthly_sku: Whether the shape supports "MONTH" SKU.
        :param bool is_support_shielded_instances: Indicates whether the shape supports shielded instances.
        :param str name: A filter to return only resources that match the given name exactly.
        :param str shape_family: The family of the shape. ESXi hosts of one SDDC must have the same shape family.
        :param Sequence[float] supported_ocpu_counts: Support OCPU count of the shape.
        :param Sequence[str] supported_operations: The operations where you can use the shape. The operations can be CREATE_SDDC or CREATE_ESXI_HOST.
        :param Sequence[str] supported_sddc_types: The supported SDDC types for the shape.
        :param Sequence[str] supported_vmware_software_versions: The VMware software versions supported by the shape.
        """
        GetSupportedHostShapesItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_ocpu_count=default_ocpu_count,
            description=description,
            is_support_monthly_sku=is_support_monthly_sku,
            is_support_shielded_instances=is_support_shielded_instances,
            name=name,
            shape_family=shape_family,
            supported_ocpu_counts=supported_ocpu_counts,
            supported_operations=supported_operations,
            supported_sddc_types=supported_sddc_types,
            supported_vmware_software_versions=supported_vmware_software_versions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_ocpu_count: float,
             description: str,
             is_support_monthly_sku: bool,
             is_support_shielded_instances: bool,
             name: str,
             shape_family: str,
             supported_ocpu_counts: Sequence[float],
             supported_operations: Sequence[str],
             supported_sddc_types: Sequence[str],
             supported_vmware_software_versions: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("default_ocpu_count", default_ocpu_count)
        _setter("description", description)
        _setter("is_support_monthly_sku", is_support_monthly_sku)
        _setter("is_support_shielded_instances", is_support_shielded_instances)
        _setter("name", name)
        _setter("shape_family", shape_family)
        _setter("supported_ocpu_counts", supported_ocpu_counts)
        _setter("supported_operations", supported_operations)
        _setter("supported_sddc_types", supported_sddc_types)
        _setter("supported_vmware_software_versions", supported_vmware_software_versions)

    @property
    @pulumi.getter(name="defaultOcpuCount")
    def default_ocpu_count(self) -> float:
        """
        The default OCPU count of the shape.
        """
        return pulumi.get(self, "default_ocpu_count")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the shape.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isSupportMonthlySku")
    def is_support_monthly_sku(self) -> bool:
        """
        Whether the shape supports "MONTH" SKU.
        """
        return pulumi.get(self, "is_support_monthly_sku")

    @property
    @pulumi.getter(name="isSupportShieldedInstances")
    def is_support_shielded_instances(self) -> bool:
        """
        Indicates whether the shape supports shielded instances.
        """
        return pulumi.get(self, "is_support_shielded_instances")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shapeFamily")
    def shape_family(self) -> str:
        """
        The family of the shape. ESXi hosts of one SDDC must have the same shape family.
        """
        return pulumi.get(self, "shape_family")

    @property
    @pulumi.getter(name="supportedOcpuCounts")
    def supported_ocpu_counts(self) -> Sequence[float]:
        """
        Support OCPU count of the shape.
        """
        return pulumi.get(self, "supported_ocpu_counts")

    @property
    @pulumi.getter(name="supportedOperations")
    def supported_operations(self) -> Sequence[str]:
        """
        The operations where you can use the shape. The operations can be CREATE_SDDC or CREATE_ESXI_HOST.
        """
        return pulumi.get(self, "supported_operations")

    @property
    @pulumi.getter(name="supportedSddcTypes")
    def supported_sddc_types(self) -> Sequence[str]:
        """
        The supported SDDC types for the shape.
        """
        return pulumi.get(self, "supported_sddc_types")

    @property
    @pulumi.getter(name="supportedVmwareSoftwareVersions")
    def supported_vmware_software_versions(self) -> Sequence[str]:
        """
        The VMware software versions supported by the shape.
        """
        return pulumi.get(self, "supported_vmware_software_versions")


@pulumi.output_type
class GetSupportedSkusFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: name of SKU
        """
        GetSupportedSkusFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedSkusItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: name of SKU
        """
        GetSupportedSkusItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSupportedVmwareSoftwareVersionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSupportedVmwareSoftwareVersionsItemResult(dict):
    def __init__(__self__, *,
                 description: str,
                 version: str):
        """
        :param str description: A description of the software in the bundle.
        :param str version: A short, unique string that identifies the version of bundled software.
        """
        GetSupportedVmwareSoftwareVersionsItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("version", version)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the software in the bundle.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A short, unique string that identifies the version of bundled software.
        """
        return pulumi.get(self, "version")


