# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SddcArgs', 'Sddc']

@pulumi.input_type
class SddcArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 compute_availability_domain: pulumi.Input[str],
                 esxi_hosts_count: pulumi.Input[int],
                 nsx_edge_uplink1vlan_id: pulumi.Input[str],
                 nsx_edge_uplink2vlan_id: pulumi.Input[str],
                 nsx_edge_vtep_vlan_id: pulumi.Input[str],
                 nsx_vtep_vlan_id: pulumi.Input[str],
                 provisioning_subnet_id: pulumi.Input[str],
                 ssh_authorized_keys: pulumi.Input[str],
                 vmotion_vlan_id: pulumi.Input[str],
                 vmware_software_version: pulumi.Input[str],
                 vsan_vlan_id: pulumi.Input[str],
                 vsphere_vlan_id: pulumi.Input[str],
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hcx_action: Optional[pulumi.Input[str]] = None,
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[str]] = None,
                 initial_sku: Optional[pulumi.Input[str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
                 is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
                 is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 workload_network_cidr: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Sddc resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        :param pulumi.Input[int] esxi_hosts_count: The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.
               
               **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.
               
               **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        :param pulumi.Input[str] nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        :param pulumi.Input[str] provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        :param pulumi.Input[str] ssh_authorized_keys: (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        :param pulumi.Input[str] vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        :param pulumi.Input[str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        :param pulumi.Input[str] vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]] datastores: A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hcx_action: (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        :param pulumi.Input[str] hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        :param pulumi.Input[float] initial_host_ocpu_count: The initial OCPU count of the SDDC's ESXi hosts.
        :param pulumi.Input[str] initial_host_shape_name: The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] initial_sku: The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param pulumi.Input[str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
               
               For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        :param pulumi.Input[bool] is_hcx_enabled: For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        :param pulumi.Input[bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this SDDC.
        :param pulumi.Input[bool] is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param pulumi.Input[str] provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        :param pulumi.Input[bool] refresh_hcx_license_status: (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        :param pulumi.Input[str] replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserving_hcx_on_premise_license_keys: (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        :param pulumi.Input[str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        SddcArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            compute_availability_domain=compute_availability_domain,
            esxi_hosts_count=esxi_hosts_count,
            nsx_edge_uplink1vlan_id=nsx_edge_uplink1vlan_id,
            nsx_edge_uplink2vlan_id=nsx_edge_uplink2vlan_id,
            nsx_edge_vtep_vlan_id=nsx_edge_vtep_vlan_id,
            nsx_vtep_vlan_id=nsx_vtep_vlan_id,
            provisioning_subnet_id=provisioning_subnet_id,
            ssh_authorized_keys=ssh_authorized_keys,
            vmotion_vlan_id=vmotion_vlan_id,
            vmware_software_version=vmware_software_version,
            vsan_vlan_id=vsan_vlan_id,
            vsphere_vlan_id=vsphere_vlan_id,
            capacity_reservation_id=capacity_reservation_id,
            datastores=datastores,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            hcx_action=hcx_action,
            hcx_vlan_id=hcx_vlan_id,
            initial_host_ocpu_count=initial_host_ocpu_count,
            initial_host_shape_name=initial_host_shape_name,
            initial_sku=initial_sku,
            instance_display_name_prefix=instance_display_name_prefix,
            is_hcx_enabled=is_hcx_enabled,
            is_shielded_instance_enabled=is_shielded_instance_enabled,
            is_single_host_sddc=is_single_host_sddc,
            provisioning_vlan_id=provisioning_vlan_id,
            refresh_hcx_license_status=refresh_hcx_license_status,
            replication_vlan_id=replication_vlan_id,
            reserving_hcx_on_premise_license_keys=reserving_hcx_on_premise_license_keys,
            workload_network_cidr=workload_network_cidr,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             compute_availability_domain: pulumi.Input[str],
             esxi_hosts_count: pulumi.Input[int],
             nsx_edge_uplink1vlan_id: pulumi.Input[str],
             nsx_edge_uplink2vlan_id: pulumi.Input[str],
             nsx_edge_vtep_vlan_id: pulumi.Input[str],
             nsx_vtep_vlan_id: pulumi.Input[str],
             provisioning_subnet_id: pulumi.Input[str],
             ssh_authorized_keys: pulumi.Input[str],
             vmotion_vlan_id: pulumi.Input[str],
             vmware_software_version: pulumi.Input[str],
             vsan_vlan_id: pulumi.Input[str],
             vsphere_vlan_id: pulumi.Input[str],
             capacity_reservation_id: Optional[pulumi.Input[str]] = None,
             datastores: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             hcx_action: Optional[pulumi.Input[str]] = None,
             hcx_vlan_id: Optional[pulumi.Input[str]] = None,
             initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
             initial_host_shape_name: Optional[pulumi.Input[str]] = None,
             initial_sku: Optional[pulumi.Input[str]] = None,
             instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
             is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
             is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
             is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
             provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
             refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
             replication_vlan_id: Optional[pulumi.Input[str]] = None,
             reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             workload_network_cidr: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("compute_availability_domain", compute_availability_domain)
        _setter("esxi_hosts_count", esxi_hosts_count)
        _setter("nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        _setter("nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        _setter("nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        _setter("nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        _setter("provisioning_subnet_id", provisioning_subnet_id)
        _setter("ssh_authorized_keys", ssh_authorized_keys)
        _setter("vmotion_vlan_id", vmotion_vlan_id)
        _setter("vmware_software_version", vmware_software_version)
        _setter("vsan_vlan_id", vsan_vlan_id)
        _setter("vsphere_vlan_id", vsphere_vlan_id)
        if capacity_reservation_id is not None:
            _setter("capacity_reservation_id", capacity_reservation_id)
        if datastores is not None:
            _setter("datastores", datastores)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if hcx_action is not None:
            _setter("hcx_action", hcx_action)
        if hcx_vlan_id is not None:
            _setter("hcx_vlan_id", hcx_vlan_id)
        if initial_host_ocpu_count is not None:
            _setter("initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            _setter("initial_host_shape_name", initial_host_shape_name)
        if initial_sku is not None:
            _setter("initial_sku", initial_sku)
        if instance_display_name_prefix is not None:
            _setter("instance_display_name_prefix", instance_display_name_prefix)
        if is_hcx_enabled is not None:
            _setter("is_hcx_enabled", is_hcx_enabled)
        if is_shielded_instance_enabled is not None:
            _setter("is_shielded_instance_enabled", is_shielded_instance_enabled)
        if is_single_host_sddc is not None:
            _setter("is_single_host_sddc", is_single_host_sddc)
        if provisioning_vlan_id is not None:
            _setter("provisioning_vlan_id", provisioning_vlan_id)
        if refresh_hcx_license_status is not None:
            _setter("refresh_hcx_license_status", refresh_hcx_license_status)
        if replication_vlan_id is not None:
            _setter("replication_vlan_id", replication_vlan_id)
        if reserving_hcx_on_premise_license_keys is not None:
            _setter("reserving_hcx_on_premise_license_keys", reserving_hcx_on_premise_license_keys)
        if workload_network_cidr is not None:
            _setter("workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> pulumi.Input[int]:
        """
        The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.

        **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "esxi_hosts_count", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @nsx_edge_uplink1vlan_id.setter
    def nsx_edge_uplink1vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_edge_uplink1vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.

        **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @nsx_edge_uplink2vlan_id.setter
    def nsx_edge_uplink2vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_edge_uplink2vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @nsx_edge_vtep_vlan_id.setter
    def nsx_edge_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_edge_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @nsx_vtep_vlan_id.setter
    def nsx_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @provisioning_subnet_id.setter
    def provisioning_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioning_subnet_id", value)

    @property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> pulumi.Input[str]:
        """
        (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_authorized_keys", value)

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @vmotion_vlan_id.setter
    def vmotion_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmotion_vlan_id", value)

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> pulumi.Input[str]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @vmware_software_version.setter
    def vmware_software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmware_software_version", value)

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @vsan_vlan_id.setter
    def vsan_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vsan_vlan_id", value)

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @vsphere_vlan_id.setter
    def vsphere_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vsphere_vlan_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter
    def datastores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]]:
        """
        A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @datastores.setter
    def datastores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]]):
        pulumi.set(self, "datastores", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hcxAction")
    def hcx_action(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        """
        return pulumi.get(self, "hcx_action")

    @hcx_action.setter
    def hcx_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_action", value)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @hcx_vlan_id.setter
    def hcx_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_vlan_id", value)

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "initial_host_ocpu_count", value)

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_host_shape_name", value)

    @property
    @pulumi.getter(name="initialSku")
    def initial_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "initial_sku")

    @initial_sku.setter
    def initial_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_sku", value)

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.

        For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @instance_display_name_prefix.setter
    def instance_display_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_display_name_prefix", value)

    @property
    @pulumi.getter(name="isHcxEnabled")
    def is_hcx_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        """
        return pulumi.get(self, "is_hcx_enabled")

    @is_hcx_enabled.setter
    def is_hcx_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hcx_enabled", value)

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether shielded instance is enabled for this SDDC.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shielded_instance_enabled", value)

    @property
    @pulumi.getter(name="isSingleHostSddc")
    def is_single_host_sddc(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this SDDC is designated for only single ESXi host.
        """
        return pulumi.get(self, "is_single_host_sddc")

    @is_single_host_sddc.setter
    def is_single_host_sddc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_single_host_sddc", value)

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @provisioning_vlan_id.setter
    def provisioning_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_vlan_id", value)

    @property
    @pulumi.getter(name="refreshHcxLicenseStatus")
    def refresh_hcx_license_status(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        """
        return pulumi.get(self, "refresh_hcx_license_status")

    @refresh_hcx_license_status.setter
    def refresh_hcx_license_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_hcx_license_status", value)

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @replication_vlan_id.setter
    def replication_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_vlan_id", value)

    @property
    @pulumi.getter(name="reservingHcxOnPremiseLicenseKeys")
    def reserving_hcx_on_premise_license_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        """
        return pulumi.get(self, "reserving_hcx_on_premise_license_keys")

    @reserving_hcx_on_premise_license_keys.setter
    def reserving_hcx_on_premise_license_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reserving_hcx_on_premise_license_keys", value)

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

    @workload_network_cidr.setter
    def workload_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_network_cidr", value)


@pulumi.input_type
class _SddcState:
    def __init__(__self__, *,
                 actual_esxi_hosts_count: Optional[pulumi.Input[int]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hcx_action: Optional[pulumi.Input[str]] = None,
                 hcx_fqdn: Optional[pulumi.Input[str]] = None,
                 hcx_initial_password: Optional[pulumi.Input[str]] = None,
                 hcx_on_prem_key: Optional[pulumi.Input[str]] = None,
                 hcx_on_prem_licenses: Optional[pulumi.Input[Sequence[pulumi.Input['SddcHcxOnPremLicenseArgs']]]] = None,
                 hcx_private_ip_id: Optional[pulumi.Input[str]] = None,
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[str]] = None,
                 initial_sku: Optional[pulumi.Input[str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
                 is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
                 is_hcx_enterprise_enabled: Optional[pulumi.Input[bool]] = None,
                 is_hcx_pending_downgrade: Optional[pulumi.Input[bool]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
                 is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
                 nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink_ip_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_manager_fqdn: Optional[pulumi.Input[str]] = None,
                 nsx_manager_initial_password: Optional[pulumi.Input[str]] = None,
                 nsx_manager_private_ip_id: Optional[pulumi.Input[str]] = None,
                 nsx_manager_username: Optional[pulumi.Input[str]] = None,
                 nsx_overlay_segment_name: Optional[pulumi.Input[str]] = None,
                 nsx_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 provisioning_subnet_id: Optional[pulumi.Input[str]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_hcx_billing_cycle_end: Optional[pulumi.Input[str]] = None,
                 time_hcx_license_status_updated: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 upgrade_licenses: Optional[pulumi.Input[Sequence[pulumi.Input['SddcUpgradeLicenseArgs']]]] = None,
                 vcenter_fqdn: Optional[pulumi.Input[str]] = None,
                 vcenter_initial_password: Optional[pulumi.Input[str]] = None,
                 vcenter_private_ip_id: Optional[pulumi.Input[str]] = None,
                 vcenter_username: Optional[pulumi.Input[str]] = None,
                 vmotion_vlan_id: Optional[pulumi.Input[str]] = None,
                 vmware_software_version: Optional[pulumi.Input[str]] = None,
                 vsan_vlan_id: Optional[pulumi.Input[str]] = None,
                 vsphere_upgrade_guide: Optional[pulumi.Input[str]] = None,
                 vsphere_upgrade_objects: Optional[pulumi.Input[Sequence[pulumi.Input['SddcVsphereUpgradeObjectArgs']]]] = None,
                 vsphere_vlan_id: Optional[pulumi.Input[str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Sddc resources.
        :param pulumi.Input[int] actual_esxi_hosts_count: The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]] datastores: A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[int] esxi_hosts_count: The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.
               
               **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hcx_action: (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        :param pulumi.Input[str] hcx_fqdn: The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] hcx_initial_password: The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        :param pulumi.Input[str] hcx_on_prem_key: The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        :param pulumi.Input[Sequence[pulumi.Input['SddcHcxOnPremLicenseArgs']]] hcx_on_prem_licenses: The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        :param pulumi.Input[str] hcx_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        :param pulumi.Input[float] initial_host_ocpu_count: The initial OCPU count of the SDDC's ESXi hosts.
        :param pulumi.Input[str] initial_host_shape_name: The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] initial_sku: The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param pulumi.Input[str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
               
               For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        :param pulumi.Input[bool] is_hcx_enabled: For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        :param pulumi.Input[bool] is_hcx_enterprise_enabled: Indicates whether HCX Enterprise is enabled for this SDDC.
        :param pulumi.Input[bool] is_hcx_pending_downgrade: Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        :param pulumi.Input[bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this SDDC.
        :param pulumi.Input[bool] is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.
               
               **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        :param pulumi.Input[str] nsx_edge_uplink_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        :param pulumi.Input[str] nsx_manager_fqdn: The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] nsx_manager_initial_password: The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        :param pulumi.Input[str] nsx_manager_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] nsx_manager_username: The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        :param pulumi.Input[str] nsx_overlay_segment_name: The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        :param pulumi.Input[str] nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        :param pulumi.Input[str] provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        :param pulumi.Input[str] provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        :param pulumi.Input[bool] refresh_hcx_license_status: (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        :param pulumi.Input[str] replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserving_hcx_on_premise_license_keys: (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        :param pulumi.Input[str] ssh_authorized_keys: (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        :param pulumi.Input[str] state: The current state of the SDDC.
        :param pulumi.Input[str] time_created: The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_hcx_billing_cycle_end: The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_hcx_license_status_updated: The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input['SddcUpgradeLicenseArgs']]] upgrade_licenses: The vSphere licenses to use when upgrading the SDDC.
        :param pulumi.Input[str] vcenter_fqdn: The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] vcenter_initial_password: The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        :param pulumi.Input[str] vcenter_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] vcenter_username: The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        :param pulumi.Input[str] vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        :param pulumi.Input[str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        :param pulumi.Input[str] vsphere_upgrade_guide: The link to guidance for upgrading vSphere.
        :param pulumi.Input[Sequence[pulumi.Input['SddcVsphereUpgradeObjectArgs']]] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param pulumi.Input[str] vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        :param pulumi.Input[str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _SddcState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actual_esxi_hosts_count=actual_esxi_hosts_count,
            capacity_reservation_id=capacity_reservation_id,
            compartment_id=compartment_id,
            compute_availability_domain=compute_availability_domain,
            datastores=datastores,
            defined_tags=defined_tags,
            display_name=display_name,
            esxi_hosts_count=esxi_hosts_count,
            freeform_tags=freeform_tags,
            hcx_action=hcx_action,
            hcx_fqdn=hcx_fqdn,
            hcx_initial_password=hcx_initial_password,
            hcx_on_prem_key=hcx_on_prem_key,
            hcx_on_prem_licenses=hcx_on_prem_licenses,
            hcx_private_ip_id=hcx_private_ip_id,
            hcx_vlan_id=hcx_vlan_id,
            initial_host_ocpu_count=initial_host_ocpu_count,
            initial_host_shape_name=initial_host_shape_name,
            initial_sku=initial_sku,
            instance_display_name_prefix=instance_display_name_prefix,
            is_hcx_enabled=is_hcx_enabled,
            is_hcx_enterprise_enabled=is_hcx_enterprise_enabled,
            is_hcx_pending_downgrade=is_hcx_pending_downgrade,
            is_shielded_instance_enabled=is_shielded_instance_enabled,
            is_single_host_sddc=is_single_host_sddc,
            nsx_edge_uplink1vlan_id=nsx_edge_uplink1vlan_id,
            nsx_edge_uplink2vlan_id=nsx_edge_uplink2vlan_id,
            nsx_edge_uplink_ip_id=nsx_edge_uplink_ip_id,
            nsx_edge_vtep_vlan_id=nsx_edge_vtep_vlan_id,
            nsx_manager_fqdn=nsx_manager_fqdn,
            nsx_manager_initial_password=nsx_manager_initial_password,
            nsx_manager_private_ip_id=nsx_manager_private_ip_id,
            nsx_manager_username=nsx_manager_username,
            nsx_overlay_segment_name=nsx_overlay_segment_name,
            nsx_vtep_vlan_id=nsx_vtep_vlan_id,
            provisioning_subnet_id=provisioning_subnet_id,
            provisioning_vlan_id=provisioning_vlan_id,
            refresh_hcx_license_status=refresh_hcx_license_status,
            replication_vlan_id=replication_vlan_id,
            reserving_hcx_on_premise_license_keys=reserving_hcx_on_premise_license_keys,
            ssh_authorized_keys=ssh_authorized_keys,
            state=state,
            time_created=time_created,
            time_hcx_billing_cycle_end=time_hcx_billing_cycle_end,
            time_hcx_license_status_updated=time_hcx_license_status_updated,
            time_updated=time_updated,
            upgrade_licenses=upgrade_licenses,
            vcenter_fqdn=vcenter_fqdn,
            vcenter_initial_password=vcenter_initial_password,
            vcenter_private_ip_id=vcenter_private_ip_id,
            vcenter_username=vcenter_username,
            vmotion_vlan_id=vmotion_vlan_id,
            vmware_software_version=vmware_software_version,
            vsan_vlan_id=vsan_vlan_id,
            vsphere_upgrade_guide=vsphere_upgrade_guide,
            vsphere_upgrade_objects=vsphere_upgrade_objects,
            vsphere_vlan_id=vsphere_vlan_id,
            workload_network_cidr=workload_network_cidr,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actual_esxi_hosts_count: Optional[pulumi.Input[int]] = None,
             capacity_reservation_id: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compute_availability_domain: Optional[pulumi.Input[str]] = None,
             datastores: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             esxi_hosts_count: Optional[pulumi.Input[int]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             hcx_action: Optional[pulumi.Input[str]] = None,
             hcx_fqdn: Optional[pulumi.Input[str]] = None,
             hcx_initial_password: Optional[pulumi.Input[str]] = None,
             hcx_on_prem_key: Optional[pulumi.Input[str]] = None,
             hcx_on_prem_licenses: Optional[pulumi.Input[Sequence[pulumi.Input['SddcHcxOnPremLicenseArgs']]]] = None,
             hcx_private_ip_id: Optional[pulumi.Input[str]] = None,
             hcx_vlan_id: Optional[pulumi.Input[str]] = None,
             initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
             initial_host_shape_name: Optional[pulumi.Input[str]] = None,
             initial_sku: Optional[pulumi.Input[str]] = None,
             instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
             is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
             is_hcx_enterprise_enabled: Optional[pulumi.Input[bool]] = None,
             is_hcx_pending_downgrade: Optional[pulumi.Input[bool]] = None,
             is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
             is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
             nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
             nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
             nsx_edge_uplink_ip_id: Optional[pulumi.Input[str]] = None,
             nsx_edge_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
             nsx_manager_fqdn: Optional[pulumi.Input[str]] = None,
             nsx_manager_initial_password: Optional[pulumi.Input[str]] = None,
             nsx_manager_private_ip_id: Optional[pulumi.Input[str]] = None,
             nsx_manager_username: Optional[pulumi.Input[str]] = None,
             nsx_overlay_segment_name: Optional[pulumi.Input[str]] = None,
             nsx_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
             provisioning_subnet_id: Optional[pulumi.Input[str]] = None,
             provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
             refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
             replication_vlan_id: Optional[pulumi.Input[str]] = None,
             reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             ssh_authorized_keys: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_hcx_billing_cycle_end: Optional[pulumi.Input[str]] = None,
             time_hcx_license_status_updated: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             upgrade_licenses: Optional[pulumi.Input[Sequence[pulumi.Input['SddcUpgradeLicenseArgs']]]] = None,
             vcenter_fqdn: Optional[pulumi.Input[str]] = None,
             vcenter_initial_password: Optional[pulumi.Input[str]] = None,
             vcenter_private_ip_id: Optional[pulumi.Input[str]] = None,
             vcenter_username: Optional[pulumi.Input[str]] = None,
             vmotion_vlan_id: Optional[pulumi.Input[str]] = None,
             vmware_software_version: Optional[pulumi.Input[str]] = None,
             vsan_vlan_id: Optional[pulumi.Input[str]] = None,
             vsphere_upgrade_guide: Optional[pulumi.Input[str]] = None,
             vsphere_upgrade_objects: Optional[pulumi.Input[Sequence[pulumi.Input['SddcVsphereUpgradeObjectArgs']]]] = None,
             vsphere_vlan_id: Optional[pulumi.Input[str]] = None,
             workload_network_cidr: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if actual_esxi_hosts_count is not None:
            _setter("actual_esxi_hosts_count", actual_esxi_hosts_count)
        if capacity_reservation_id is not None:
            _setter("capacity_reservation_id", capacity_reservation_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compute_availability_domain is not None:
            _setter("compute_availability_domain", compute_availability_domain)
        if datastores is not None:
            _setter("datastores", datastores)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if esxi_hosts_count is not None:
            _setter("esxi_hosts_count", esxi_hosts_count)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if hcx_action is not None:
            _setter("hcx_action", hcx_action)
        if hcx_fqdn is not None:
            _setter("hcx_fqdn", hcx_fqdn)
        if hcx_initial_password is not None:
            _setter("hcx_initial_password", hcx_initial_password)
        if hcx_on_prem_key is not None:
            _setter("hcx_on_prem_key", hcx_on_prem_key)
        if hcx_on_prem_licenses is not None:
            _setter("hcx_on_prem_licenses", hcx_on_prem_licenses)
        if hcx_private_ip_id is not None:
            _setter("hcx_private_ip_id", hcx_private_ip_id)
        if hcx_vlan_id is not None:
            _setter("hcx_vlan_id", hcx_vlan_id)
        if initial_host_ocpu_count is not None:
            _setter("initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            _setter("initial_host_shape_name", initial_host_shape_name)
        if initial_sku is not None:
            _setter("initial_sku", initial_sku)
        if instance_display_name_prefix is not None:
            _setter("instance_display_name_prefix", instance_display_name_prefix)
        if is_hcx_enabled is not None:
            _setter("is_hcx_enabled", is_hcx_enabled)
        if is_hcx_enterprise_enabled is not None:
            _setter("is_hcx_enterprise_enabled", is_hcx_enterprise_enabled)
        if is_hcx_pending_downgrade is not None:
            _setter("is_hcx_pending_downgrade", is_hcx_pending_downgrade)
        if is_shielded_instance_enabled is not None:
            _setter("is_shielded_instance_enabled", is_shielded_instance_enabled)
        if is_single_host_sddc is not None:
            _setter("is_single_host_sddc", is_single_host_sddc)
        if nsx_edge_uplink1vlan_id is not None:
            _setter("nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        if nsx_edge_uplink2vlan_id is not None:
            _setter("nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        if nsx_edge_uplink_ip_id is not None:
            _setter("nsx_edge_uplink_ip_id", nsx_edge_uplink_ip_id)
        if nsx_edge_vtep_vlan_id is not None:
            _setter("nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        if nsx_manager_fqdn is not None:
            _setter("nsx_manager_fqdn", nsx_manager_fqdn)
        if nsx_manager_initial_password is not None:
            _setter("nsx_manager_initial_password", nsx_manager_initial_password)
        if nsx_manager_private_ip_id is not None:
            _setter("nsx_manager_private_ip_id", nsx_manager_private_ip_id)
        if nsx_manager_username is not None:
            _setter("nsx_manager_username", nsx_manager_username)
        if nsx_overlay_segment_name is not None:
            _setter("nsx_overlay_segment_name", nsx_overlay_segment_name)
        if nsx_vtep_vlan_id is not None:
            _setter("nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        if provisioning_subnet_id is not None:
            _setter("provisioning_subnet_id", provisioning_subnet_id)
        if provisioning_vlan_id is not None:
            _setter("provisioning_vlan_id", provisioning_vlan_id)
        if refresh_hcx_license_status is not None:
            _setter("refresh_hcx_license_status", refresh_hcx_license_status)
        if replication_vlan_id is not None:
            _setter("replication_vlan_id", replication_vlan_id)
        if reserving_hcx_on_premise_license_keys is not None:
            _setter("reserving_hcx_on_premise_license_keys", reserving_hcx_on_premise_license_keys)
        if ssh_authorized_keys is not None:
            _setter("ssh_authorized_keys", ssh_authorized_keys)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_hcx_billing_cycle_end is not None:
            _setter("time_hcx_billing_cycle_end", time_hcx_billing_cycle_end)
        if time_hcx_license_status_updated is not None:
            _setter("time_hcx_license_status_updated", time_hcx_license_status_updated)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if upgrade_licenses is not None:
            _setter("upgrade_licenses", upgrade_licenses)
        if vcenter_fqdn is not None:
            _setter("vcenter_fqdn", vcenter_fqdn)
        if vcenter_initial_password is not None:
            _setter("vcenter_initial_password", vcenter_initial_password)
        if vcenter_private_ip_id is not None:
            _setter("vcenter_private_ip_id", vcenter_private_ip_id)
        if vcenter_username is not None:
            _setter("vcenter_username", vcenter_username)
        if vmotion_vlan_id is not None:
            _setter("vmotion_vlan_id", vmotion_vlan_id)
        if vmware_software_version is not None:
            _setter("vmware_software_version", vmware_software_version)
        if vsan_vlan_id is not None:
            _setter("vsan_vlan_id", vsan_vlan_id)
        if vsphere_upgrade_guide is not None:
            _setter("vsphere_upgrade_guide", vsphere_upgrade_guide)
        if vsphere_upgrade_objects is not None:
            _setter("vsphere_upgrade_objects", vsphere_upgrade_objects)
        if vsphere_vlan_id is not None:
            _setter("vsphere_vlan_id", vsphere_vlan_id)
        if workload_network_cidr is not None:
            _setter("workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @actual_esxi_hosts_count.setter
    def actual_esxi_hosts_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "actual_esxi_hosts_count", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter
    def datastores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]]:
        """
        A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @datastores.setter
    def datastores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcDatastoreArgs']]]]):
        pulumi.set(self, "datastores", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.

        **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "esxi_hosts_count", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hcxAction")
    def hcx_action(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        """
        return pulumi.get(self, "hcx_action")

    @hcx_action.setter
    def hcx_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_action", value)

    @property
    @pulumi.getter(name="hcxFqdn")
    def hcx_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "hcx_fqdn")

    @hcx_fqdn.setter
    def hcx_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_fqdn", value)

    @property
    @pulumi.getter(name="hcxInitialPassword")
    def hcx_initial_password(self) -> Optional[pulumi.Input[str]]:
        """
        The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        """
        return pulumi.get(self, "hcx_initial_password")

    @hcx_initial_password.setter
    def hcx_initial_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_initial_password", value)

    @property
    @pulumi.getter(name="hcxOnPremKey")
    def hcx_on_prem_key(self) -> Optional[pulumi.Input[str]]:
        """
        The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        """
        return pulumi.get(self, "hcx_on_prem_key")

    @hcx_on_prem_key.setter
    def hcx_on_prem_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_on_prem_key", value)

    @property
    @pulumi.getter(name="hcxOnPremLicenses")
    def hcx_on_prem_licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcHcxOnPremLicenseArgs']]]]:
        """
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        """
        return pulumi.get(self, "hcx_on_prem_licenses")

    @hcx_on_prem_licenses.setter
    def hcx_on_prem_licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcHcxOnPremLicenseArgs']]]]):
        pulumi.set(self, "hcx_on_prem_licenses", value)

    @property
    @pulumi.getter(name="hcxPrivateIpId")
    def hcx_private_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "hcx_private_ip_id")

    @hcx_private_ip_id.setter
    def hcx_private_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_private_ip_id", value)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @hcx_vlan_id.setter
    def hcx_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_vlan_id", value)

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "initial_host_ocpu_count", value)

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_host_shape_name", value)

    @property
    @pulumi.getter(name="initialSku")
    def initial_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "initial_sku")

    @initial_sku.setter
    def initial_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_sku", value)

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.

        For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @instance_display_name_prefix.setter
    def instance_display_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_display_name_prefix", value)

    @property
    @pulumi.getter(name="isHcxEnabled")
    def is_hcx_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        """
        return pulumi.get(self, "is_hcx_enabled")

    @is_hcx_enabled.setter
    def is_hcx_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hcx_enabled", value)

    @property
    @pulumi.getter(name="isHcxEnterpriseEnabled")
    def is_hcx_enterprise_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether HCX Enterprise is enabled for this SDDC.
        """
        return pulumi.get(self, "is_hcx_enterprise_enabled")

    @is_hcx_enterprise_enabled.setter
    def is_hcx_enterprise_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hcx_enterprise_enabled", value)

    @property
    @pulumi.getter(name="isHcxPendingDowngrade")
    def is_hcx_pending_downgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        """
        return pulumi.get(self, "is_hcx_pending_downgrade")

    @is_hcx_pending_downgrade.setter
    def is_hcx_pending_downgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hcx_pending_downgrade", value)

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether shielded instance is enabled for this SDDC.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shielded_instance_enabled", value)

    @property
    @pulumi.getter(name="isSingleHostSddc")
    def is_single_host_sddc(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this SDDC is designated for only single ESXi host.
        """
        return pulumi.get(self, "is_single_host_sddc")

    @is_single_host_sddc.setter
    def is_single_host_sddc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_single_host_sddc", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @nsx_edge_uplink1vlan_id.setter
    def nsx_edge_uplink1vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink1vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.

        **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @nsx_edge_uplink2vlan_id.setter
    def nsx_edge_uplink2vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink2vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplinkIpId")
    def nsx_edge_uplink_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_edge_uplink_ip_id")

    @nsx_edge_uplink_ip_id.setter
    def nsx_edge_uplink_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink_ip_id", value)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @nsx_edge_vtep_vlan_id.setter
    def nsx_edge_vtep_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="nsxManagerFqdn")
    def nsx_manager_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "nsx_manager_fqdn")

    @nsx_manager_fqdn.setter
    def nsx_manager_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_manager_fqdn", value)

    @property
    @pulumi.getter(name="nsxManagerInitialPassword")
    def nsx_manager_initial_password(self) -> Optional[pulumi.Input[str]]:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        """
        return pulumi.get(self, "nsx_manager_initial_password")

    @nsx_manager_initial_password.setter
    def nsx_manager_initial_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_manager_initial_password", value)

    @property
    @pulumi.getter(name="nsxManagerPrivateIpId")
    def nsx_manager_private_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_manager_private_ip_id")

    @nsx_manager_private_ip_id.setter
    def nsx_manager_private_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_manager_private_ip_id", value)

    @property
    @pulumi.getter(name="nsxManagerUsername")
    def nsx_manager_username(self) -> Optional[pulumi.Input[str]]:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        """
        return pulumi.get(self, "nsx_manager_username")

    @nsx_manager_username.setter
    def nsx_manager_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_manager_username", value)

    @property
    @pulumi.getter(name="nsxOverlaySegmentName")
    def nsx_overlay_segment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        """
        return pulumi.get(self, "nsx_overlay_segment_name")

    @nsx_overlay_segment_name.setter
    def nsx_overlay_segment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_overlay_segment_name", value)

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @nsx_vtep_vlan_id.setter
    def nsx_vtep_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @provisioning_subnet_id.setter
    def provisioning_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_subnet_id", value)

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @provisioning_vlan_id.setter
    def provisioning_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_vlan_id", value)

    @property
    @pulumi.getter(name="refreshHcxLicenseStatus")
    def refresh_hcx_license_status(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        """
        return pulumi.get(self, "refresh_hcx_license_status")

    @refresh_hcx_license_status.setter
    def refresh_hcx_license_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_hcx_license_status", value)

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @replication_vlan_id.setter
    def replication_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_vlan_id", value)

    @property
    @pulumi.getter(name="reservingHcxOnPremiseLicenseKeys")
    def reserving_hcx_on_premise_license_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        """
        return pulumi.get(self, "reserving_hcx_on_premise_license_keys")

    @reserving_hcx_on_premise_license_keys.setter
    def reserving_hcx_on_premise_license_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reserving_hcx_on_premise_license_keys", value)

    @property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_authorized_keys", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the SDDC.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeHcxBillingCycleEnd")
    def time_hcx_billing_cycle_end(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_billing_cycle_end")

    @time_hcx_billing_cycle_end.setter
    def time_hcx_billing_cycle_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_hcx_billing_cycle_end", value)

    @property
    @pulumi.getter(name="timeHcxLicenseStatusUpdated")
    def time_hcx_license_status_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_license_status_updated")

    @time_hcx_license_status_updated.setter
    def time_hcx_license_status_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_hcx_license_status_updated", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcUpgradeLicenseArgs']]]]:
        """
        The vSphere licenses to use when upgrading the SDDC.
        """
        return pulumi.get(self, "upgrade_licenses")

    @upgrade_licenses.setter
    def upgrade_licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcUpgradeLicenseArgs']]]]):
        pulumi.set(self, "upgrade_licenses", value)

    @property
    @pulumi.getter(name="vcenterFqdn")
    def vcenter_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "vcenter_fqdn")

    @vcenter_fqdn.setter
    def vcenter_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_fqdn", value)

    @property
    @pulumi.getter(name="vcenterInitialPassword")
    def vcenter_initial_password(self) -> Optional[pulumi.Input[str]]:
        """
        The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        """
        return pulumi.get(self, "vcenter_initial_password")

    @vcenter_initial_password.setter
    def vcenter_initial_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_initial_password", value)

    @property
    @pulumi.getter(name="vcenterPrivateIpId")
    def vcenter_private_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "vcenter_private_ip_id")

    @vcenter_private_ip_id.setter
    def vcenter_private_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_private_ip_id", value)

    @property
    @pulumi.getter(name="vcenterUsername")
    def vcenter_username(self) -> Optional[pulumi.Input[str]]:
        """
        The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        """
        return pulumi.get(self, "vcenter_username")

    @vcenter_username.setter
    def vcenter_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_username", value)

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @vmotion_vlan_id.setter
    def vmotion_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmotion_vlan_id", value)

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @vmware_software_version.setter
    def vmware_software_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_software_version", value)

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @vsan_vlan_id.setter
    def vsan_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vsan_vlan_id", value)

    @property
    @pulumi.getter(name="vsphereUpgradeGuide")
    def vsphere_upgrade_guide(self) -> Optional[pulumi.Input[str]]:
        """
        The link to guidance for upgrading vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_guide")

    @vsphere_upgrade_guide.setter
    def vsphere_upgrade_guide(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vsphere_upgrade_guide", value)

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcVsphereUpgradeObjectArgs']]]]:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @vsphere_upgrade_objects.setter
    def vsphere_upgrade_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcVsphereUpgradeObjectArgs']]]]):
        pulumi.set(self, "vsphere_upgrade_objects", value)

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @vsphere_vlan_id.setter
    def vsphere_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vsphere_vlan_id", value)

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

    @workload_network_cidr.setter
    def workload_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_network_cidr", value)


class Sddc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcDatastoreArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hcx_action: Optional[pulumi.Input[str]] = None,
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[str]] = None,
                 initial_sku: Optional[pulumi.Input[str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
                 is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
                 is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
                 nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 provisioning_subnet_id: Optional[pulumi.Input[str]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[str]] = None,
                 vmotion_vlan_id: Optional[pulumi.Input[str]] = None,
                 vmware_software_version: Optional[pulumi.Input[str]] = None,
                 vsan_vlan_id: Optional[pulumi.Input[str]] = None,
                 vsphere_vlan_id: Optional[pulumi.Input[str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sddc resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

        Creates an Oracle Cloud VMware Solution software-defined data center (SDDC).

        Use the [WorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/WorkRequest/) operations to track the
        creation of the SDDC.

        **Important:** You must configure the SDDC's networking resources with the security rules detailed in [Security Rules for Oracle Cloud VMware Solution SDDCs](https://docs.cloud.oracle.com/iaas/Content/VMware/Reference/ocvssecurityrules.htm). Otherwise, provisioning the SDDC will fail. The rules are based on the requirements set by VMware.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sddc = oci.ocvp.Sddc("testSddc",
            compartment_id=var["compartment_id"],
            compute_availability_domain=var["sddc_compute_availability_domain"],
            esxi_hosts_count=var["sddc_esxi_hosts_count"],
            nsx_edge_uplink1vlan_id=oci_core_vlan["test_nsx_edge_uplink1vlan"]["id"],
            nsx_edge_uplink2vlan_id=oci_core_vlan["test_nsx_edge_uplink2vlan"]["id"],
            nsx_edge_vtep_vlan_id=oci_core_vlan["test_nsx_edge_vtep_vlan"]["id"],
            nsx_vtep_vlan_id=oci_core_vlan["test_nsx_vtep_vlan"]["id"],
            provisioning_subnet_id=oci_core_subnet["test_subnet"]["id"],
            ssh_authorized_keys=var["sddc_ssh_authorized_keys"],
            vmotion_vlan_id=oci_core_vlan["test_vmotion_vlan"]["id"],
            vmware_software_version=var["sddc_vmware_software_version"],
            vsan_vlan_id=oci_core_vlan["test_vsan_vlan"]["id"],
            vsphere_vlan_id=oci_core_vlan["test_vsphere_vlan"]["id"],
            capacity_reservation_id=oci_ocvp_capacity_reservation["test_capacity_reservation"]["id"],
            datastores=[oci.ocvp.SddcDatastoreArgs(
                block_volume_ids=var["sddc_datastores_block_volume_ids"],
                datastore_type=var["sddc_datastores_datastore_type"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["sddc_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            hcx_action=var["hcx_action"],
            hcx_vlan_id=oci_core_vlan["test_vlan"]["id"],
            initial_host_ocpu_count=var["sddc_initial_host_ocpu_count"],
            initial_host_shape_name=oci_core_shape["test_shape"]["name"],
            initial_sku=var["sddc_initial_sku"],
            instance_display_name_prefix=var["sddc_instance_display_name_prefix"],
            is_hcx_enabled=var["sddc_is_hcx_enabled"],
            is_shielded_instance_enabled=var["sddc_is_shielded_instance_enabled"],
            is_single_host_sddc=var["sddc_is_single_host_sddc"],
            provisioning_vlan_id=oci_core_vlan["test_vlan"]["id"],
            refresh_hcx_license_status=True,
            replication_vlan_id=oci_core_vlan["test_vlan"]["id"],
            reserving_hcx_on_premise_license_keys=var["reserving_hcx_on_premise_license_keys"],
            workload_network_cidr=var["sddc_workload_network_cidr"])
        ```

        ## Import

        Sddcs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Ocvp/sddc:Sddc test_sddc "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcDatastoreArgs']]]] datastores: A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[int] esxi_hosts_count: The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.
               
               **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hcx_action: (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        :param pulumi.Input[str] hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        :param pulumi.Input[float] initial_host_ocpu_count: The initial OCPU count of the SDDC's ESXi hosts.
        :param pulumi.Input[str] initial_host_shape_name: The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] initial_sku: The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param pulumi.Input[str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
               
               For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        :param pulumi.Input[bool] is_hcx_enabled: For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        :param pulumi.Input[bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this SDDC.
        :param pulumi.Input[bool] is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.
               
               **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        :param pulumi.Input[str] nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        :param pulumi.Input[str] provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        :param pulumi.Input[str] provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        :param pulumi.Input[bool] refresh_hcx_license_status: (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        :param pulumi.Input[str] replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserving_hcx_on_premise_license_keys: (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        :param pulumi.Input[str] ssh_authorized_keys: (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        :param pulumi.Input[str] vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        :param pulumi.Input[str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        :param pulumi.Input[str] vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        :param pulumi.Input[str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SddcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sddc resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

        Creates an Oracle Cloud VMware Solution software-defined data center (SDDC).

        Use the [WorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/WorkRequest/) operations to track the
        creation of the SDDC.

        **Important:** You must configure the SDDC's networking resources with the security rules detailed in [Security Rules for Oracle Cloud VMware Solution SDDCs](https://docs.cloud.oracle.com/iaas/Content/VMware/Reference/ocvssecurityrules.htm). Otherwise, provisioning the SDDC will fail. The rules are based on the requirements set by VMware.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sddc = oci.ocvp.Sddc("testSddc",
            compartment_id=var["compartment_id"],
            compute_availability_domain=var["sddc_compute_availability_domain"],
            esxi_hosts_count=var["sddc_esxi_hosts_count"],
            nsx_edge_uplink1vlan_id=oci_core_vlan["test_nsx_edge_uplink1vlan"]["id"],
            nsx_edge_uplink2vlan_id=oci_core_vlan["test_nsx_edge_uplink2vlan"]["id"],
            nsx_edge_vtep_vlan_id=oci_core_vlan["test_nsx_edge_vtep_vlan"]["id"],
            nsx_vtep_vlan_id=oci_core_vlan["test_nsx_vtep_vlan"]["id"],
            provisioning_subnet_id=oci_core_subnet["test_subnet"]["id"],
            ssh_authorized_keys=var["sddc_ssh_authorized_keys"],
            vmotion_vlan_id=oci_core_vlan["test_vmotion_vlan"]["id"],
            vmware_software_version=var["sddc_vmware_software_version"],
            vsan_vlan_id=oci_core_vlan["test_vsan_vlan"]["id"],
            vsphere_vlan_id=oci_core_vlan["test_vsphere_vlan"]["id"],
            capacity_reservation_id=oci_ocvp_capacity_reservation["test_capacity_reservation"]["id"],
            datastores=[oci.ocvp.SddcDatastoreArgs(
                block_volume_ids=var["sddc_datastores_block_volume_ids"],
                datastore_type=var["sddc_datastores_datastore_type"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["sddc_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            hcx_action=var["hcx_action"],
            hcx_vlan_id=oci_core_vlan["test_vlan"]["id"],
            initial_host_ocpu_count=var["sddc_initial_host_ocpu_count"],
            initial_host_shape_name=oci_core_shape["test_shape"]["name"],
            initial_sku=var["sddc_initial_sku"],
            instance_display_name_prefix=var["sddc_instance_display_name_prefix"],
            is_hcx_enabled=var["sddc_is_hcx_enabled"],
            is_shielded_instance_enabled=var["sddc_is_shielded_instance_enabled"],
            is_single_host_sddc=var["sddc_is_single_host_sddc"],
            provisioning_vlan_id=oci_core_vlan["test_vlan"]["id"],
            refresh_hcx_license_status=True,
            replication_vlan_id=oci_core_vlan["test_vlan"]["id"],
            reserving_hcx_on_premise_license_keys=var["reserving_hcx_on_premise_license_keys"],
            workload_network_cidr=var["sddc_workload_network_cidr"])
        ```

        ## Import

        Sddcs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Ocvp/sddc:Sddc test_sddc "id"
        ```

        :param str resource_name: The name of the resource.
        :param SddcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SddcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            SddcArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcDatastoreArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hcx_action: Optional[pulumi.Input[str]] = None,
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[str]] = None,
                 initial_sku: Optional[pulumi.Input[str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
                 is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
                 is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
                 nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
                 provisioning_subnet_id: Optional[pulumi.Input[str]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[str]] = None,
                 vmotion_vlan_id: Optional[pulumi.Input[str]] = None,
                 vmware_software_version: Optional[pulumi.Input[str]] = None,
                 vsan_vlan_id: Optional[pulumi.Input[str]] = None,
                 vsphere_vlan_id: Optional[pulumi.Input[str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SddcArgs.__new__(SddcArgs)

            __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if compute_availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'compute_availability_domain'")
            __props__.__dict__["compute_availability_domain"] = compute_availability_domain
            __props__.__dict__["datastores"] = datastores
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if esxi_hosts_count is None and not opts.urn:
                raise TypeError("Missing required property 'esxi_hosts_count'")
            __props__.__dict__["esxi_hosts_count"] = esxi_hosts_count
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["hcx_action"] = hcx_action
            __props__.__dict__["hcx_vlan_id"] = hcx_vlan_id
            __props__.__dict__["initial_host_ocpu_count"] = initial_host_ocpu_count
            __props__.__dict__["initial_host_shape_name"] = initial_host_shape_name
            __props__.__dict__["initial_sku"] = initial_sku
            __props__.__dict__["instance_display_name_prefix"] = instance_display_name_prefix
            __props__.__dict__["is_hcx_enabled"] = is_hcx_enabled
            __props__.__dict__["is_shielded_instance_enabled"] = is_shielded_instance_enabled
            __props__.__dict__["is_single_host_sddc"] = is_single_host_sddc
            if nsx_edge_uplink1vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'nsx_edge_uplink1vlan_id'")
            __props__.__dict__["nsx_edge_uplink1vlan_id"] = nsx_edge_uplink1vlan_id
            if nsx_edge_uplink2vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'nsx_edge_uplink2vlan_id'")
            __props__.__dict__["nsx_edge_uplink2vlan_id"] = nsx_edge_uplink2vlan_id
            if nsx_edge_vtep_vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'nsx_edge_vtep_vlan_id'")
            __props__.__dict__["nsx_edge_vtep_vlan_id"] = nsx_edge_vtep_vlan_id
            if nsx_vtep_vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'nsx_vtep_vlan_id'")
            __props__.__dict__["nsx_vtep_vlan_id"] = nsx_vtep_vlan_id
            if provisioning_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'provisioning_subnet_id'")
            __props__.__dict__["provisioning_subnet_id"] = provisioning_subnet_id
            __props__.__dict__["provisioning_vlan_id"] = provisioning_vlan_id
            __props__.__dict__["refresh_hcx_license_status"] = refresh_hcx_license_status
            __props__.__dict__["replication_vlan_id"] = replication_vlan_id
            __props__.__dict__["reserving_hcx_on_premise_license_keys"] = reserving_hcx_on_premise_license_keys
            if ssh_authorized_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_authorized_keys'")
            __props__.__dict__["ssh_authorized_keys"] = ssh_authorized_keys
            if vmotion_vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vmotion_vlan_id'")
            __props__.__dict__["vmotion_vlan_id"] = vmotion_vlan_id
            if vmware_software_version is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_software_version'")
            __props__.__dict__["vmware_software_version"] = vmware_software_version
            if vsan_vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vsan_vlan_id'")
            __props__.__dict__["vsan_vlan_id"] = vsan_vlan_id
            if vsphere_vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vsphere_vlan_id'")
            __props__.__dict__["vsphere_vlan_id"] = vsphere_vlan_id
            __props__.__dict__["workload_network_cidr"] = workload_network_cidr
            __props__.__dict__["actual_esxi_hosts_count"] = None
            __props__.__dict__["hcx_fqdn"] = None
            __props__.__dict__["hcx_initial_password"] = None
            __props__.__dict__["hcx_on_prem_key"] = None
            __props__.__dict__["hcx_on_prem_licenses"] = None
            __props__.__dict__["hcx_private_ip_id"] = None
            __props__.__dict__["is_hcx_enterprise_enabled"] = None
            __props__.__dict__["is_hcx_pending_downgrade"] = None
            __props__.__dict__["nsx_edge_uplink_ip_id"] = None
            __props__.__dict__["nsx_manager_fqdn"] = None
            __props__.__dict__["nsx_manager_initial_password"] = None
            __props__.__dict__["nsx_manager_private_ip_id"] = None
            __props__.__dict__["nsx_manager_username"] = None
            __props__.__dict__["nsx_overlay_segment_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_hcx_billing_cycle_end"] = None
            __props__.__dict__["time_hcx_license_status_updated"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["upgrade_licenses"] = None
            __props__.__dict__["vcenter_fqdn"] = None
            __props__.__dict__["vcenter_initial_password"] = None
            __props__.__dict__["vcenter_private_ip_id"] = None
            __props__.__dict__["vcenter_username"] = None
            __props__.__dict__["vsphere_upgrade_guide"] = None
            __props__.__dict__["vsphere_upgrade_objects"] = None
        super(Sddc, __self__).__init__(
            'oci:Ocvp/sddc:Sddc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actual_esxi_hosts_count: Optional[pulumi.Input[int]] = None,
            capacity_reservation_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_availability_domain: Optional[pulumi.Input[str]] = None,
            datastores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcDatastoreArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            esxi_hosts_count: Optional[pulumi.Input[int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hcx_action: Optional[pulumi.Input[str]] = None,
            hcx_fqdn: Optional[pulumi.Input[str]] = None,
            hcx_initial_password: Optional[pulumi.Input[str]] = None,
            hcx_on_prem_key: Optional[pulumi.Input[str]] = None,
            hcx_on_prem_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcHcxOnPremLicenseArgs']]]]] = None,
            hcx_private_ip_id: Optional[pulumi.Input[str]] = None,
            hcx_vlan_id: Optional[pulumi.Input[str]] = None,
            initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
            initial_host_shape_name: Optional[pulumi.Input[str]] = None,
            initial_sku: Optional[pulumi.Input[str]] = None,
            instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
            is_hcx_enabled: Optional[pulumi.Input[bool]] = None,
            is_hcx_enterprise_enabled: Optional[pulumi.Input[bool]] = None,
            is_hcx_pending_downgrade: Optional[pulumi.Input[bool]] = None,
            is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
            is_single_host_sddc: Optional[pulumi.Input[bool]] = None,
            nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
            nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
            nsx_edge_uplink_ip_id: Optional[pulumi.Input[str]] = None,
            nsx_edge_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
            nsx_manager_fqdn: Optional[pulumi.Input[str]] = None,
            nsx_manager_initial_password: Optional[pulumi.Input[str]] = None,
            nsx_manager_private_ip_id: Optional[pulumi.Input[str]] = None,
            nsx_manager_username: Optional[pulumi.Input[str]] = None,
            nsx_overlay_segment_name: Optional[pulumi.Input[str]] = None,
            nsx_vtep_vlan_id: Optional[pulumi.Input[str]] = None,
            provisioning_subnet_id: Optional[pulumi.Input[str]] = None,
            provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
            refresh_hcx_license_status: Optional[pulumi.Input[bool]] = None,
            replication_vlan_id: Optional[pulumi.Input[str]] = None,
            reserving_hcx_on_premise_license_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ssh_authorized_keys: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_hcx_billing_cycle_end: Optional[pulumi.Input[str]] = None,
            time_hcx_license_status_updated: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            upgrade_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcUpgradeLicenseArgs']]]]] = None,
            vcenter_fqdn: Optional[pulumi.Input[str]] = None,
            vcenter_initial_password: Optional[pulumi.Input[str]] = None,
            vcenter_private_ip_id: Optional[pulumi.Input[str]] = None,
            vcenter_username: Optional[pulumi.Input[str]] = None,
            vmotion_vlan_id: Optional[pulumi.Input[str]] = None,
            vmware_software_version: Optional[pulumi.Input[str]] = None,
            vsan_vlan_id: Optional[pulumi.Input[str]] = None,
            vsphere_upgrade_guide: Optional[pulumi.Input[str]] = None,
            vsphere_upgrade_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcVsphereUpgradeObjectArgs']]]]] = None,
            vsphere_vlan_id: Optional[pulumi.Input[str]] = None,
            workload_network_cidr: Optional[pulumi.Input[str]] = None) -> 'Sddc':
        """
        Get an existing Sddc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] actual_esxi_hosts_count: The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcDatastoreArgs']]]] datastores: A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[int] esxi_hosts_count: The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.
               
               **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hcx_action: (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        :param pulumi.Input[str] hcx_fqdn: The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] hcx_initial_password: The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        :param pulumi.Input[str] hcx_on_prem_key: The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcHcxOnPremLicenseArgs']]]] hcx_on_prem_licenses: The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        :param pulumi.Input[str] hcx_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        :param pulumi.Input[float] initial_host_ocpu_count: The initial OCPU count of the SDDC's ESXi hosts.
        :param pulumi.Input[str] initial_host_shape_name: The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] initial_sku: The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        :param pulumi.Input[str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.
               
               For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        :param pulumi.Input[bool] is_hcx_enabled: For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        :param pulumi.Input[bool] is_hcx_enterprise_enabled: Indicates whether HCX Enterprise is enabled for this SDDC.
        :param pulumi.Input[bool] is_hcx_pending_downgrade: Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        :param pulumi.Input[bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this SDDC.
        :param pulumi.Input[bool] is_single_host_sddc: Indicates whether this SDDC is designated for only single ESXi host.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.
               
               **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        :param pulumi.Input[str] nsx_edge_uplink_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        :param pulumi.Input[str] nsx_manager_fqdn: The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] nsx_manager_initial_password: The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        :param pulumi.Input[str] nsx_manager_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] nsx_manager_username: The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        :param pulumi.Input[str] nsx_overlay_segment_name: The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        :param pulumi.Input[str] nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        :param pulumi.Input[str] provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        :param pulumi.Input[str] provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        :param pulumi.Input[bool] refresh_hcx_license_status: (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        :param pulumi.Input[str] replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reserving_hcx_on_premise_license_keys: (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        :param pulumi.Input[str] ssh_authorized_keys: (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        :param pulumi.Input[str] state: The current state of the SDDC.
        :param pulumi.Input[str] time_created: The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_hcx_billing_cycle_end: The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_hcx_license_status_updated: The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcUpgradeLicenseArgs']]]] upgrade_licenses: The vSphere licenses to use when upgrading the SDDC.
        :param pulumi.Input[str] vcenter_fqdn: The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        :param pulumi.Input[str] vcenter_initial_password: The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        :param pulumi.Input[str] vcenter_private_ip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        :param pulumi.Input[str] vcenter_username: The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        :param pulumi.Input[str] vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        :param pulumi.Input[str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[str] vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        :param pulumi.Input[str] vsphere_upgrade_guide: The link to guidance for upgrading vSphere.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SddcVsphereUpgradeObjectArgs']]]] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param pulumi.Input[str] vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        :param pulumi.Input[str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SddcState.__new__(_SddcState)

        __props__.__dict__["actual_esxi_hosts_count"] = actual_esxi_hosts_count
        __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_availability_domain"] = compute_availability_domain
        __props__.__dict__["datastores"] = datastores
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["esxi_hosts_count"] = esxi_hosts_count
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hcx_action"] = hcx_action
        __props__.__dict__["hcx_fqdn"] = hcx_fqdn
        __props__.__dict__["hcx_initial_password"] = hcx_initial_password
        __props__.__dict__["hcx_on_prem_key"] = hcx_on_prem_key
        __props__.__dict__["hcx_on_prem_licenses"] = hcx_on_prem_licenses
        __props__.__dict__["hcx_private_ip_id"] = hcx_private_ip_id
        __props__.__dict__["hcx_vlan_id"] = hcx_vlan_id
        __props__.__dict__["initial_host_ocpu_count"] = initial_host_ocpu_count
        __props__.__dict__["initial_host_shape_name"] = initial_host_shape_name
        __props__.__dict__["initial_sku"] = initial_sku
        __props__.__dict__["instance_display_name_prefix"] = instance_display_name_prefix
        __props__.__dict__["is_hcx_enabled"] = is_hcx_enabled
        __props__.__dict__["is_hcx_enterprise_enabled"] = is_hcx_enterprise_enabled
        __props__.__dict__["is_hcx_pending_downgrade"] = is_hcx_pending_downgrade
        __props__.__dict__["is_shielded_instance_enabled"] = is_shielded_instance_enabled
        __props__.__dict__["is_single_host_sddc"] = is_single_host_sddc
        __props__.__dict__["nsx_edge_uplink1vlan_id"] = nsx_edge_uplink1vlan_id
        __props__.__dict__["nsx_edge_uplink2vlan_id"] = nsx_edge_uplink2vlan_id
        __props__.__dict__["nsx_edge_uplink_ip_id"] = nsx_edge_uplink_ip_id
        __props__.__dict__["nsx_edge_vtep_vlan_id"] = nsx_edge_vtep_vlan_id
        __props__.__dict__["nsx_manager_fqdn"] = nsx_manager_fqdn
        __props__.__dict__["nsx_manager_initial_password"] = nsx_manager_initial_password
        __props__.__dict__["nsx_manager_private_ip_id"] = nsx_manager_private_ip_id
        __props__.__dict__["nsx_manager_username"] = nsx_manager_username
        __props__.__dict__["nsx_overlay_segment_name"] = nsx_overlay_segment_name
        __props__.__dict__["nsx_vtep_vlan_id"] = nsx_vtep_vlan_id
        __props__.__dict__["provisioning_subnet_id"] = provisioning_subnet_id
        __props__.__dict__["provisioning_vlan_id"] = provisioning_vlan_id
        __props__.__dict__["refresh_hcx_license_status"] = refresh_hcx_license_status
        __props__.__dict__["replication_vlan_id"] = replication_vlan_id
        __props__.__dict__["reserving_hcx_on_premise_license_keys"] = reserving_hcx_on_premise_license_keys
        __props__.__dict__["ssh_authorized_keys"] = ssh_authorized_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_hcx_billing_cycle_end"] = time_hcx_billing_cycle_end
        __props__.__dict__["time_hcx_license_status_updated"] = time_hcx_license_status_updated
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upgrade_licenses"] = upgrade_licenses
        __props__.__dict__["vcenter_fqdn"] = vcenter_fqdn
        __props__.__dict__["vcenter_initial_password"] = vcenter_initial_password
        __props__.__dict__["vcenter_private_ip_id"] = vcenter_private_ip_id
        __props__.__dict__["vcenter_username"] = vcenter_username
        __props__.__dict__["vmotion_vlan_id"] = vmotion_vlan_id
        __props__.__dict__["vmware_software_version"] = vmware_software_version
        __props__.__dict__["vsan_vlan_id"] = vsan_vlan_id
        __props__.__dict__["vsphere_upgrade_guide"] = vsphere_upgrade_guide
        __props__.__dict__["vsphere_upgrade_objects"] = vsphere_upgrade_objects
        __props__.__dict__["vsphere_vlan_id"] = vsphere_vlan_id
        __props__.__dict__["workload_network_cidr"] = workload_network_cidr
        return Sddc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> pulumi.Output[int]:
        """
        The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the SDDC.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain to create the SDDC's ESXi hosts in. For multi-AD SDDC deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> pulumi.Output[Sequence['outputs.SddcDatastore']]:
        """
        A list of datastore info for the SDDC. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A descriptive name for the SDDC. SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> pulumi.Output[int]:
        """
        The number of ESXi hosts to create in the SDDC. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a SDDC with a ESXi host count of 1 will be considered a single ESXi host SDDC.

        **Note:** If you later delete EXSi hosts from a production SDDC to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the SDDC until it again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hcxAction")
    def hcx_action(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The action to be performed upon HCX licenses. "UPGRADE" will upgrade the SDDC from HCX Advanced to HCX Enterprise. "DOWNGRADE" will downgrade the SDDC from HCX Enterprise to HCX Advanced after current HCX Enterprise billing cycle end date. "CANCEL_DOWNGRADE" will cancel the pending downgrade of HCX licenses. The action will only be performed when its value is changed. This field can also be used to enable HCX Enterprise during SDDC creation. If "UPGRADE" is set during SDDC creation, the SDDC will be created with HCX Enterprise enable. Supported actions during update: UPGRADE, DOWNGRADE, CANCEL_DOWNGRADE. Supported actions during creation: UPGRADE.
        """
        return pulumi.get(self, "hcx_action")

    @property
    @pulumi.getter(name="hcxFqdn")
    def hcx_fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN for HCX Manager.  Example: `hcx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "hcx_fqdn")

    @property
    @pulumi.getter(name="hcxInitialPassword")
    def hcx_initial_password(self) -> pulumi.Output[str]:
        """
        The SDDC includes an administrator username and initial password for HCX Manager. Make sure to change this initial HCX Manager password to a different value.
        """
        return pulumi.get(self, "hcx_initial_password")

    @property
    @pulumi.getter(name="hcxOnPremKey")
    def hcx_on_prem_key(self) -> pulumi.Output[str]:
        """
        The activation keys to use on the on-premises HCX Enterprise appliances you site pair with HCX Manager in your VMware Solution. The number of keys provided depends on the HCX license type. HCX Advanced provides 3 activation keys. HCX Enterprise provides 10 activation keys.
        """
        return pulumi.get(self, "hcx_on_prem_key")

    @property
    @pulumi.getter(name="hcxOnPremLicenses")
    def hcx_on_prem_licenses(self) -> pulumi.Output[Sequence['outputs.SddcHcxOnPremLicense']]:
        """
        The activation licenses to use on the on-premises HCX Enterprise appliance you site pair with HCX Manager in your VMware Solution.
        """
        return pulumi.get(self, "hcx_on_prem_licenses")

    @property
    @pulumi.getter(name="hcxPrivateIpId")
    def hcx_private_ip_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for HCX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "hcx_private_ip_id")

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the HCX component of the VMware environment. This value is required only when `isHcxEnabled` is true.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> pulumi.Output[float]:
        """
        The initial OCPU count of the SDDC's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> pulumi.Output[str]:
        """
        The initial compute shape of the SDDC's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="initialSku")
    def initial_sku(self) -> pulumi.Output[str]:
        """
        The billing option selected during SDDC creation. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        return pulumi.get(self, "initial_sku")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> pulumi.Output[str]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the SDDC. If this isn't set, the SDDC's `displayName` is used as the prefix.

        For example, if the value is `mySDDC`, the ESXi hosts are named `mySDDC-1`, `mySDDC-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isHcxEnabled")
    def is_hcx_enabled(self) -> pulumi.Output[bool]:
        """
        For SDDC with dense compute shapes, this parameter indicates whether to enable HCX Advanced for this SDDC. For SDDC with standard compute shapes, this parameter is equivalent to `isHcxEnterpriseEnabled`.
        """
        return pulumi.get(self, "is_hcx_enabled")

    @property
    @pulumi.getter(name="isHcxEnterpriseEnabled")
    def is_hcx_enterprise_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether HCX Enterprise is enabled for this SDDC.
        """
        return pulumi.get(self, "is_hcx_enterprise_enabled")

    @property
    @pulumi.getter(name="isHcxPendingDowngrade")
    def is_hcx_pending_downgrade(self) -> pulumi.Output[bool]:
        """
        Indicates whether SDDC is pending downgrade from HCX Enterprise to HCX Advanced.
        """
        return pulumi.get(self, "is_hcx_pending_downgrade")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether shielded instance is enabled for this SDDC.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="isSingleHostSddc")
    def is_single_host_sddc(self) -> pulumi.Output[bool]:
        """
        Indicates whether this SDDC is designated for only single ESXi host.
        """
        return pulumi.get(self, "is_single_host_sddc")

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 1 component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge Uplink 2 component of the VMware environment.

        **Note:** This VLAN is reserved for future use to deploy public-facing applications on the VMware SDDC.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @property
    @pulumi.getter(name="nsxEdgeUplinkIpId")
    def nsx_edge_uplink_ip_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for the NSX Edge Uplink. Use this OCID as the route target for route table rules when setting up connectivity between the SDDC and other networks. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_edge_uplink_ip_id")

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX Edge VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @property
    @pulumi.getter(name="nsxManagerFqdn")
    def nsx_manager_fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN for NSX Manager.  Example: `nsx-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "nsx_manager_fqdn")

    @property
    @pulumi.getter(name="nsxManagerInitialPassword")
    def nsx_manager_initial_password(self) -> pulumi.Output[str]:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. Make sure to change this initial NSX Manager password to a different value.
        """
        return pulumi.get(self, "nsx_manager_initial_password")

    @property
    @pulumi.getter(name="nsxManagerPrivateIpId")
    def nsx_manager_private_ip_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for NSX Manager. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "nsx_manager_private_ip_id")

    @property
    @pulumi.getter(name="nsxManagerUsername")
    def nsx_manager_username(self) -> pulumi.Output[str]:
        """
        The SDDC includes an administrator username and initial password for NSX Manager. You can change this initial username to a different value in NSX Manager.
        """
        return pulumi.get(self, "nsx_manager_username")

    @property
    @pulumi.getter(name="nsxOverlaySegmentName")
    def nsx_overlay_segment_name(self) -> pulumi.Output[str]:
        """
        The VMware NSX overlay workload segment to host your application. Connect to workload portgroup in vCenter to access this overlay segment.
        """
        return pulumi.get(self, "nsx_overlay_segment_name")

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the NSX VTEP component of the VMware environment.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet to use for provisioning the SDDC.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @property
    @pulumi.getter(name="refreshHcxLicenseStatus")
    def refresh_hcx_license_status(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) HCX on-premise licenses status will be refreshed whenever the value of this field is changed.
        """
        return pulumi.get(self, "refresh_hcx_license_status")

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @property
    @pulumi.getter(name="reservingHcxOnPremiseLicenseKeys")
    def reserving_hcx_on_premise_license_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) The HCX on-premise licenses to be reserved when downgrade from HCX Enterprise to HCX Advanced. It should not be provided during resource creation. It is required and can only be set when the hcx_action is "DOWNGRADE". Its value can only be changed when hcx_action is updated.
        """
        return pulumi.get(self, "reserving_hcx_on_premise_license_keys")

    @property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> pulumi.Output[str]:
        """
        (Updatable) One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on each ESXi host. Use a newline character to separate multiple keys. The SSH keys must be in the format required for the `authorized_keys` file
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the SDDC.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the SDDC was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeHcxBillingCycleEnd")
    def time_hcx_billing_cycle_end(self) -> pulumi.Output[str]:
        """
        The date and time current HCX Enterprise billing cycle ends, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_billing_cycle_end")

    @property
    @pulumi.getter(name="timeHcxLicenseStatusUpdated")
    def time_hcx_license_status_updated(self) -> pulumi.Output[str]:
        """
        The date and time the SDDC's HCX on-premise license status was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_hcx_license_status_updated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the SDDC was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> pulumi.Output[Sequence['outputs.SddcUpgradeLicense']]:
        """
        The vSphere licenses to use when upgrading the SDDC.
        """
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vcenterFqdn")
    def vcenter_fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN for vCenter.  Example: `vcenter-my-sddc.sddc.us-phoenix-1.oraclecloud.com`
        """
        return pulumi.get(self, "vcenter_fqdn")

    @property
    @pulumi.getter(name="vcenterInitialPassword")
    def vcenter_initial_password(self) -> pulumi.Output[str]:
        """
        The SDDC includes an administrator username and initial password for vCenter. Make sure to change this initial vCenter password to a different value.
        """
        return pulumi.get(self, "vcenter_initial_password")

    @property
    @pulumi.getter(name="vcenterPrivateIpId")
    def vcenter_private_ip_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `PrivateIp` object that is the virtual IP (VIP) for vCenter. For information about `PrivateIp` objects, see the Core Services API.
        """
        return pulumi.get(self, "vcenter_private_ip_id")

    @property
    @pulumi.getter(name="vcenterUsername")
    def vcenter_username(self) -> pulumi.Output[str]:
        """
        The SDDC includes an administrator username and initial password for vCenter. You can change this initial username to a different value in vCenter.
        """
        return pulumi.get(self, "vcenter_username")

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vMotion component of the VMware environment.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the SDDC. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSAN component of the VMware environment.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @property
    @pulumi.getter(name="vsphereUpgradeGuide")
    def vsphere_upgrade_guide(self) -> pulumi.Output[str]:
        """
        The link to guidance for upgrading vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_guide")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> pulumi.Output[Sequence['outputs.SddcVsphereUpgradeObject']]:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN to use for the vSphere component of the VMware environment.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block for the IP addresses that VMware VMs in the SDDC use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

