# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DatabaseInsightConnectionCredentialDetailsArgs',
    'DatabaseInsightConnectionDetailsArgs',
    'DatabaseInsightConnectionDetailsHostArgs',
    'DatabaseInsightCredentialDetailsArgs',
    'ExadataInsightMemberVmClusterDetailArgs',
    'ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs',
    'ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs',
    'ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs',
    'ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs',
    'NewsReportContentTypesArgs',
    'OpsiConfigurationConfigItemArgs',
    'OpsiConfigurationConfigItemMetadataArgs',
    'OpsiConfigurationConfigItemMetadataUnitDetailArgs',
    'OpsiConfigurationConfigItemMetadataValueInputDetailArgs',
    'GetAwrHubAwrSnapshotsFilterArgs',
    'GetAwrHubsFilterArgs',
    'GetDatabaseInsightsFilterArgs',
    'GetEnterpriseManagerBridgesFilterArgs',
    'GetExadataInsightsFilterArgs',
    'GetHostInsightsFilterArgs',
    'GetNewsReportsFilterArgs',
    'GetOperationsInsightsPrivateEndpointsFilterArgs',
    'GetOperationsInsightsWarehouseUsersFilterArgs',
    'GetOperationsInsightsWarehousesFilterArgs',
    'GetOpsiConfigurationsFilterArgs',
]

@pulumi.input_type
class DatabaseInsightConnectionCredentialDetailsArgs:
    def __init__(__self__, *,
                 credential_source_name: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 wallet_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_source_name: Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        :param pulumi.Input[str] credential_type: Credential type.
        :param pulumi.Input[str] password_secret_id: The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        :param pulumi.Input[str] role: database user role.
        :param pulumi.Input[str] user_name: database user name.
        :param pulumi.Input[str] wallet_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        DatabaseInsightConnectionCredentialDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_source_name=credential_source_name,
            credential_type=credential_type,
            password_secret_id=password_secret_id,
            role=role,
            user_name=user_name,
            wallet_secret_id=wallet_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_source_name: Optional[pulumi.Input[str]] = None,
             credential_type: Optional[pulumi.Input[str]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             role: Optional[pulumi.Input[str]] = None,
             user_name: Optional[pulumi.Input[str]] = None,
             wallet_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if credential_source_name is not None:
            _setter("credential_source_name", credential_source_name)
        if credential_type is not None:
            _setter("credential_type", credential_type)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if role is not None:
            _setter("role", role)
        if user_name is not None:
            _setter("user_name", user_name)
        if wallet_secret_id is not None:
            _setter("wallet_secret_id", wallet_secret_id)

    @property
    @pulumi.getter(name="credentialSourceName")
    def credential_source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        """
        return pulumi.get(self, "credential_source_name")

    @credential_source_name.setter
    def credential_source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_source_name", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[str]]:
        """
        Credential type.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        database user role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        database user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="walletSecretId")
    def wallet_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        return pulumi.get(self, "wallet_secret_id")

    @wallet_secret_id.setter
    def wallet_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_secret_id", value)


@pulumi.input_type
class DatabaseInsightConnectionDetailsArgs:
    def __init__(__self__, *,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInsightConnectionDetailsHostArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_name: Name of the listener host that will be used to create the connect string to the database.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseInsightConnectionDetailsHostArgs']]] hosts: List of hosts and port for private endpoint accessed database resource.
        :param pulumi.Input[int] port: Listener port number used for connection requests for rivate endpoint accessed db resource.
        :param pulumi.Input[str] protocol: Protocol used for connection requests for private endpoint accssed database resource.
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        """
        DatabaseInsightConnectionDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host_name=host_name,
            hosts=hosts,
            port=port,
            protocol=protocol,
            service_name=service_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host_name: Optional[pulumi.Input[str]] = None,
             hosts: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInsightConnectionDetailsHostArgs']]]] = None,
             port: Optional[pulumi.Input[int]] = None,
             protocol: Optional[pulumi.Input[str]] = None,
             service_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if host_name is not None:
            _setter("host_name", host_name)
        if hosts is not None:
            _setter("hosts", hosts)
        if port is not None:
            _setter("port", port)
        if protocol is not None:
            _setter("protocol", protocol)
        if service_name is not None:
            _setter("service_name", service_name)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the listener host that will be used to create the connect string to the database.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInsightConnectionDetailsHostArgs']]]]:
        """
        List of hosts and port for private endpoint accessed database resource.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseInsightConnectionDetailsHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Listener port number used for connection requests for rivate endpoint accessed db resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used for connection requests for private endpoint accssed database resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class DatabaseInsightConnectionDetailsHostArgs:
    def __init__(__self__, *,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] host_ip: Host IP used for connection requests for Cloud DB resource.
        :param pulumi.Input[int] port: Listener port number used for connection requests for rivate endpoint accessed db resource.
        """
        DatabaseInsightConnectionDetailsHostArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host_ip=host_ip,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host_ip: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if host_ip is not None:
            _setter("host_ip", host_ip)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Host IP used for connection requests for Cloud DB resource.
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Listener port number used for connection requests for rivate endpoint accessed db resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class DatabaseInsightCredentialDetailsArgs:
    def __init__(__self__, *,
                 credential_type: pulumi.Input[str],
                 credential_source_name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 wallet_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: Credential type.
        :param pulumi.Input[str] credential_source_name: Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        :param pulumi.Input[str] password_secret_id: The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        :param pulumi.Input[str] role: database user role.
        :param pulumi.Input[str] user_name: database user name.
        :param pulumi.Input[str] wallet_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        DatabaseInsightCredentialDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_type=credential_type,
            credential_source_name=credential_source_name,
            password_secret_id=password_secret_id,
            role=role,
            user_name=user_name,
            wallet_secret_id=wallet_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_type: pulumi.Input[str],
             credential_source_name: Optional[pulumi.Input[str]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             role: Optional[pulumi.Input[str]] = None,
             user_name: Optional[pulumi.Input[str]] = None,
             wallet_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("credential_type", credential_type)
        if credential_source_name is not None:
            _setter("credential_source_name", credential_source_name)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if role is not None:
            _setter("role", role)
        if user_name is not None:
            _setter("user_name", user_name)
        if wallet_secret_id is not None:
            _setter("wallet_secret_id", wallet_secret_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        Credential type.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="credentialSourceName")
    def credential_source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        """
        return pulumi.get(self, "credential_source_name")

    @credential_source_name.setter
    def credential_source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_source_name", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        database user role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        database user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="walletSecretId")
    def wallet_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        return pulumi.get(self, "wallet_secret_id")

    @wallet_secret_id.setter
    def wallet_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_secret_id", value)


@pulumi.input_type
class ExadataInsightMemberVmClusterDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 member_database_details: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs']]]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vmcluster_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs']]] member_database_details: The databases that belong to the VM Cluster
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] vmcluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster.
        """
        ExadataInsightMemberVmClusterDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            dbm_private_endpoint_id=dbm_private_endpoint_id,
            member_database_details=member_database_details,
            opsi_private_endpoint_id=opsi_private_endpoint_id,
            vmcluster_id=vmcluster_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
             member_database_details: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs']]]] = None,
             opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
             vmcluster_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if dbm_private_endpoint_id is not None:
            _setter("dbm_private_endpoint_id", dbm_private_endpoint_id)
        if member_database_details is not None:
            _setter("member_database_details", member_database_details)
        if opsi_private_endpoint_id is not None:
            _setter("opsi_private_endpoint_id", opsi_private_endpoint_id)
        if vmcluster_id is not None:
            _setter("vmcluster_id", vmcluster_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbmPrivateEndpointId")
    def dbm_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint
        """
        return pulumi.get(self, "dbm_private_endpoint_id")

    @dbm_private_endpoint_id.setter
    def dbm_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbm_private_endpoint_id", value)

    @property
    @pulumi.getter(name="memberDatabaseDetails")
    def member_database_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs']]]]:
        """
        The databases that belong to the VM Cluster
        """
        return pulumi.get(self, "member_database_details")

    @member_database_details.setter
    def member_database_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs']]]]):
        pulumi.set(self, "member_database_details", value)

    @property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @opsi_private_endpoint_id.setter
    def opsi_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsi_private_endpoint_id", value)

    @property
    @pulumi.getter(name="vmclusterId")
    def vmcluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster.
        """
        return pulumi.get(self, "vmcluster_id")

    @vmcluster_id.setter
    def vmcluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmcluster_id", value)


@pulumi.input_type
class ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_details: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs']] = None,
                 credential_details: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs']] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_resource_type: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs'] connection_details: Connection details of the private endpoints.
        :param pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs'] credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[str] database_resource_type: Oracle Cloud Infrastructure database resource type
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_type: Database Deployment Type
        :param pulumi.Input[str] entity_source: Source of the database entity.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            connection_details=connection_details,
            credential_details=credential_details,
            database_id=database_id,
            database_resource_type=database_resource_type,
            dbm_private_endpoint_id=dbm_private_endpoint_id,
            defined_tags=defined_tags,
            deployment_type=deployment_type,
            entity_source=entity_source,
            freeform_tags=freeform_tags,
            opsi_private_endpoint_id=opsi_private_endpoint_id,
            service_name=service_name,
            system_tags=system_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             connection_details: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs']] = None,
             credential_details: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs']] = None,
             database_id: Optional[pulumi.Input[str]] = None,
             database_resource_type: Optional[pulumi.Input[str]] = None,
             dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             deployment_type: Optional[pulumi.Input[str]] = None,
             entity_source: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
             service_name: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if connection_details is not None:
            _setter("connection_details", connection_details)
        if credential_details is not None:
            _setter("credential_details", credential_details)
        if database_id is not None:
            _setter("database_id", database_id)
        if database_resource_type is not None:
            _setter("database_resource_type", database_resource_type)
        if dbm_private_endpoint_id is not None:
            _setter("dbm_private_endpoint_id", dbm_private_endpoint_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if deployment_type is not None:
            _setter("deployment_type", deployment_type)
        if entity_source is not None:
            _setter("entity_source", entity_source)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if opsi_private_endpoint_id is not None:
            _setter("opsi_private_endpoint_id", opsi_private_endpoint_id)
        if service_name is not None:
            _setter("service_name", service_name)
        if system_tags is not None:
            _setter("system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs']]:
        """
        Connection details of the private endpoints.
        """
        return pulumi.get(self, "connection_details")

    @connection_details.setter
    def connection_details(self, value: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs']]):
        pulumi.set(self, "connection_details", value)

    @property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "credential_details")

    @credential_details.setter
    def credential_details(self, value: Optional[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs']]):
        pulumi.set(self, "credential_details", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseResourceType")
    def database_resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Cloud Infrastructure database resource type
        """
        return pulumi.get(self, "database_resource_type")

    @database_resource_type.setter
    def database_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_resource_type", value)

    @property
    @pulumi.getter(name="dbmPrivateEndpointId")
    def dbm_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint
        """
        return pulumi.get(self, "dbm_private_endpoint_id")

    @dbm_private_endpoint_id.setter
    def dbm_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbm_private_endpoint_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Database Deployment Type
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> Optional[pulumi.Input[str]]:
        """
        Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @opsi_private_endpoint_id.setter
    def opsi_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsi_private_endpoint_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs:
    def __init__(__self__, *,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs']]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs']]] hosts: List of hosts and port for private endpoint accessed database resource.
        :param pulumi.Input[str] protocol: Protocol used for connection requests for private endpoint accssed database resource.
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        """
        ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hosts=hosts,
            protocol=protocol,
            service_name=service_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hosts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs']]]] = None,
             protocol: Optional[pulumi.Input[str]] = None,
             service_name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if hosts is not None:
            _setter("hosts", hosts)
        if protocol is not None:
            _setter("protocol", protocol)
        if service_name is not None:
            _setter("service_name", service_name)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs']]]]:
        """
        List of hosts and port for private endpoint accessed database resource.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used for connection requests for private endpoint accssed database resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs:
    def __init__(__self__, *,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] host_ip: Host IP used for connection requests for Cloud DB resource.
        :param pulumi.Input[int] port: Listener port number used for connection requests for rivate endpoint accessed db resource.
        """
        ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host_ip=host_ip,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host_ip: Optional[pulumi.Input[str]] = None,
             port: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if host_ip is not None:
            _setter("host_ip", host_ip)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Host IP used for connection requests for Cloud DB resource.
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Listener port number used for connection requests for rivate endpoint accessed db resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs:
    def __init__(__self__, *,
                 credential_type: pulumi.Input[str],
                 credential_source_name: Optional[pulumi.Input[str]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 wallet_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: Credential type.
        :param pulumi.Input[str] credential_source_name: Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        :param pulumi.Input[str] password_secret_id: The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        :param pulumi.Input[str] role: database user role.
        :param pulumi.Input[str] user_name: database user name.
        :param pulumi.Input[str] wallet_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_type=credential_type,
            credential_source_name=credential_source_name,
            password_secret_id=password_secret_id,
            role=role,
            user_name=user_name,
            wallet_secret_id=wallet_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_type: pulumi.Input[str],
             credential_source_name: Optional[pulumi.Input[str]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             role: Optional[pulumi.Input[str]] = None,
             user_name: Optional[pulumi.Input[str]] = None,
             wallet_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("credential_type", credential_type)
        if credential_source_name is not None:
            _setter("credential_source_name", credential_source_name)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if role is not None:
            _setter("role", role)
        if user_name is not None:
            _setter("user_name", user_name)
        if wallet_secret_id is not None:
            _setter("wallet_secret_id", wallet_secret_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        Credential type.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="credentialSourceName")
    def credential_source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Credential source name that had been added in Management Agent wallet. This is supplied in the External Database Service.
        """
        return pulumi.get(self, "credential_source_name")

    @credential_source_name.setter
    def credential_source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_source_name", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The secret [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) mapping to the database credentials.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        database user role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        database user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="walletSecretId")
    def wallet_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the database keystore contents are stored.
        """
        return pulumi.get(self, "wallet_secret_id")

    @wallet_secret_id.setter
    def wallet_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_secret_id", value)


@pulumi.input_type
class NewsReportContentTypesArgs:
    def __init__(__self__, *,
                 capacity_planning_resources: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capacity_planning_resources: (Updatable) Supported resources for capacity planning content type.
        """
        NewsReportContentTypesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacity_planning_resources=capacity_planning_resources,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacity_planning_resources: pulumi.Input[Sequence[pulumi.Input[str]]],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("capacity_planning_resources", capacity_planning_resources)

    @property
    @pulumi.getter(name="capacityPlanningResources")
    def capacity_planning_resources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) Supported resources for capacity planning content type.
        """
        return pulumi.get(self, "capacity_planning_resources")

    @capacity_planning_resources.setter
    def capacity_planning_resources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "capacity_planning_resources", value)


@pulumi.input_type
class OpsiConfigurationConfigItemArgs:
    def __init__(__self__, *,
                 config_item_type: pulumi.Input[str],
                 applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] config_item_type: (Updatable) Type of configuration item.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applicable_contexts: List of contexts in Operations Insights where this configuration item is applicable.
        :param pulumi.Input[str] default_value: Value of configuration item.
        :param pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataArgs']]] metadatas: Configuration item metadata.
        :param pulumi.Input[str] name: (Updatable) Name of configuration item.
        :param pulumi.Input[str] value: (Updatable) Value of configuration item.
        """
        OpsiConfigurationConfigItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config_item_type=config_item_type,
            applicable_contexts=applicable_contexts,
            default_value=default_value,
            metadatas=metadatas,
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config_item_type: pulumi.Input[str],
             applicable_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             default_value: Optional[pulumi.Input[str]] = None,
             metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataArgs']]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("config_item_type", config_item_type)
        if applicable_contexts is not None:
            _setter("applicable_contexts", applicable_contexts)
        if default_value is not None:
            _setter("default_value", default_value)
        if metadatas is not None:
            _setter("metadatas", metadatas)
        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter(name="configItemType")
    def config_item_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of configuration item.
        """
        return pulumi.get(self, "config_item_type")

    @config_item_type.setter
    def config_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_item_type", value)

    @property
    @pulumi.getter(name="applicableContexts")
    def applicable_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of contexts in Operations Insights where this configuration item is applicable.
        """
        return pulumi.get(self, "applicable_contexts")

    @applicable_contexts.setter
    def applicable_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "applicable_contexts", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of configuration item.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataArgs']]]]:
        """
        Configuration item metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of configuration item.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value of configuration item.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OpsiConfigurationConfigItemMetadataArgs:
    def __init__(__self__, *,
                 config_item_type: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 unit_details: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataUnitDetailArgs']]]] = None,
                 value_input_details: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataValueInputDetailArgs']]]] = None):
        """
        :param pulumi.Input[str] config_item_type: (Updatable) Type of configuration item.
        :param pulumi.Input[str] data_type: Data type of configuration item. Examples: STRING, BOOLEAN, NUMBER
        :param pulumi.Input[str] description: (Updatable) Description of OPSI configuration.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataUnitDetailArgs']]] unit_details: Unit details of configuration item.
        :param pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataValueInputDetailArgs']]] value_input_details: Allowed value details of configuration item, to validate what value can be assigned to a configuration item.
        """
        OpsiConfigurationConfigItemMetadataArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            config_item_type=config_item_type,
            data_type=data_type,
            description=description,
            display_name=display_name,
            unit_details=unit_details,
            value_input_details=value_input_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             config_item_type: Optional[pulumi.Input[str]] = None,
             data_type: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             unit_details: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataUnitDetailArgs']]]] = None,
             value_input_details: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataValueInputDetailArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if config_item_type is not None:
            _setter("config_item_type", config_item_type)
        if data_type is not None:
            _setter("data_type", data_type)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if unit_details is not None:
            _setter("unit_details", unit_details)
        if value_input_details is not None:
            _setter("value_input_details", value_input_details)

    @property
    @pulumi.getter(name="configItemType")
    def config_item_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of configuration item.
        """
        return pulumi.get(self, "config_item_type")

    @config_item_type.setter
    def config_item_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_item_type", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        Data type of configuration item. Examples: STRING, BOOLEAN, NUMBER
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of OPSI configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="unitDetails")
    def unit_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataUnitDetailArgs']]]]:
        """
        Unit details of configuration item.
        """
        return pulumi.get(self, "unit_details")

    @unit_details.setter
    def unit_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataUnitDetailArgs']]]]):
        pulumi.set(self, "unit_details", value)

    @property
    @pulumi.getter(name="valueInputDetails")
    def value_input_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataValueInputDetailArgs']]]]:
        """
        Allowed value details of configuration item, to validate what value can be assigned to a configuration item.
        """
        return pulumi.get(self, "value_input_details")

    @value_input_details.setter
    def value_input_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpsiConfigurationConfigItemMetadataValueInputDetailArgs']]]]):
        pulumi.set(self, "value_input_details", value)


@pulumi.input_type
class OpsiConfigurationConfigItemMetadataUnitDetailArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        :param pulumi.Input[str] unit: Unit of configuration item.
        """
        OpsiConfigurationConfigItemMetadataUnitDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            unit=unit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: Optional[pulumi.Input[str]] = None,
             unit: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if display_name is not None:
            _setter("display_name", display_name)
        if unit is not None:
            _setter("unit", unit)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Unit of configuration item.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class OpsiConfigurationConfigItemMetadataValueInputDetailArgs:
    def __init__(__self__, *,
                 allowed_value_type: Optional[pulumi.Input[str]] = None,
                 max_value: Optional[pulumi.Input[str]] = None,
                 min_value: Optional[pulumi.Input[str]] = None,
                 possible_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] allowed_value_type: Allowed value type of configuration item.
        :param pulumi.Input[str] max_value: Maximum value limit for the configuration item.
        :param pulumi.Input[str] min_value: Minimum value limit for the configuration item.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] possible_values: Allowed values to pick for the configuration item.
        """
        OpsiConfigurationConfigItemMetadataValueInputDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            allowed_value_type=allowed_value_type,
            max_value=max_value,
            min_value=min_value,
            possible_values=possible_values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             allowed_value_type: Optional[pulumi.Input[str]] = None,
             max_value: Optional[pulumi.Input[str]] = None,
             min_value: Optional[pulumi.Input[str]] = None,
             possible_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if allowed_value_type is not None:
            _setter("allowed_value_type", allowed_value_type)
        if max_value is not None:
            _setter("max_value", max_value)
        if min_value is not None:
            _setter("min_value", min_value)
        if possible_values is not None:
            _setter("possible_values", possible_values)

    @property
    @pulumi.getter(name="allowedValueType")
    def allowed_value_type(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed value type of configuration item.
        """
        return pulumi.get(self, "allowed_value_type")

    @allowed_value_type.setter
    def allowed_value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_value_type", value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum value limit for the configuration item.
        """
        return pulumi.get(self, "max_value")

    @max_value.setter
    def max_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_value", value)

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum value limit for the configuration item.
        """
        return pulumi.get(self, "min_value")

    @min_value.setter
    def min_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_value", value)

    @property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed values to pick for the configuration item.
        """
        return pulumi.get(self, "possible_values")

    @possible_values.setter
    def possible_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "possible_values", value)


@pulumi.input_type
class GetAwrHubAwrSnapshotsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAwrHubAwrSnapshotsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetAwrHubsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAwrHubsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDatabaseInsightsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDatabaseInsightsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetEnterpriseManagerBridgesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEnterpriseManagerBridgesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetExadataInsightsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetExadataInsightsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetHostInsightsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetHostInsightsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetNewsReportsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The news report name.
        """
        GetNewsReportsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The news report name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOperationsInsightsPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOperationsInsightsPrivateEndpointsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOperationsInsightsWarehouseUsersFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Username for schema which would have access to AWR Data,  Enterprise Manager Data and Operations Insights OPSI Hub.
        """
        GetOperationsInsightsWarehouseUsersFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Username for schema which would have access to AWR Data,  Enterprise Manager Data and Operations Insights OPSI Hub.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOperationsInsightsWarehousesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOperationsInsightsWarehousesFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOpsiConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of configuration item.
        """
        GetOpsiConfigurationsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of configuration item.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


