# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NewsReportArgs', 'NewsReport']

@pulumi.input_type
class NewsReportArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 content_types: pulumi.Input['NewsReportContentTypesArgs'],
                 description: pulumi.Input[str],
                 locale: pulumi.Input[str],
                 news_frequency: pulumi.Input[str],
                 ons_topic_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NewsReport resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input['NewsReportContentTypesArgs'] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[str] description: The description of the news report.
        :param pulumi.Input[str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: The news report name.
        :param pulumi.Input[str] status: (Updatable) Defines if the news report will be enabled or disabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        NewsReportArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            content_types=content_types,
            description=description,
            locale=locale,
            news_frequency=news_frequency,
            ons_topic_id=ons_topic_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            name=name,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             content_types: pulumi.Input['NewsReportContentTypesArgs'],
             description: pulumi.Input[str],
             locale: pulumi.Input[str],
             news_frequency: pulumi.Input[str],
             ons_topic_id: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("content_types", content_types)
        _setter("description", description)
        _setter("locale", locale)
        _setter("news_frequency", news_frequency)
        _setter("ons_topic_id", ons_topic_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Input['NewsReportContentTypesArgs']:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: pulumi.Input['NewsReportContentTypesArgs']):
        pulumi.set(self, "content_types", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the news report.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Input[str]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> pulumi.Input[str]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @news_frequency.setter
    def news_frequency(self, value: pulumi.Input[str]):
        pulumi.set(self, "news_frequency", value)

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @ons_topic_id.setter
    def ons_topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ons_topic_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The news report name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _NewsReportState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 content_types: Optional[pulumi.Input['NewsReportContentTypesArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 news_frequency: Optional[pulumi.Input[str]] = None,
                 ons_topic_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NewsReport resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input['NewsReportContentTypesArgs'] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The description of the news report.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[str] name: The news report name.
        :param pulumi.Input[str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[str] state: The current state of the news report.
        :param pulumi.Input[str] status: (Updatable) Defines if the news report will be enabled or disabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the news report was first enabled. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the news report was updated. An RFC3339 formatted datetime string.
        """
        _NewsReportState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            content_types=content_types,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            locale=locale,
            name=name,
            news_frequency=news_frequency,
            ons_topic_id=ons_topic_id,
            state=state,
            status=status,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             content_types: Optional[pulumi.Input['NewsReportContentTypesArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             locale: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             news_frequency: Optional[pulumi.Input[str]] = None,
             ons_topic_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             status: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if content_types is not None:
            _setter("content_types", content_types)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if locale is not None:
            _setter("locale", locale)
        if name is not None:
            _setter("name", name)
        if news_frequency is not None:
            _setter("news_frequency", news_frequency)
        if ons_topic_id is not None:
            _setter("ons_topic_id", ons_topic_id)
        if state is not None:
            _setter("state", state)
        if status is not None:
            _setter("status", status)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input['NewsReportContentTypesArgs']]:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input['NewsReportContentTypesArgs']]):
        pulumi.set(self, "content_types", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the news report.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The news report name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @news_frequency.setter
    def news_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "news_frequency", value)

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @ons_topic_id.setter
    def ons_topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ons_topic_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the news report was first enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the news report was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class NewsReport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 content_types: Optional[pulumi.Input[pulumi.InputType['NewsReportContentTypesArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 news_frequency: Optional[pulumi.Input[str]] = None,
                 ons_topic_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the News Report resource in Oracle Cloud Infrastructure Opsi service.

        Create a news report in Operations Insights. The report will be enabled in Operations Insights. Insights will be emailed as per selected frequency.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_news_report = oci.opsi.NewsReport("testNewsReport",
            compartment_id=var["compartment_id"],
            content_types=oci.opsi.NewsReportContentTypesArgs(
                capacity_planning_resources=var["news_report_content_types_capacity_planning_resources"],
            ),
            description=var["news_report_description"],
            locale=var["news_report_locale"],
            news_frequency=var["news_report_news_frequency"],
            ons_topic_id=oci_opsi_ons_topic["test_ons_topic"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=var["news_report_status"])
        ```

        ## Import

        NewsReports can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/newsReport:NewsReport test_news_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input[pulumi.InputType['NewsReportContentTypesArgs']] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The description of the news report.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[str] name: The news report name.
        :param pulumi.Input[str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[str] status: (Updatable) Defines if the news report will be enabled or disabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NewsReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the News Report resource in Oracle Cloud Infrastructure Opsi service.

        Create a news report in Operations Insights. The report will be enabled in Operations Insights. Insights will be emailed as per selected frequency.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_news_report = oci.opsi.NewsReport("testNewsReport",
            compartment_id=var["compartment_id"],
            content_types=oci.opsi.NewsReportContentTypesArgs(
                capacity_planning_resources=var["news_report_content_types_capacity_planning_resources"],
            ),
            description=var["news_report_description"],
            locale=var["news_report_locale"],
            news_frequency=var["news_report_news_frequency"],
            ons_topic_id=oci_opsi_ons_topic["test_ons_topic"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=var["news_report_status"])
        ```

        ## Import

        NewsReports can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/newsReport:NewsReport test_news_report "id"
        ```

        :param str resource_name: The name of the resource.
        :param NewsReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NewsReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            NewsReportArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 content_types: Optional[pulumi.Input[pulumi.InputType['NewsReportContentTypesArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 news_frequency: Optional[pulumi.Input[str]] = None,
                 ons_topic_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NewsReportArgs.__new__(NewsReportArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if content_types is not None and not isinstance(content_types, NewsReportContentTypesArgs):
                content_types = content_types or {}
                def _setter(key, value):
                    content_types[key] = value
                NewsReportContentTypesArgs._configure(_setter, **content_types)
            if content_types is None and not opts.urn:
                raise TypeError("Missing required property 'content_types'")
            __props__.__dict__["content_types"] = content_types
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if locale is None and not opts.urn:
                raise TypeError("Missing required property 'locale'")
            __props__.__dict__["locale"] = locale
            __props__.__dict__["name"] = name
            if news_frequency is None and not opts.urn:
                raise TypeError("Missing required property 'news_frequency'")
            __props__.__dict__["news_frequency"] = news_frequency
            if ons_topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'ons_topic_id'")
            __props__.__dict__["ons_topic_id"] = ons_topic_id
            __props__.__dict__["status"] = status
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NewsReport, __self__).__init__(
            'oci:Opsi/newsReport:NewsReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            content_types: Optional[pulumi.Input[pulumi.InputType['NewsReportContentTypesArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            locale: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            news_frequency: Optional[pulumi.Input[str]] = None,
            ons_topic_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'NewsReport':
        """
        Get an existing NewsReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier where the news report will be created.
        :param pulumi.Input[pulumi.InputType['NewsReportContentTypesArgs']] content_types: (Updatable) Content types that the news report can handle.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: The description of the news report.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] locale: (Updatable) Language of the news report.
        :param pulumi.Input[str] name: The news report name.
        :param pulumi.Input[str] news_frequency: (Updatable) News report frequency.
        :param pulumi.Input[str] ons_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        :param pulumi.Input[str] state: The current state of the news report.
        :param pulumi.Input[str] status: (Updatable) Defines if the news report will be enabled or disabled.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the news report was first enabled. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the news report was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NewsReportState.__new__(_NewsReportState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["content_types"] = content_types
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locale"] = locale
        __props__.__dict__["name"] = name
        __props__.__dict__["news_frequency"] = news_frequency
        __props__.__dict__["ons_topic_id"] = ons_topic_id
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return NewsReport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier where the news report will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Output['outputs.NewsReportContentTypes']:
        """
        (Updatable) Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the news report.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Output[str]:
        """
        (Updatable) Language of the news report.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The news report name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> pulumi.Output[str]:
        """
        (Updatable) News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Defines if the news report will be enabled or disabled.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the news report was first enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the news report was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

