# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceArgs', 'ManagedInstance']

@pulumi.input_type
class ManagedInstanceArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[str],
                 is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedInstance resource.
        :param pulumi.Input[str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[bool] is_data_collection_authorized: (Updatable) True if user allow data collection for this instance
        :param pulumi.Input[str] notification_topic_id: (Updatable) OCID of the ONS topic used to send notification to users
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ManagedInstanceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            managed_instance_id=managed_instance_id,
            is_data_collection_authorized=is_data_collection_authorized,
            notification_topic_id=notification_topic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             managed_instance_id: pulumi.Input[str],
             is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
             notification_topic_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("managed_instance_id", managed_instance_id)
        if is_data_collection_authorized is not None:
            _setter("is_data_collection_authorized", is_data_collection_authorized)
        if notification_topic_id is not None:
            _setter("notification_topic_id", notification_topic_id)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[str]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="isDataCollectionAuthorized")
    def is_data_collection_authorized(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if user allow data collection for this instance
        """
        return pulumi.get(self, "is_data_collection_authorized")

    @is_data_collection_authorized.setter
    def is_data_collection_authorized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_data_collection_authorized", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the ONS topic used to send notification to users


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_id", value)


@pulumi.input_type
class _ManagedInstanceState:
    def __init__(__self__, *,
                 autonomouses: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceAutonomouseArgs']]]] = None,
                 bug_updates_available: Optional[pulumi.Input[int]] = None,
                 child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceChildSoftwareSourceArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enhancement_updates_available: Optional[pulumi.Input[int]] = None,
                 is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
                 is_reboot_required: Optional[pulumi.Input[bool]] = None,
                 ksplice_effective_kernel_version: Optional[pulumi.Input[str]] = None,
                 last_boot: Optional[pulumi.Input[str]] = None,
                 last_checkin: Optional[pulumi.Input[str]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 os_kernel_version: Optional[pulumi.Input[str]] = None,
                 os_name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 other_updates_available: Optional[pulumi.Input[int]] = None,
                 parent_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceParentSoftwareSourceArgs']]]] = None,
                 scheduled_job_count: Optional[pulumi.Input[int]] = None,
                 security_updates_available: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 updates_available: Optional[pulumi.Input[int]] = None,
                 work_request_count: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ManagedInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceAutonomouseArgs']]] autonomouses: if present, indicates the Managed Instance is an autonomous instance. Holds all the Autonomous specific information
        :param pulumi.Input[int] bug_updates_available: Number of bug fix type updates available to be installed
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceChildSoftwareSourceArgs']]] child_software_sources: list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[str] compartment_id: OCID for the Compartment
        :param pulumi.Input[str] description: Information specified by the user about the managed instance
        :param pulumi.Input[str] display_name: User friendly name
        :param pulumi.Input[int] enhancement_updates_available: Number of enhancement type updates available to be installed
        :param pulumi.Input[bool] is_data_collection_authorized: (Updatable) True if user allow data collection for this instance
        :param pulumi.Input[bool] is_reboot_required: Indicates whether a reboot is required to complete installation of updates.
        :param pulumi.Input[str] ksplice_effective_kernel_version: The ksplice effective kernel version
        :param pulumi.Input[str] last_boot: Time at which the instance last booted
        :param pulumi.Input[str] last_checkin: Time at which the instance last checked in
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]] managed_instance_groups: The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input[str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[str] notification_topic_id: (Updatable) OCID of the ONS topic used to send notification to users
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] os_family: The Operating System type of the managed instance.
        :param pulumi.Input[str] os_kernel_version: Operating System Kernel Version
        :param pulumi.Input[str] os_name: Operating System Name
        :param pulumi.Input[str] os_version: Operating System Version
        :param pulumi.Input[int] other_updates_available: Number of non-classified updates available to be installed
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceParentSoftwareSourceArgs']]] parent_software_sources: the parent (base) Software Source attached to the Managed Instance
        :param pulumi.Input[int] scheduled_job_count: Number of scheduled jobs associated with this instance
        :param pulumi.Input[int] security_updates_available: Number of security type updates available to be installed
        :param pulumi.Input[str] status: status of the managed instance.
        :param pulumi.Input[int] updates_available: Number of updates available to be installed
        :param pulumi.Input[int] work_request_count: Number of work requests associated with this instance
        """
        _ManagedInstanceState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            autonomouses=autonomouses,
            bug_updates_available=bug_updates_available,
            child_software_sources=child_software_sources,
            compartment_id=compartment_id,
            description=description,
            display_name=display_name,
            enhancement_updates_available=enhancement_updates_available,
            is_data_collection_authorized=is_data_collection_authorized,
            is_reboot_required=is_reboot_required,
            ksplice_effective_kernel_version=ksplice_effective_kernel_version,
            last_boot=last_boot,
            last_checkin=last_checkin,
            managed_instance_groups=managed_instance_groups,
            managed_instance_id=managed_instance_id,
            notification_topic_id=notification_topic_id,
            os_family=os_family,
            os_kernel_version=os_kernel_version,
            os_name=os_name,
            os_version=os_version,
            other_updates_available=other_updates_available,
            parent_software_sources=parent_software_sources,
            scheduled_job_count=scheduled_job_count,
            security_updates_available=security_updates_available,
            status=status,
            updates_available=updates_available,
            work_request_count=work_request_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             autonomouses: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceAutonomouseArgs']]]] = None,
             bug_updates_available: Optional[pulumi.Input[int]] = None,
             child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceChildSoftwareSourceArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             enhancement_updates_available: Optional[pulumi.Input[int]] = None,
             is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
             is_reboot_required: Optional[pulumi.Input[bool]] = None,
             ksplice_effective_kernel_version: Optional[pulumi.Input[str]] = None,
             last_boot: Optional[pulumi.Input[str]] = None,
             last_checkin: Optional[pulumi.Input[str]] = None,
             managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]] = None,
             managed_instance_id: Optional[pulumi.Input[str]] = None,
             notification_topic_id: Optional[pulumi.Input[str]] = None,
             os_family: Optional[pulumi.Input[str]] = None,
             os_kernel_version: Optional[pulumi.Input[str]] = None,
             os_name: Optional[pulumi.Input[str]] = None,
             os_version: Optional[pulumi.Input[str]] = None,
             other_updates_available: Optional[pulumi.Input[int]] = None,
             parent_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceParentSoftwareSourceArgs']]]] = None,
             scheduled_job_count: Optional[pulumi.Input[int]] = None,
             security_updates_available: Optional[pulumi.Input[int]] = None,
             status: Optional[pulumi.Input[str]] = None,
             updates_available: Optional[pulumi.Input[int]] = None,
             work_request_count: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if autonomouses is not None:
            _setter("autonomouses", autonomouses)
        if bug_updates_available is not None:
            _setter("bug_updates_available", bug_updates_available)
        if child_software_sources is not None:
            _setter("child_software_sources", child_software_sources)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if enhancement_updates_available is not None:
            _setter("enhancement_updates_available", enhancement_updates_available)
        if is_data_collection_authorized is not None:
            _setter("is_data_collection_authorized", is_data_collection_authorized)
        if is_reboot_required is not None:
            _setter("is_reboot_required", is_reboot_required)
        if ksplice_effective_kernel_version is not None:
            _setter("ksplice_effective_kernel_version", ksplice_effective_kernel_version)
        if last_boot is not None:
            _setter("last_boot", last_boot)
        if last_checkin is not None:
            _setter("last_checkin", last_checkin)
        if managed_instance_groups is not None:
            _setter("managed_instance_groups", managed_instance_groups)
        if managed_instance_id is not None:
            _setter("managed_instance_id", managed_instance_id)
        if notification_topic_id is not None:
            _setter("notification_topic_id", notification_topic_id)
        if os_family is not None:
            _setter("os_family", os_family)
        if os_kernel_version is not None:
            _setter("os_kernel_version", os_kernel_version)
        if os_name is not None:
            _setter("os_name", os_name)
        if os_version is not None:
            _setter("os_version", os_version)
        if other_updates_available is not None:
            _setter("other_updates_available", other_updates_available)
        if parent_software_sources is not None:
            _setter("parent_software_sources", parent_software_sources)
        if scheduled_job_count is not None:
            _setter("scheduled_job_count", scheduled_job_count)
        if security_updates_available is not None:
            _setter("security_updates_available", security_updates_available)
        if status is not None:
            _setter("status", status)
        if updates_available is not None:
            _setter("updates_available", updates_available)
        if work_request_count is not None:
            _setter("work_request_count", work_request_count)

    @property
    @pulumi.getter
    def autonomouses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceAutonomouseArgs']]]]:
        """
        if present, indicates the Managed Instance is an autonomous instance. Holds all the Autonomous specific information
        """
        return pulumi.get(self, "autonomouses")

    @autonomouses.setter
    def autonomouses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceAutonomouseArgs']]]]):
        pulumi.set(self, "autonomouses", value)

    @property
    @pulumi.getter(name="bugUpdatesAvailable")
    def bug_updates_available(self) -> Optional[pulumi.Input[int]]:
        """
        Number of bug fix type updates available to be installed
        """
        return pulumi.get(self, "bug_updates_available")

    @bug_updates_available.setter
    def bug_updates_available(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bug_updates_available", value)

    @property
    @pulumi.getter(name="childSoftwareSources")
    def child_software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceChildSoftwareSourceArgs']]]]:
        """
        list of child Software Sources attached to the Managed Instance
        """
        return pulumi.get(self, "child_software_sources")

    @child_software_sources.setter
    def child_software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceChildSoftwareSourceArgs']]]]):
        pulumi.set(self, "child_software_sources", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Information specified by the user about the managed instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enhancementUpdatesAvailable")
    def enhancement_updates_available(self) -> Optional[pulumi.Input[int]]:
        """
        Number of enhancement type updates available to be installed
        """
        return pulumi.get(self, "enhancement_updates_available")

    @enhancement_updates_available.setter
    def enhancement_updates_available(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enhancement_updates_available", value)

    @property
    @pulumi.getter(name="isDataCollectionAuthorized")
    def is_data_collection_authorized(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if user allow data collection for this instance
        """
        return pulumi.get(self, "is_data_collection_authorized")

    @is_data_collection_authorized.setter
    def is_data_collection_authorized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_data_collection_authorized", value)

    @property
    @pulumi.getter(name="isRebootRequired")
    def is_reboot_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a reboot is required to complete installation of updates.
        """
        return pulumi.get(self, "is_reboot_required")

    @is_reboot_required.setter
    def is_reboot_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_reboot_required", value)

    @property
    @pulumi.getter(name="kspliceEffectiveKernelVersion")
    def ksplice_effective_kernel_version(self) -> Optional[pulumi.Input[str]]:
        """
        The ksplice effective kernel version
        """
        return pulumi.get(self, "ksplice_effective_kernel_version")

    @ksplice_effective_kernel_version.setter
    def ksplice_effective_kernel_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ksplice_effective_kernel_version", value)

    @property
    @pulumi.getter(name="lastBoot")
    def last_boot(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the instance last booted
        """
        return pulumi.get(self, "last_boot")

    @last_boot.setter
    def last_boot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_boot", value)

    @property
    @pulumi.getter(name="lastCheckin")
    def last_checkin(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the instance last checked in
        """
        return pulumi.get(self, "last_checkin")

    @last_checkin.setter
    def last_checkin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_checkin", value)

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]]:
        """
        The ids of the managed instance groups of which this instance is a member.
        """
        return pulumi.get(self, "managed_instance_groups")

    @managed_instance_groups.setter
    def managed_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceManagedInstanceGroupArgs']]]]):
        pulumi.set(self, "managed_instance_groups", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the ONS topic used to send notification to users


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The Operating System type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> Optional[pulumi.Input[str]]:
        """
        Operating System Kernel Version
        """
        return pulumi.get(self, "os_kernel_version")

    @os_kernel_version.setter
    def os_kernel_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_kernel_version", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[str]]:
        """
        Operating System Name
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        Operating System Version
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter(name="otherUpdatesAvailable")
    def other_updates_available(self) -> Optional[pulumi.Input[int]]:
        """
        Number of non-classified updates available to be installed
        """
        return pulumi.get(self, "other_updates_available")

    @other_updates_available.setter
    def other_updates_available(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "other_updates_available", value)

    @property
    @pulumi.getter(name="parentSoftwareSources")
    def parent_software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceParentSoftwareSourceArgs']]]]:
        """
        the parent (base) Software Source attached to the Managed Instance
        """
        return pulumi.get(self, "parent_software_sources")

    @parent_software_sources.setter
    def parent_software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceParentSoftwareSourceArgs']]]]):
        pulumi.set(self, "parent_software_sources", value)

    @property
    @pulumi.getter(name="scheduledJobCount")
    def scheduled_job_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of scheduled jobs associated with this instance
        """
        return pulumi.get(self, "scheduled_job_count")

    @scheduled_job_count.setter
    def scheduled_job_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scheduled_job_count", value)

    @property
    @pulumi.getter(name="securityUpdatesAvailable")
    def security_updates_available(self) -> Optional[pulumi.Input[int]]:
        """
        Number of security type updates available to be installed
        """
        return pulumi.get(self, "security_updates_available")

    @security_updates_available.setter
    def security_updates_available(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "security_updates_available", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of the managed instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> Optional[pulumi.Input[int]]:
        """
        Number of updates available to be installed
        """
        return pulumi.get(self, "updates_available")

    @updates_available.setter
    def updates_available(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "updates_available", value)

    @property
    @pulumi.getter(name="workRequestCount")
    def work_request_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of work requests associated with this instance
        """
        return pulumi.get(self, "work_request_count")

    @work_request_count.setter
    def work_request_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "work_request_count", value)


class ManagedInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance resource in Oracle Cloud Infrastructure OS Management service.

        Updates a specific Managed Instance.

        ## Import

        ManagedInstances can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OsManagement/managedInstance:ManagedInstance test_managed_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_data_collection_authorized: (Updatable) True if user allow data collection for this instance
        :param pulumi.Input[str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[str] notification_topic_id: (Updatable) OCID of the ONS topic used to send notification to users
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance resource in Oracle Cloud Infrastructure OS Management service.

        Updates a specific Managed Instance.

        ## Import

        ManagedInstances can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OsManagement/managedInstance:ManagedInstance test_managed_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ManagedInstanceArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceArgs.__new__(ManagedInstanceArgs)

            __props__.__dict__["is_data_collection_authorized"] = is_data_collection_authorized
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            __props__.__dict__["autonomouses"] = None
            __props__.__dict__["bug_updates_available"] = None
            __props__.__dict__["child_software_sources"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["enhancement_updates_available"] = None
            __props__.__dict__["is_reboot_required"] = None
            __props__.__dict__["ksplice_effective_kernel_version"] = None
            __props__.__dict__["last_boot"] = None
            __props__.__dict__["last_checkin"] = None
            __props__.__dict__["managed_instance_groups"] = None
            __props__.__dict__["os_family"] = None
            __props__.__dict__["os_kernel_version"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["other_updates_available"] = None
            __props__.__dict__["parent_software_sources"] = None
            __props__.__dict__["scheduled_job_count"] = None
            __props__.__dict__["security_updates_available"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updates_available"] = None
            __props__.__dict__["work_request_count"] = None
        super(ManagedInstance, __self__).__init__(
            'oci:OsManagement/managedInstance:ManagedInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomouses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceAutonomouseArgs']]]]] = None,
            bug_updates_available: Optional[pulumi.Input[int]] = None,
            child_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceChildSoftwareSourceArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enhancement_updates_available: Optional[pulumi.Input[int]] = None,
            is_data_collection_authorized: Optional[pulumi.Input[bool]] = None,
            is_reboot_required: Optional[pulumi.Input[bool]] = None,
            ksplice_effective_kernel_version: Optional[pulumi.Input[str]] = None,
            last_boot: Optional[pulumi.Input[str]] = None,
            last_checkin: Optional[pulumi.Input[str]] = None,
            managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceManagedInstanceGroupArgs']]]]] = None,
            managed_instance_id: Optional[pulumi.Input[str]] = None,
            notification_topic_id: Optional[pulumi.Input[str]] = None,
            os_family: Optional[pulumi.Input[str]] = None,
            os_kernel_version: Optional[pulumi.Input[str]] = None,
            os_name: Optional[pulumi.Input[str]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            other_updates_available: Optional[pulumi.Input[int]] = None,
            parent_software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceParentSoftwareSourceArgs']]]]] = None,
            scheduled_job_count: Optional[pulumi.Input[int]] = None,
            security_updates_available: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            updates_available: Optional[pulumi.Input[int]] = None,
            work_request_count: Optional[pulumi.Input[int]] = None) -> 'ManagedInstance':
        """
        Get an existing ManagedInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceAutonomouseArgs']]]] autonomouses: if present, indicates the Managed Instance is an autonomous instance. Holds all the Autonomous specific information
        :param pulumi.Input[int] bug_updates_available: Number of bug fix type updates available to be installed
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceChildSoftwareSourceArgs']]]] child_software_sources: list of child Software Sources attached to the Managed Instance
        :param pulumi.Input[str] compartment_id: OCID for the Compartment
        :param pulumi.Input[str] description: Information specified by the user about the managed instance
        :param pulumi.Input[str] display_name: User friendly name
        :param pulumi.Input[int] enhancement_updates_available: Number of enhancement type updates available to be installed
        :param pulumi.Input[bool] is_data_collection_authorized: (Updatable) True if user allow data collection for this instance
        :param pulumi.Input[bool] is_reboot_required: Indicates whether a reboot is required to complete installation of updates.
        :param pulumi.Input[str] ksplice_effective_kernel_version: The ksplice effective kernel version
        :param pulumi.Input[str] last_boot: Time at which the instance last booted
        :param pulumi.Input[str] last_checkin: Time at which the instance last checked in
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceManagedInstanceGroupArgs']]]] managed_instance_groups: The ids of the managed instance groups of which this instance is a member.
        :param pulumi.Input[str] managed_instance_id: OCID for the managed instance
        :param pulumi.Input[str] notification_topic_id: (Updatable) OCID of the ONS topic used to send notification to users
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] os_family: The Operating System type of the managed instance.
        :param pulumi.Input[str] os_kernel_version: Operating System Kernel Version
        :param pulumi.Input[str] os_name: Operating System Name
        :param pulumi.Input[str] os_version: Operating System Version
        :param pulumi.Input[int] other_updates_available: Number of non-classified updates available to be installed
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagedInstanceParentSoftwareSourceArgs']]]] parent_software_sources: the parent (base) Software Source attached to the Managed Instance
        :param pulumi.Input[int] scheduled_job_count: Number of scheduled jobs associated with this instance
        :param pulumi.Input[int] security_updates_available: Number of security type updates available to be installed
        :param pulumi.Input[str] status: status of the managed instance.
        :param pulumi.Input[int] updates_available: Number of updates available to be installed
        :param pulumi.Input[int] work_request_count: Number of work requests associated with this instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceState.__new__(_ManagedInstanceState)

        __props__.__dict__["autonomouses"] = autonomouses
        __props__.__dict__["bug_updates_available"] = bug_updates_available
        __props__.__dict__["child_software_sources"] = child_software_sources
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enhancement_updates_available"] = enhancement_updates_available
        __props__.__dict__["is_data_collection_authorized"] = is_data_collection_authorized
        __props__.__dict__["is_reboot_required"] = is_reboot_required
        __props__.__dict__["ksplice_effective_kernel_version"] = ksplice_effective_kernel_version
        __props__.__dict__["last_boot"] = last_boot
        __props__.__dict__["last_checkin"] = last_checkin
        __props__.__dict__["managed_instance_groups"] = managed_instance_groups
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["os_kernel_version"] = os_kernel_version
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["other_updates_available"] = other_updates_available
        __props__.__dict__["parent_software_sources"] = parent_software_sources
        __props__.__dict__["scheduled_job_count"] = scheduled_job_count
        __props__.__dict__["security_updates_available"] = security_updates_available
        __props__.__dict__["status"] = status
        __props__.__dict__["updates_available"] = updates_available
        __props__.__dict__["work_request_count"] = work_request_count
        return ManagedInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autonomouses(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceAutonomouse']]:
        """
        if present, indicates the Managed Instance is an autonomous instance. Holds all the Autonomous specific information
        """
        return pulumi.get(self, "autonomouses")

    @property
    @pulumi.getter(name="bugUpdatesAvailable")
    def bug_updates_available(self) -> pulumi.Output[int]:
        """
        Number of bug fix type updates available to be installed
        """
        return pulumi.get(self, "bug_updates_available")

    @property
    @pulumi.getter(name="childSoftwareSources")
    def child_software_sources(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceChildSoftwareSource']]:
        """
        list of child Software Sources attached to the Managed Instance
        """
        return pulumi.get(self, "child_software_sources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Information specified by the user about the managed instance
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        User friendly name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enhancementUpdatesAvailable")
    def enhancement_updates_available(self) -> pulumi.Output[int]:
        """
        Number of enhancement type updates available to be installed
        """
        return pulumi.get(self, "enhancement_updates_available")

    @property
    @pulumi.getter(name="isDataCollectionAuthorized")
    def is_data_collection_authorized(self) -> pulumi.Output[bool]:
        """
        (Updatable) True if user allow data collection for this instance
        """
        return pulumi.get(self, "is_data_collection_authorized")

    @property
    @pulumi.getter(name="isRebootRequired")
    def is_reboot_required(self) -> pulumi.Output[bool]:
        """
        Indicates whether a reboot is required to complete installation of updates.
        """
        return pulumi.get(self, "is_reboot_required")

    @property
    @pulumi.getter(name="kspliceEffectiveKernelVersion")
    def ksplice_effective_kernel_version(self) -> pulumi.Output[str]:
        """
        The ksplice effective kernel version
        """
        return pulumi.get(self, "ksplice_effective_kernel_version")

    @property
    @pulumi.getter(name="lastBoot")
    def last_boot(self) -> pulumi.Output[str]:
        """
        Time at which the instance last booted
        """
        return pulumi.get(self, "last_boot")

    @property
    @pulumi.getter(name="lastCheckin")
    def last_checkin(self) -> pulumi.Output[str]:
        """
        Time at which the instance last checked in
        """
        return pulumi.get(self, "last_checkin")

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceManagedInstanceGroup']]:
        """
        The ids of the managed instance groups of which this instance is a member.
        """
        return pulumi.get(self, "managed_instance_groups")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[str]:
        """
        OCID for the managed instance
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of the ONS topic used to send notification to users


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[str]:
        """
        The Operating System type of the managed instance.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="osKernelVersion")
    def os_kernel_version(self) -> pulumi.Output[str]:
        """
        Operating System Kernel Version
        """
        return pulumi.get(self, "os_kernel_version")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[str]:
        """
        Operating System Name
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        Operating System Version
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="otherUpdatesAvailable")
    def other_updates_available(self) -> pulumi.Output[int]:
        """
        Number of non-classified updates available to be installed
        """
        return pulumi.get(self, "other_updates_available")

    @property
    @pulumi.getter(name="parentSoftwareSources")
    def parent_software_sources(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceParentSoftwareSource']]:
        """
        the parent (base) Software Source attached to the Managed Instance
        """
        return pulumi.get(self, "parent_software_sources")

    @property
    @pulumi.getter(name="scheduledJobCount")
    def scheduled_job_count(self) -> pulumi.Output[int]:
        """
        Number of scheduled jobs associated with this instance
        """
        return pulumi.get(self, "scheduled_job_count")

    @property
    @pulumi.getter(name="securityUpdatesAvailable")
    def security_updates_available(self) -> pulumi.Output[int]:
        """
        Number of security type updates available to be installed
        """
        return pulumi.get(self, "security_updates_available")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        status of the managed instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatesAvailable")
    def updates_available(self) -> pulumi.Output[int]:
        """
        Number of updates available to be installed
        """
        return pulumi.get(self, "updates_available")

    @property
    @pulumi.getter(name="workRequestCount")
    def work_request_count(self) -> pulumi.Output[int]:
        """
        Number of work requests associated with this instance
        """
        return pulumi.get(self, "work_request_count")

