# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 email: pulumi.Input[str],
                 osp_home_region: pulumi.Input[str],
                 subscription: pulumi.Input['SubscriptionSubscriptionArgs'],
                 subscription_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] email: (Updatable) User email
        :param pulumi.Input[str] osp_home_region: (Updatable) The home region's public name of the logged in user.
        :param pulumi.Input['SubscriptionSubscriptionArgs'] subscription: (Updatable) Subscription details object which extends the SubscriptionSummary
        :param pulumi.Input[str] subscription_id: Subscription id(OCID).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        SubscriptionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            email=email,
            osp_home_region=osp_home_region,
            subscription=subscription,
            subscription_id=subscription_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             email: pulumi.Input[str],
             osp_home_region: pulumi.Input[str],
             subscription: pulumi.Input['SubscriptionSubscriptionArgs'],
             subscription_id: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("email", email)
        _setter("osp_home_region", osp_home_region)
        _setter("subscription", subscription)
        _setter("subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        (Updatable) User email
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> pulumi.Input[str]:
        """
        (Updatable) The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @osp_home_region.setter
    def osp_home_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "osp_home_region", value)

    @property
    @pulumi.getter
    def subscription(self) -> pulumi.Input['SubscriptionSubscriptionArgs']:
        """
        (Updatable) Subscription details object which extends the SubscriptionSummary
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: pulumi.Input['SubscriptionSubscriptionArgs']):
        pulumi.set(self, "subscription", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[str]:
        """
        Subscription id(OCID).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 account_type: Optional[pulumi.Input[str]] = None,
                 bill_to_cust_account_id: Optional[pulumi.Input[str]] = None,
                 billing_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionBillingAddressArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 currency_code: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 gsi_org_code: Optional[pulumi.Input[str]] = None,
                 is_intent_to_pay: Optional[pulumi.Input[bool]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 payment_gateways: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentGatewayArgs']]]] = None,
                 payment_options: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentOptionArgs']]]] = None,
                 plan_type: Optional[pulumi.Input[str]] = None,
                 ship_to_cust_acct_role_id: Optional[pulumi.Input[str]] = None,
                 ship_to_cust_acct_site_id: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input['SubscriptionSubscriptionArgs']] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 subscription_plan_number: Optional[pulumi.Input[str]] = None,
                 tax_infos: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionTaxInfoArgs']]]] = None,
                 time_personal_to_corporate_conv: Optional[pulumi.Input[str]] = None,
                 time_plan_upgrade: Optional[pulumi.Input[str]] = None,
                 time_start: Optional[pulumi.Input[str]] = None,
                 upgrade_state: Optional[pulumi.Input[str]] = None,
                 upgrade_state_details: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[str] account_type: (Updatable) Account type.
        :param pulumi.Input[str] bill_to_cust_account_id: (Updatable) Bill to customer Account id.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionBillingAddressArgs']]] billing_addresses: (Updatable) Address details model.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] currency_code: (Updatable) Currency code
        :param pulumi.Input[str] email: (Updatable) User email
        :param pulumi.Input[str] gsi_org_code: (Updatable) GSI Subscription external code.
        :param pulumi.Input[bool] is_intent_to_pay: (Updatable) Payment intension.
        :param pulumi.Input[str] language_code: (Updatable) Language short code (en, de, hu, etc)
        :param pulumi.Input[str] organization_id: (Updatable) GSI organization external identifier.
        :param pulumi.Input[str] osp_home_region: (Updatable) The home region's public name of the logged in user.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentGatewayArgs']]] payment_gateways: (Updatable) Payment gateway details.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentOptionArgs']]] payment_options: (Updatable) Payment option list of a subscription.
        :param pulumi.Input[str] plan_type: (Updatable) Subscription plan type.
        :param pulumi.Input[str] ship_to_cust_acct_role_id: (Updatable) Ship to customer account role.
        :param pulumi.Input[str] ship_to_cust_acct_site_id: (Updatable) Ship to customer account site address id.
        :param pulumi.Input['SubscriptionSubscriptionArgs'] subscription: (Updatable) Subscription details object which extends the SubscriptionSummary
        :param pulumi.Input[str] subscription_id: Subscription id(OCID).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] subscription_plan_number: (Updatable) Subscription plan number.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionTaxInfoArgs']]] tax_infos: (Updatable) Tax details.
        :param pulumi.Input[str] time_personal_to_corporate_conv: (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param pulumi.Input[str] time_plan_upgrade: (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param pulumi.Input[str] time_start: (Updatable) Start date of the subscription.
        :param pulumi.Input[str] upgrade_state: (Updatable) Status of the upgrade.
        :param pulumi.Input[str] upgrade_state_details: (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        _SubscriptionState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            account_type=account_type,
            bill_to_cust_account_id=bill_to_cust_account_id,
            billing_addresses=billing_addresses,
            compartment_id=compartment_id,
            currency_code=currency_code,
            email=email,
            gsi_org_code=gsi_org_code,
            is_intent_to_pay=is_intent_to_pay,
            language_code=language_code,
            organization_id=organization_id,
            osp_home_region=osp_home_region,
            payment_gateways=payment_gateways,
            payment_options=payment_options,
            plan_type=plan_type,
            ship_to_cust_acct_role_id=ship_to_cust_acct_role_id,
            ship_to_cust_acct_site_id=ship_to_cust_acct_site_id,
            subscription=subscription,
            subscription_id=subscription_id,
            subscription_plan_number=subscription_plan_number,
            tax_infos=tax_infos,
            time_personal_to_corporate_conv=time_personal_to_corporate_conv,
            time_plan_upgrade=time_plan_upgrade,
            time_start=time_start,
            upgrade_state=upgrade_state,
            upgrade_state_details=upgrade_state_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             account_type: Optional[pulumi.Input[str]] = None,
             bill_to_cust_account_id: Optional[pulumi.Input[str]] = None,
             billing_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionBillingAddressArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             currency_code: Optional[pulumi.Input[str]] = None,
             email: Optional[pulumi.Input[str]] = None,
             gsi_org_code: Optional[pulumi.Input[str]] = None,
             is_intent_to_pay: Optional[pulumi.Input[bool]] = None,
             language_code: Optional[pulumi.Input[str]] = None,
             organization_id: Optional[pulumi.Input[str]] = None,
             osp_home_region: Optional[pulumi.Input[str]] = None,
             payment_gateways: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentGatewayArgs']]]] = None,
             payment_options: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentOptionArgs']]]] = None,
             plan_type: Optional[pulumi.Input[str]] = None,
             ship_to_cust_acct_role_id: Optional[pulumi.Input[str]] = None,
             ship_to_cust_acct_site_id: Optional[pulumi.Input[str]] = None,
             subscription: Optional[pulumi.Input['SubscriptionSubscriptionArgs']] = None,
             subscription_id: Optional[pulumi.Input[str]] = None,
             subscription_plan_number: Optional[pulumi.Input[str]] = None,
             tax_infos: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionTaxInfoArgs']]]] = None,
             time_personal_to_corporate_conv: Optional[pulumi.Input[str]] = None,
             time_plan_upgrade: Optional[pulumi.Input[str]] = None,
             time_start: Optional[pulumi.Input[str]] = None,
             upgrade_state: Optional[pulumi.Input[str]] = None,
             upgrade_state_details: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if account_type is not None:
            _setter("account_type", account_type)
        if bill_to_cust_account_id is not None:
            _setter("bill_to_cust_account_id", bill_to_cust_account_id)
        if billing_addresses is not None:
            _setter("billing_addresses", billing_addresses)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if currency_code is not None:
            _setter("currency_code", currency_code)
        if email is not None:
            _setter("email", email)
        if gsi_org_code is not None:
            _setter("gsi_org_code", gsi_org_code)
        if is_intent_to_pay is not None:
            _setter("is_intent_to_pay", is_intent_to_pay)
        if language_code is not None:
            _setter("language_code", language_code)
        if organization_id is not None:
            _setter("organization_id", organization_id)
        if osp_home_region is not None:
            _setter("osp_home_region", osp_home_region)
        if payment_gateways is not None:
            _setter("payment_gateways", payment_gateways)
        if payment_options is not None:
            _setter("payment_options", payment_options)
        if plan_type is not None:
            _setter("plan_type", plan_type)
        if ship_to_cust_acct_role_id is not None:
            _setter("ship_to_cust_acct_role_id", ship_to_cust_acct_role_id)
        if ship_to_cust_acct_site_id is not None:
            _setter("ship_to_cust_acct_site_id", ship_to_cust_acct_site_id)
        if subscription is not None:
            _setter("subscription", subscription)
        if subscription_id is not None:
            _setter("subscription_id", subscription_id)
        if subscription_plan_number is not None:
            _setter("subscription_plan_number", subscription_plan_number)
        if tax_infos is not None:
            _setter("tax_infos", tax_infos)
        if time_personal_to_corporate_conv is not None:
            _setter("time_personal_to_corporate_conv", time_personal_to_corporate_conv)
        if time_plan_upgrade is not None:
            _setter("time_plan_upgrade", time_plan_upgrade)
        if time_start is not None:
            _setter("time_start", time_start)
        if upgrade_state is not None:
            _setter("upgrade_state", upgrade_state)
        if upgrade_state_details is not None:
            _setter("upgrade_state_details", upgrade_state_details)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Account type.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_type", value)

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @bill_to_cust_account_id.setter
    def bill_to_cust_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bill_to_cust_account_id", value)

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionBillingAddressArgs']]]]:
        """
        (Updatable) Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @billing_addresses.setter
    def billing_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionBillingAddressArgs']]]]):
        pulumi.set(self, "billing_addresses", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Currency code
        """
        return pulumi.get(self, "currency_code")

    @currency_code.setter
    def currency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency_code", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User email
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @gsi_org_code.setter
    def gsi_org_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gsi_org_code", value)

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @is_intent_to_pay.setter
    def is_intent_to_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_intent_to_pay", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @osp_home_region.setter
    def osp_home_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "osp_home_region", value)

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentGatewayArgs']]]]:
        """
        (Updatable) Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @payment_gateways.setter
    def payment_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentGatewayArgs']]]]):
        pulumi.set(self, "payment_gateways", value)

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentOptionArgs']]]]:
        """
        (Updatable) Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @payment_options.setter
    def payment_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionPaymentOptionArgs']]]]):
        pulumi.set(self, "payment_options", value)

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @plan_type.setter
    def plan_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_type", value)

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @ship_to_cust_acct_role_id.setter
    def ship_to_cust_acct_role_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ship_to_cust_acct_role_id", value)

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @ship_to_cust_acct_site_id.setter
    def ship_to_cust_acct_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ship_to_cust_acct_site_id", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input['SubscriptionSubscriptionArgs']]:
        """
        (Updatable) Subscription details object which extends the SubscriptionSummary
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input['SubscriptionSubscriptionArgs']]):
        pulumi.set(self, "subscription", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription id(OCID).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @subscription_plan_number.setter
    def subscription_plan_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_plan_number", value)

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionTaxInfoArgs']]]]:
        """
        (Updatable) Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @tax_infos.setter
    def tax_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionTaxInfoArgs']]]]):
        pulumi.set(self, "tax_infos", value)

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @time_personal_to_corporate_conv.setter
    def time_personal_to_corporate_conv(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_personal_to_corporate_conv", value)

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @time_plan_upgrade.setter
    def time_plan_upgrade(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_plan_upgrade", value)

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @time_start.setter
    def time_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_start", value)

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @upgrade_state.setter
    def upgrade_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_state", value)

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")

    @upgrade_state_details.setter
    def upgrade_state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_state_details", value)


class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[pulumi.InputType['SubscriptionSubscriptionArgs']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Subscription resource in Oracle Cloud Infrastructure Osp Gateway service.

        Update plan of the subscription.

        ## Import

        Subscriptions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OspGateway/subscription:Subscription test_subscription "subscriptions/{subscriptionId}/compartmentId/{compartmentId}/ospHomeRegion/{ospHomeRegion}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] email: (Updatable) User email
        :param pulumi.Input[str] osp_home_region: (Updatable) The home region's public name of the logged in user.
        :param pulumi.Input[pulumi.InputType['SubscriptionSubscriptionArgs']] subscription: (Updatable) Subscription details object which extends the SubscriptionSummary
        :param pulumi.Input[str] subscription_id: Subscription id(OCID).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Subscription resource in Oracle Cloud Infrastructure Osp Gateway service.

        Update plan of the subscription.

        ## Import

        Subscriptions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OspGateway/subscription:Subscription test_subscription "subscriptions/{subscriptionId}/compartmentId/{compartmentId}/ospHomeRegion/{ospHomeRegion}"
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            SubscriptionArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[pulumi.InputType['SubscriptionSubscriptionArgs']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if osp_home_region is None and not opts.urn:
                raise TypeError("Missing required property 'osp_home_region'")
            __props__.__dict__["osp_home_region"] = osp_home_region
            if subscription is not None and not isinstance(subscription, SubscriptionSubscriptionArgs):
                subscription = subscription or {}
                def _setter(key, value):
                    subscription[key] = value
                SubscriptionSubscriptionArgs._configure(_setter, **subscription)
            if subscription is None and not opts.urn:
                raise TypeError("Missing required property 'subscription'")
            __props__.__dict__["subscription"] = subscription
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["account_type"] = None
            __props__.__dict__["bill_to_cust_account_id"] = None
            __props__.__dict__["billing_addresses"] = None
            __props__.__dict__["currency_code"] = None
            __props__.__dict__["gsi_org_code"] = None
            __props__.__dict__["is_intent_to_pay"] = None
            __props__.__dict__["language_code"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["payment_gateways"] = None
            __props__.__dict__["payment_options"] = None
            __props__.__dict__["plan_type"] = None
            __props__.__dict__["ship_to_cust_acct_role_id"] = None
            __props__.__dict__["ship_to_cust_acct_site_id"] = None
            __props__.__dict__["subscription_plan_number"] = None
            __props__.__dict__["tax_infos"] = None
            __props__.__dict__["time_personal_to_corporate_conv"] = None
            __props__.__dict__["time_plan_upgrade"] = None
            __props__.__dict__["time_start"] = None
            __props__.__dict__["upgrade_state"] = None
            __props__.__dict__["upgrade_state_details"] = None
        super(Subscription, __self__).__init__(
            'oci:OspGateway/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_type: Optional[pulumi.Input[str]] = None,
            bill_to_cust_account_id: Optional[pulumi.Input[str]] = None,
            billing_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionBillingAddressArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            currency_code: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            gsi_org_code: Optional[pulumi.Input[str]] = None,
            is_intent_to_pay: Optional[pulumi.Input[bool]] = None,
            language_code: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            osp_home_region: Optional[pulumi.Input[str]] = None,
            payment_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionPaymentGatewayArgs']]]]] = None,
            payment_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionPaymentOptionArgs']]]]] = None,
            plan_type: Optional[pulumi.Input[str]] = None,
            ship_to_cust_acct_role_id: Optional[pulumi.Input[str]] = None,
            ship_to_cust_acct_site_id: Optional[pulumi.Input[str]] = None,
            subscription: Optional[pulumi.Input[pulumi.InputType['SubscriptionSubscriptionArgs']]] = None,
            subscription_id: Optional[pulumi.Input[str]] = None,
            subscription_plan_number: Optional[pulumi.Input[str]] = None,
            tax_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionTaxInfoArgs']]]]] = None,
            time_personal_to_corporate_conv: Optional[pulumi.Input[str]] = None,
            time_plan_upgrade: Optional[pulumi.Input[str]] = None,
            time_start: Optional[pulumi.Input[str]] = None,
            upgrade_state: Optional[pulumi.Input[str]] = None,
            upgrade_state_details: Optional[pulumi.Input[str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_type: (Updatable) Account type.
        :param pulumi.Input[str] bill_to_cust_account_id: (Updatable) Bill to customer Account id.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionBillingAddressArgs']]]] billing_addresses: (Updatable) Address details model.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] currency_code: (Updatable) Currency code
        :param pulumi.Input[str] email: (Updatable) User email
        :param pulumi.Input[str] gsi_org_code: (Updatable) GSI Subscription external code.
        :param pulumi.Input[bool] is_intent_to_pay: (Updatable) Payment intension.
        :param pulumi.Input[str] language_code: (Updatable) Language short code (en, de, hu, etc)
        :param pulumi.Input[str] organization_id: (Updatable) GSI organization external identifier.
        :param pulumi.Input[str] osp_home_region: (Updatable) The home region's public name of the logged in user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionPaymentGatewayArgs']]]] payment_gateways: (Updatable) Payment gateway details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionPaymentOptionArgs']]]] payment_options: (Updatable) Payment option list of a subscription.
        :param pulumi.Input[str] plan_type: (Updatable) Subscription plan type.
        :param pulumi.Input[str] ship_to_cust_acct_role_id: (Updatable) Ship to customer account role.
        :param pulumi.Input[str] ship_to_cust_acct_site_id: (Updatable) Ship to customer account site address id.
        :param pulumi.Input[pulumi.InputType['SubscriptionSubscriptionArgs']] subscription: (Updatable) Subscription details object which extends the SubscriptionSummary
        :param pulumi.Input[str] subscription_id: Subscription id(OCID).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] subscription_plan_number: (Updatable) Subscription plan number.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionTaxInfoArgs']]]] tax_infos: (Updatable) Tax details.
        :param pulumi.Input[str] time_personal_to_corporate_conv: (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        :param pulumi.Input[str] time_plan_upgrade: (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        :param pulumi.Input[str] time_start: (Updatable) Start date of the subscription.
        :param pulumi.Input[str] upgrade_state: (Updatable) Status of the upgrade.
        :param pulumi.Input[str] upgrade_state_details: (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["bill_to_cust_account_id"] = bill_to_cust_account_id
        __props__.__dict__["billing_addresses"] = billing_addresses
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["currency_code"] = currency_code
        __props__.__dict__["email"] = email
        __props__.__dict__["gsi_org_code"] = gsi_org_code
        __props__.__dict__["is_intent_to_pay"] = is_intent_to_pay
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["osp_home_region"] = osp_home_region
        __props__.__dict__["payment_gateways"] = payment_gateways
        __props__.__dict__["payment_options"] = payment_options
        __props__.__dict__["plan_type"] = plan_type
        __props__.__dict__["ship_to_cust_acct_role_id"] = ship_to_cust_acct_role_id
        __props__.__dict__["ship_to_cust_acct_site_id"] = ship_to_cust_acct_site_id
        __props__.__dict__["subscription"] = subscription
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["subscription_plan_number"] = subscription_plan_number
        __props__.__dict__["tax_infos"] = tax_infos
        __props__.__dict__["time_personal_to_corporate_conv"] = time_personal_to_corporate_conv
        __props__.__dict__["time_plan_upgrade"] = time_plan_upgrade
        __props__.__dict__["time_start"] = time_start
        __props__.__dict__["upgrade_state"] = upgrade_state
        __props__.__dict__["upgrade_state_details"] = upgrade_state_details
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Account type.
        """
        return pulumi.get(self, "account_type")

    @property
    @pulumi.getter(name="billToCustAccountId")
    def bill_to_cust_account_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Bill to customer Account id.
        """
        return pulumi.get(self, "bill_to_cust_account_id")

    @property
    @pulumi.getter(name="billingAddresses")
    def billing_addresses(self) -> pulumi.Output[Sequence['outputs.SubscriptionBillingAddress']]:
        """
        (Updatable) Address details model.
        """
        return pulumi.get(self, "billing_addresses")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> pulumi.Output[str]:
        """
        (Updatable) Currency code
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        (Updatable) User email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="gsiOrgCode")
    def gsi_org_code(self) -> pulumi.Output[str]:
        """
        (Updatable) GSI Subscription external code.
        """
        return pulumi.get(self, "gsi_org_code")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> pulumi.Output[bool]:
        """
        (Updatable) Payment intension.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[str]:
        """
        (Updatable) Language short code (en, de, hu, etc)
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        (Updatable) GSI organization external identifier.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> pulumi.Output[str]:
        """
        (Updatable) The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="paymentGateways")
    def payment_gateways(self) -> pulumi.Output[Sequence['outputs.SubscriptionPaymentGateway']]:
        """
        (Updatable) Payment gateway details.
        """
        return pulumi.get(self, "payment_gateways")

    @property
    @pulumi.getter(name="paymentOptions")
    def payment_options(self) -> pulumi.Output[Sequence['outputs.SubscriptionPaymentOption']]:
        """
        (Updatable) Payment option list of a subscription.
        """
        return pulumi.get(self, "payment_options")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Subscription plan type.
        """
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter(name="shipToCustAcctRoleId")
    def ship_to_cust_acct_role_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Ship to customer account role.
        """
        return pulumi.get(self, "ship_to_cust_acct_role_id")

    @property
    @pulumi.getter(name="shipToCustAcctSiteId")
    def ship_to_cust_acct_site_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Ship to customer account site address id.
        """
        return pulumi.get(self, "ship_to_cust_acct_site_id")

    @property
    @pulumi.getter
    def subscription(self) -> pulumi.Output['outputs.SubscriptionSubscription']:
        """
        (Updatable) Subscription details object which extends the SubscriptionSummary
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        Subscription id(OCID).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionPlanNumber")
    def subscription_plan_number(self) -> pulumi.Output[str]:
        """
        (Updatable) Subscription plan number.
        """
        return pulumi.get(self, "subscription_plan_number")

    @property
    @pulumi.getter(name="taxInfos")
    def tax_infos(self) -> pulumi.Output[Sequence['outputs.SubscriptionTaxInfo']]:
        """
        (Updatable) Tax details.
        """
        return pulumi.get(self, "tax_infos")

    @property
    @pulumi.getter(name="timePersonalToCorporateConv")
    def time_personal_to_corporate_conv(self) -> pulumi.Output[str]:
        """
        (Updatable) Date of upgrade/conversion when account type changed from PERSONAL to CORPORATE
        """
        return pulumi.get(self, "time_personal_to_corporate_conv")

    @property
    @pulumi.getter(name="timePlanUpgrade")
    def time_plan_upgrade(self) -> pulumi.Output[str]:
        """
        (Updatable) Date of upgrade/conversion when planType changed from FREE_TIER to PAYG
        """
        return pulumi.get(self, "time_plan_upgrade")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> pulumi.Output[str]:
        """
        (Updatable) Start date of the subscription.
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="upgradeState")
    def upgrade_state(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of the upgrade.
        """
        return pulumi.get(self, "upgrade_state")

    @property
    @pulumi.getter(name="upgradeStateDetails")
    def upgrade_state_details(self) -> pulumi.Output[str]:
        """
        (Updatable) This field is used to describe the Upgrade State in case of error (E.g. Upgrade failure caused by interfacing Tax details- TaxError)
        """
        return pulumi.get(self, "upgrade_state_details")

