# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 partitions: pulumi.Input[int],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_in_hours: Optional[pulumi.Input[int]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input[int] partitions: The number of partitions in the stream.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        :param pulumi.Input[int] retention_in_hours: The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The OCID of the stream pool that contains the stream.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        StreamArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            partitions=partitions,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            name=name,
            retention_in_hours=retention_in_hours,
            stream_pool_id=stream_pool_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             partitions: pulumi.Input[int],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             retention_in_hours: Optional[pulumi.Input[int]] = None,
             stream_pool_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("partitions", partitions)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)
        if retention_in_hours is not None:
            _setter("retention_in_hours", retention_in_hours)
        if stream_pool_id is not None:
            _setter("stream_pool_id", stream_pool_id)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[int]:
        """
        The number of partitions in the stream.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        """
        return pulumi.get(self, "retention_in_hours")

    @retention_in_hours.setter
    def retention_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_hours", value)

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the stream pool that contains the stream.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stream_pool_id")

    @stream_pool_id.setter
    def stream_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_pool_id", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[str]] = None,
                 messages_endpoint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 retention_in_hours: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_state_details: Any additional details about the current state of the stream.
        :param pulumi.Input[str] messages_endpoint: The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        :param pulumi.Input[str] name: The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        :param pulumi.Input[int] partitions: The number of partitions in the stream.
        :param pulumi.Input[int] retention_in_hours: The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        :param pulumi.Input[str] state: The current state of the stream.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The OCID of the stream pool that contains the stream.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        _StreamState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            lifecycle_state_details=lifecycle_state_details,
            messages_endpoint=messages_endpoint,
            name=name,
            partitions=partitions,
            retention_in_hours=retention_in_hours,
            state=state,
            stream_pool_id=stream_pool_id,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_state_details: Optional[pulumi.Input[str]] = None,
             messages_endpoint: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             partitions: Optional[pulumi.Input[int]] = None,
             retention_in_hours: Optional[pulumi.Input[int]] = None,
             state: Optional[pulumi.Input[str]] = None,
             stream_pool_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_state_details is not None:
            _setter("lifecycle_state_details", lifecycle_state_details)
        if messages_endpoint is not None:
            _setter("messages_endpoint", messages_endpoint)
        if name is not None:
            _setter("name", name)
        if partitions is not None:
            _setter("partitions", partitions)
        if retention_in_hours is not None:
            _setter("retention_in_hours", retention_in_hours)
        if state is not None:
            _setter("state", state)
        if stream_pool_id is not None:
            _setter("stream_pool_id", stream_pool_id)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[str]]:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        """
        return pulumi.get(self, "messages_endpoint")

    @messages_endpoint.setter
    def messages_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "messages_endpoint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions in the stream.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        """
        return pulumi.get(self, "retention_in_hours")

    @retention_in_hours.setter
    def retention_in_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_hours", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the stream.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the stream pool that contains the stream.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stream_pool_id")

    @stream_pool_id.setter
    def stream_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_pool_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 retention_in_hours: Optional[pulumi.Input[int]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Stream resource in Oracle Cloud Infrastructure Streaming service.

        Starts the provisioning of a new stream.
        The stream will be created in the given compartment id or stream pool id, depending on which parameter is specified.
        Compartment id and stream pool id cannot be specified at the same time.
        To track the progress of the provisioning, you can periodically call [GetStream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream).
        In the response, the `lifecycleState` parameter of the [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream/) object tells you its current state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream = oci.streaming.Stream("testStream",
            partitions=var["stream_partitions"],
            compartment_id=var["compartment_id"],
            defined_tags=var["stream_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            retention_in_hours=var["stream_retention_in_hours"],
            stream_pool_id=oci_streaming_stream_pool["test_stream_pool"]["id"])
        ```

        ## Import

        Streams can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Streaming/stream:Stream test_stream "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        :param pulumi.Input[int] partitions: The number of partitions in the stream.
        :param pulumi.Input[int] retention_in_hours: The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The OCID of the stream pool that contains the stream.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Stream resource in Oracle Cloud Infrastructure Streaming service.

        Starts the provisioning of a new stream.
        The stream will be created in the given compartment id or stream pool id, depending on which parameter is specified.
        Compartment id and stream pool id cannot be specified at the same time.
        To track the progress of the provisioning, you can periodically call [GetStream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream).
        In the response, the `lifecycleState` parameter of the [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream/) object tells you its current state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream = oci.streaming.Stream("testStream",
            partitions=var["stream_partitions"],
            compartment_id=var["compartment_id"],
            defined_tags=var["stream_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            },
            retention_in_hours=var["stream_retention_in_hours"],
            stream_pool_id=oci_streaming_stream_pool["test_stream_pool"]["id"])
        ```

        ## Import

        Streams can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Streaming/stream:Stream test_stream "id"
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            StreamArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 retention_in_hours: Optional[pulumi.Input[int]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            __props__.__dict__["retention_in_hours"] = retention_in_hours
            __props__.__dict__["stream_pool_id"] = stream_pool_id
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["messages_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Stream, __self__).__init__(
            'oci:Streaming/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_state_details: Optional[pulumi.Input[str]] = None,
            messages_endpoint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partitions: Optional[pulumi.Input[int]] = None,
            retention_in_hours: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            stream_pool_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_state_details: Any additional details about the current state of the stream.
        :param pulumi.Input[str] messages_endpoint: The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        :param pulumi.Input[str] name: The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        :param pulumi.Input[int] partitions: The number of partitions in the stream.
        :param pulumi.Input[int] retention_in_hours: The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        :param pulumi.Input[str] state: The current state of the stream.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The OCID of the stream pool that contains the stream.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["messages_endpoint"] = messages_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["retention_in_hours"] = retention_in_hours
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_pool_id"] = stream_pool_id
        __props__.__dict__["time_created"] = time_created
        return Stream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[str]:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        """
        return pulumi.get(self, "messages_endpoint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[int]:
        """
        The number of partitions in the stream.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> pulumi.Output[int]:
        """
        The retention period of the stream, in hours. Accepted values are between 24 and 168 (7 days). If not specified, the stream will have a retention period of 24 hours.
        """
        return pulumi.get(self, "retention_in_hours")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the stream pool that contains the stream.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

