# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPathAnalyzerTestDestinationEndpointResult',
    'GetPathAnalyzerTestProtocolParameterResult',
    'GetPathAnalyzerTestQueryOptionResult',
    'GetPathAnalyzerTestSourceEndpointResult',
    'GetPathAnalyzerTestsFilterResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult',
    'GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult',
    'PathAnalysiDestinationEndpoint',
    'PathAnalysiProtocolParameters',
    'PathAnalysiQueryOptions',
    'PathAnalysiSourceEndpoint',
    'PathAnalyzerTestDestinationEndpoint',
    'PathAnalyzerTestProtocolParameters',
    'PathAnalyzerTestQueryOptions',
    'PathAnalyzerTestSourceEndpoint',
]

@pulumi.output_type
class GetPathAnalyzerTestDestinationEndpointResult(dict):
    def __init__(__self__, *,
                 address: str,
                 instance_id: str,
                 listener_id: str,
                 load_balancer_id: str,
                 network_load_balancer_id: str,
                 state: str,
                 subnet_id: str,
                 type: str,
                 vlan_id: str,
                 vnic_id: str):
        """
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: The current state of the `PathAnalyzerTest` resource.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str type: The type of the `Endpoint`.
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        GetPathAnalyzerTestDestinationEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            type=type,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             instance_id: str,
             listener_id: str,
             load_balancer_id: str,
             network_load_balancer_id: str,
             state: str,
             subnet_id: str,
             type: str,
             vlan_id: str,
             vnic_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("instance_id", instance_id)
        _setter("listener_id", listener_id)
        _setter("load_balancer_id", load_balancer_id)
        _setter("network_load_balancer_id", network_load_balancer_id)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("type", type)
        _setter("vlan_id", vlan_id)
        _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestProtocolParameterResult(dict):
    def __init__(__self__, *,
                 destination_port: int,
                 icmp_code: int,
                 icmp_type: int,
                 source_port: int,
                 type: str):
        """
        :param int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param int source_port: The source port to use in a `PathAnalyzerTest` resource.
        :param str type: The type of the `Endpoint`.
        """
        GetPathAnalyzerTestProtocolParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_port=destination_port,
            icmp_code=icmp_code,
            icmp_type=icmp_type,
            source_port=source_port,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_port: int,
             icmp_code: int,
             icmp_type: int,
             source_port: int,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("destination_port", destination_port)
        _setter("icmp_code", icmp_code)
        _setter("icmp_type", icmp_type)
        _setter("source_port", source_port)
        _setter("type", type)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> int:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> int:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPathAnalyzerTestQueryOptionResult(dict):
    def __init__(__self__, *,
                 is_bi_directional_analysis: bool):
        """
        :param bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        GetPathAnalyzerTestQueryOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_bi_directional_analysis=is_bi_directional_analysis,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_bi_directional_analysis: bool,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> bool:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class GetPathAnalyzerTestSourceEndpointResult(dict):
    def __init__(__self__, *,
                 address: str,
                 instance_id: str,
                 listener_id: str,
                 load_balancer_id: str,
                 network_load_balancer_id: str,
                 state: str,
                 subnet_id: str,
                 type: str,
                 vlan_id: str,
                 vnic_id: str):
        """
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: The current state of the `PathAnalyzerTest` resource.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str type: The type of the `Endpoint`.
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        GetPathAnalyzerTestSourceEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            type=type,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             instance_id: str,
             listener_id: str,
             load_balancer_id: str,
             network_load_balancer_id: str,
             state: str,
             subnet_id: str,
             type: str,
             vlan_id: str,
             vnic_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("instance_id", instance_id)
        _setter("listener_id", listener_id)
        _setter("load_balancer_id", load_balancer_id)
        _setter("network_load_balancer_id", network_load_balancer_id)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("type", type)
        _setter("vlan_id", vlan_id)
        _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetPathAnalyzerTestsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult']):
        GetPathAnalyzerTestsPathAnalyzerTestCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 destination_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult'],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 protocol: int,
                 protocol_parameters: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult'],
                 query_options: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult'],
                 source_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointArgs'] destination_endpoints: Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param str display_name: A filter that returns only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: A unique identifier established when the resource is created. The identifier can't be changed later.
        :param int protocol: The IP protocol to use for the `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterArgs'] protocol_parameters: Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionArgs'] query_options: Defines the query options required for a `PathAnalyzerTest` resource.
        :param Sequence['GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointArgs'] source_endpoints: Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param str time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        GetPathAnalyzerTestsPathAnalyzerTestCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            destination_endpoints=destination_endpoints,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            protocol=protocol,
            protocol_parameters=protocol_parameters,
            query_options=query_options,
            source_endpoints=source_endpoints,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             destination_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult'],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             protocol: int,
             protocol_parameters: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult'],
             query_options: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult'],
             source_endpoints: Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("destination_endpoints", destination_endpoints)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("protocol", protocol)
        _setter("protocol_parameters", protocol_parameters)
        _setter("query_options", query_options)
        _setter("source_endpoints", source_endpoints)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="destinationEndpoints")
    def destination_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoints")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter that returns only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier established when the resource is created. The identifier can't be changed later.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def protocol(self) -> int:
        """
        The IP protocol to use for the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult']:
        """
        Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult']:
        """
        Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @property
    @pulumi.getter(name="sourceEndpoints")
    def source_endpoints(self) -> Sequence['outputs.GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult']:
        """
        Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoints")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult(dict):
    def __init__(__self__, *,
                 address: str,
                 instance_id: str,
                 listener_id: str,
                 load_balancer_id: str,
                 network_load_balancer_id: str,
                 state: str,
                 subnet_id: str,
                 type: str,
                 vlan_id: str,
                 vnic_id: str):
        """
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str type: The type of the `Endpoint`.
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        GetPathAnalyzerTestsPathAnalyzerTestCollectionItemDestinationEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            type=type,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             instance_id: str,
             listener_id: str,
             load_balancer_id: str,
             network_load_balancer_id: str,
             state: str,
             subnet_id: str,
             type: str,
             vlan_id: str,
             vnic_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("instance_id", instance_id)
        _setter("listener_id", listener_id)
        _setter("load_balancer_id", load_balancer_id)
        _setter("network_load_balancer_id", network_load_balancer_id)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("type", type)
        _setter("vlan_id", vlan_id)
        _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult(dict):
    def __init__(__self__, *,
                 destination_port: int,
                 icmp_code: int,
                 icmp_type: int,
                 source_port: int,
                 type: str):
        """
        :param int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param int source_port: The source port to use in a `PathAnalyzerTest` resource.
        :param str type: The type of the `Endpoint`.
        """
        GetPathAnalyzerTestsPathAnalyzerTestCollectionItemProtocolParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            destination_port=destination_port,
            icmp_code=icmp_code,
            icmp_type=icmp_type,
            source_port=source_port,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             destination_port: int,
             icmp_code: int,
             icmp_type: int,
             source_port: int,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("destination_port", destination_port)
        _setter("icmp_code", icmp_code)
        _setter("icmp_type", icmp_type)
        _setter("source_port", source_port)
        _setter("type", type)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> int:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> int:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> int:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult(dict):
    def __init__(__self__, *,
                 is_bi_directional_analysis: bool):
        """
        :param bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        GetPathAnalyzerTestsPathAnalyzerTestCollectionItemQueryOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_bi_directional_analysis=is_bi_directional_analysis,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_bi_directional_analysis: bool,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> bool:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult(dict):
    def __init__(__self__, *,
                 address: str,
                 instance_id: str,
                 listener_id: str,
                 load_balancer_id: str,
                 network_load_balancer_id: str,
                 state: str,
                 subnet_id: str,
                 type: str,
                 vlan_id: str,
                 vnic_id: str):
        """
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str type: The type of the `Endpoint`.
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        GetPathAnalyzerTestsPathAnalyzerTestCollectionItemSourceEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            type=type,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: str,
             instance_id: str,
             listener_id: str,
             load_balancer_id: str,
             network_load_balancer_id: str,
             state: str,
             subnet_id: str,
             type: str,
             vlan_id: str,
             vnic_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("address", address)
        _setter("instance_id", instance_id)
        _setter("listener_id", listener_id)
        _setter("load_balancer_id", load_balancer_id)
        _setter("network_load_balancer_id", network_load_balancer_id)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("type", type)
        _setter("vlan_id", vlan_id)
        _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns only resources whose `lifecycleState` matches the given `lifecycleState`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalysiDestinationEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiDestinationEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiDestinationEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiDestinationEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 address: Optional[str] = None,
                 instance_id: Optional[str] = None,
                 listener_id: Optional[str] = None,
                 load_balancer_id: Optional[str] = None,
                 network_load_balancer_id: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vlan_id: Optional[str] = None,
                 vnic_id: Optional[str] = None):
        """
        :param str type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        PathAnalysiDestinationEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             address: Optional[str] = None,
             instance_id: Optional[str] = None,
             listener_id: Optional[str] = None,
             load_balancer_id: Optional[str] = None,
             network_load_balancer_id: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             vlan_id: Optional[str] = None,
             vnic_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if address is not None:
            _setter("address", address)
        if instance_id is not None:
            _setter("instance_id", instance_id)
        if listener_id is not None:
            _setter("listener_id", listener_id)
        if load_balancer_id is not None:
            _setter("load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            _setter("network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vlan_id is not None:
            _setter("vlan_id", vlan_id)
        if vnic_id is not None:
            _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalysiProtocolParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "icmpCode":
            suggest = "icmp_code"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiProtocolParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiProtocolParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiProtocolParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 destination_port: Optional[int] = None,
                 icmp_code: Optional[int] = None,
                 icmp_type: Optional[int] = None,
                 source_port: Optional[int] = None):
        """
        :param str type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param int destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param int icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param int icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param int source_port: The source port to use in a `PathAnalyzerTest` resource.
        """
        PathAnalysiProtocolParameters._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            destination_port=destination_port,
            icmp_code=icmp_code,
            icmp_type=icmp_type,
            source_port=source_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             destination_port: Optional[int] = None,
             icmp_code: Optional[int] = None,
             icmp_type: Optional[int] = None,
             source_port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if destination_port is not None:
            _setter("destination_port", destination_port)
        if icmp_code is not None:
            _setter("icmp_code", icmp_code)
        if icmp_type is not None:
            _setter("icmp_type", icmp_type)
        if source_port is not None:
            _setter("source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[int]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[int]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[int]:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class PathAnalysiQueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isBiDirectionalAnalysis":
            suggest = "is_bi_directional_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiQueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiQueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiQueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[bool] = None):
        """
        :param bool is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        PathAnalysiQueryOptions._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_bi_directional_analysis=is_bi_directional_analysis,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_bi_directional_analysis: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_bi_directional_analysis is not None:
            _setter("is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[bool]:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class PathAnalysiSourceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalysiSourceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalysiSourceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalysiSourceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 address: Optional[str] = None,
                 instance_id: Optional[str] = None,
                 listener_id: Optional[str] = None,
                 load_balancer_id: Optional[str] = None,
                 network_load_balancer_id: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vlan_id: Optional[str] = None,
                 vnic_id: Optional[str] = None):
        """
        :param str type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        PathAnalysiSourceEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             address: Optional[str] = None,
             instance_id: Optional[str] = None,
             listener_id: Optional[str] = None,
             load_balancer_id: Optional[str] = None,
             network_load_balancer_id: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             vlan_id: Optional[str] = None,
             vnic_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if address is not None:
            _setter("address", address)
        if instance_id is not None:
            _setter("instance_id", instance_id)
        if listener_id is not None:
            _setter("listener_id", listener_id)
        if load_balancer_id is not None:
            _setter("load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            _setter("network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vlan_id is not None:
            _setter("vlan_id", vlan_id)
        if vnic_id is not None:
            _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalyzerTestDestinationEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestDestinationEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestDestinationEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestDestinationEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 address: Optional[str] = None,
                 instance_id: Optional[str] = None,
                 listener_id: Optional[str] = None,
                 load_balancer_id: Optional[str] = None,
                 network_load_balancer_id: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vlan_id: Optional[str] = None,
                 vnic_id: Optional[str] = None):
        """
        :param str type: (Updatable) The type of the `Endpoint`.
        :param str address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: The current state of the `PathAnalyzerTest` resource.
        :param str subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        PathAnalyzerTestDestinationEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             address: Optional[str] = None,
             instance_id: Optional[str] = None,
             listener_id: Optional[str] = None,
             load_balancer_id: Optional[str] = None,
             network_load_balancer_id: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             vlan_id: Optional[str] = None,
             vnic_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if address is not None:
            _setter("address", address)
        if instance_id is not None:
            _setter("instance_id", instance_id)
        if listener_id is not None:
            _setter("listener_id", listener_id)
        if load_balancer_id is not None:
            _setter("load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            _setter("network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vlan_id is not None:
            _setter("vlan_id", vlan_id)
        if vnic_id is not None:
            _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class PathAnalyzerTestProtocolParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPort":
            suggest = "destination_port"
        elif key == "icmpCode":
            suggest = "icmp_code"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "sourcePort":
            suggest = "source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestProtocolParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestProtocolParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestProtocolParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 destination_port: Optional[int] = None,
                 icmp_code: Optional[int] = None,
                 icmp_type: Optional[int] = None,
                 source_port: Optional[int] = None):
        """
        :param str type: (Updatable) The type of the `Endpoint`.
        :param int destination_port: (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        :param int icmp_code: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param int icmp_type: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param int source_port: (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        PathAnalyzerTestProtocolParameters._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            destination_port=destination_port,
            icmp_code=icmp_code,
            icmp_type=icmp_type,
            source_port=source_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             destination_port: Optional[int] = None,
             icmp_code: Optional[int] = None,
             icmp_type: Optional[int] = None,
             source_port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if destination_port is not None:
            _setter("destination_port", destination_port)
        if icmp_code is not None:
            _setter("icmp_code", icmp_code)
        if icmp_type is not None:
            _setter("icmp_type", icmp_type)
        if source_port is not None:
            _setter("source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[int]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[int]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[int]:
        """
        (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")


@pulumi.output_type
class PathAnalyzerTestQueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isBiDirectionalAnalysis":
            suggest = "is_bi_directional_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestQueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestQueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestQueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[bool] = None):
        """
        :param bool is_bi_directional_analysis: (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        PathAnalyzerTestQueryOptions._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_bi_directional_analysis=is_bi_directional_analysis,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_bi_directional_analysis: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_bi_directional_analysis is not None:
            _setter("is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[bool]:
        """
        (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")


@pulumi.output_type
class PathAnalyzerTestSourceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "loadBalancerId":
            suggest = "load_balancer_id"
        elif key == "networkLoadBalancerId":
            suggest = "network_load_balancer_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vlanId":
            suggest = "vlan_id"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PathAnalyzerTestSourceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PathAnalyzerTestSourceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PathAnalyzerTestSourceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 address: Optional[str] = None,
                 instance_id: Optional[str] = None,
                 listener_id: Optional[str] = None,
                 load_balancer_id: Optional[str] = None,
                 network_load_balancer_id: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vlan_id: Optional[str] = None,
                 vnic_id: Optional[str] = None):
        """
        :param str type: (Updatable) The type of the `Endpoint`.
        :param str address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param str instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param str listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param str load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param str network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param str state: The current state of the `PathAnalyzerTest` resource.
        :param str subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param str vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param str vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        PathAnalyzerTestSourceEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            address=address,
            instance_id=instance_id,
            listener_id=listener_id,
            load_balancer_id=load_balancer_id,
            network_load_balancer_id=network_load_balancer_id,
            state=state,
            subnet_id=subnet_id,
            vlan_id=vlan_id,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             address: Optional[str] = None,
             instance_id: Optional[str] = None,
             listener_id: Optional[str] = None,
             load_balancer_id: Optional[str] = None,
             network_load_balancer_id: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             vlan_id: Optional[str] = None,
             vnic_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if address is not None:
            _setter("address", address)
        if instance_id is not None:
            _setter("instance_id", instance_id)
        if listener_id is not None:
            _setter("listener_id", listener_id)
        if load_balancer_id is not None:
            _setter("load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            _setter("network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if vlan_id is not None:
            _setter("vlan_id", vlan_id)
        if vnic_id is not None:
            _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vnic_id")


