""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ipv6gw.schemas import apis


class ipv6gwClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(ipv6gwClient, self).__init__(
            config, transport, middleware, logger
        )

    def modify_ipv_6internet_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyIpv6InternetBandwidth - 修改ipv6公网带宽值

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Bandwidth** (int) - 要修改为的出向带宽峰值。带宽值范围[1, 2000]
        - **InternetBandwidthId** (str) - ipv6公网带宽Id；与Ipv6AddressId二选一必填
        - **Ipv6AddressId** (str) - Ipv6地址 id；与InternetBandwidthId二选一必填

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyIpv6InternetBandwidthRequestSchema().dumps(d)

        resp = self.invoke("ModifyIpv6InternetBandwidth", d, **kwargs)
        return apis.ModifyIpv6InternetBandwidthResponseSchema().loads(resp)
