""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ubill.schemas import apis


class UBillClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UBillClient, self).__init__(config, transport, middleware, logger)

    def create_renew(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """CreateRenew - 创建单个续费订单

        **Request**

        - **Quantity** (int) - (Required) 续费周期数[1~10]，按月计费资源可传值为0，表示续费到月底
        - **ResourceId** (str) - (Required) 需要续费资源ID

        **Response**

        - **OrderNo** (str) - 订单号

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.CreateRenewRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateRenew", d, **kwargs)
        return apis.CreateRenewResponseSchema().loads(resp)

    def get_balance(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """GetBalance - 获取账户余额

        **Request**


        **Response**

        - **AccountInfo** (dict) - 见 **AccountInfo** 模型定义

        **Response Model**

        **AccountInfo**
        - **Amount** (str) - 账户余额
        - **AmountAvailable** (str) - 账户可用余额
        - **AmountCredit** (str) - 信用账户余额
        - **AmountFree** (str) - 赠送账户余额
        - **AmountFreeze** (str) - 冻结账户金额


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBalanceRequestSchema().dumps(d)

        resp = self.invoke("GetBalance", d, **kwargs)
        return apis.GetBalanceResponseSchema().loads(resp)

    def get_bill_data_file_url(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetBillDataFileUrl - 生成账单数据文件下载的 url，包含三类文件，1. 已支付总览账单(支持CSV和PDF,从2023年03月开始支持PDF)；2. 未支付总览文件(支持CSV，只有当月账期可以查看)；3 账单详情文件(支持CSV)。           备注：文件生成有延迟，若返回值 IsValid=‘no’，需要使用者发起重试。

        **Request**

        - **BillType** (int) - (Required) 账单类型，枚举值：\\ > 0: 账单总览报表; \\ > 1: 账单明细报表
        - **BillingCycle** (str) - (Required) 账期: YYYY-MM格式的字符串，例如 ”2021-08“
        - **BillPeriod** (int) - 账期: 时间戳格式，已弃用，请使用BillingCycle
        - **Format** (str) - 文件格式，枚举值：\\ > ”csv“: csv格式;\\ > ”pdf“: pdf格式(已支付总览文件 从2023年03月开始支持PDF)
        - **PaidType** (int) - 账单支付状态，  (获取账单明细报表，不需要填写该参数)，枚举值：\\ > 0: 0待支付总览账单(只支持当前月份的账期);\\ > 1: 已支付账单总览
        - **RequireVersion** (str) - 账单语言版本，枚举值：\\ > ”“: 默认中文;\\ > ”EN“: 英文版本
        - **Version** (str) - 文件版本，固定值"v1"。

        **Response**

        - **FileUrl** (str) - 交易账单文件下载URL
        - **IsValid** (str) - 是否有对应数据文件。(该参数返回no，表示文件正在生成中，需要用户发起重试获取。

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBillDataFileUrlRequestSchema().dumps(d)

        resp = self.invoke("GetBillDataFileUrl", d, **kwargs)
        return apis.GetBillDataFileUrlResponseSchema().loads(resp)

    def list_u_bill_detail(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ListUBillDetail - 获取某个账期内的所有消费。

        **Request**

        - **BillingCycle** (str) - (Required) 账期，YYYY-MM，比如2021-08，只支持2018-05之后的查询
        - **ChargeType** (str) - 计费方式 (筛选项, 默认全部)。枚举值：\\ > Year:按年\\ > Month:按月 \\ > Day:按天 \\ > Dynamic:按时  \\ > Used:按量 \\ > Donate:赠送 \\ > Trial:试用  \\ > Post:后付费  \\ > Spot:抢占式
        - **Limit** (int) - 每页数量，默认值25，最大值：100。
        - **Offset** (int) - 数据偏移量 (默认0)
        - **OrderType** (str) - 订单类型 (筛选项, 默认全部) 。枚举值：\\ > OT_BUY:新购 \\ > OT_RENEW:续费 \\ > OT_UPGRADE:升级 \\ > OT_DOWNGRADE:降级 \\ > OT_SUSPEND:结算 \\ > OT_ADDITIONAL:补单 \\ > OT_REFUND:删除 \\ > OT_POSTPAID_RENEW:过期 \\ > OT_POSTPAID_PAYMENT:后付费 \\ > OT_RECOVER:删除恢复
        - **PaidState** (int) - 支付状态 (筛选项, 1:仅显示未支付订单; 2:仅显示已支付订单; 0:两者都显示)	    当前月份 传递1或者0，会返回历史所有未支付账单；历史月份不支持查询未支付，请勿传递1
        - **ProjectName** (str) - 项目名称 (筛选项, 默认全部)
        - **ResourceIds** (list) - 资源ID(筛选项, 默认全部)	支持多筛选，多筛选请在请求参数中添加多个字段例ResourceIds.0: uhost-bzgf1gh5，ResourceIds.1: uhost-gu1xpspa，
        - **ResourceTypes** (list) - 产品类型 (筛选项, 默认全部),支持多筛选，多筛选请在请求参数中添加多个字段。枚举值：\\ > uhost:云主机 \\ > udisk:普通云硬盘 \\ > udisk_ssd:SSD云硬盘 \\ > rssd:RSSD云硬盘 \\ > snapshot:云快照 \\ > uimage:云主机镜像 \\ > isolation_group:硬件隔离组 \\ > udisk_system_disk:云硬盘系统盘 \\ > phost:裸金属云主机 \\ > udset:资源池 \\ > udhost:专区宿主 \\ > rack:托管云机位 \\ > hybrid_rack:托管云机柜 \\ > hybrid_machine:托管云物理机 \\ > userver:金翼物理机 \\ > hybrid_host:托管云物理云主机 \\ > hybrid_vip_service:启明VIP服务 \\ > hybrid_public_net:外网-IP段 \\ > hybrid_public_bw:外网-带宽 \\ > rack_bw:网络 \\ > ulink:内网-云互通 \\ > hybrid_others:耗材 \\ > uconnect:专线 \\ > hybrid_switch:交换机 \\ > hybrid_port:交换机端口 \\ > shared_bandwidth:共享带宽 \\ > eip:弹性IP \\ > traffic:流量 \\ > bandwidth:带宽包 \\ > vpn:VPN网关 \\ > firewall:防火墙 \\ > vip:内网IP \\ > UAnycastClean:Anycast全球清洗防护包 \\ > AnycastEIP:AnycastEIP \\ > ulb:负载均衡 \\ > vlb:专享型ULB \\ > ssl:证书管理 \\ > subnet:子网 \\ > natgw:NAT网关 \\ > vpc:虚拟私有网络 \\ > acl:访问控制列表 \\ > udpn:高速通道 \\ > vpngw:VPN网关 \\ > remotevpngw:客户网关 \\ > vpn_tunnel:隧道 \\ > udee:域名要素引擎 \\ > ugaa:全球动态加速 \\ > upath:线路管理 \\ > Roma:罗马 \\ > ufs:文件存储 \\ > ufile:对象存储 \\ > udataark:数据方舟 \\ > uarchive:归档存储 \\ > ucdn:云分发 \\ > uodn:开放式分发节点 \\ > uodn2:边缘分发节点 \\ > umem:云内存存储 \\ > umemcache:单机版memcache \\ > uredis:主备版redis \\ > udb:云数据库 \\ > mongodb:MongoDB \\ > sqlserver:SQLServer \\ > postgresql:PostgreSQL \\ > utsdb:时序数据库 \\ > uddb:分布式数据库 \\ > tidb:分布式NewSQL数据库 \\ > Hadoop:托管Hadoop集群 \\ > HadoopHost:托管Hadoop集群节点 \\ > udw:云数据仓库 \\ > ues:弹性搜索 \\ > uscheduler:调度系统 \\ > ukafka:Kafka消息队列 \\ > usql_end:数据湖分析 \\ > UFlink:Flink实时计算 \\ > ukafka_host:Kafka消息队列节点 \\ > UKafkaSinker:Kafka连接器 \\ > message_queue:消息队列 \\ > UAPIGateway:API网关 \\ > ucs:通用计算 \\ > docker_uhost:节点 \\ > uiot:UIoT-Core \\ > uai_service:AI在线服务 \\ > uai_training:AI训练服务 \\ > UAI-Censor:AI内容审核 \\ > uvideo:云点播 \\ > ulive:云直播 \\ > umedia:媒体工厂 \\ > VideoSDK:视频工具 \\ > UKMS:密钥管理服务 \\ > SDefense:高防 \\ > ADS-HD:华东高防 \\ > ADS-abroad:海外高防 \\ > uclean:清洗 \\ > waf:WEB应用防火墙 \\ > uws:WEB漏洞扫描 \\ > uhids:主机入侵检测 \\ > uencrypt:加密服务 \\ > fortress_host:堡垒机 \\ > db_audit:数据库审计 \\ > usa:云安全中心 \\ > udbcp:等保咨询 \\ > usms:短信包 \\ > udnr:域名注册服务 \\ > hegui:备案 \\ > ussl:SSL证书唯一标识 \\ > umarket:应用市场 \\ > urtc:实时音视频 \\ > umr:MapReduce \\ > utss:UCloud技术支持服务 \\ > store_box:店铺盒子 \\ > ukv:容量型KV存储 \\ > ucloudperation:云合作 \\ > umon_network:网络质量监控 \\ > uaccess_box:UBox \\ > UOPS:运维服务 \\ > TeuProduct:非标-企业 \\ > TeuHumanResource:服务-企业 \\ > UBI:数据可视化分析 \\ > First_tier_Bandwidth:ODN一线城市带宽 \\ > Second_tier_Bandwidth:ODN二线城市带宽 \\ > ODN-EDU-BW:ODN教育网带宽 \\ > uodn_docker_resource:ODN容器 \\ > UAI-Solution:AI解决方案 \\ > USNAPSHOT:磁盘快照服务 \\ > ServiceFee:一次性收费 \\ > UCloudAntiDDoS-NorthChinaBGP:高防-华北BGP \\ > Cube:容器实例 \\ > UHybrid-EBN:混合云-企业网 \\ > UHybrid-VBS:混合云-虚拟边界交换机 \\ > UHybrid-EBNBandwidth:混合云-企业网带宽 \\ > UCGS:云游戏 \\ > USDP:智能大数据平台 \\ > UIoT-Stack:物联网平台系统套件 \\ > uiotedgebox:物联网边缘盒子 \\ > UClickhouse:云数据库仓库UClickHouse \\ > UDNS:云解析 \\ > UFS-SMB:SMB文件系统 \\ > EPC:云极高性能计算节点 \\ > EPCCluster:高性能计算集群 \\ > Instance:海外站云主机 \\ > UGA3:全球动态加速 \\ > uhybrid_xzone:混合云-金翼XZone \\ > udts:数据传输服务 \\ > uk8s_service:容器云 \\ > UIW:无间盾反欺诈系统 \\ > ISMS:视频短信 \\ > PLiveUPRO:Polyv云直播U享版 \\ > UNVS:号码认证 \\ > UVMS:语音消息服务 \\ > UGame:云游戏 \\ > UHive:UHive \\ > UDoris:UDoris \\ > USLK:短链工具 \\ > UPCA:UPCA \\ > URCM:富信消息 \\ > HTTPDNS:HTTP DNS \\ > UAdsSp:DDOS防御服务包 \\ > UPhone-eip:云手机（eip） \\ > UPhone-share-bandwidth:云手机（共享带宽） \\ > UCloud Phone Server:云手机服务器 \\ > UMongoDBMember:云数据库 MongoDB UDB 集群内节点成员 \\ > UPhone-NetworkResource:云手机（网络资源） \\ > UOL:海外直播加速 \\ > UDBProxy:云数据库读写分离中间件 \\ > UDBProxyMember:云数据库读写分离中间件集群内成员 \\ > UPgSQL:UDB For PgSQL \\ > UMongoDB:UMongoDB \\ > UPresto:UPresto \\ > UDBC:UDBC \\ > CAAS:CAAS \\ > UPhone:云手机 \\ > NVAS:混合云-网络增值服务 \\ > UNPP:号码隐私保护 \\ > UNPP:企业名片 \\ > UMongoDBVirtualMember:云数据库 MongoDB UDB集群内虚拟节点 \\ > CF-antiddos:CF高防服务 \\ > UAM:优信 \\ > UAIModelFactory:人工智能模型工厂 \\ > UGNBW:云联网带宽包 \\ > UDAS:数据库自治服务 \\ > URM:资源迁移 \\ > UDTS-DI:数据传输服务-数据集成 \\ > ALB:应用型负载均衡 \\ > UTrafficPack:共享流量包 \\ > ULHost:轻量应用云主机 \\ > UWSCBandwith:UWAN智联-接入带宽包 \\ > MySQLBackup:MySQL 备份服务 \\ > SkyMirror:天镜 \\ > UCustomImage:自定义镜像 \\ > UDTS-DIS:数据传输服务-数据集成子任务 \\ > utm:流量镜像 \\ > NLB:网络型负载均衡 \\ > ALS:ALB监听器 \\ > NLS:NLB监听器 \\ > ARS:ALB服务节点 \\ > NRS:NLB服务节点 \\ > UAIM:卡片消息 \\ > UWSC:UWAN智联 \\ > LBIP:负载均衡内网IP \\ > ULogstash:Logstash服务 \\ > UWCE:UWAN智联-CE客户网关 \\ > UWSC-Tunnel:UWAN智联-VPN隧道 \\ > UNDT:网络拨测 \\ > UHBW:托管带宽包 \\ > UHNet:托管网络 \\ > UH-VRrouter:托管虚拟路由器 \\ > XC:楼内线 \\ > UModelVerse:模型服务平台 \\ > ULogstash-Node:Logstash Node服务 \\ > CloudWatch:云监控 \\ > UGN:云联网 \\ > epsrv:终端节点服务 \\ > ep:终端节点 \\ > uwcpe:CPE智能网关 \\ > uwcpetunnel:CPE隧道 \\ > USCS:安全定制服务 \\ > UAAA:应用仓库加速 \\ > ULogService:日志服务 \\ > UXZONE-GPU:金翼GPU \\ > UReach:优睿达 \\ > UPLVR:专线虚拟路由器 \\ > maxir:云数据仓库MAXIR \\ > maxirvector:云数据仓库MAXIR向量版 \\ > UPFS:文件存储UPFS \\ > UMarketplace:云市场 \\ > IPRP:IP资源池 \\ > ExclusiveHosts:包销宿主机 \\ > RedisReplicate:Redis 从库 \\ > SecurityCenter:云安全中心 \\ > PrivateLink:私有链接 \\ > UMongoDBBackup:MongoDB备份服务 \\ > TiDBCluster:分布式数据库 TiDB Cluster \\ > MAXIRDPS:MAXIR DPS \\ > Label:标签 \\ > NVAS:混合云网络增值服务 \\ > UIBUDS:互联网事业部开发服务 \\ > KafkaGroup:Kafka消费组 \\ > RLM:实时无损监控告警 \\ > USG:安全组 \\ > CF-antiddos:CF高防服务 \\ > UClickhouseNode:云数据仓库UClickhouse节点 \\ > HPCExpress:盘柜直达服务 \\ > UDI:数据智能 \\ > UMountPoint:文件系统挂载点 \\ > UPrometheus:托管Prometheus服务 \\ > AnycastCleanPromotion:全球清洗促销 \\ > USMC:服务器迁移中心 \\ > UK8SPod:UK8SPod 类型资源 \\ > UAS:弹性伸缩 \\ > Manul:统一存储 \\ > UDas:分部式应用服务 \\ > USecLog:安全日志审计 \\ > UKafkaSinkerNode:Kafka连接器节点 \\ > IPv6Address:IPv6地址 \\ > UFlink-Node:Flink实时计算节点 \\ > UContract:电子合同 \\ > NAT64:IPv6转换 \\ > OBJ_TYPE_UDDBAC:UDDB分析节点 \\ > OBJ_TYPE_SYS_UDISK_SSD:SSD云硬盘系统盘 \\ > utoken:令牌服务 \\ > UATP:API测试平台 \\ > udb_region:跨可用区高可用数据库 \\ > compshareImage:算力镜像 \\ > commImage:算力社区镜像 \\ > MAXIR AI:知识洞察 \\ > UCNest:算力云巢 \\ > IPV6 Gateway:IPV6公网网关 \\ > UCNest ExIP:算力云巢外网IP \\ > IPV6 Address:IPV6地址 \\ > UDBProxy RoGroup for MySQL:数据库代理只读组 \\ > SSD Essential:经济型SSD云盘 \\ > RSSD Essential:经济型RSSD云盘 \\ > RocketMQ Message Queue Node:消息队列节点 \\ > Runc Instance:Runc 实例 \\ > Runc Image:Runc 镜像 \\ > UCDC:专属云平台服务 \\ > Other:其他
        - **ShowZero** (int) - 是否显示0元订单 (0 不显示, 1 显示, 默认0)
        - **UserEmail** (str) - 用户邮箱，可以根据用户邮箱来进行筛选

        **Response**

        - **Items** (list) - 见 **BillDetailItem** 模型定义
        - **TotalCount** (int) - 账单明细总长度

        **Response Model**

        **ItemDetail**
        - **ProductName** (str) - 产品小类名称
        - **Value** (str) - 产品小类规格


        **ResourceExtendInfo**
        - **KeyId** (str) - 资源标识健
        - **Value** (str) - 资源标识值


        **BillDetailItem**
        - **Admin** (int) - 是否为主账号。枚举值：\\ > 0:子账号 \\ > 1:主账号
        - **Amount** (str) - 订单总金额
        - **AmountCoupon** (str) - 代金券抵扣
        - **AmountFree** (str) - 赠送金额抵扣
        - **AmountReal** (str) - 现金账户支付
        - **AzGroupCName** (str) - 可用区
        - **BusinessGroup** (str) - 业务组
        - **ChargeType** (str) - 计费方式 (筛选项, 默认全部)。枚举值：\\ > Year:按年\\ > Month:按月 \\ > Day:按天 \\ > Dynamic:按时 \\ > Used:按量 \\ > Donate:赠送 \\ > Trial:试用 \\ > Post:后付费 \\ > Spot:抢占式
        - **CreateTime** (int) - 创建时间（时间戳）
        - **EndTime** (int) - 结束时间（时间戳）
        - **ItemDetails** (list) - 见 **ItemDetail** 模型定义
        - **OrderNo** (str) - 订单号
        - **OrderType** (str) - 订单类型 (筛选项, 默认全部) 。枚举值：\\ > OT_BUY:新购 \\ > OT_RENEW:续费 \\ > OT_UPGRADE:升级 \\ > OT_DOWNGRADE:降级 \\ > OT_SUSPEND:结算 \\ > OT_ADDITIONAL:补单 \\ > OT_REFUND:删除 \\ > OT_POSTPAID_RENEW:过期 \\ > OT_POSTPAID_PAYMENT:后付费 \\ > OT_RECOVER:删除恢复
        - **ProjectId** (str) - 项目id
        - **ProjectName** (str) - 项目名称
        - **ResourceExtendInfo** (list) - 见 **ResourceExtendInfo** 模型定义
        - **ResourceId** (str) - 资源ID
        - **ResourceLabel** (dict) - 资源标签。字符串键值对的map：{"cs_label": "cs_label_value"}
        - **ResourceType** (str) - 产品类型 (筛选项, 默认全部),支持多筛选，多筛选请在请求参数中添加多个字段。枚举值：\\ > uhost:云主机 \\ > udisk:普通云硬盘 \\ > udisk_ssd:SSD云硬盘 \\ > rssd:RSSD云硬盘 \\ > snapshot:云快照 \\ > uimage:云主机镜像 \\ > isolation_group:硬件隔离组 \\ > udisk_system_disk:云硬盘系统盘 \\ > phost:裸金属云主机 \\ > udset:资源池 \\ > udhost:专区宿主 \\ > rack:托管云机位 \\ > hybrid_rack:托管云机柜 \\ > hybrid_machine:托管云物理机 \\ > userver:金翼物理机 \\ > hybrid_host:托管云物理云主机 \\ > hybrid_vip_service:启明VIP服务 \\ > hybrid_public_net:外网-IP段 \\ > hybrid_public_bw:外网-带宽 \\ > rack_bw:网络 \\ > ulink:内网-云互通 \\ > hybrid_others:耗材 \\ > uconnect:专线 \\ > hybrid_switch:交换机 \\ > hybrid_port:交换机端口 \\ > shared_bandwidth:共享带宽 \\ > eip:弹性IP \\ > traffic:流量 \\ > bandwidth:带宽包 \\ > vpn:VPN网关 \\ > firewall:防火墙 \\ > vip:内网IP \\ > UAnycastClean:Anycast全球清洗防护包 \\ > AnycastEIP:AnycastEIP \\ > ulb:负载均衡 \\ > vlb:专享型ULB \\ > ssl:证书管理 \\ > subnet:子网 \\ > natgw:NAT网关 \\ > vpc:虚拟私有网络 \\ > acl:访问控制列表 \\ > udpn:高速通道 \\ > vpngw:VPN网关 \\ > remotevpngw:客户网关 \\ > vpn_tunnel:隧道 \\ > udee:域名要素引擎 \\ > ugaa:全球动态加速 \\ > upath:线路管理 \\ > Roma:罗马 \\ > ufs:文件存储 \\ > ufile:对象存储 \\ > udataark:数据方舟 \\ > uarchive:归档存储 \\ > ucdn:云分发 \\ > uodn:开放式分发节点 \\ > uodn2:边缘分发节点 \\ > umem:云内存存储 \\ > umemcache:单机版memcache \\ > uredis:主备版redis \\ > udb:云数据库 \\ > mongodb:MongoDB \\ > sqlserver:SQLServer \\ > postgresql:PostgreSQL \\ > utsdb:时序数据库 \\ > uddb:分布式数据库 \\ > tidb:分布式NewSQL数据库 \\ > Hadoop:托管Hadoop集群 \\ > HadoopHost:托管Hadoop集群节点 \\ > udw:云数据仓库 \\ > ues:弹性搜索 \\ > uscheduler:调度系统 \\ > ukafka:Kafka消息队列 \\ > usql_end:数据湖分析 \\ > UFlink:Flink实时计算 \\ > ukafka_host:Kafka消息队列节点 \\ > UKafkaSinker:Kafka连接器 \\ > message_queue:消息队列 \\ > UAPIGateway:API网关 \\ > ucs:通用计算 \\ > docker_uhost:节点 \\ > uiot:UIoT-Core \\ > uai_service:AI在线服务 \\ > uai_training:AI训练服务 \\ > UAI-Censor:AI内容审核 \\ > uvideo:云点播 \\ > ulive:云直播 \\ > umedia:媒体工厂 \\ > VideoSDK:视频工具 \\ > UKMS:密钥管理服务 \\ > SDefense:高防 \\ > ADS-HD:华东高防 \\ > ADS-abroad:海外高防 \\ > uclean:清洗 \\ > waf:WEB应用防火墙 \\ > uws:WEB漏洞扫描 \\ > uhids:主机入侵检测 \\ > uencrypt:加密服务 \\ > fortress_host:堡垒机 \\ > db_audit:数据库审计 \\ > usa:云安全中心 \\ > udbcp:等保咨询 \\ > usms:短信包 \\ > udnr:域名注册服务 \\ > hegui:备案 \\ > ussl:SSL证书唯一标识 \\ > umarket:应用市场 \\ > urtc:实时音视频 \\ > umr:MapReduce \\ > utss:UCloud技术支持服务 \\ > store_box:店铺盒子 \\ > ukv:容量型KV存储 \\ > ucloudperation:云合作 \\ > umon_network:网络质量监控 \\ > uaccess_box:UBox \\ > UOPS:运维服务 \\ > TeuProduct:非标-企业 \\ > TeuHumanResource:服务-企业 \\ > UBI:数据可视化分析 \\ > First_tier_Bandwidth:ODN一线城市带宽 \\ > Second_tier_Bandwidth:ODN二线城市带宽 \\ > ODN-EDU-BW:ODN教育网带宽 \\ > uodn_docker_resource:ODN容器 \\ > UAI-Solution:AI解决方案 \\ > USNAPSHOT:磁盘快照服务 \\ > ServiceFee:一次性收费 \\ > UCloudAntiDDoS-NorthChinaBGP:高防-华北BGP \\ > Cube:容器实例 \\ > UHybrid-EBN:混合云-企业网 \\ > UHybrid-VBS:混合云-虚拟边界交换机 \\ > UHybrid-EBNBandwidth:混合云-企业网带宽 \\ > UCGS:云游戏 \\ > USDP:智能大数据平台 \\ > UIoT-Stack:物联网平台系统套件 \\ > uiotedgebox:物联网边缘盒子 \\ > UClickhouse:云数据库仓库UClickHouse \\ > UDNS:云解析 \\ > UFS-SMB:SMB文件系统 \\ > EPC:云极高性能计算节点 \\ > EPCCluster:高性能计算集群 \\ > Instance:海外站云主机 \\ > UGA3:全球动态加速 \\ > uhybrid_xzone:混合云-金翼XZone \\ > udts:数据传输服务 \\ > uk8s_service:容器云 \\ > UIW:无间盾反欺诈系统 \\ > ISMS:视频短信 \\ > PLiveUPRO:Polyv云直播U享版 \\ > UNVS:号码认证 \\ > UVMS:语音消息服务 \\ > UGame:云游戏 \\ > UHive:UHive \\ > UDoris:UDoris \\ > USLK:短链工具 \\ > UPCA:UPCA \\ > URCM:富信消息 \\ > HTTPDNS:HTTP DNS \\ > UAdsSp:DDOS防御服务包 \\ > UPhone-eip:云手机（eip） \\ > UPhone-share-bandwidth:云手机（共享带宽） \\ > UCloud Phone Server:云手机服务器 \\ > UMongoDBMember:云数据库 MongoDB UDB 集群内节点成员 \\ > UPhone-NetworkResource:云手机（网络资源） \\ > UOL:海外直播加速 \\ > UDBProxy:云数据库读写分离中间件 \\ > UDBProxyMember:云数据库读写分离中间件集群内成员 \\ > UPgSQL:UDB For PgSQL \\ > UMongoDB:UMongoDB \\ > UPresto:UPresto \\ > UDBC:UDBC \\ > CAAS:CAAS \\ > UPhone:云手机 \\ > NVAS:混合云-网络增值服务 \\ > UNPP:号码隐私保护 \\ > UNPP:企业名片 \\ > UMongoDBVirtualMember:云数据库 MongoDB UDB集群内虚拟节点 \\ > CF-antiddos:CF高防服务 \\ > UAM:优信 \\ > UAIModelFactory:人工智能模型工厂 \\ > UGNBW:云联网带宽包 \\ > UDAS:数据库自治服务 \\ > URM:资源迁移 \\ > UDTS-DI:数据传输服务-数据集成 \\ > ALB:应用型负载均衡 \\ > UTrafficPack:共享流量包 \\ > ULHost:轻量应用云主机 \\ > UWSCBandwith:UWAN智联-接入带宽包 \\ > MySQLBackup:MySQL 备份服务 \\ > SkyMirror:天镜 \\ > UCustomImage:自定义镜像 \\ > UDTS-DIS:数据传输服务-数据集成子任务 \\ > utm:流量镜像 \\ > NLB:网络型负载均衡 \\ > ALS:ALB监听器 \\ > NLS:NLB监听器 \\ > ARS:ALB服务节点 \\ > NRS:NLB服务节点 \\ > UAIM:卡片消息 \\ > UWSC:UWAN智联 \\ > LBIP:负载均衡内网IP \\ > ULogstash:Logstash服务 \\ > UWCE:UWAN智联-CE客户网关 \\ > UWSC-Tunnel:UWAN智联-VPN隧道 \\ > UNDT:网络拨测 \\ > UHBW:托管带宽包 \\ > UHNet:托管网络 \\ > UH-VRrouter:托管虚拟路由器 \\ > XC:楼内线 \\ > UModelVerse:模型服务平台 \\ > ULogstash-Node:Logstash Node服务 \\ > CloudWatch:云监控 \\ > UGN:云联网 \\ > epsrv:终端节点服务 \\ > ep:终端节点 \\ > uwcpe:CPE智能网关 \\ > uwcpetunnel:CPE隧道 \\ > USCS:安全定制服务 \\ > UAAA:应用仓库加速 \\ > ULogService:日志服务 \\ > UXZONE-GPU:金翼GPU \\ > UReach:优睿达 \\ > UPLVR:专线虚拟路由器 \\ > maxir:云数据仓库MAXIR \\ > maxirvector:云数据仓库MAXIR向量版 \\ > UPFS:文件存储UPFS \\ > UMarketplace:云市场 \\ > IPRP:IP资源池 \\ > ExclusiveHosts:包销宿主机 \\ > RedisReplicate:Redis 从库 \\ > SecurityCenter:云安全中心 \\ > PrivateLink:私有链接 \\ > UMongoDBBackup:MongoDB备份服务 \\ > TiDBCluster:分布式数据库 TiDB Cluster \\ > MAXIRDPS:MAXIR DPS \\ > Label:标签 \\ > NVAS:混合云网络增值服务 \\ > UIBUDS:互联网事业部开发服务 \\ > KafkaGroup:Kafka消费组 \\ > RLM:实时无损监控告警 \\ > USG:安全组 \\ > CF-antiddos:CF高防服务 \\ > UClickhouseNode:云数据仓库UClickhouse节点 \\ > HPCExpress:盘柜直达服务 \\ > UDI:数据智能 \\ > UMountPoint:文件系统挂载点 \\ > UPrometheus:托管Prometheus服务 \\ > AnycastCleanPromotion:全球清洗促销 \\ > USMC:服务器迁移中心 \\ > UK8SPod:UK8SPod 类型资源 \\ > UAS:弹性伸缩 \\ > Manul:统一存储 \\ > UDas:分部式应用服务 \\ > USecLog:安全日志审计 \\ > UKafkaSinkerNode:Kafka连接器节点 \\ > IPv6Address:IPv6地址 \\ > UFlink-Node:Flink实时计算节点 \\ > UContract:电子合同 \\ > NAT64:IPv6转换 \\ > OBJ_TYPE_UDDBAC:UDDB分析节点 \\ > OBJ_TYPE_SYS_UDISK_SSD:SSD云硬盘系统盘 \\ > utoken:令牌服务 \\ > UATP:API测试平台 \\ > udb_region:跨可用区高可用数据库 \\ > compshareImage:算力镜像 \\ > commImage:算力社区镜像 \\ > MAXIR AI:知识洞察 \\ > UCNest:算力云巢 \\ > IPV6 Gateway:IPV6公网网关 \\ > UCNest ExIP:算力云巢外网IP \\ > IPV6 Address:IPV6地址 \\ > UDBProxy RoGroup for MySQL:数据库代理只读组 \\ > SSD Essential:经济型SSD云盘 \\ > RSSD Essential:经济型RSSD云盘 \\ > RocketMQ Message Queue Node:消息队列节点 \\ > Runc Instance:Runc 实例 \\ > Runc Image:Runc 镜像 \\ > UCDC:专属云平台服务 \\ > Other:其他
        - **ResourceTypeCode** (int) - 产品类型代码
        - **ShowHover** (int) - 订单支付状态。枚举值：\\> 0:未支付 \\ > 1:已支付
        - **StartTime** (int) - 开始时间（时间戳）
        - **UserDisplayName** (str) - 账户昵称
        - **UserEmail** (str) - 账户邮箱
        - **UserName** (str) - 账户名


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.ListUBillDetailRequestSchema().dumps(d)

        resp = self.invoke("ListUBillDetail", d, **kwargs)
        return apis.ListUBillDetailResponseSchema().loads(resp)

    def list_u_bill_overview(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ListUBillOverview - 账单总览。可按产品/项目/用户纬度获取某个账期内账单总览信息。

        **Request**

        - **BillingCycle** (str) - (Required) 账期，YYYY-MM格式，例如2022-02，只支持2018-05之后的查询
        - **Dimension** (str) - (Required) 账单维度, product 按产品聚合,project 按项目聚合，user 按子账号聚合
        - **HideUnpaid** (int) - 是否显示已入账账单, 1 已入账, 0 待入账 (默认0 )

        **Response**

        - **Items** (list) - 见 **BillOverviewItem** 模型定义
        - **TotalCount** (int) - 账单总览数据总数
        - **TotalPaidAmount** (str) - 已入账订单总额（已入账时显示）
        - **TotalPaidAmountReal** (str) - 现金账户扣款总额	（已入账时显示）
        - **TotalUnpaidAmount** (str) - 待入账订单总额（待入账时显示）

        **Response Model**

        **BillOverviewItem**
        - **Admin** (int) - 该账户是否为主账号，1 主账号，0 子账号（账单维度按子账号筛选时显示）
        - **Amount** (str) - 订单总金额
        - **AmountCoupon** (str) - 代金券抵扣（已入账时显示）
        - **AmountFree** (str) - 赠送金额抵扣（已入账时显示）
        - **AmountReal** (str) - 现金账户支付（已入账时显示）
        - **Dimension** (str) - 账单维度, product 按产品维度聚合,project 按项目维度聚合，user 按子账号维度聚合
        - **ProductCategory** (str) - 产品分类	（账单维度按产品筛选时显示）
        - **ProjectName** (str) - 项目名称（账单维度按项目筛选时显示）
        - **ResourceType** (str) - 产品类型	（账单维度按产品筛选时显示）
        - **ResourceTypeCode** (int) - 产品类型代码（账单维度按产品筛选时显示）
        - **UserDisplayName** (str) - 账户昵称（账单维度按子账号筛选时显示）
        - **UserEmail** (str) - 账户邮箱（账单维度按子账号筛选时显示）
        - **UserName** (str) - 账户名   （账单维度按子账号筛选时显示）


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.ListUBillOverviewRequestSchema().dumps(d)

        resp = self.invoke("ListUBillOverview", d, **kwargs)
        return apis.ListUBillOverviewResponseSchema().loads(resp)

    def modify_auto_renew_flag(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyAutoRenewFlag - 修改资源自动续费标识

        **Request**

        - **Flag** (str) - (Required) 开关标识(TURN_ON: 打开; TURN_OFF: 关闭)
        - **ResourceId** (str) - (Required) 资源ID

        **Response**

        - **Fail** (int) - 操作失败资源数量
        - **ResultSet** (list) - 见 **ResultSet** 模型定义
        - **Success** (int) - 操作成功资源数量

        **Response Model**

        **ResultSet**
        - **Message** (str) - 错误信息描述
        - **ResourceId** (str) - 资源ID
        - **RetCode** (int) - 续费结果(0:成功，失败返回错误码)


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.ModifyAutoRenewFlagRequestSchema().dumps(d)

        resp = self.invoke("ModifyAutoRenewFlag", d, **kwargs)
        return apis.ModifyAutoRenewFlagResponseSchema().loads(resp)
