""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.upfs.schemas import models

""" UPFS API Schema
"""


"""
API: CreateUPFSVolume

创建UPFS文件系统
"""


class CreateUPFSVolumeRequestSchema(schema.RequestSchema):
    """CreateUPFSVolume - 创建UPFS文件系统"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ProtocolType": fields.Str(required=True, dump_to="ProtocolType"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VolumeName": fields.Str(required=False, dump_to="VolumeName"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUPFSVolumeResponseSchema(schema.ResponseSchema):
    """CreateUPFSVolume - 创建UPFS文件系统"""

    fields = {
        "VolumeId": fields.Str(required=True, load_from="VolumeId"),
        "VolumeName": fields.Str(required=True, load_from="VolumeName"),
    }


"""
API: DescribeUPFSVolume

获取UPFS文件系统列表
"""


class DescribeUPFSVolumeRequestSchema(schema.RequestSchema):
    """DescribeUPFSVolume - 获取UPFS文件系统列表"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VolumeId": fields.Str(required=False, dump_to="VolumeId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUPFSVolumeResponseSchema(schema.ResponseSchema):
    """DescribeUPFSVolume - 获取UPFS文件系统列表"""

    fields = {
        "DataSet": fields.List(
            models.UPFSVolumeInfoSchema(), required=True, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeUPFSVolumePrice

获取UPFS文件系统价格
"""


class DescribeUPFSVolumePriceRequestSchema(schema.RequestSchema):
    """DescribeUPFSVolumePrice - 获取UPFS文件系统价格"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "VolumeId": fields.Str(required=False, dump_to="VolumeId"),
    }


class DescribeUPFSVolumePriceResponseSchema(schema.ResponseSchema):
    """DescribeUPFSVolumePrice - 获取UPFS文件系统价格"""

    fields = {
        "DataSet": fields.List(
            models.UPFSPriceDataSetSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DescribeUPFSVolumeUpgradePrice

UPFS文件系统扩容价格
"""


class DescribeUPFSVolumeUpgradePriceRequestSchema(schema.RequestSchema):
    """DescribeUPFSVolumeUpgradePrice - UPFS文件系统扩容价格"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Str(required=True, dump_to="Size"),
        "VolumeId": fields.Str(required=True, dump_to="VolumeId"),
    }


class DescribeUPFSVolumeUpgradePriceResponseSchema(schema.ResponseSchema):
    """DescribeUPFSVolumeUpgradePrice - UPFS文件系统扩容价格"""

    fields = {
        "OriginalPrice": fields.Float(
            required=False, load_from="OriginalPrice"
        ),
        "Price": fields.Float(required=True, load_from="Price"),
    }


"""
API: ExtendUPFSVolume

UPFS文件系统扩容
"""


class ExtendUPFSVolumeRequestSchema(schema.RequestSchema):
    """ExtendUPFSVolume - UPFS文件系统扩容"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "VolumeId": fields.Str(required=True, dump_to="VolumeId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ExtendUPFSVolumeResponseSchema(schema.ResponseSchema):
    """ExtendUPFSVolume - UPFS文件系统扩容"""

    fields = {}


"""
API: RemoveUPFSVolume

删除UPFS文件系统
"""


class RemoveUPFSVolumeRequestSchema(schema.RequestSchema):
    """RemoveUPFSVolume - 删除UPFS文件系统"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VolumeId": fields.Str(required=True, dump_to="VolumeId"),
    }


class RemoveUPFSVolumeResponseSchema(schema.ResponseSchema):
    """RemoveUPFSVolume - 删除UPFS文件系统"""

    fields = {}


"""
API: UpdateUPFSVolumeInfo

更改UPFS文件系统相关信息（名称／备注）
"""


class UpdateUPFSVolumeInfoRequestSchema(schema.RequestSchema):
    """UpdateUPFSVolumeInfo - 更改UPFS文件系统相关信息（名称／备注）"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "VolumeId": fields.Str(required=True, dump_to="VolumeId"),
        "VolumeName": fields.Str(required=False, dump_to="VolumeName"),
    }


class UpdateUPFSVolumeInfoResponseSchema(schema.ResponseSchema):
    """UpdateUPFSVolumeInfo - 更改UPFS文件系统相关信息（名称／备注）"""

    fields = {}
