"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class TimeToLive extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        aws_cdk_lib_1.Annotations.of(this).addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_cdk_lib_1.aws_lambda.Function(this, 'DeleteStack', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_cdk_lib_1.aws_events.Rule(this, 'TimeToLive', {
            schedule: aws_cdk_lib_1.aws_events.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_cdk_lib_1.aws_events_targets.LambdaFunction(deleteStack, {
            event: aws_cdk_lib_1.aws_events.RuleTargetInput.fromObject({
                stackId: aws_cdk_lib_1.Aws.STACK_ID,
            }),
        }));
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (!this.node.findAll().includes(c)) {
                        c.node.addDependency(this);
                    }
                });
                let count = 0;
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (c instanceof TimeToLive) {
                        count++;
                    }
                });
                if (count > 1) {
                    return [
                        `Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`,
                    ];
                }
                return [];
            },
        });
    }
}
exports.TimeToLive = TimeToLive;
_a = JSII_RTTI_SYMBOL_1;
TimeToLive[_a] = { fqn: "@cloudcomponents/cdk-temp-stack.TimeToLive", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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