# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PythonPythonPackageContentResponse(BaseModel):
    """
    A Serializer for PythonPackageContent.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    pulp_created: Optional[datetime] = Field(default=None, description="Timestamp of creation.")
    pulp_last_updated: Optional[datetime] = Field(default=None, description="Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.")
    pulp_labels: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")
    vuln_report: Optional[StrictStr] = None
    artifact: Optional[StrictStr] = Field(default=None, description="Artifact file representing the physical content")
    author: Optional[StrictStr] = Field(default=None, description="Text containing the author's name. Contact information can also be added, separated with newlines.")
    author_email: Optional[StrictStr] = Field(default=None, description="The author's e-mail address. ")
    description: Optional[StrictStr] = Field(default=None, description="A longer description of the package that can run to several paragraphs.")
    home_page: Optional[StrictStr] = Field(default=None, description="The URL for the package's home page.")
    keywords: Optional[StrictStr] = Field(default=None, description="Additional keywords to be used to assist searching for the package in a larger catalog.")
    license: Optional[StrictStr] = Field(default=None, description="Text indicating the license covering the distribution")
    metadata_version: Optional[StrictStr] = Field(default=None, description="Version of the file format")
    name: Optional[StrictStr] = Field(default=None, description="The name of the python project.")
    platform: Optional[StrictStr] = Field(default=None, description="A comma-separated list of platform specifications, summarizing the operating systems supported by the package.")
    summary: Optional[StrictStr] = Field(default=None, description="A one-line summary of what the package does.")
    version: Optional[StrictStr] = Field(default=None, description="The packages version number.")
    classifiers: Optional[Any] = None
    download_url: Optional[StrictStr] = Field(default=None, description="Legacy field denoting the URL from which this package can be downloaded.")
    supported_platform: Optional[StrictStr] = Field(default=None, description="Field to specify the OS and CPU for which the binary package was compiled. ")
    maintainer: Optional[StrictStr] = Field(default=None, description="The maintainer's name at a minimum; additional contact information may be provided.")
    maintainer_email: Optional[StrictStr] = Field(default=None, description="The maintainer's e-mail address.")
    obsoletes_dist: Optional[Any] = None
    project_url: Optional[StrictStr] = Field(default=None, description="A browsable URL for the project and a label for it, separated by a comma.")
    project_urls: Optional[Any] = None
    provides_dist: Optional[Any] = None
    requires_external: Optional[Any] = None
    requires_dist: Optional[Any] = None
    requires_python: Optional[StrictStr] = Field(default=None, description="The Python version(s) that the distribution is guaranteed to be compatible with.")
    description_content_type: Optional[StrictStr] = Field(default=None, description="A string stating the markup syntax (if any) used in the distribution's description, so that tools can intelligently render the description.")
    provides_extras: Optional[Any] = None
    dynamic: Optional[Any] = None
    license_expression: Optional[StrictStr] = Field(default=None, description="Text string that is a valid SPDX license expression.")
    license_file: Optional[Any] = None
    filename: Optional[StrictStr] = Field(default=None, description="The name of the distribution package, usually of the format: {distribution}-{version}(-{build tag})?-{python tag}-{abi tag}-{platform tag}.{packagetype}")
    packagetype: Optional[StrictStr] = Field(default=None, description="The type of the distribution package (e.g. sdist, bdist_wheel, bdist_egg, etc)")
    python_version: Optional[StrictStr] = Field(default=None, description="The tag that indicates which Python implementation or version the package requires.")
    sha256: Optional[StrictStr] = Field(default='', description="The SHA256 digest of this package.")
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "pulp_created", "pulp_last_updated", "pulp_labels", "vuln_report", "artifact", "author", "author_email", "description", "home_page", "keywords", "license", "metadata_version", "name", "platform", "summary", "version", "classifiers", "download_url", "supported_platform", "maintainer", "maintainer_email", "obsoletes_dist", "project_url", "project_urls", "provides_dist", "requires_external", "requires_dist", "requires_python", "description_content_type", "provides_extras", "dynamic", "license_expression", "license_file", "filename", "packagetype", "python_version", "sha256"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PythonPythonPackageContentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "pulp_created",
            "pulp_last_updated",
            "vuln_report",
            "metadata_version",
            "name",
            "version",
            "filename",
            "packagetype",
            "python_version",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if classifiers (nullable) is None
        # and model_fields_set contains the field
        if self.classifiers is None and "classifiers" in self.model_fields_set:
            _dict['classifiers'] = None

        # set to None if obsoletes_dist (nullable) is None
        # and model_fields_set contains the field
        if self.obsoletes_dist is None and "obsoletes_dist" in self.model_fields_set:
            _dict['obsoletes_dist'] = None

        # set to None if project_urls (nullable) is None
        # and model_fields_set contains the field
        if self.project_urls is None and "project_urls" in self.model_fields_set:
            _dict['project_urls'] = None

        # set to None if provides_dist (nullable) is None
        # and model_fields_set contains the field
        if self.provides_dist is None and "provides_dist" in self.model_fields_set:
            _dict['provides_dist'] = None

        # set to None if requires_external (nullable) is None
        # and model_fields_set contains the field
        if self.requires_external is None and "requires_external" in self.model_fields_set:
            _dict['requires_external'] = None

        # set to None if requires_dist (nullable) is None
        # and model_fields_set contains the field
        if self.requires_dist is None and "requires_dist" in self.model_fields_set:
            _dict['requires_dist'] = None

        # set to None if provides_extras (nullable) is None
        # and model_fields_set contains the field
        if self.provides_extras is None and "provides_extras" in self.model_fields_set:
            _dict['provides_extras'] = None

        # set to None if dynamic (nullable) is None
        # and model_fields_set contains the field
        if self.dynamic is None and "dynamic" in self.model_fields_set:
            _dict['dynamic'] = None

        # set to None if license_file (nullable) is None
        # and model_fields_set contains the field
        if self.license_file is None and "license_file" in self.model_fields_set:
            _dict['license_file'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PythonPythonPackageContentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "pulp_created": obj.get("pulp_created"),
            "pulp_last_updated": obj.get("pulp_last_updated"),
            "pulp_labels": obj.get("pulp_labels"),
            "vuln_report": obj.get("vuln_report"),
            "artifact": obj.get("artifact"),
            "author": obj.get("author"),
            "author_email": obj.get("author_email"),
            "description": obj.get("description"),
            "home_page": obj.get("home_page"),
            "keywords": obj.get("keywords"),
            "license": obj.get("license"),
            "metadata_version": obj.get("metadata_version"),
            "name": obj.get("name"),
            "platform": obj.get("platform"),
            "summary": obj.get("summary"),
            "version": obj.get("version"),
            "classifiers": obj.get("classifiers"),
            "download_url": obj.get("download_url"),
            "supported_platform": obj.get("supported_platform"),
            "maintainer": obj.get("maintainer"),
            "maintainer_email": obj.get("maintainer_email"),
            "obsoletes_dist": obj.get("obsoletes_dist"),
            "project_url": obj.get("project_url"),
            "project_urls": obj.get("project_urls"),
            "provides_dist": obj.get("provides_dist"),
            "requires_external": obj.get("requires_external"),
            "requires_dist": obj.get("requires_dist"),
            "requires_python": obj.get("requires_python"),
            "description_content_type": obj.get("description_content_type"),
            "provides_extras": obj.get("provides_extras"),
            "dynamic": obj.get("dynamic"),
            "license_expression": obj.get("license_expression"),
            "license_file": obj.get("license_file"),
            "filename": obj.get("filename"),
            "packagetype": obj.get("packagetype"),
            "python_version": obj.get("python_version"),
            "sha256": obj.get("sha256") if obj.get("sha256") is not None else ''
        })
        return _obj


