# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_get_account_info_resp import GetAccountInfoResp
from .model_get_apikey_info_resp import GetApikeyInfoResp
from .model_get_cross_margin_account_req import GetCrossMarginAccountReq
from .model_get_cross_margin_account_resp import GetCrossMarginAccountResp
from .model_get_futures_account_req import GetFuturesAccountReq
from .model_get_futures_account_resp import GetFuturesAccountResp
from .model_get_futures_ledger_req import GetFuturesLedgerReq
from .model_get_futures_ledger_resp import GetFuturesLedgerResp
from .model_get_isolated_margin_account_detail_v1_req import GetIsolatedMarginAccountDetailV1Req
from .model_get_isolated_margin_account_detail_v1_resp import GetIsolatedMarginAccountDetailV1Resp
from .model_get_isolated_margin_account_list_v1_req import GetIsolatedMarginAccountListV1Req
from .model_get_isolated_margin_account_list_v1_resp import GetIsolatedMarginAccountListV1Resp
from .model_get_isolated_margin_account_req import GetIsolatedMarginAccountReq
from .model_get_isolated_margin_account_resp import GetIsolatedMarginAccountResp
from .model_get_margin_account_detail_resp import GetMarginAccountDetailResp
from .model_get_margin_hf_ledger_req import GetMarginHfLedgerReq
from .model_get_margin_hf_ledger_resp import GetMarginHfLedgerResp
from .model_get_spot_account_detail_req import GetSpotAccountDetailReq
from .model_get_spot_account_detail_resp import GetSpotAccountDetailResp
from .model_get_spot_account_list_req import GetSpotAccountListReq
from .model_get_spot_account_list_resp import GetSpotAccountListResp
from .model_get_spot_account_type_resp import GetSpotAccountTypeResp
from .model_get_spot_hf_ledger_req import GetSpotHfLedgerReq
from .model_get_spot_hf_ledger_resp import GetSpotHfLedgerResp
from .model_get_spot_ledger_req import GetSpotLedgerReq
from .model_get_spot_ledger_resp import GetSpotLedgerResp
from typing_extensions import deprecated


class AccountAPI(ABC):

    @abstractmethod
    def get_account_info(self, **kwargs: Any) -> GetAccountInfoResp:
        """
        summary: Get Account Summary Info
        description: This endpoint can be used to obtain account summary information.
        documentation: https://www.kucoin.com/docs-new/api-3470119
        +-----------------------+------------+
        | Extra API Info        | Value      |
        +-----------------------+------------+
        | API-DOMAIN            | SPOT       |
        | API-CHANNEL           | PRIVATE    |
        | API-PERMISSION        | GENERAL    |
        | API-RATE-LIMIT-POOL   | MANAGEMENT |
        | API-RATE-LIMIT-WEIGHT | 20         |
        +-----------------------+------------+
        """
        pass

    @abstractmethod
    def get_apikey_info(self, **kwargs: Any) -> GetApikeyInfoResp:
        """
        summary: Get Apikey Info
        description: Get the api key information. Use the api key awaiting checking to call the endpoint. Both master and sub user&#39;s api key are applicable.
        documentation: https://www.kucoin.com/docs-new/api-3470130
        +-----------------------+------------+
        | Extra API Info        | Value      |
        +-----------------------+------------+
        | API-DOMAIN            | SPOT       |
        | API-CHANNEL           | PRIVATE    |
        | API-PERMISSION        | GENERAL    |
        | API-RATE-LIMIT-POOL   | MANAGEMENT |
        | API-RATE-LIMIT-WEIGHT | 20         |
        +-----------------------+------------+
        """
        pass

    @abstractmethod
    def get_spot_account_type(self, **kwargs: Any) -> GetSpotAccountTypeResp:
        """
        summary: Get Account Type - Spot 
        description: This interface determines whether the current user is a spot high-frequency user or a spot low-frequency user.
        documentation: https://www.kucoin.com/docs-new/api-3470120
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 30      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_spot_account_list(self, req: GetSpotAccountListReq,
                              **kwargs: Any) -> GetSpotAccountListResp:
        """
        summary: Get Account List - Spot
        description: Get a list of accounts. Please deposit funds into the main account first, then use the Transfer function to move them to the trade account before trading.
        documentation: https://www.kucoin.com/docs-new/api-3470125
        +-----------------------+------------+
        | Extra API Info        | Value      |
        +-----------------------+------------+
        | API-DOMAIN            | SPOT       |
        | API-CHANNEL           | PRIVATE    |
        | API-PERMISSION        | GENERAL    |
        | API-RATE-LIMIT-POOL   | MANAGEMENT |
        | API-RATE-LIMIT-WEIGHT | 5          |
        +-----------------------+------------+
        """
        pass

    @abstractmethod
    def get_spot_account_detail(self, req: GetSpotAccountDetailReq,
                                **kwargs: Any) -> GetSpotAccountDetailResp:
        """
        summary: Get Account Detail - Spot
        description: Get information for a single spot account. Use this endpoint when you know the accountId.
        documentation: https://www.kucoin.com/docs-new/api-3470126
        +-----------------------+------------+
        | Extra API Info        | Value      |
        +-----------------------+------------+
        | API-DOMAIN            | SPOT       |
        | API-CHANNEL           | PRIVATE    |
        | API-PERMISSION        | GENERAL    |
        | API-RATE-LIMIT-POOL   | MANAGEMENT |
        | API-RATE-LIMIT-WEIGHT | 5          |
        +-----------------------+------------+
        """
        pass

    @abstractmethod
    def get_cross_margin_account(self, req: GetCrossMarginAccountReq,
                                 **kwargs: Any) -> GetCrossMarginAccountResp:
        """
        summary: Get Account - Cross Margin
        description: Request cross margin account info via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470127
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 15      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_isolated_margin_account(
            self, req: GetIsolatedMarginAccountReq,
            **kwargs: Any) -> GetIsolatedMarginAccountResp:
        """
        summary: Get Account - Isolated Margin
        description: Request isolated margin account info via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470128
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 15      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_futures_account(self, req: GetFuturesAccountReq,
                            **kwargs: Any) -> GetFuturesAccountResp:
        """
        summary: Get Account - Futures
        description: Request futures account info via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470129
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | FUTURES |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | FUTURES |
        | API-RATE-LIMIT-POOL   | FUTURES |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_spot_ledger(self, req: GetSpotLedgerReq,
                        **kwargs: Any) -> GetSpotLedgerResp:
        """
        summary: Get Account Ledgers - Spot/Margin
        description: This interface is for transaction records from all your account types, supporting various currency inquiries. Items are paginated and sorted to show the latest first. See the Pagination section for retrieving additional entries after the first page.
        documentation: https://www.kucoin.com/docs-new/api-3470121
        +-----------------------+------------+
        | Extra API Info        | Value      |
        +-----------------------+------------+
        | API-DOMAIN            | SPOT       |
        | API-CHANNEL           | PRIVATE    |
        | API-PERMISSION        | GENERAL    |
        | API-RATE-LIMIT-POOL   | MANAGEMENT |
        | API-RATE-LIMIT-WEIGHT | 2          |
        +-----------------------+------------+
        """
        pass

    @abstractmethod
    def get_spot_hf_ledger(self, req: GetSpotHfLedgerReq,
                           **kwargs: Any) -> GetSpotHfLedgerResp:
        """
        summary: Get Account Ledgers - Trade_hf
        description: This API endpoint returns all transfer (in and out) records in high-frequency trading accounts and supports multi-coin queries. The query results are sorted in descending order by createdAt and ID.
        documentation: https://www.kucoin.com/docs-new/api-3470122
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 2       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_margin_hf_ledger(self, req: GetMarginHfLedgerReq,
                             **kwargs: Any) -> GetMarginHfLedgerResp:
        """
        summary: Get Account Ledgers - Margin_hf
        description: This API endpoint returns all transfer (in and out) records in high-frequency margin trading accounts and supports multi-coin queries. The query results are sorted in descending order by createdAt and ID.
        documentation: https://www.kucoin.com/docs-new/api-3470123
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 2       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_futures_ledger(self, req: GetFuturesLedgerReq,
                           **kwargs: Any) -> GetFuturesLedgerResp:
        """
        summary: Get Account Ledgers - Futures
        description: This interface can query the ledger records of the futures business line.
        documentation: https://www.kucoin.com/docs-new/api-3470124
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | FUTURES |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | FUTURES |
        | API-RATE-LIMIT-WEIGHT | 2       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def get_margin_account_detail(self,
                                  **kwargs: Any) -> GetMarginAccountDetailResp:
        """
        summary: Get Account Detail - Margin
        description: Request margin account info via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470311
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 40      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def get_isolated_margin_account_list_v1(
            self, req: GetIsolatedMarginAccountListV1Req,
            **kwargs: Any) -> GetIsolatedMarginAccountListV1Resp:
        """
        summary: Get Account List - Isolated Margin - V1
        description: Request the isolated margin account info list via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470314
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 50      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    @deprecated('')
    def get_isolated_margin_account_detail_v1(
            self, req: GetIsolatedMarginAccountDetailV1Req,
            **kwargs: Any) -> GetIsolatedMarginAccountDetailV1Resp:
        """
        summary: Get Account Detail - Isolated Margin - V1
        description: Request isolated margin account info via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470315
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 50      |
        +-----------------------+---------+
        """
        pass


class AccountAPIImpl(AccountAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_account_info(self, **kwargs: Any) -> GetAccountInfoResp:
        return self.transport.call("spot", False, "GET", "/api/v2/user-info",
                                   None, GetAccountInfoResp(), False, **kwargs)

    def get_apikey_info(self, **kwargs: Any) -> GetApikeyInfoResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/user/api-key", None,
                                   GetApikeyInfoResp(), False, **kwargs)

    def get_spot_account_type(self, **kwargs: Any) -> GetSpotAccountTypeResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/hf/accounts/opened", None,
                                   GetSpotAccountTypeResp(), False, **kwargs)

    def get_spot_account_list(self, req: GetSpotAccountListReq,
                              **kwargs: Any) -> GetSpotAccountListResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/accounts", req,
                                   GetSpotAccountListResp(), False, **kwargs)

    def get_spot_account_detail(self, req: GetSpotAccountDetailReq,
                                **kwargs: Any) -> GetSpotAccountDetailResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/accounts/{accountId}", req,
                                   GetSpotAccountDetailResp(), False, **kwargs)

    def get_cross_margin_account(self, req: GetCrossMarginAccountReq,
                                 **kwargs: Any) -> GetCrossMarginAccountResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/margin/accounts", req,
                                   GetCrossMarginAccountResp(), False,
                                   **kwargs)

    def get_isolated_margin_account(
            self, req: GetIsolatedMarginAccountReq,
            **kwargs: Any) -> GetIsolatedMarginAccountResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/isolated/accounts", req,
                                   GetIsolatedMarginAccountResp(), False,
                                   **kwargs)

    def get_futures_account(self, req: GetFuturesAccountReq,
                            **kwargs: Any) -> GetFuturesAccountResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/account-overview", req,
                                   GetFuturesAccountResp(), False, **kwargs)

    def get_spot_ledger(self, req: GetSpotLedgerReq,
                        **kwargs: Any) -> GetSpotLedgerResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/accounts/ledgers", req,
                                   GetSpotLedgerResp(), False, **kwargs)

    def get_spot_hf_ledger(self, req: GetSpotHfLedgerReq,
                           **kwargs: Any) -> GetSpotHfLedgerResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/hf/accounts/ledgers", req,
                                   GetSpotHfLedgerResp(), False, **kwargs)

    def get_margin_hf_ledger(self, req: GetMarginHfLedgerReq,
                             **kwargs: Any) -> GetMarginHfLedgerResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/hf/margin/account/ledgers", req,
                                   GetMarginHfLedgerResp(), False, **kwargs)

    def get_futures_ledger(self, req: GetFuturesLedgerReq,
                           **kwargs: Any) -> GetFuturesLedgerResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/transaction-history", req,
                                   GetFuturesLedgerResp(), False, **kwargs)

    def get_margin_account_detail(self,
                                  **kwargs: Any) -> GetMarginAccountDetailResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/margin/account", None,
                                   GetMarginAccountDetailResp(), False,
                                   **kwargs)

    def get_isolated_margin_account_list_v1(
            self, req: GetIsolatedMarginAccountListV1Req,
            **kwargs: Any) -> GetIsolatedMarginAccountListV1Resp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/isolated/accounts", req,
                                   GetIsolatedMarginAccountListV1Resp(), False,
                                   **kwargs)

    def get_isolated_margin_account_detail_v1(
            self, req: GetIsolatedMarginAccountDetailV1Req,
            **kwargs: Any) -> GetIsolatedMarginAccountDetailV1Resp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/isolated/account/{symbol}", req,
                                   GetIsolatedMarginAccountDetailV1Resp(),
                                   False, **kwargs)
