# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetAccountInfoResp(BaseModel, Response):
    """
    GetAccountInfoResp

    Attributes:
        level (int): User VIP level 
        sub_quantity (int): Number of sub-accounts
        spot_sub_quantity (int): Number of sub-accounts with spot trading permissions enabled
        margin_sub_quantity (int): Number of sub-accounts with margin trading permissions enabled
        futures_sub_quantity (int): Number of sub-accounts with futures trading permissions enabled
        option_sub_quantity (int): Number of sub-accounts with option trading permissions enabled
        max_sub_quantity (int): Max. number of sub-accounts = maxDefaultSubQuantity + maxSpotSubQuantity
        max_default_sub_quantity (int): Max. number of default open sub-accounts (according to VIP level)
        max_spot_sub_quantity (int): Max. number of sub-accounts with additional spot trading permissions
        max_margin_sub_quantity (int): Max. number of sub-accounts with additional margin trading permissions
        max_futures_sub_quantity (int): Max. number of sub-accounts with additional futures trading permissions
        max_option_sub_quantity (int): Max. number of sub-accounts with additional option trading permissions
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    level: Optional[int] = Field(default=None, description="User VIP level ")
    sub_quantity: Optional[int] = Field(default=None,
                                        description="Number of sub-accounts",
                                        alias="subQuantity")
    spot_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Number of sub-accounts with spot trading permissions enabled",
        alias="spotSubQuantity")
    margin_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Number of sub-accounts with margin trading permissions enabled",
        alias="marginSubQuantity")
    futures_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Number of sub-accounts with futures trading permissions enabled",
        alias="futuresSubQuantity")
    option_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Number of sub-accounts with option trading permissions enabled",
        alias="optionSubQuantity")
    max_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of sub-accounts = maxDefaultSubQuantity + maxSpotSubQuantity",
        alias="maxSubQuantity")
    max_default_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of default open sub-accounts (according to VIP level)",
        alias="maxDefaultSubQuantity")
    max_spot_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of sub-accounts with additional spot trading permissions",
        alias="maxSpotSubQuantity")
    max_margin_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of sub-accounts with additional margin trading permissions",
        alias="maxMarginSubQuantity")
    max_futures_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of sub-accounts with additional futures trading permissions",
        alias="maxFuturesSubQuantity")
    max_option_sub_quantity: Optional[int] = Field(
        default=None,
        description=
        "Max. number of sub-accounts with additional option trading permissions",
        alias="maxOptionSubQuantity")

    __properties: ClassVar[List[str]] = [
        "level", "subQuantity", "spotSubQuantity", "marginSubQuantity",
        "futuresSubQuantity", "optionSubQuantity", "maxSubQuantity",
        "maxDefaultSubQuantity", "maxSpotSubQuantity", "maxMarginSubQuantity",
        "maxFuturesSubQuantity", "maxOptionSubQuantity"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAccountInfoResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAccountInfoResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "level":
            obj.get("level"),
            "subQuantity":
            obj.get("subQuantity"),
            "spotSubQuantity":
            obj.get("spotSubQuantity"),
            "marginSubQuantity":
            obj.get("marginSubQuantity"),
            "futuresSubQuantity":
            obj.get("futuresSubQuantity"),
            "optionSubQuantity":
            obj.get("optionSubQuantity"),
            "maxSubQuantity":
            obj.get("maxSubQuantity"),
            "maxDefaultSubQuantity":
            obj.get("maxDefaultSubQuantity"),
            "maxSpotSubQuantity":
            obj.get("maxSpotSubQuantity"),
            "maxMarginSubQuantity":
            obj.get("maxMarginSubQuantity"),
            "maxFuturesSubQuantity":
            obj.get("maxFuturesSubQuantity"),
            "maxOptionSubQuantity":
            obj.get("maxOptionSubQuantity")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
