# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetFuturesAccountResp(BaseModel, Response):
    """
    GetFuturesAccountResp

    Attributes:
        account_equity (float): Account equity = marginBalance + unrealizedPNL
        unrealised_pnl (float): Unrealized profit and loss
        margin_balance (float): Margin balance = positionMargin + orderMargin + frozenFunds + availableBalance - unrealizedPNL
        position_margin (float): Position margin
        order_margin (float): Order margin
        frozen_funds (float): Frozen funds for out-transfer
        available_balance (float): Available balance
        currency (str): Currency
        risk_ratio (float): Cross margin risk rate
        max_withdraw_amount (float): Maximum amount that can be withdrawn/transferred.
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    account_equity: Optional[float] = Field(
        default=None,
        description="Account equity = marginBalance + unrealizedPNL",
        alias="accountEquity")
    unrealised_pnl: Optional[float] = Field(
        default=None,
        description="Unrealized profit and loss",
        alias="unrealisedPNL")
    margin_balance: Optional[float] = Field(
        default=None,
        description=
        "Margin balance = positionMargin + orderMargin + frozenFunds + availableBalance - unrealizedPNL",
        alias="marginBalance")
    position_margin: Optional[float] = Field(default=None,
                                             description="Position margin",
                                             alias="positionMargin")
    order_margin: Optional[float] = Field(default=None,
                                          description="Order margin",
                                          alias="orderMargin")
    frozen_funds: Optional[float] = Field(
        default=None,
        description="Frozen funds for out-transfer",
        alias="frozenFunds")
    available_balance: Optional[float] = Field(default=None,
                                               description="Available balance",
                                               alias="availableBalance")
    currency: Optional[str] = Field(default=None, description="Currency")
    risk_ratio: Optional[float] = Field(default=None,
                                        description="Cross margin risk rate",
                                        alias="riskRatio")
    max_withdraw_amount: Optional[float] = Field(
        default=None,
        description="Maximum amount that can be withdrawn/transferred.",
        alias="maxWithdrawAmount")

    __properties: ClassVar[List[str]] = [
        "accountEquity", "unrealisedPNL", "marginBalance", "positionMargin",
        "orderMargin", "frozenFunds", "availableBalance", "currency",
        "riskRatio", "maxWithdrawAmount"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetFuturesAccountResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetFuturesAccountResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountEquity":
            obj.get("accountEquity"),
            "unrealisedPNL":
            obj.get("unrealisedPNL"),
            "marginBalance":
            obj.get("marginBalance"),
            "positionMargin":
            obj.get("positionMargin"),
            "orderMargin":
            obj.get("orderMargin"),
            "frozenFunds":
            obj.get("frozenFunds"),
            "availableBalance":
            obj.get("availableBalance"),
            "currency":
            obj.get("currency"),
            "riskRatio":
            obj.get("riskRatio"),
            "maxWithdrawAmount":
            obj.get("maxWithdrawAmount")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
