# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_isolated_margin_account_assets_base_asset import GetIsolatedMarginAccountAssetsBaseAsset
from .model_get_isolated_margin_account_assets_quote_asset import GetIsolatedMarginAccountAssetsQuoteAsset


class GetIsolatedMarginAccountAssets(BaseModel):
    """
    GetIsolatedMarginAccountAssets

    Attributes:
        symbol (str): Symbol
        status (StatusEnum): Position status; EFFECTIVE-effective, BANKRUPTCY-bankruptcy liquidation, LIQUIDATION-closing, REPAY-repayment, BORROW-borrowing
        debt_ratio (str): debt ratio
        base_asset (GetIsolatedMarginAccountAssetsBaseAsset): 
        quote_asset (GetIsolatedMarginAccountAssetsQuoteAsset): 
    """

    class StatusEnum(Enum):
        """
        Attributes:
            EFFECTIVE: Effective
            BANKRUPTCY: Bankruptcy liquidation
            LIQUIDATION: Closing
            REPAY: Repayment
            BORROW: Borrowing
        """
        EFFECTIVE = 'EFFECTIVE'
        BANKRUPTCY = 'BANKRUPTCY'
        LIQUIDATION = 'LIQUIDATION'
        REPAY = 'REPAY'
        BORROW = 'BORROW'

    symbol: Optional[str] = Field(default=None, description="Symbol")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Position status; EFFECTIVE-effective, BANKRUPTCY-bankruptcy liquidation, LIQUIDATION-closing, REPAY-repayment, BORROW-borrowing"
    )
    debt_ratio: Optional[str] = Field(default=None,
                                      description="debt ratio",
                                      alias="debtRatio")
    base_asset: Optional[GetIsolatedMarginAccountAssetsBaseAsset] = Field(
        default=None, alias="baseAsset")
    quote_asset: Optional[GetIsolatedMarginAccountAssetsQuoteAsset] = Field(
        default=None, alias="quoteAsset")

    __properties: ClassVar[List[str]] = [
        "symbol", "status", "debtRatio", "baseAsset", "quoteAsset"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetIsolatedMarginAccountAssets]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base_asset
        if self.base_asset:
            _dict['baseAsset'] = self.base_asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quote_asset
        if self.quote_asset:
            _dict['quoteAsset'] = self.quote_asset.to_dict()
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetIsolatedMarginAccountAssets]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "status":
            obj.get("status"),
            "debtRatio":
            obj.get("debtRatio"),
            "baseAsset":
            GetIsolatedMarginAccountAssetsBaseAsset.from_dict(obj["baseAsset"])
            if obj.get("baseAsset") is not None else None,
            "quoteAsset":
            GetIsolatedMarginAccountAssetsQuoteAsset.from_dict(
                obj["quoteAsset"])
            if obj.get("quoteAsset") is not None else None
        })
        return _obj
