# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetIsolatedMarginAccountDetailV1QuoteAsset(BaseModel):
    """
    quote asset

    Attributes:
        currency (str): currency
        total_balance (str): Current currency total asset amount
        hold_balance (str): Current currency holding asset amount
        available_balance (str): Current available asset amount
        liability (str): Liabilities
        interest (str): 
        borrowable_amount (str): 
    """

    currency: Optional[str] = Field(default=None, description="currency")
    total_balance: Optional[str] = Field(
        default=None,
        description="Current currency total asset amount",
        alias="totalBalance")
    hold_balance: Optional[str] = Field(
        default=None,
        description="Current currency holding asset amount",
        alias="holdBalance")
    available_balance: Optional[str] = Field(
        default=None,
        description="Current available asset amount",
        alias="availableBalance")
    liability: Optional[str] = Field(default=None, description="Liabilities")
    interest: Optional[str] = None
    borrowable_amount: Optional[str] = Field(default=None,
                                             alias="borrowableAmount")

    __properties: ClassVar[List[str]] = [
        "currency", "totalBalance", "holdBalance", "availableBalance",
        "liability", "interest", "borrowableAmount"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls, json_str: str
    ) -> Optional[GetIsolatedMarginAccountDetailV1QuoteAsset]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetIsolatedMarginAccountDetailV1QuoteAsset]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "totalBalance":
            obj.get("totalBalance"),
            "holdBalance":
            obj.get("holdBalance"),
            "availableBalance":
            obj.get("availableBalance"),
            "liability":
            obj.get("liability"),
            "interest":
            obj.get("interest"),
            "borrowableAmount":
            obj.get("borrowableAmount")
        })
        return _obj
