# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_isolated_margin_account_list_v1_assets_base_asset import GetIsolatedMarginAccountListV1AssetsBaseAsset
from .model_get_isolated_margin_account_list_v1_assets_quote_asset import GetIsolatedMarginAccountListV1AssetsQuoteAsset


class GetIsolatedMarginAccountListV1Assets(BaseModel):
    """
    GetIsolatedMarginAccountListV1Assets

    Attributes:
        symbol (str): Symbol
        status (StatusEnum): Position status: Existing liabilities-DEBT, No liabilities-CLEAR, Bankrupcy (after position enters a negative balance)-BANKRUPTCY, Existing borrowings-IN_BORROW, Existing repayments-IN_REPAY, Under liquidation-IN_LIQUIDATION, Under auto-renewal assets-IN_AUTO_RENEW .
        debt_ratio (str): debt ratio
        base_asset (GetIsolatedMarginAccountListV1AssetsBaseAsset): 
        quote_asset (GetIsolatedMarginAccountListV1AssetsQuoteAsset): 
    """

    class StatusEnum(Enum):
        """
        Attributes:
            DEBT: 
            CLEAR: 
            BANKRUPTCY: 
            IN_BORROW: 
            IN_REPAY: 
            IN_LIQUIDATION: 
            IN_AUTO_RENEW: 
        """
        DEBT = 'DEBT'
        CLEAR = 'CLEAR'
        BANKRUPTCY = 'BANKRUPTCY'
        IN_BORROW = 'IN_BORROW'
        IN_REPAY = 'IN_REPAY'
        IN_LIQUIDATION = 'IN_LIQUIDATION'
        IN_AUTO_RENEW = 'IN_AUTO_RENEW'

    symbol: Optional[str] = Field(default=None, description="Symbol")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Position status: Existing liabilities-DEBT, No liabilities-CLEAR, Bankrupcy (after position enters a negative balance)-BANKRUPTCY, Existing borrowings-IN_BORROW, Existing repayments-IN_REPAY, Under liquidation-IN_LIQUIDATION, Under auto-renewal assets-IN_AUTO_RENEW ."
    )
    debt_ratio: Optional[str] = Field(default=None,
                                      description="debt ratio",
                                      alias="debtRatio")
    base_asset: Optional[
        GetIsolatedMarginAccountListV1AssetsBaseAsset] = Field(
            default=None, alias="baseAsset")
    quote_asset: Optional[
        GetIsolatedMarginAccountListV1AssetsQuoteAsset] = Field(
            default=None, alias="quoteAsset")

    __properties: ClassVar[List[str]] = [
        "symbol", "status", "debtRatio", "baseAsset", "quoteAsset"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls,
            json_str: str) -> Optional[GetIsolatedMarginAccountListV1Assets]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base_asset
        if self.base_asset:
            _dict['baseAsset'] = self.base_asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quote_asset
        if self.quote_asset:
            _dict['quoteAsset'] = self.quote_asset.to_dict()
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetIsolatedMarginAccountListV1Assets]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "status":
            obj.get("status"),
            "debtRatio":
            obj.get("debtRatio"),
            "baseAsset":
            GetIsolatedMarginAccountListV1AssetsBaseAsset.from_dict(
                obj["baseAsset"])
            if obj.get("baseAsset") is not None else None,
            "quoteAsset":
            GetIsolatedMarginAccountListV1AssetsQuoteAsset.from_dict(
                obj["quoteAsset"])
            if obj.get("quoteAsset") is not None else None
        })
        return _obj
