# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetMarginHfLedgerReq(BaseModel):
    """
    GetMarginHfLedgerReq

    Attributes:
        currency (str): Currency optional; more than one can be selected; separate using commas; select no more than 10 currencies; the default will be to query for all currencies if left empty
        direction (DirectionEnum): direction: in, out
        biz_type (str): Transaction type: TRANSFER- transfer funds, MARGIN_EXCHANGE-cross margin trade, ISOLATED_EXCHANGE-isolated margin trade, LIQUIDATION-liquidation, ASSERT_RETURN-forced liquidation asset return
        last_id (int): The ID of the last set of data from the previous data batch. By default, the latest information is given.
        limit (int): Default100, Max200
        start_at (int): Start time (milliseconds)
        end_at (int): End time (milliseconds)
    """

    class DirectionEnum(Enum):
        """
        Attributes:
            IN_: 
            OUT: 
        """
        IN_ = 'in'
        OUT = 'out'

    currency: Optional[str] = Field(
        default=None,
        description=
        "Currency optional; more than one can be selected; separate using commas; select no more than 10 currencies; the default will be to query for all currencies if left empty"
    )
    direction: Optional[DirectionEnum] = Field(
        default=None, description="direction: in, out")
    biz_type: Optional[str] = Field(
        default=None,
        description=
        "Transaction type: TRANSFER- transfer funds, MARGIN_EXCHANGE-cross margin trade, ISOLATED_EXCHANGE-isolated margin trade, LIQUIDATION-liquidation, ASSERT_RETURN-forced liquidation asset return",
        alias="bizType")
    last_id: Optional[int] = Field(
        default=None,
        description=
        "The ID of the last set of data from the previous data batch. By default, the latest information is given.",
        alias="lastId")
    limit: Optional[int] = Field(default=100, description="Default100, Max200")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milliseconds)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milliseconds)",
                                  alias="endAt")

    __properties: ClassVar[List[str]] = [
        "currency", "direction", "bizType", "lastId", "limit", "startAt",
        "endAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetMarginHfLedgerReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetMarginHfLedgerReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "direction":
            obj.get("direction"),
            "bizType":
            obj.get("bizType"),
            "lastId":
            obj.get("lastId"),
            "limit":
            obj.get("limit") if obj.get("limit") is not None else 100,
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt")
        })
        return _obj


class GetMarginHfLedgerReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetMarginHfLedgerReqBuilder:
        """
        Currency optional; more than one can be selected; separate using commas; select no more than 10 currencies; the default will be to query for all currencies if left empty
        """
        self.obj['currency'] = value
        return self

    def set_direction(
        self, value: GetMarginHfLedgerReq.DirectionEnum
    ) -> GetMarginHfLedgerReqBuilder:
        """
        direction: in, out
        """
        self.obj['direction'] = value
        return self

    def set_biz_type(self, value: str) -> GetMarginHfLedgerReqBuilder:
        """
        Transaction type: TRANSFER- transfer funds, MARGIN_EXCHANGE-cross margin trade, ISOLATED_EXCHANGE-isolated margin trade, LIQUIDATION-liquidation, ASSERT_RETURN-forced liquidation asset return
        """
        self.obj['bizType'] = value
        return self

    def set_last_id(self, value: int) -> GetMarginHfLedgerReqBuilder:
        """
        The ID of the last set of data from the previous data batch. By default, the latest information is given.
        """
        self.obj['lastId'] = value
        return self

    def set_limit(self, value: int) -> GetMarginHfLedgerReqBuilder:
        """
        Default100, Max200
        """
        self.obj['limit'] = value
        return self

    def set_start_at(self, value: int) -> GetMarginHfLedgerReqBuilder:
        """
        Start time (milliseconds)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetMarginHfLedgerReqBuilder:
        """
        End time (milliseconds)
        """
        self.obj['endAt'] = value
        return self

    def build(self) -> GetMarginHfLedgerReq:
        return GetMarginHfLedgerReq(**self.obj)
