# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotAccountListReq(BaseModel):
    """
    GetSpotAccountListReq

    Attributes:
        currency (str): currency
        type (TypeEnum): Account type
    """

    class TypeEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            OPTION: Option account
        """
        MAIN = 'main'
        TRADE = 'trade'
        OPTION = 'option'

    currency: Optional[str] = Field(default=None, description="currency")
    type: Optional[TypeEnum] = Field(default=None, description="Account type")

    __properties: ClassVar[List[str]] = ["currency", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotAccountListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotAccountListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "type": obj.get("type")
        })
        return _obj


class GetSpotAccountListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetSpotAccountListReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_type(
            self, value: GetSpotAccountListReq.TypeEnum
    ) -> GetSpotAccountListReqBuilder:
        """
        Account type
        """
        self.obj['type'] = value
        return self

    def build(self) -> GetSpotAccountListReq:
        return GetSpotAccountListReq(**self.obj)
