# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotHfLedgerReq(BaseModel):
    """
    GetSpotHfLedgerReq

    Attributes:
        currency (str): Currency (you can choose more than one currency). You can specify a max. of 10 currencies in one go. If not specified, all currencies will be queried by default.
        direction (DirectionEnum): direction: in, out
        biz_type (BizTypeEnum): Transaction type
        last_id (int): The ID of the last set of data from the previous data batch. By default, the latest information is given.
        limit (int): Default100, Max200
        start_at (int): Start time (milliseconds)
        end_at (int): End time (milliseconds)
    """

    class DirectionEnum(Enum):
        """
        Attributes:
            IN_: 
            OUT: 
        """
        IN_ = 'in'
        OUT = 'out'

    class BizTypeEnum(Enum):
        """
        Attributes:
            TRADE_EXCHANGE: trade exchange
            TRANSFER: transfer
            RETURNED_FEES: returned fees
            DEDUCTION_FEES: deduction fees
            OTHER: other
        """
        TRADE_EXCHANGE = 'TRADE_EXCHANGE'
        TRANSFER = 'TRANSFER'
        RETURNED_FEES = 'RETURNED_FEES'
        DEDUCTION_FEES = 'DEDUCTION_FEES'
        OTHER = 'OTHER'

    currency: Optional[str] = Field(
        default=None,
        description=
        "Currency (you can choose more than one currency). You can specify a max. of 10 currencies in one go. If not specified, all currencies will be queried by default."
    )
    direction: Optional[DirectionEnum] = Field(
        default=None, description="direction: in, out")
    biz_type: Optional[BizTypeEnum] = Field(default=None,
                                            description="Transaction type",
                                            alias="bizType")
    last_id: Optional[int] = Field(
        default=None,
        description=
        "The ID of the last set of data from the previous data batch. By default, the latest information is given.",
        alias="lastId")
    limit: Optional[int] = Field(default=100, description="Default100, Max200")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milliseconds)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milliseconds)",
                                  alias="endAt")

    __properties: ClassVar[List[str]] = [
        "currency", "direction", "bizType", "lastId", "limit", "startAt",
        "endAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotHfLedgerReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotHfLedgerReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "direction":
            obj.get("direction"),
            "bizType":
            obj.get("bizType"),
            "lastId":
            obj.get("lastId"),
            "limit":
            obj.get("limit") if obj.get("limit") is not None else 100,
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt")
        })
        return _obj


class GetSpotHfLedgerReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetSpotHfLedgerReqBuilder:
        """
        Currency (you can choose more than one currency). You can specify a max. of 10 currencies in one go. If not specified, all currencies will be queried by default.
        """
        self.obj['currency'] = value
        return self

    def set_direction(
            self, value: GetSpotHfLedgerReq.DirectionEnum
    ) -> GetSpotHfLedgerReqBuilder:
        """
        direction: in, out
        """
        self.obj['direction'] = value
        return self

    def set_biz_type(
            self, value: GetSpotHfLedgerReq.BizTypeEnum
    ) -> GetSpotHfLedgerReqBuilder:
        """
        Transaction type
        """
        self.obj['bizType'] = value
        return self

    def set_last_id(self, value: int) -> GetSpotHfLedgerReqBuilder:
        """
        The ID of the last set of data from the previous data batch. By default, the latest information is given.
        """
        self.obj['lastId'] = value
        return self

    def set_limit(self, value: int) -> GetSpotHfLedgerReqBuilder:
        """
        Default100, Max200
        """
        self.obj['limit'] = value
        return self

    def set_start_at(self, value: int) -> GetSpotHfLedgerReqBuilder:
        """
        Start time (milliseconds)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetSpotHfLedgerReqBuilder:
        """
        End time (milliseconds)
        """
        self.obj['endAt'] = value
        return self

    def build(self) -> GetSpotHfLedgerReq:
        return GetSpotHfLedgerReq(**self.obj)
