# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddDepositAddressV1Req(BaseModel):
    """
    AddDepositAddressV1Req

    Attributes:
        currency (str): currency
        chain (str): The chainId of currency, e.g. the available values for USDT are OMNI, ERC20, and TRC20; default is ERC20. The available values for BTC are Native, Segwit, TRC20; the parameters are bech32, btc, trx; default is Native. This only applies to multi-chain currencies; no need for single-chain currencies.
        to (ToEnum): Deposit account type: main (funding account), trade (spot trading account); the default is main
    """

    class ToEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
        """
        MAIN = 'main'
        TRADE = 'trade'

    currency: Optional[str] = Field(default=None, description="currency")
    chain: Optional[str] = Field(
        default='eth',
        description=
        "The chainId of currency, e.g. the available values for USDT are OMNI, ERC20, and TRC20; default is ERC20. The available values for BTC are Native, Segwit, TRC20; the parameters are bech32, btc, trx; default is Native. This only applies to multi-chain currencies; no need for single-chain currencies."
    )
    to: Optional[ToEnum] = Field(
        default=ToEnum.MAIN,
        description=
        "Deposit account type: main (funding account), trade (spot trading account); the default is main"
    )

    __properties: ClassVar[List[str]] = ["currency", "chain", "to"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddDepositAddressV1Req]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddDepositAddressV1Req]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "chain":
            obj.get("chain") if obj.get("chain") is not None else 'eth',
            "to":
            obj.get("to") if obj.get("to") is not None else
            AddDepositAddressV1Req.ToEnum.MAIN
        })
        return _obj


class AddDepositAddressV1ReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> AddDepositAddressV1ReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_chain(self, value: str) -> AddDepositAddressV1ReqBuilder:
        """
        The chainId of currency, e.g. the available values for USDT are OMNI, ERC20, and TRC20; default is ERC20. The available values for BTC are Native, Segwit, TRC20; the parameters are bech32, btc, trx; default is Native. This only applies to multi-chain currencies; no need for single-chain currencies.
        """
        self.obj['chain'] = value
        return self

    def set_to(
            self, value: AddDepositAddressV1Req.ToEnum
    ) -> AddDepositAddressV1ReqBuilder:
        """
        Deposit account type: main (funding account), trade (spot trading account); the default is main
        """
        self.obj['to'] = value
        return self

    def build(self) -> AddDepositAddressV1Req:
        return AddDepositAddressV1Req(**self.obj)
