# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetDepositHistoryOldReq(BaseModel):
    """
    GetDepositHistoryOldReq

    Attributes:
        currency (str): currency
        status (StatusEnum): Status. Available value: PROCESSING, SUCCESS, and FAILURE
        start_at (int): Start time (milliseconds)
        end_at (int): End time (milliseconds)
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    currency: Optional[str] = Field(default=None, description="currency")
    status: Optional[StatusEnum] = Field(
        default=None,
        description="Status. Available value: PROCESSING, SUCCESS, and FAILURE"
    )
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milliseconds)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milliseconds)",
                                  alias="endAt")

    __properties: ClassVar[List[str]] = [
        "currency", "status", "startAt", "endAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDepositHistoryOldReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetDepositHistoryOldReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "status": obj.get("status"),
            "startAt": obj.get("startAt"),
            "endAt": obj.get("endAt")
        })
        return _obj


class GetDepositHistoryOldReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetDepositHistoryOldReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_status(
        self, value: GetDepositHistoryOldReq.StatusEnum
    ) -> GetDepositHistoryOldReqBuilder:
        """
        Status. Available value: PROCESSING, SUCCESS, and FAILURE
        """
        self.obj['status'] = value
        return self

    def set_start_at(self, value: int) -> GetDepositHistoryOldReqBuilder:
        """
        Start time (milliseconds)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetDepositHistoryOldReqBuilder:
        """
        End time (milliseconds)
        """
        self.obj['endAt'] = value
        return self

    def build(self) -> GetDepositHistoryOldReq:
        return GetDepositHistoryOldReq(**self.obj)
