# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddSubAccountApiReq(BaseModel):
    """
    AddSubAccountApiReq

    Attributes:
        passphrase (str): Password (Must contain 7–32 characters. Cannot contain any spaces.)
        remark (str): Remarks (1–24 characters)
        permission (str): [Permissions](https://www.kucoin.com/docs-new/doc-338144)(Only General, Spot, Futures, Margin, InnerTransfer (Flex Transfer) permissions can be set, such as \"General, Trade\". The default is \"General\")
        ip_whitelist (str): IP whitelist (You may add up to 20 IPs. Use a halfwidth comma to each IP)
        expire (ExpireEnum): API expiration time: Never expire(default)-1, 30Day30, 90Day90, 180Day180, 360Day360
        sub_name (str): Sub-account name, create sub account name of API Key.
    """

    class ExpireEnum(Enum):
        """
        Attributes:
            T_1: 
            T_30: 
            T_90: 
            T_180: 
            T_360: 
        """
        T_1 = '-1'
        T_30 = '30'
        T_90 = '90'
        T_180 = '180'
        T_360 = '360'

    passphrase: Optional[str] = Field(
        default=None,
        description=
        "Password (Must contain 7–32 characters. Cannot contain any spaces.)")
    remark: Optional[str] = Field(default=None,
                                  description="Remarks (1–24 characters)")
    permission: Optional[str] = Field(
        default='General',
        description=
        "[Permissions](https://www.kucoin.com/docs-new/doc-338144)(Only General, Spot, Futures, Margin, InnerTransfer (Flex Transfer) permissions can be set, such as \"General, Trade\". The default is \"General\")"
    )
    ip_whitelist: Optional[str] = Field(
        default=None,
        description=
        "IP whitelist (You may add up to 20 IPs. Use a halfwidth comma to each IP)",
        alias="ipWhitelist")
    expire: Optional[ExpireEnum] = Field(
        default=ExpireEnum.T_1,
        description=
        "API expiration time: Never expire(default)-1, 30Day30, 90Day90, 180Day180, 360Day360"
    )
    sub_name: Optional[str] = Field(
        default=None,
        description="Sub-account name, create sub account name of API Key.",
        alias="subName")

    __properties: ClassVar[List[str]] = [
        "passphrase", "remark", "permission", "ipWhitelist", "expire",
        "subName"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddSubAccountApiReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddSubAccountApiReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "passphrase":
            obj.get("passphrase"),
            "remark":
            obj.get("remark"),
            "permission":
            obj.get("permission")
            if obj.get("permission") is not None else 'General',
            "ipWhitelist":
            obj.get("ipWhitelist"),
            "expire":
            obj.get("expire") if obj.get("expire") is not None else
            AddSubAccountApiReq.ExpireEnum.T_1,
            "subName":
            obj.get("subName")
        })
        return _obj


class AddSubAccountApiReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_passphrase(self, value: str) -> AddSubAccountApiReqBuilder:
        """
        Password (Must contain 7–32 characters. Cannot contain any spaces.)
        """
        self.obj['passphrase'] = value
        return self

    def set_remark(self, value: str) -> AddSubAccountApiReqBuilder:
        """
        Remarks (1–24 characters)
        """
        self.obj['remark'] = value
        return self

    def set_permission(self, value: str) -> AddSubAccountApiReqBuilder:
        """
        [Permissions](https://www.kucoin.com/docs-new/doc-338144)(Only General, Spot, Futures, Margin, InnerTransfer (Flex Transfer) permissions can be set, such as \"General, Trade\". The default is \"General\")
        """
        self.obj['permission'] = value
        return self

    def set_ip_whitelist(self, value: str) -> AddSubAccountApiReqBuilder:
        """
        IP whitelist (You may add up to 20 IPs. Use a halfwidth comma to each IP)
        """
        self.obj['ipWhitelist'] = value
        return self

    def set_expire(
            self, value: AddSubAccountApiReq.ExpireEnum
    ) -> AddSubAccountApiReqBuilder:
        """
        API expiration time: Never expire(default)-1, 30Day30, 90Day90, 180Day180, 360Day360
        """
        self.obj['expire'] = value
        return self

    def set_sub_name(self, value: str) -> AddSubAccountApiReqBuilder:
        """
        Sub-account name, create sub account name of API Key.
        """
        self.obj['subName'] = value
        return self

    def build(self) -> AddSubAccountApiReq:
        return AddSubAccountApiReq(**self.obj)
