# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class AddSubAccountApiResp(BaseModel, Response):
    """
    AddSubAccountApiResp

    Attributes:
        sub_name (str): Sub-account name
        remark (str): Remarks
        api_key (str): API Key
        api_secret (str): API Secret Key 
        api_version (int): API Version
        passphrase (str): Password
        permission (str): [Permissions](https://www.kucoin.com/docs-new/doc-338144)
        ip_whitelist (str): IP whitelist
        created_at (int): Time of event
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    sub_name: Optional[str] = Field(default=None,
                                    description="Sub-account name",
                                    alias="subName")
    remark: Optional[str] = Field(default=None, description="Remarks")
    api_key: Optional[str] = Field(default=None,
                                   description="API Key",
                                   alias="apiKey")
    api_secret: Optional[str] = Field(default=None,
                                      description="API Secret Key ",
                                      alias="apiSecret")
    api_version: Optional[int] = Field(default=None,
                                       description="API Version",
                                       alias="apiVersion")
    passphrase: Optional[str] = Field(default=None, description="Password")
    permission: Optional[str] = Field(
        default=None,
        description="[Permissions](https://www.kucoin.com/docs-new/doc-338144)"
    )
    ip_whitelist: Optional[str] = Field(default=None,
                                        description="IP whitelist",
                                        alias="ipWhitelist")
    created_at: Optional[int] = Field(default=None,
                                      description="Time of event",
                                      alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "subName", "remark", "apiKey", "apiSecret", "apiVersion", "passphrase",
        "permission", "ipWhitelist", "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddSubAccountApiResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[AddSubAccountApiResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subName": obj.get("subName"),
            "remark": obj.get("remark"),
            "apiKey": obj.get("apiKey"),
            "apiSecret": obj.get("apiSecret"),
            "apiVersion": obj.get("apiVersion"),
            "passphrase": obj.get("passphrase"),
            "permission": obj.get("permission"),
            "ipWhitelist": obj.get("ipWhitelist"),
            "createdAt": obj.get("createdAt")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
