# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetFuturesSubAccountListV2Summary(BaseModel):
    """
    GetFuturesSubAccountListV2Summary

    Attributes:
        account_equity_total (float): Total Account Equity
        unrealised_pnl_total (float): Total unrealizedPNL
        margin_balance_total (float): Total Margin Balance
        position_margin_total (float): Total Position margin
        order_margin_total (float): 
        frozen_funds_total (float): Total frozen funds for withdrawal and out-transfer
        available_balance_total (float): Total available balance
        currency (str): 
    """

    account_equity_total: Optional[float] = Field(
        default=None,
        description="Total Account Equity",
        alias="accountEquityTotal")
    unrealised_pnl_total: Optional[float] = Field(
        default=None,
        description="Total unrealizedPNL",
        alias="unrealisedPNLTotal")
    margin_balance_total: Optional[float] = Field(
        default=None,
        description="Total Margin Balance",
        alias="marginBalanceTotal")
    position_margin_total: Optional[float] = Field(
        default=None,
        description="Total Position margin",
        alias="positionMarginTotal")
    order_margin_total: Optional[float] = Field(default=None,
                                                alias="orderMarginTotal")
    frozen_funds_total: Optional[float] = Field(
        default=None,
        description="Total frozen funds for withdrawal and out-transfer",
        alias="frozenFundsTotal")
    available_balance_total: Optional[float] = Field(
        default=None,
        description="Total available balance",
        alias="availableBalanceTotal")
    currency: Optional[str] = None

    __properties: ClassVar[List[str]] = [
        "accountEquityTotal", "unrealisedPNLTotal", "marginBalanceTotal",
        "positionMarginTotal", "orderMarginTotal", "frozenFundsTotal",
        "availableBalanceTotal", "currency"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls, json_str: str) -> Optional[GetFuturesSubAccountListV2Summary]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetFuturesSubAccountListV2Summary]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountEquityTotal":
            obj.get("accountEquityTotal"),
            "unrealisedPNLTotal":
            obj.get("unrealisedPNLTotal"),
            "marginBalanceTotal":
            obj.get("marginBalanceTotal"),
            "positionMarginTotal":
            obj.get("positionMarginTotal"),
            "orderMarginTotal":
            obj.get("orderMarginTotal"),
            "frozenFundsTotal":
            obj.get("frozenFundsTotal"),
            "availableBalanceTotal":
            obj.get("availableBalanceTotal"),
            "currency":
            obj.get("currency")
        })
        return _obj
