# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_spot_sub_account_list_v1_data_main_accounts import GetSpotSubAccountListV1DataMainAccounts
from .model_get_spot_sub_account_list_v1_data_margin_accounts import GetSpotSubAccountListV1DataMarginAccounts
from .model_get_spot_sub_account_list_v1_data_trade_accounts import GetSpotSubAccountListV1DataTradeAccounts


class GetSpotSubAccountListV1Data(BaseModel):
    """
    GetSpotSubAccountListV1Data

    Attributes:
        sub_user_id (str): The user ID of the sub-user.
        sub_name (str): The username of the sub-user.
        main_accounts (list[GetSpotSubAccountListV1DataMainAccounts]): Funding Account
        trade_accounts (list[GetSpotSubAccountListV1DataTradeAccounts]): Spot Account
        margin_accounts (list[GetSpotSubAccountListV1DataMarginAccounts]): Margin Account
        trade_hf_accounts (list[str]): This param is deprecated and only valid for some old users
    """

    sub_user_id: Optional[str] = Field(
        default=None,
        description="The user ID of the sub-user.",
        alias="subUserId")
    sub_name: Optional[str] = Field(
        default=None,
        description="The username of the sub-user.",
        alias="subName")
    main_accounts: Optional[
        List[GetSpotSubAccountListV1DataMainAccounts]] = Field(
            default=None, description="Funding Account", alias="mainAccounts")
    trade_accounts: Optional[
        List[GetSpotSubAccountListV1DataTradeAccounts]] = Field(
            default=None, description="Spot Account", alias="tradeAccounts")
    margin_accounts: Optional[
        List[GetSpotSubAccountListV1DataMarginAccounts]] = Field(
            default=None, description="Margin Account", alias="marginAccounts")
    trade_hf_accounts: Optional[List[str]] = Field(
        default=None,
        description=
        "This param is deprecated and only valid for some old users",
        alias="tradeHFAccounts")

    __properties: ClassVar[List[str]] = [
        "subUserId", "subName", "mainAccounts", "tradeAccounts",
        "marginAccounts", "tradeHFAccounts"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotSubAccountListV1Data]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in main_accounts (list)
        _items = []
        if self.main_accounts:
            for _item_main_accounts in self.main_accounts:
                if _item_main_accounts:
                    _items.append(_item_main_accounts.to_dict())
            _dict['mainAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trade_accounts (list)
        _items = []
        if self.trade_accounts:
            for _item_trade_accounts in self.trade_accounts:
                if _item_trade_accounts:
                    _items.append(_item_trade_accounts.to_dict())
            _dict['tradeAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in margin_accounts (list)
        _items = []
        if self.margin_accounts:
            for _item_margin_accounts in self.margin_accounts:
                if _item_margin_accounts:
                    _items.append(_item_margin_accounts.to_dict())
            _dict['marginAccounts'] = _items
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetSpotSubAccountListV1Data]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subUserId":
            obj.get("subUserId"),
            "subName":
            obj.get("subName"),
            "mainAccounts": [
                GetSpotSubAccountListV1DataMainAccounts.from_dict(_item)
                for _item in obj["mainAccounts"]
            ] if obj.get("mainAccounts") is not None else None,
            "tradeAccounts": [
                GetSpotSubAccountListV1DataTradeAccounts.from_dict(_item)
                for _item in obj["tradeAccounts"]
            ] if obj.get("tradeAccounts") is not None else None,
            "marginAccounts": [
                GetSpotSubAccountListV1DataMarginAccounts.from_dict(_item)
                for _item in obj["marginAccounts"]
            ] if obj.get("marginAccounts") is not None else None,
            "tradeHFAccounts":
            obj.get("tradeHFAccounts")
        })
        return _obj
