# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class InnerTransferReq(BaseModel):
    """
    InnerTransferReq

    Attributes:
        client_oid (str): Unique order ID created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        currency (str): currency
        amount (str): Transfer amount: The amount is a positive integer multiple of the currency precision.
        to (ToEnum): Receiving Account Type: main, trade, margin, isolated, margin_v2, isolated_v2, contract
        from_tag (str): Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT
        to_tag (str): Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT
        from_ (FromEnum): Payment Account Type: main, trade, margin, isolated, margin_v2, isolated_v2
    """

    class ToEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            MARGIN: Cross margin account
            ISOLATED: Isolated margin account
            MARGIN_V2: Cross margin account
            ISOLATED_V2: Isolated margin account
            OPTION: Option account
        """
        MAIN = 'main'
        TRADE = 'trade'
        MARGIN = 'margin'
        ISOLATED = 'isolated'
        MARGIN_V2 = 'margin_v2'
        ISOLATED_V2 = 'isolated_v2'
        OPTION = 'option'

    class FromEnum(Enum):
        """
        Attributes:
            MAIN: Funding account
            TRADE: Spot account
            MARGIN: Cross margin account
            ISOLATED: Isolated margin account
            MARGIN_V2: Cross margin account
            ISOLATED_V2: Isolated margin account
            OPTION: Option account
        """
        MAIN = 'main'
        TRADE = 'trade'
        MARGIN = 'margin'
        ISOLATED = 'isolated'
        MARGIN_V2 = 'margin_v2'
        ISOLATED_V2 = 'isolated_v2'
        OPTION = 'option'

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order ID created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits",
        alias="clientOid")
    currency: Optional[str] = Field(default=None, description="currency")
    amount: Optional[str] = Field(
        default=None,
        description=
        "Transfer amount: The amount is a positive integer multiple of the currency precision."
    )
    to: Optional[ToEnum] = Field(
        default=None,
        description=
        "Receiving Account Type: main, trade, margin, isolated, margin_v2, isolated_v2, contract"
    )
    from_tag: Optional[str] = Field(
        default=None,
        description=
        "Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT",
        alias="fromTag")
    to_tag: Optional[str] = Field(
        default=None,
        description=
        "Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT",
        alias="toTag")
    from_: Optional[FromEnum] = Field(
        default=None,
        description=
        "Payment Account Type: main, trade, margin, isolated, margin_v2, isolated_v2",
        alias="from")

    __properties: ClassVar[List[str]] = [
        "clientOid", "currency", "amount", "to", "fromTag", "toTag", "from"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[InnerTransferReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[InnerTransferReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid": obj.get("clientOid"),
            "currency": obj.get("currency"),
            "amount": obj.get("amount"),
            "to": obj.get("to"),
            "fromTag": obj.get("fromTag"),
            "toTag": obj.get("toTag"),
            "from": obj.get("from")
        })
        return _obj


class InnerTransferReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> InnerTransferReqBuilder:
        """
        Unique order ID created by users to identify their orders, e.g. UUID, with a maximum length of 128 bits
        """
        self.obj['clientOid'] = value
        return self

    def set_currency(self, value: str) -> InnerTransferReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_amount(self, value: str) -> InnerTransferReqBuilder:
        """
        Transfer amount: The amount is a positive integer multiple of the currency precision.
        """
        self.obj['amount'] = value
        return self

    def set_to(self,
               value: InnerTransferReq.ToEnum) -> InnerTransferReqBuilder:
        """
        Receiving Account Type: main, trade, margin, isolated, margin_v2, isolated_v2, contract
        """
        self.obj['to'] = value
        return self

    def set_from_tag(self, value: str) -> InnerTransferReqBuilder:
        """
        Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT
        """
        self.obj['fromTag'] = value
        return self

    def set_to_tag(self, value: str) -> InnerTransferReqBuilder:
        """
        Trading pair, required when the payment account type is isolated, e.g.: BTC-USDT
        """
        self.obj['toTag'] = value
        return self

    def set_from_(self,
                  value: InnerTransferReq.FromEnum) -> InnerTransferReqBuilder:
        """
        Payment Account Type: main, trade, margin, isolated, margin_v2, isolated_v2
        """
        self.obj['from'] = value
        return self

    def build(self) -> InnerTransferReq:
        return InnerTransferReq(**self.obj)
