# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class WithdrawalV3Req(BaseModel):
    """
    WithdrawalV3Req

    Attributes:
        currency (str): currency
        chain (str): The chainId of currency, For a currency with multiple chains, it is recommended to specify the chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface.
        amount (int): Withdrawal amount, a positive number which is a multiple of the amount precision
        memo (str): Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to KuCoin, you need to fill in memo(tag). Be careful: If you do not fill in memo(tag), your deposit may not be available.
        is_inner (bool): Internal withdrawal or not. Default: False
        remark (str): Remark
        fee_deduct_type (str): Withdrawal fee deduction type: INTERNAL, EXTERNAL, or not specified  1. INTERNAL: Deduct the transaction fees from your withdrawal amount 2. EXTERNAL: Deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.
        to_address (str): Withdrawal address
        withdraw_type (WithdrawTypeEnum): Withdrawal type, ADDRESS (withdrawal address), UID, MAIL (email), PHONE (mobile phone number). Note: If you withdraw by uid/mail/phone, there will be rate limits: 3 times/10 seconds, 50 times/24 hours (calculated on a rolling basis based on the first request time)
    """

    class WithdrawTypeEnum(Enum):
        """
        Attributes:
            ADDRESS: 
            UID: 
            MAIL: 
            PHONE: 
        """
        ADDRESS = 'ADDRESS'
        UID = 'UID'
        MAIL = 'MAIL'
        PHONE = 'PHONE'

    currency: Optional[str] = Field(default=None, description="currency")
    chain: Optional[str] = Field(
        default='eth',
        description=
        "The chainId of currency, For a currency with multiple chains, it is recommended to specify the chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface."
    )
    amount: Optional[int] = Field(
        default=None,
        description=
        "Withdrawal amount, a positive number which is a multiple of the amount precision"
    )
    memo: Optional[str] = Field(
        default=None,
        description=
        "Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to KuCoin, you need to fill in memo(tag). Be careful: If you do not fill in memo(tag), your deposit may not be available."
    )
    is_inner: Optional[bool] = Field(
        default=False,
        description="Internal withdrawal or not. Default: False",
        alias="isInner")
    remark: Optional[str] = Field(default=None, description="Remark")
    fee_deduct_type: Optional[str] = Field(
        default=None,
        description=
        "Withdrawal fee deduction type: INTERNAL, EXTERNAL, or not specified  1. INTERNAL: Deduct the transaction fees from your withdrawal amount 2. EXTERNAL: Deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.",
        alias="feeDeductType")
    to_address: Optional[str] = Field(default=None,
                                      description="Withdrawal address",
                                      alias="toAddress")
    withdraw_type: Optional[WithdrawTypeEnum] = Field(
        default=None,
        description=
        "Withdrawal type, ADDRESS (withdrawal address), UID, MAIL (email), PHONE (mobile phone number). Note: If you withdraw by uid/mail/phone, there will be rate limits: 3 times/10 seconds, 50 times/24 hours (calculated on a rolling basis based on the first request time)",
        alias="withdrawType")

    __properties: ClassVar[List[str]] = [
        "currency", "chain", "amount", "memo", "isInner", "remark",
        "feeDeductType", "toAddress", "withdrawType"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[WithdrawalV3Req]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[WithdrawalV3Req]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "chain":
            obj.get("chain") if obj.get("chain") is not None else 'eth',
            "amount":
            obj.get("amount"),
            "memo":
            obj.get("memo"),
            "isInner":
            obj.get("isInner") if obj.get("isInner") is not None else False,
            "remark":
            obj.get("remark"),
            "feeDeductType":
            obj.get("feeDeductType"),
            "toAddress":
            obj.get("toAddress"),
            "withdrawType":
            obj.get("withdrawType")
        })
        return _obj


class WithdrawalV3ReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_chain(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        The chainId of currency, For a currency with multiple chains, it is recommended to specify the chain parameter instead of using the default chain; you can query the chainId through the response of the GET /api/v3/currencies/{currency} interface.
        """
        self.obj['chain'] = value
        return self

    def set_amount(self, value: int) -> WithdrawalV3ReqBuilder:
        """
        Withdrawal amount, a positive number which is a multiple of the amount precision
        """
        self.obj['amount'] = value
        return self

    def set_memo(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        Address remark. If there’s no remark, it is empty. When you withdraw from other platforms to KuCoin, you need to fill in memo(tag). Be careful: If you do not fill in memo(tag), your deposit may not be available.
        """
        self.obj['memo'] = value
        return self

    def set_is_inner(self, value: bool) -> WithdrawalV3ReqBuilder:
        """
        Internal withdrawal or not. Default: False
        """
        self.obj['isInner'] = value
        return self

    def set_remark(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        Remark
        """
        self.obj['remark'] = value
        return self

    def set_fee_deduct_type(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        Withdrawal fee deduction type: INTERNAL, EXTERNAL, or not specified  1. INTERNAL: Deduct the transaction fees from your withdrawal amount 2. EXTERNAL: Deduct the transaction fees from your main account 3. If you don't specify the feeDeductType parameter, when the balance in your main account is sufficient to support the withdrawal, the system will initially deduct the transaction fees from your main account. But if the balance in your main account is not sufficient to support the withdrawal, the system will deduct the fees from your withdrawal amount. For example: Suppose you are going to withdraw 1 BTC from the KuCoin platform (transaction fee: 0.0001BTC), if the balance in your main account is insufficient, the system will deduct the transaction fees from your withdrawal amount. In this case, you will be receiving 0.9999BTC.
        """
        self.obj['feeDeductType'] = value
        return self

    def set_to_address(self, value: str) -> WithdrawalV3ReqBuilder:
        """
        Withdrawal address
        """
        self.obj['toAddress'] = value
        return self

    def set_withdraw_type(
            self,
            value: WithdrawalV3Req.WithdrawTypeEnum) -> WithdrawalV3ReqBuilder:
        """
        Withdrawal type, ADDRESS (withdrawal address), UID, MAIL (email), PHONE (mobile phone number). Note: If you withdraw by uid/mail/phone, there will be rate limits: 3 times/10 seconds, 50 times/24 hours (calculated on a rolling basis based on the first request time)
        """
        self.obj['withdrawType'] = value
        return self

    def build(self) -> WithdrawalV3Req:
        return WithdrawalV3Req(**self.obj)
