# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAccountMargins(BaseModel):
    """
    GetAccountMargins

    Attributes:
        margin_ccy (str): Margin Currency
        margin_qty (str): Maintenance Quantity (Calculated with Margin Coefficient)
        margin_factor (str): Margin Coefficient return real-time margin discount rate to USDT
    """

    margin_ccy: Optional[str] = Field(default=None,
                                      description="Margin Currency",
                                      alias="marginCcy")
    margin_qty: Optional[str] = Field(
        default=None,
        description="Maintenance Quantity (Calculated with Margin Coefficient)",
        alias="marginQty")
    margin_factor: Optional[str] = Field(
        default=None,
        description=
        "Margin Coefficient return real-time margin discount rate to USDT",
        alias="marginFactor")

    __properties: ClassVar[List[str]] = [
        "marginCcy", "marginQty", "marginFactor"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAccountMargins]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[GetAccountMargins]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "marginCcy": obj.get("marginCcy"),
            "marginQty": obj.get("marginQty"),
            "marginFactor": obj.get("marginFactor")
        })
        return _obj
