# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetRebaseReq(BaseModel):
    """
    GetRebaseReq

    Attributes:
        begin (str): Start time, for example: 20240610
        end (str): End time, for example: 20241010 (query data with a maximum interval of 6 months) 
        trade_type (TradeTypeEnum): Transaction type: 1, spot; 2, futures
    """

    class TradeTypeEnum(Enum):
        """
        Attributes:
            T_1: spot
            T_2: futures
        """
        T_1 = '1'
        T_2 = '2'

    begin: Optional[str] = Field(
        default=None, description="Start time, for example: 20240610")
    end: Optional[str] = Field(
        default=None,
        description=
        "End time, for example: 20241010 (query data with a maximum interval of 6 months) "
    )
    trade_type: Optional[TradeTypeEnum] = Field(
        default=None,
        description="Transaction type: 1, spot; 2, futures",
        alias="tradeType")

    __properties: ClassVar[List[str]] = ["begin", "end", "tradeType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRebaseReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetRebaseReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "begin": obj.get("begin"),
            "end": obj.get("end"),
            "tradeType": obj.get("tradeType")
        })
        return _obj


class GetRebaseReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_begin(self, value: str) -> GetRebaseReqBuilder:
        """
        Start time, for example: 20240610
        """
        self.obj['begin'] = value
        return self

    def set_end(self, value: str) -> GetRebaseReqBuilder:
        """
        End time, for example: 20241010 (query data with a maximum interval of 6 months) 
        """
        self.obj['end'] = value
        return self

    def set_trade_type(
            self, value: GetRebaseReq.TradeTypeEnum) -> GetRebaseReqBuilder:
        """
        Transaction type: 1, spot; 2, futures
        """
        self.obj['tradeType'] = value
        return self

    def build(self) -> GetRebaseReq:
        return GetRebaseReq(**self.obj)
