# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddSubAccountReq(BaseModel):
    """
    AddSubAccountReq

    Attributes:
        account_name (str): Sub-account Name. Note that this name is unique across the exchange. It is recommended to add a special identifier to prevent name duplication.
    """

    account_name: Optional[str] = Field(
        default=None,
        description=
        "Sub-account Name. Note that this name is unique across the exchange. It is recommended to add a special identifier to prevent name duplication.",
        alias="accountName")

    __properties: ClassVar[List[str]] = ["accountName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddSubAccountReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AddSubAccountReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({"accountName": obj.get("accountName")})
        return _obj


class AddSubAccountReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_account_name(self, value: str) -> AddSubAccountReqBuilder:
        """
        Sub-account Name. Note that this name is unique across the exchange. It is recommended to add a special identifier to prevent name duplication.
        """
        self.obj['accountName'] = value
        return self

    def build(self) -> AddSubAccountReq:
        return AddSubAccountReq(**self.obj)
