# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetBrokerInfoResp(BaseModel, Response):
    """
    GetBrokerInfoResp

    Attributes:
        account_size (int): Number of sub-accounts created
        max_account_size (int): The maximum number of sub-accounts allowed to be created; null means no limit
        level (int): Broker level
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    account_size: Optional[int] = Field(
        default=None,
        description="Number of sub-accounts created",
        alias="accountSize")
    max_account_size: Optional[int] = Field(
        default=None,
        description=
        "The maximum number of sub-accounts allowed to be created; null means no limit",
        alias="maxAccountSize")
    level: Optional[int] = Field(default=None, description="Broker level")

    __properties: ClassVar[List[str]] = [
        "accountSize", "maxAccountSize", "level"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetBrokerInfoResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[GetBrokerInfoResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountSize": obj.get("accountSize"),
            "maxAccountSize": obj.get("maxAccountSize"),
            "level": obj.get("level")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
