# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSubAccountItems(BaseModel):
    """
    GetSubAccountItems

    Attributes:
        account_name (str): Sub-account name
        uid (str): Sub-account UID
        created_at (int): Creation time, Unix timestamp (milliseconds)
        level (int): Sub-account VIP level 
    """

    account_name: Optional[str] = Field(default=None,
                                        description="Sub-account name",
                                        alias="accountName")
    uid: Optional[str] = Field(default=None, description="Sub-account UID")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation time, Unix timestamp (milliseconds)",
        alias="createdAt")
    level: Optional[int] = Field(default=None,
                                 description="Sub-account VIP level ")

    __properties: ClassVar[List[str]] = [
        "accountName", "uid", "createdAt", "level"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSubAccountItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSubAccountItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountName": obj.get("accountName"),
            "uid": obj.get("uid"),
            "createdAt": obj.get("createdAt"),
            "level": obj.get("level")
        })
        return _obj
