# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetWithdrawDetailResp(BaseModel, Response):
    """
    GetWithdrawDetailResp

    Attributes:
        id (str): Withdrawal ID
        chain (str): Chain ID of currency
        wallet_tx_id (str): Wallet Transaction ID
        uid (int): UID
        updated_at (int): Update Time (milliseconds)
        amount (str): Amount
        memo (str): Memo
        fee (str): Fee
        address (str): Address
        remark (str): Remark
        is_inner (bool): Is Internal (true or false)
        currency (str): Currency
        status (StatusEnum): Status (PROCESSING, WALLET_PROCESSING, REVIEW, SUCCESS, FAILURE)
        created_at (int): Creation Time (milliseconds)
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PROCESSING: 
            WALLET_PROCESSING: 
            REVIEW: 
            SUCCESS: 
            FAILURE: 
        """
        PROCESSING = 'PROCESSING'
        WALLET_PROCESSING = 'WALLET_PROCESSING'
        REVIEW = 'REVIEW'
        SUCCESS = 'SUCCESS'
        FAILURE = 'FAILURE'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    id: Optional[str] = Field(default=None, description="Withdrawal ID")
    chain: Optional[str] = Field(default=None,
                                 description="Chain ID of currency")
    wallet_tx_id: Optional[str] = Field(default=None,
                                        description="Wallet Transaction ID",
                                        alias="walletTxId")
    uid: Optional[int] = Field(default=None, description="UID")
    updated_at: Optional[int] = Field(default=None,
                                      description="Update Time (milliseconds)",
                                      alias="updatedAt")
    amount: Optional[str] = Field(default=None, description="Amount")
    memo: Optional[str] = Field(default=None, description="Memo")
    fee: Optional[str] = Field(default=None, description="Fee")
    address: Optional[str] = Field(default=None, description="Address")
    remark: Optional[str] = Field(default=None, description="Remark")
    is_inner: Optional[bool] = Field(default=None,
                                     description="Is Internal (true or false)",
                                     alias="isInner")
    currency: Optional[str] = Field(default=None, description="Currency")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Status (PROCESSING, WALLET_PROCESSING, REVIEW, SUCCESS, FAILURE)")
    created_at: Optional[int] = Field(
        default=None,
        description="Creation Time (milliseconds)",
        alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "id", "chain", "walletTxId", "uid", "updatedAt", "amount", "memo",
        "fee", "address", "remark", "isInner", "currency", "status",
        "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetWithdrawDetailResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetWithdrawDetailResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "chain": obj.get("chain"),
            "walletTxId": obj.get("walletTxId"),
            "uid": obj.get("uid"),
            "updatedAt": obj.get("updatedAt"),
            "amount": obj.get("amount"),
            "memo": obj.get("memo"),
            "fee": obj.get("fee"),
            "address": obj.get("address"),
            "remark": obj.get("remark"),
            "isInner": obj.get("isInner"),
            "currency": obj.get("currency"),
            "status": obj.get("status"),
            "createdAt": obj.get("createdAt")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
