# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class AddOrderTestReq(BaseModel):
    """
    AddOrderTestReq

    Attributes:
        client_oid (str): Unique order ID created by users to identify their orders. The maximum length cannot exceed 40, e.g. UUID only allows numbers, characters, underline(_), and separator (-).
        side (SideEnum): Specify if the order is to 'buy' or 'sell'.
        symbol (str): Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        leverage (int): Used to calculate the margin to be frozen for the order. If you are to close the position, this parameter is not required.
        type (TypeEnum): Specify if the order is a 'limit' order or 'market' order
        stop (StopEnum): Either 'down' or 'up'.  If stop is used, parameter stopPrice and stopPriceType also need to be provided.
        stop_price_type (StopPriceTypeEnum): Either 'TP' or 'MP' need to be defined if stop is specified.
        stop_price (str): Needs to be defined if stop is specified. 
        reduce_only (bool): A mark to reduce the position size only. Set to false by default. Need to set the position size when reduceOnly is true. If set to true, only the orders reducing the position size will be executed. If the reduce-only order size exceeds the position size, the extra size will be canceled.
        close_order (bool): A mark to close the position. Set to false by default. If closeOrder is set to true, the system will close the position and the position size will become 0. Side, Size and Leverage fields can be left empty and the system will determine the side and size automatically.
        margin_mode (MarginModeEnum): Margin mode: ISOLATED, default: ISOLATED
        price (str): Required for type is 'limit' order, indicating the operating price
        size (int): Order size (lot), must be a positive integer. The quantity unit of coin-swap contracts is size (lot), and other units are not supported.
        time_in_force (TimeInForceEnum): Optional for type is 'limit' order, [Time in force](https://www.kucoin.com/docs-new/doc-338146) is a special strategy used during trading, default is GTC
        post_only (bool): Optional for type is 'limit' order, post only flag, invalid when timeInForce is IOC. When postOnly is true, not allowed to choose hidden or iceberg. The post-only flag ensures that the trader always pays the maker fee and provides liquidity to the order book. If any part of the order is going to pay taker fees, the order will be fully rejected.
        hidden (bool): Optional for type is 'limit' order, orders not displaying in order book. When hidden is chosen, choosing postOnly is not allowed.
        iceberg (bool): Optional for type is 'limit' order, Only visible portion of the order is displayed in the order book. When iceberg is chose, choosing postOnly is not allowed.
        visible_size (str): Optional for type is 'limit' order, the maximum visible size of an iceberg order. Please place order in size (lots). The units of qty (base currency) and valueQty (value) are not supported. Need to be defined if iceberg is specified.
    """

    class SideEnum(Enum):
        """
        Attributes:
            BUY: 
            SELL: 
        """
        BUY = 'buy'
        SELL = 'sell'

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: 
            MARKET: 
        """
        LIMIT = 'limit'
        MARKET = 'market'

    class StopEnum(Enum):
        """
        Attributes:
            DOWN: Triggers when the price reaches or goes below the stopPrice.
            UP: Triggers when the price reaches or goes above the stopPrice.
        """
        DOWN = 'down'
        UP = 'up'

    class StopPriceTypeEnum(Enum):
        """
        Attributes:
            TRADE_PRICE: TP for trade price, The last trade price is the last price at which an order was filled. This price can be found in the latest match message.
            MARK_PRICE: MP for mark price. The mark price can be obtained through relevant OPEN API for index services.
        """
        TRADE_PRICE = 'TP'
        MARK_PRICE = 'MP'

    class MarginModeEnum(Enum):
        """
        Attributes:
            ISOLATED: Isolated Margin
        """
        ISOLATED = 'ISOLATED'

    class TimeInForceEnum(Enum):
        """
        Attributes:
            GOOD_TILL_CANCELED: order remains open on the order book until canceled. This is the default type if the field is left empty.
            IMMEDIATE_OR_CANCEL: being matched or not, the remaining size of the order will be instantly canceled instead of entering the order book.
        """
        GOOD_TILL_CANCELED = 'GTC'
        IMMEDIATE_OR_CANCEL = 'IOC'

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order ID created by users to identify their orders. The maximum length cannot exceed 40, e.g. UUID only allows numbers, characters, underline(_), and separator (-).",
        alias="clientOid")
    side: Optional[SideEnum] = Field(
        default=None,
        description="Specify if the order is to 'buy' or 'sell'.")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    leverage: Optional[int] = Field(
        default=None,
        description=
        "Used to calculate the margin to be frozen for the order. If you are to close the position, this parameter is not required."
    )
    type: Optional[TypeEnum] = Field(
        default=TypeEnum.LIMIT,
        description="Specify if the order is a 'limit' order or 'market' order"
    )
    stop: Optional[StopEnum] = Field(
        default=None,
        description=
        "Either 'down' or 'up'.  If stop is used, parameter stopPrice and stopPriceType also need to be provided."
    )
    stop_price_type: Optional[StopPriceTypeEnum] = Field(
        default=None,
        description=
        "Either 'TP' or 'MP' need to be defined if stop is specified.",
        alias="stopPriceType")
    stop_price: Optional[str] = Field(
        default=None,
        description="Needs to be defined if stop is specified. ",
        alias="stopPrice")
    reduce_only: Optional[bool] = Field(
        default=False,
        description=
        "A mark to reduce the position size only. Set to false by default. Need to set the position size when reduceOnly is true. If set to true, only the orders reducing the position size will be executed. If the reduce-only order size exceeds the position size, the extra size will be canceled.",
        alias="reduceOnly")
    close_order: Optional[bool] = Field(
        default=False,
        description=
        "A mark to close the position. Set to false by default. If closeOrder is set to true, the system will close the position and the position size will become 0. Side, Size and Leverage fields can be left empty and the system will determine the side and size automatically.",
        alias="closeOrder")
    margin_mode: Optional[MarginModeEnum] = Field(
        default=MarginModeEnum.ISOLATED,
        description="Margin mode: ISOLATED, default: ISOLATED",
        alias="marginMode")
    price: Optional[str] = Field(
        default=None,
        description=
        "Required for type is 'limit' order, indicating the operating price")
    size: Optional[int] = Field(
        default=None,
        description=
        "Order size (lot), must be a positive integer. The quantity unit of coin-swap contracts is size (lot), and other units are not supported."
    )
    time_in_force: Optional[TimeInForceEnum] = Field(
        default=TimeInForceEnum.GOOD_TILL_CANCELED,
        description=
        "Optional for type is 'limit' order, [Time in force](https://www.kucoin.com/docs-new/doc-338146) is a special strategy used during trading, default is GTC",
        alias="timeInForce")
    post_only: Optional[bool] = Field(
        default=False,
        description=
        "Optional for type is 'limit' order, post only flag, invalid when timeInForce is IOC. When postOnly is true, not allowed to choose hidden or iceberg. The post-only flag ensures that the trader always pays the maker fee and provides liquidity to the order book. If any part of the order is going to pay taker fees, the order will be fully rejected.",
        alias="postOnly")
    hidden: Optional[bool] = Field(
        default=False,
        description=
        "Optional for type is 'limit' order, orders not displaying in order book. When hidden is chosen, choosing postOnly is not allowed."
    )
    iceberg: Optional[bool] = Field(
        default=False,
        description=
        "Optional for type is 'limit' order, Only visible portion of the order is displayed in the order book. When iceberg is chose, choosing postOnly is not allowed."
    )
    visible_size: Optional[str] = Field(
        default=None,
        description=
        "Optional for type is 'limit' order, the maximum visible size of an iceberg order. Please place order in size (lots). The units of qty (base currency) and valueQty (value) are not supported. Need to be defined if iceberg is specified.",
        alias="visibleSize")

    __properties: ClassVar[List[str]] = [
        "clientOid", "side", "symbol", "leverage", "type", "stop",
        "stopPriceType", "stopPrice", "reduceOnly", "closeOrder", "marginMode",
        "price", "size", "timeInForce", "postOnly", "hidden", "iceberg",
        "visibleSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AddOrderTestReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AddOrderTestReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid":
            obj.get("clientOid"),
            "side":
            obj.get("side"),
            "symbol":
            obj.get("symbol"),
            "leverage":
            obj.get("leverage"),
            "type":
            obj.get("type")
            if obj.get("type") is not None else AddOrderTestReq.TypeEnum.LIMIT,
            "stop":
            obj.get("stop"),
            "stopPriceType":
            obj.get("stopPriceType"),
            "stopPrice":
            obj.get("stopPrice"),
            "reduceOnly":
            obj.get("reduceOnly")
            if obj.get("reduceOnly") is not None else False,
            "closeOrder":
            obj.get("closeOrder")
            if obj.get("closeOrder") is not None else False,
            "marginMode":
            obj.get("marginMode") if obj.get("marginMode") is not None else
            AddOrderTestReq.MarginModeEnum.ISOLATED,
            "price":
            obj.get("price"),
            "size":
            obj.get("size"),
            "timeInForce":
            obj.get("timeInForce") if obj.get("timeInForce") is not None else
            AddOrderTestReq.TimeInForceEnum.GOOD_TILL_CANCELED,
            "postOnly":
            obj.get("postOnly") if obj.get("postOnly") is not None else False,
            "hidden":
            obj.get("hidden") if obj.get("hidden") is not None else False,
            "iceberg":
            obj.get("iceberg") if obj.get("iceberg") is not None else False,
            "visibleSize":
            obj.get("visibleSize")
        })
        return _obj


class AddOrderTestReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> AddOrderTestReqBuilder:
        """
        Unique order ID created by users to identify their orders. The maximum length cannot exceed 40, e.g. UUID only allows numbers, characters, underline(_), and separator (-).
        """
        self.obj['clientOid'] = value
        return self

    def set_side(self,
                 value: AddOrderTestReq.SideEnum) -> AddOrderTestReqBuilder:
        """
        Specify if the order is to 'buy' or 'sell'.
        """
        self.obj['side'] = value
        return self

    def set_symbol(self, value: str) -> AddOrderTestReqBuilder:
        """
        Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_leverage(self, value: int) -> AddOrderTestReqBuilder:
        """
        Used to calculate the margin to be frozen for the order. If you are to close the position, this parameter is not required.
        """
        self.obj['leverage'] = value
        return self

    def set_type(self,
                 value: AddOrderTestReq.TypeEnum) -> AddOrderTestReqBuilder:
        """
        Specify if the order is a 'limit' order or 'market' order
        """
        self.obj['type'] = value
        return self

    def set_stop(self,
                 value: AddOrderTestReq.StopEnum) -> AddOrderTestReqBuilder:
        """
        Either 'down' or 'up'.  If stop is used, parameter stopPrice and stopPriceType also need to be provided.
        """
        self.obj['stop'] = value
        return self

    def set_stop_price_type(
            self, value: AddOrderTestReq.StopPriceTypeEnum
    ) -> AddOrderTestReqBuilder:
        """
        Either 'TP' or 'MP' need to be defined if stop is specified.
        """
        self.obj['stopPriceType'] = value
        return self

    def set_stop_price(self, value: str) -> AddOrderTestReqBuilder:
        """
        Needs to be defined if stop is specified. 
        """
        self.obj['stopPrice'] = value
        return self

    def set_reduce_only(self, value: bool) -> AddOrderTestReqBuilder:
        """
        A mark to reduce the position size only. Set to false by default. Need to set the position size when reduceOnly is true. If set to true, only the orders reducing the position size will be executed. If the reduce-only order size exceeds the position size, the extra size will be canceled.
        """
        self.obj['reduceOnly'] = value
        return self

    def set_close_order(self, value: bool) -> AddOrderTestReqBuilder:
        """
        A mark to close the position. Set to false by default. If closeOrder is set to true, the system will close the position and the position size will become 0. Side, Size and Leverage fields can be left empty and the system will determine the side and size automatically.
        """
        self.obj['closeOrder'] = value
        return self

    def set_margin_mode(
            self,
            value: AddOrderTestReq.MarginModeEnum) -> AddOrderTestReqBuilder:
        """
        Margin mode: ISOLATED, default: ISOLATED
        """
        self.obj['marginMode'] = value
        return self

    def set_price(self, value: str) -> AddOrderTestReqBuilder:
        """
        Required for type is 'limit' order, indicating the operating price
        """
        self.obj['price'] = value
        return self

    def set_size(self, value: int) -> AddOrderTestReqBuilder:
        """
        Order size (lot), must be a positive integer. The quantity unit of coin-swap contracts is size (lot), and other units are not supported.
        """
        self.obj['size'] = value
        return self

    def set_time_in_force(
            self,
            value: AddOrderTestReq.TimeInForceEnum) -> AddOrderTestReqBuilder:
        """
        Optional for type is 'limit' order, [Time in force](https://www.kucoin.com/docs-new/doc-338146) is a special strategy used during trading, default is GTC
        """
        self.obj['timeInForce'] = value
        return self

    def set_post_only(self, value: bool) -> AddOrderTestReqBuilder:
        """
        Optional for type is 'limit' order, post only flag, invalid when timeInForce is IOC. When postOnly is true, not allowed to choose hidden or iceberg. The post-only flag ensures that the trader always pays the maker fee and provides liquidity to the order book. If any part of the order is going to pay taker fees, the order will be fully rejected.
        """
        self.obj['postOnly'] = value
        return self

    def set_hidden(self, value: bool) -> AddOrderTestReqBuilder:
        """
        Optional for type is 'limit' order, orders not displaying in order book. When hidden is chosen, choosing postOnly is not allowed.
        """
        self.obj['hidden'] = value
        return self

    def set_iceberg(self, value: bool) -> AddOrderTestReqBuilder:
        """
        Optional for type is 'limit' order, Only visible portion of the order is displayed in the order book. When iceberg is chose, choosing postOnly is not allowed.
        """
        self.obj['iceberg'] = value
        return self

    def set_visible_size(self, value: str) -> AddOrderTestReqBuilder:
        """
        Optional for type is 'limit' order, the maximum visible size of an iceberg order. Please place order in size (lots). The units of qty (base currency) and valueQty (value) are not supported. Need to be defined if iceberg is specified.
        """
        self.obj['visibleSize'] = value
        return self

    def build(self) -> AddOrderTestReq:
        return AddOrderTestReq(**self.obj)
