# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_get_account_holding_req import GetAccountHoldingReq
from .model_get_account_holding_resp import GetAccountHoldingResp
from .model_get_eth_staking_products_req import GetEthStakingProductsReq
from .model_get_eth_staking_products_resp import GetEthStakingProductsResp
from .model_get_kcs_staking_products_req import GetKcsStakingProductsReq
from .model_get_kcs_staking_products_resp import GetKcsStakingProductsResp
from .model_get_promotion_products_req import GetPromotionProductsReq
from .model_get_promotion_products_resp import GetPromotionProductsResp
from .model_get_redeem_preview_req import GetRedeemPreviewReq
from .model_get_redeem_preview_resp import GetRedeemPreviewResp
from .model_get_savings_products_req import GetSavingsProductsReq
from .model_get_savings_products_resp import GetSavingsProductsResp
from .model_get_staking_products_req import GetStakingProductsReq
from .model_get_staking_products_resp import GetStakingProductsResp
from .model_purchase_req import PurchaseReq
from .model_purchase_resp import PurchaseResp
from .model_redeem_req import RedeemReq
from .model_redeem_resp import RedeemResp


class EarnAPI(ABC):

    @abstractmethod
    def purchase(self, req: PurchaseReq, **kwargs: Any) -> PurchaseResp:
        """
        summary: Purchase
        description: This endpoint allows you to subscribe Earn products.
        documentation: https://www.kucoin.com/docs-new/api-3470268
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | EARN    |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_redeem_preview(self, req: GetRedeemPreviewReq,
                           **kwargs: Any) -> GetRedeemPreviewResp:
        """
        summary: Get Redeem Preview
        description: This endpoint allows you to subscribe Earn products.
        documentation: https://www.kucoin.com/docs-new/api-3470269
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | EARN    |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def redeem(self, req: RedeemReq, **kwargs: Any) -> RedeemResp:
        """
        summary: Redeem
        description: This endpoint allows you to redeem Earn products by using holding ID. If the current holding is fully redeemed or in the process of being redeemed, it means that the holding does not exist.
        documentation: https://www.kucoin.com/docs-new/api-3470270
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | EARN    |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_savings_products(self, req: GetSavingsProductsReq,
                             **kwargs: Any) -> GetSavingsProductsResp:
        """
        summary: Get Savings Products
        description: Available savings products can be obtained at this endpoint. If no products are available, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470271
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_promotion_products(self, req: GetPromotionProductsReq,
                               **kwargs: Any) -> GetPromotionProductsResp:
        """
        summary: Get Promotion Products
        description: Available limited-duration products can be obtained at this endpoint. If no products are available, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470272
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | NULL    |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_staking_products(self, req: GetStakingProductsReq,
                             **kwargs: Any) -> GetStakingProductsResp:
        """
        summary: Get Staking Products
        description: Available staking products can be obtained at this endpoint. If no products are available, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470274
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_kcs_staking_products(self, req: GetKcsStakingProductsReq,
                                 **kwargs: Any) -> GetKcsStakingProductsResp:
        """
        summary: Get KCS Staking Products
        description: Available KCS staking products can be obtained at this endpoint. If no products are available, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470275
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_eth_staking_products(self, req: GetEthStakingProductsReq,
                                 **kwargs: Any) -> GetEthStakingProductsResp:
        """
        summary: Get ETH Staking Products
        description: Available ETH staking products can be obtained at this endpoint. If no products are available, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470276
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_account_holding(self, req: GetAccountHoldingReq,
                            **kwargs: Any) -> GetAccountHoldingResp:
        """
        summary: Get Account Holding
        description: Information on currently held assets can be obtained at this endpoint. If no assets are currently held, an empty list is returned.
        documentation: https://www.kucoin.com/docs-new/api-3470273
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | GENERAL |
        | API-RATE-LIMIT-POOL   | EARN    |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass


class EarnAPIImpl(EarnAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def purchase(self, req: PurchaseReq, **kwargs: Any) -> PurchaseResp:
        return self.transport.call("spot", False,
                                   "POST", "/api/v1/earn/orders", req,
                                   PurchaseResp(), False, **kwargs)

    def get_redeem_preview(self, req: GetRedeemPreviewReq,
                           **kwargs: Any) -> GetRedeemPreviewResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/redeem-preview", req,
                                   GetRedeemPreviewResp(), False, **kwargs)

    def redeem(self, req: RedeemReq, **kwargs: Any) -> RedeemResp:
        return self.transport.call("spot", False,
                                   "DELETE", "/api/v1/earn/orders", req,
                                   RedeemResp(), False, **kwargs)

    def get_savings_products(self, req: GetSavingsProductsReq,
                             **kwargs: Any) -> GetSavingsProductsResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/saving/products", req,
                                   GetSavingsProductsResp(), False, **kwargs)

    def get_promotion_products(self, req: GetPromotionProductsReq,
                               **kwargs: Any) -> GetPromotionProductsResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/promotion/products", req,
                                   GetPromotionProductsResp(), False, **kwargs)

    def get_staking_products(self, req: GetStakingProductsReq,
                             **kwargs: Any) -> GetStakingProductsResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/staking/products", req,
                                   GetStakingProductsResp(), False, **kwargs)

    def get_kcs_staking_products(self, req: GetKcsStakingProductsReq,
                                 **kwargs: Any) -> GetKcsStakingProductsResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/kcs-staking/products", req,
                                   GetKcsStakingProductsResp(), False,
                                   **kwargs)

    def get_eth_staking_products(self, req: GetEthStakingProductsReq,
                                 **kwargs: Any) -> GetEthStakingProductsResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/eth-staking/products", req,
                                   GetEthStakingProductsResp(), False,
                                   **kwargs)

    def get_account_holding(self, req: GetAccountHoldingReq,
                            **kwargs: Any) -> GetAccountHoldingResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v1/earn/hold-assets", req,
                                   GetAccountHoldingResp(), False, **kwargs)
