# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAccountHoldingReq(BaseModel):
    """
    GetAccountHoldingReq

    Attributes:
        currency (str): currency
        product_id (str): Product ID
        product_category (ProductCategoryEnum): Product category
        current_page (int): Current request page.
        page_size (int): Number of results per request. Minimum is 10, maximum is 500.
    """

    class ProductCategoryEnum(Enum):
        """
        Attributes:
            DEMAND: Savings
            ACTIVITY: Activity
            STAKING: Staking
            KCS_STAKING: KCS Staking
            ETH2: ETHStaking
        """
        DEMAND = 'DEMAND'
        ACTIVITY = 'ACTIVITY'
        STAKING = 'STAKING'
        KCS_STAKING = 'KCS_STAKING'
        ETH2 = 'ETH2'

    currency: Optional[str] = Field(default=None, description="currency")
    product_id: Optional[str] = Field(default=None,
                                      description="Product ID",
                                      alias="productId")
    product_category: Optional[ProductCategoryEnum] = Field(
        default=None, description="Product category", alias="productCategory")
    current_page: Optional[int] = Field(default=1,
                                        description="Current request page.",
                                        alias="currentPage")
    page_size: Optional[int] = Field(
        default=15,
        description=
        "Number of results per request. Minimum is 10, maximum is 500.",
        alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "currency", "productId", "productCategory", "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAccountHoldingReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAccountHoldingReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "productId":
            obj.get("productId"),
            "productCategory":
            obj.get("productCategory"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 15
        })
        return _obj


class GetAccountHoldingReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> GetAccountHoldingReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_product_id(self, value: str) -> GetAccountHoldingReqBuilder:
        """
        Product ID
        """
        self.obj['productId'] = value
        return self

    def set_product_category(
        self, value: GetAccountHoldingReq.ProductCategoryEnum
    ) -> GetAccountHoldingReqBuilder:
        """
        Product category
        """
        self.obj['productCategory'] = value
        return self

    def set_current_page(self, value: int) -> GetAccountHoldingReqBuilder:
        """
        Current request page.
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetAccountHoldingReqBuilder:
        """
        Number of results per request. Minimum is 10, maximum is 500.
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetAccountHoldingReq:
        return GetAccountHoldingReq(**self.obj)
