# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetEthStakingProductsData(BaseModel):
    """
    GetEthStakingProductsData

    Attributes:
        id (str): Product ID
        category (CategoryEnum): Product category:  ETH2 (ETH Staking)
        type (TypeEnum): Product subtype: DEMAND (demand)
        precision (int): Maximum precision supported
        currency (str): currency
        income_currency (str): Income currency
        return_rate (str): Annualized Rate of Return, for example, 0.035 is equal to 3.5% annualized rate of return
        user_lower_limit (str): Min. user subscribe amount
        user_upper_limit (str): Max. user subscription amount
        product_upper_limit (str): Products total subscription amount
        product_remain_amount (str): Remaining product subscription amount
        redeem_period (int): Redemption waiting period (days)
        redeem_type (RedeemTypeEnum): Redemption channel: MANUAL (manual redemption), TRANS_DEMAND (transfer to corresponding demand product upon maturity), AUTO (redeem to funding account upon maturity)
        income_release_type (IncomeReleaseTypeEnum): Income release type: DAILY (daily release), AFTER (release after product ends)
        apply_start_time (int): Subscription start time, in milliseconds
        apply_end_time (int): Subscription end time, in milliseconds
        lock_start_time (int): Product earliest interest start time, in milliseconds
        lock_end_time (int): Product maturity time, in milliseconds
        interest_date (int): Most recent interest date (milliseconds)
        new_user_only (NewUserOnlyEnum): Whether the product is exclusive to new users: 0 (no), 1 (yes)
        early_redeem_supported (EarlyRedeemSupportedEnum): Whether the fixed product supports early redemption: 0 (no), 1 (yes)
        duration (int): Product duration (days)
        status (StatusEnum): Product status: ONGOING (Subscription in progress), PENDING (Preheating Subscription), FULL (Subscribed), INTERESTING (Interest in progress)
    """

    class CategoryEnum(Enum):
        """
        Attributes:
            ETH2: 
        """
        ETH2 = 'ETH2'

    class TypeEnum(Enum):
        """
        Attributes:
            DEMAND: demand
        """
        DEMAND = 'DEMAND'

    class RedeemTypeEnum(Enum):
        """
        Attributes:
            MANUAL: 
            TRANS_DEMAND: 
            AUTO: 
        """
        MANUAL = 'MANUAL'
        TRANS_DEMAND = 'TRANS_DEMAND'
        AUTO = 'AUTO'

    class IncomeReleaseTypeEnum(Enum):
        """
        Attributes:
            DAILY: 
            AFTER: 
        """
        DAILY = 'DAILY'
        AFTER = 'AFTER'

    class NewUserOnlyEnum(Enum):
        """
        Attributes:
            T_0: 
            T_1: 
        """
        T_0 = 0
        T_1 = 1

    class EarlyRedeemSupportedEnum(Enum):
        """
        Attributes:
            T_0: 
            T_1: 
        """
        T_0 = 0
        T_1 = 1

    class StatusEnum(Enum):
        """
        Attributes:
            ONGOING: 
            PENDING: 
            FULL: 
            INTERESTING: 
        """
        ONGOING = 'ONGOING'
        PENDING = 'PENDING'
        FULL = 'FULL'
        INTERESTING = 'INTERESTING'

    id: Optional[str] = Field(default=None, description="Product ID")
    category: Optional[CategoryEnum] = Field(
        default=None, description="Product category:  ETH2 (ETH Staking)")
    type: Optional[TypeEnum] = Field(
        default=None, description="Product subtype: DEMAND (demand)")
    precision: Optional[int] = Field(default=None,
                                     description="Maximum precision supported")
    currency: Optional[str] = Field(default=None, description="currency")
    income_currency: Optional[str] = Field(default=None,
                                           description="Income currency",
                                           alias="incomeCurrency")
    return_rate: Optional[str] = Field(
        default=None,
        description=
        "Annualized Rate of Return, for example, 0.035 is equal to 3.5% annualized rate of return",
        alias="returnRate")
    user_lower_limit: Optional[str] = Field(
        default=None,
        description="Min. user subscribe amount",
        alias="userLowerLimit")
    user_upper_limit: Optional[str] = Field(
        default=None,
        description="Max. user subscription amount",
        alias="userUpperLimit")
    product_upper_limit: Optional[str] = Field(
        default=None,
        description="Products total subscription amount",
        alias="productUpperLimit")
    product_remain_amount: Optional[str] = Field(
        default=None,
        description="Remaining product subscription amount",
        alias="productRemainAmount")
    redeem_period: Optional[int] = Field(
        default=None,
        description="Redemption waiting period (days)",
        alias="redeemPeriod")
    redeem_type: Optional[RedeemTypeEnum] = Field(
        default=None,
        description=
        "Redemption channel: MANUAL (manual redemption), TRANS_DEMAND (transfer to corresponding demand product upon maturity), AUTO (redeem to funding account upon maturity)",
        alias="redeemType")
    income_release_type: Optional[IncomeReleaseTypeEnum] = Field(
        default=None,
        description=
        "Income release type: DAILY (daily release), AFTER (release after product ends)",
        alias="incomeReleaseType")
    apply_start_time: Optional[int] = Field(
        default=None,
        description="Subscription start time, in milliseconds",
        alias="applyStartTime")
    apply_end_time: Optional[int] = Field(
        default=None,
        description="Subscription end time, in milliseconds",
        alias="applyEndTime")
    lock_start_time: Optional[int] = Field(
        default=None,
        description="Product earliest interest start time, in milliseconds",
        alias="lockStartTime")
    lock_end_time: Optional[int] = Field(
        default=None,
        description="Product maturity time, in milliseconds",
        alias="lockEndTime")
    interest_date: Optional[int] = Field(
        default=None,
        description="Most recent interest date (milliseconds)",
        alias="interestDate")
    new_user_only: Optional[NewUserOnlyEnum] = Field(
        default=None,
        description=
        "Whether the product is exclusive to new users: 0 (no), 1 (yes)",
        alias="newUserOnly")
    early_redeem_supported: Optional[EarlyRedeemSupportedEnum] = Field(
        default=None,
        description=
        "Whether the fixed product supports early redemption: 0 (no), 1 (yes)",
        alias="earlyRedeemSupported")
    duration: Optional[int] = Field(default=None,
                                    description="Product duration (days)")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Product status: ONGOING (Subscription in progress), PENDING (Preheating Subscription), FULL (Subscribed), INTERESTING (Interest in progress)"
    )

    __properties: ClassVar[List[str]] = [
        "id", "category", "type", "precision", "currency", "incomeCurrency",
        "returnRate", "userLowerLimit", "userUpperLimit", "productUpperLimit",
        "productRemainAmount", "redeemPeriod", "redeemType",
        "incomeReleaseType", "applyStartTime", "applyEndTime", "lockStartTime",
        "lockEndTime", "interestDate", "newUserOnly", "earlyRedeemSupported",
        "duration", "status"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetEthStakingProductsData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetEthStakingProductsData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id":
            obj.get("id"),
            "category":
            obj.get("category"),
            "type":
            obj.get("type"),
            "precision":
            obj.get("precision"),
            "currency":
            obj.get("currency"),
            "incomeCurrency":
            obj.get("incomeCurrency"),
            "returnRate":
            obj.get("returnRate"),
            "userLowerLimit":
            obj.get("userLowerLimit"),
            "userUpperLimit":
            obj.get("userUpperLimit"),
            "productUpperLimit":
            obj.get("productUpperLimit"),
            "productRemainAmount":
            obj.get("productRemainAmount"),
            "redeemPeriod":
            obj.get("redeemPeriod"),
            "redeemType":
            obj.get("redeemType"),
            "incomeReleaseType":
            obj.get("incomeReleaseType"),
            "applyStartTime":
            obj.get("applyStartTime"),
            "applyEndTime":
            obj.get("applyEndTime"),
            "lockStartTime":
            obj.get("lockStartTime"),
            "lockEndTime":
            obj.get("lockEndTime"),
            "interestDate":
            obj.get("interestDate"),
            "newUserOnly":
            obj.get("newUserOnly"),
            "earlyRedeemSupported":
            obj.get("earlyRedeemSupported"),
            "duration":
            obj.get("duration"),
            "status":
            obj.get("status")
        })
        return _obj
