# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class RedeemResp(BaseModel, Response):
    """
    RedeemResp

    Attributes:
        order_tx_id (str): Redemption order ID
        deliver_time (int): Expected deliver time (milliseconds)
        status (StatusEnum): Redemption status: SUCCESS (successful), PENDING (redemption pending)
        amount (str): Redemption amount
    """

    class StatusEnum(Enum):
        """
        Attributes:
            SUCCESS: 
            PENDING: 
        """
        SUCCESS = 'SUCCESS'
        PENDING = 'PENDING'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    order_tx_id: Optional[str] = Field(default=None,
                                       description="Redemption order ID",
                                       alias="orderTxId")
    deliver_time: Optional[int] = Field(
        default=None,
        description="Expected deliver time (milliseconds)",
        alias="deliverTime")
    status: Optional[StatusEnum] = Field(
        default=None,
        description=
        "Redemption status: SUCCESS (successful), PENDING (redemption pending)"
    )
    amount: Optional[str] = Field(default=None,
                                  description="Redemption amount")

    __properties: ClassVar[List[str]] = [
        "orderTxId", "deliverTime", "status", "amount"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[RedeemResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[RedeemResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderTxId": obj.get("orderTxId"),
            "deliverTime": obj.get("deliverTime"),
            "status": obj.get("status"),
            "amount": obj.get("amount")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
